; put into the public domain by Russell Nelson, nelson@crynwr.com
; modified for PDCLKSET usage by Jan Engvald LDC

Movesb		proc	near
		test	cs:GenFlags,IS_A_386	; are we running on a 386?
		jz	MoveMem_86

		test	si,2			; doubleword align
		jz	MemAligned
		cmp	cx,2
		jb	MemAligned
		movsw
		dec	cx
		dec	cx
  MemAligned:
		push	cx			; transfer all complete dwords.
		.386
		shr	cx,2			; convert byte count to dword
		rep	movsd
		.8086
		pop	cx

		and	cx,3			; now take take of any trailing
		rep	movsb			;    words and/or bytes.
		ret
Movesb		endp



MoveMem_86:
; does the same thing as "rep movsb", only 50% faster.
; moves words instead of bytes, and handles the case of both addresses odd
; efficiently.  There is no way to handle one address odd efficiently.
; This routine always aligns the source address in the hopes that the
; destination address will also get aligned.  This is from Phil Karn's
; code from ec.c, a part of his NET package.  I bummed a few instructions
; out.
		.8086
		jcxz	movemem_cnte		; If zero, we're done already.
		test	si,1			; Does source start on odd byte?
		jz	movemem_adre		; Go if not
		movsb				; Yes, move the first byte
		dec	cx			; Count that byte
  movemem_adre:
		shr	cx,1			; convert to word count
		rep	movsw			; Move the bulk as words
		jnc	movemem_cnte		; Go if the count was even
		movsb				; Move leftover last byte
  movemem_cnte:
		ret



MovesbEsToDs	proc	near
		push	es		; switch es and ds
		push	ds
		pop	es
		pop	ds
		call	Movesb		; copy
		push	es		; switch back es and ds
		push	ds
		pop	es
		pop	ds
		ret
MovesbEsToDs	endp
