include ppp.asi
;
; note that I never send term-request, but instead simply drop the carrier
; mean, but effective...
;
; also I'm not sure when configuration options take effect
;

CGROUP group TSR ,CONFIG
	assume cs:cgroup,ds:cgroup
	public sm_init, sm_handler, sm_timed, confbuf
	public callnewstate ; for testing only
	extrn startxmit : PROC, LCP_struc : statemachine
	extrn receiveddispatch : byte
TSR  segment word public 'CODE'
termack		db	LCP_TERMACK,0	; TERM ACK command
		dw	400h
termreq		db	LCP_TERMREQ,0	; TERM REQ command
		dw	400h
echorep		db	LCP_ECHOREP,0	; ECHO RESPONE command
		dw	400h
confbuf		db	MRU DUP (?)	; buffer for commands which return
					; arbitrary data

;===========================================================================
;
; this restarts the timer/counter mechanism
;

InitRestartCount PROC
	mov	al,[bx].sm_defcount
	mov	[bx].sm_count,al
	mov	ax,[bx].sm_deftime
	mov	[bx].sm_time,ax
	ret
InitRestartCount ENDP
;
; This sets the timer to 3, counter to 0
;
ZeroRestartCount PROC
	mov	[bx].sm_count,1
	mov	ax,[bx].sm_deftime
	mov	[bx].sm_time,ax
	ret
ZeroRestartCount ENDP
;===========================================================================
;
; routines for standard packets
;
xtpacket PROC
	mov	si,offset cgroup:confbuf	; just load the conf packet
	jmp	pktcont		; and go
xtpacket ENDP
stdpacket PROC
	mov	al,[bx].sm_index		; need to add an index field
	inc	[bx].sm_index
	or	al,al    			; skip zero index
	jz	stdpacket
	mov	[si+1],al
stdpacket ENDP
pktcont PROC
	mov	cx,word ptr [si+2]	; load length of packet
	xchg	cl,ch
	mov	ax,[bx].sm_protocol		; protocol
	push	bx
	call	startxmit		; queue it for xmit
	pop	bx
	ret
pktcont ENDP
;===========================================================================
;
; they didn't like our conf req, renegotiate
;
SendConfReneg PROC
	lodsw     			; get past the type & id
	mov	dx,ax
	sub	dl,LCP_CONFNAK		; DL = 0, NAK; 1 = REJ
	lodsw				; get the count field
	xchg	al,ah			; fix endianness
	sub	ax,4			; subtract header length
	mov	cx,ax
	jcxz	SendConfReq
scrl:
	call	[bx].sm_reneg
	lodsb
	lodsb        			; get the protocol len
	sub	ah,ah			;
	add	si,ax			; point past it
	dec	si
	dec	si
	sub	cx,ax			; decrement count
	jg	scrl			; loop if more
	jmp	SendConfReq
; fall through
SendConfReneg ENDP
;
; we send our current confreq or timeout has occurred so resend
;
ResendConfReq PROC
	dec	[bx].sm_index		; reuse the same ident.
ResendConfReq ENDP
SendConfReq PROC
	mov	di,offset cgroup:confbuf
	mov	al,LCP_CONFREQ		; CONF request
	stosb
	stosb				; id filled in later
	stosw        			; save garbage in the count field
	call	[bx].sm_reqdata		; now move our ack fields in
	add	ax,4			; add in the packet header size
	mov	si,offset cgroup:confbuf
	xchg	al,ah			; save the size
	mov	[si+2],ax
	jmp	stdpacket		; do the packet
SendConfReq ENDP
;
; we like their conf
;
SendConfAck PROC
	push 	si
	mov	cx,[si+2]		; get count
	xchg	cl,ch
	sub	cx,4
	lea	si,[si+4]		; point at data
	jcxz	scago
pcl:
	call	[bx].sm_acceptconf
	mov	al,[si+1]		; get len field
	sub	ah,ah			; add to our pointer
	add	si,ax
	sub	cx,ax			; subtrackt from out count
	jg	pcl			; loop till done
scago:
	pop	si
	mov	di,offset cgroup:confbuf	; get conf buf
	lodsw                		; get type and index
	mov	al,LCP_CONFACK		; change type to ack
	stosw				; save it
	lodsw				; move the length
	stosw
	mov	cx,ax			; now move their data into the new packet
	xchg	cl,ch
	sub	cx,4
	rep	movsb
	jmp	xtpacket		; and send it...
SendConfAck ENDP
;
; we don't like their conf. send an Nak or a REJECT
;
SendConfNak PROC
	mov	di,offset cgroup:confbuf    	; confbuf
	lodsw				; use their ID but change the command to NAK
	mov	al,LCP_CONFNAK
	stosw				; save it
	mov	dx,4			; DX = total count (note: byte swap later!!!!
	stosw				; save it but we will change it
	lodsw				; now get their count field to CX
	mov	cx,ax
	xchg	cl,ch
	sub	cx,4
	jcxz	scnx
scnlp:
	stc     			; can change
	call	[bx].sm_verifyconf
	mov	al,[si+1]			; al = length
	jnc	nomove
	sub	ah,ah			; we didn't like this, keep it
	push	cx
	push	si
	mov	cx,ax
	add	dx,ax
	rep	movsb
	pop	si
	pop	cx
nomove:
	sub	ah,ah			; point at next field
	add	si,ax
	sub	cx,ax
	jg	scnlp			; loop till done
					; we'll byte swap later
;
; now we have the options we didn't like,
; if there is anything besides AUTH then get rid of the auth and turn it
; into a reject message
;
scnx:	
	cmp	[confbuf],LCP_CONFREJ	; any rejections?
	jnz	scnnorej		; no, just send the packet
	lea	si,[confbuf+4]		; else point at count
	mov	cx,dx
	sub	cx,4
scnrl:
	call	[bx].sm_noreject
	jnz	scnrlno			; no, next
	mov	al,[si+1]     		; get length of AUTH option
	sub	ah,ah			;
	mov	di,si
	add	si,ax
	sub	dx,ax
	sub	cx,ax			; and count
	rep	movsb			; and do move
	jmp	scnnorej

scnrlno:
	mov	al,[si+1]		; else get length of option
	sub	ah,ah			;
	add	si,ax
	sub	cx,ax
	jg	scnrl			; continue till done
scnnorej:
	xchg	dl,dh			; endianness of count field
	mov	word ptr [confbuf + 2],dx ; Save count field
	jmp	xtpacket		; send packet
SendConfNak ENDP
;
; send a terminate message
;
SendTermAck PROC
	mov	si,offset cgroup:termack	; standard message
	jmp	stdpacket
SendTermAck ENDP
;
; bad code, send a message and prepend as much of their packet as
; possible given the MRU
;
SendCodeReject PROC
	mov	di,offset cgroup:confbuf	; store a reject msg, ID=0
	mov	al,LCP_CODEREJ
	mov	ah,[LCP_struc].sm_index		; need to add an index field
	inc	[LCP_struc].sm_index
	stosw             
	mov	ax,[si + 2]		; get the count field
	xchg	al,ah
	cmp	ax,MRU-8			; see if two big?
	jc	sprok
	mov	ax,MRU-8			; yes, max it out

sprok:
	mov	cx,ax			; now copy their packet
	inc	ax
	inc	ax
	xchg	al,ah
	stosw				; store the count field
; fixme - should add address bytes in .
	mov	ax,[bx].sm_protocol
	xchg	al,ah
	stosw
	rep	movsb
	jmp	xtpacket
SendCodeReject ENDP
;
; they want an echo, give them one
;
SendEchoResponse PROC
	mov	di,offset cgroup:confbuf	; store a reject msg, ID=0
	mov	ax,LCP_ECHOREP
	stosw
	mov	ax,[si + 2]		; get the count field
	xchg	al,ah
	cmp	ax,MRU-4			; see if two big?
	jc	errok
	mov	ax,MRU-4			; yes, max it out

errok:
	mov	cx,ax			; now copy their packet
	add	ax,4
	xchg	al,ah
	stosw				; store the count field
	rep	movsb
	jmp	xtpacket
SendEchoResponse ENDP
;
; request termination
;
SendTermReq PROC
	mov	si,offset cgroup:termreq
	jmp	stdpacket
SendTermReq ENDP
;===========================================================================
;
; next comes the state machine
;
; this is out of the RFC, not commenting it
;
starting_state PROC
	cmp	al,SM_UP
	jnz	ss_chkclose
	mov	ah,ST_REQ_SENT
	call	postnewstate
	call	InitRestartCount
	jmp	SendConfReq
ss_chkclose:
	cmp	al,SM_CLOSE
	jnz	ss_remain
	mov	al,ST_INITIAL
	mov	ah,SM_CLOSE
	call	postnewstate
ss_remain:
	ret
starting_state ENDP
close_state	PROC
	cmp	al,SM_DOWN
	jnz	ss_chkopen
	mov	al,ST_INITIAL
	mov	ah,SM_CLOSE
	jmp	postnewstate
ss_chkopen:
	cmp	al,SM_OPEN
	jnz	ss_chkrcr
	call	InitRestartCount
	jmp	SendConfReq
ss_chkrcr:
	cmp	al,SM_RCRPLUS
	jz	ss_okrcr
	cmp	al,SM_RCRMINUS
	jz	ss_okrcr
	cmp	al,SM_RCA
	jz	ss_okrcr
	cmp	al,SM_RCN
	jz	ss_okrcr
	cmp	al,SM_RTR
	jnz	ss_chkruc
ss_okrcr:
	jmp	SendTermAck
ss_chkruc:
	cmp	al,SM_RUC
	jnz	ss_chkrxj
	jmp	SendCodeReject
ss_chkrxj:
	cmp	al,SM_RXJMINUS
	jnz	ss_x
; this level finished

ss_x:
	ret
close_state	ENDP
stopped_state	PROC
	cmp	al,SM_OPEN
	jnz	sp_chkclose
	mov	ah,ST_REQ_SENT
	call	postnewstate
	jmp	SendConfReq
sp_chkclose:
	cmp	al,SM_CLOSE
	jnz	sp_chkrcrplus
	mov	ah,ST_CLOSED
	jmp	postnewstate
sp_chkrcrplus:
	cmp	al,SM_RCRPLUS
	jnz	sp_chkrcrminus
	push	bx
	call	SendConfAck
	pop	bx
	mov	ah,ST_ACK_SENT
	call	postnewstate
	call	InitRestartCount
	jmp	SendConfReq
sp_chkrcrminus:
	cmp	al,SM_RCRMINUS
	jnz	sp_chkrca
	push	bx
	call	SendConfNak
	pop	bx
	mov	ah,ST_REQ_SENT
	call	postnewstate
	call	InitRestartCount
	jmp	SendConfReq
sp_chkrca:
	cmp	al,SM_RCA
	jz	sp_okrcr
	cmp	al,SM_RCN
	jz	sp_okrcr
	cmp	al,SM_RTR
	jnz	sp_chkruc
sp_okrcr:
	jmp	SendTermAck
sp_chkruc:
	cmp	al,SM_RUC
	jnz	sp_chkrxj
	jmp	SendCodeReject
sp_chkrxj:
	cmp	al,SM_RXJMINUS
	jnz	sp_x
; this level finished
sp_x:
	ret
stopped_state	ENDP
closing_state PROC
	cmp	al,SM_UP
	jnz	cs_notup
	mov	ah,ST_INITIAL
	jmp	postnewstate
cs_notup:
	cmp	al,SM_DOWN
	jnz	cs_notdown
	mov	ah,ST_STOPPING
	jmp	postnewstate
cs_notdown:
	cmp	al,SM_CLOSE
	jnz	cs_notclose
	mov	ah,ST_CLOSING
	jmp	postnewstate
cs_notclose:
	cmp	al,SM_TOPLUS
	jnz	cs_nottoplus
	jmp	SendTermReq
cs_nottoplus:
	cmp	al,SM_TOMINUS
	jz	cs_tlf
	cmp	al,SM_RTA
	jz	cs_tlf
	cmp	al,SM_RXJMINUS
	jnz	cs_nottominus
cs_tlf:
; this layer finished
	mov	ah,ST_CLOSED
	jmp	postnewstate
cs_nottominus:
	cmp	al,SM_RTR
	jnz	cs_notrtr
	jmp	SendTermAck
cs_notrtr:
	cmp	al,SM_RUC
	jnz	cs_x
	jmp	SendCodeReject
cs_x:
	ret

	
closing_state ENDP
stopping_state PROC
	cmp	al,SM_UP
	jnz	sg_notup
	mov	ah,ST_STARTING
	jmp	postnewstate
sg_notup:
	cmp	al,SM_DOWN
	jnz	sg_notdown
	mov	ah,ST_STOPPING
	jmp	postnewstate
sg_notdown:
	cmp	al,SM_CLOSE
	jnz	sg_notclose
	mov	ah,ST_stopping
	jmp	postnewstate
sg_notclose:
	cmp	al,SM_TOPLUS
	jnz	sg_nottoplus
	jmp	SendTermReq
sg_nottoplus:
	cmp	al,SM_TOMINUS
	jz	sg_tlf
	cmp	al,SM_RTA
	jz	sg_tlf
	cmp	al,SM_RXJMINUS
	jnz	sg_nottominus
sg_tlf:
; this layer finished
	mov	ah,ST_STOPPED
	jmp	postnewstate
sg_nottominus:
	cmp	al,SM_RTR
	jnz	sg_notrtr
	jmp	SendTermAck
sg_notrtr:
	cmp	al,SM_RUC
	jnz	sg_x
	jmp	SendCodeReject
sg_x:
	ret
stopping_state ENDP

reqsent_state PROC
	cmp	al,SM_DOWN
	jnz	rss_close
	mov	ah,ST_STARTING
	jmp	postnewstate
rss_close:
	cmp	al,SM_CLOSE
	jnz	rss_toplus
	mov	ah,ST_CLOSING
	call	postnewstate
	call	InitRestartCount
	jmp	SendTermReq
rss_toplus:
	cmp	al,SM_TOPLUS
	jnz	rss_tominus
	jmp	ResendConfReq
rss_tominus:
	cmp	al,SM_TOMINUS
	jnz	rss_rcrplus
	mov	ah,ST_STOPPED
	
;this layer finished
	jmp	postnewstate
rss_rcrplus:
	cmp	al,SM_RCRPLUS
	jnz	rss_rcrminus
	mov	ah,ST_ACK_SENT
	call	postnewstate
	jmp	SendConfAck
rss_rcrminus:
	cmp	al,SM_RCRMINUS
	jnz	rss_rca
	jmp	SendConfNak
rss_rca:
	cmp	al,SM_RCA
	jnz	rss_rcn
	mov	ah,ST_ACK_RCVD
	call	postnewstate
	jmp	InitRestartCount
rss_rcn:
	cmp	al,SM_RCN
	jnz	rss_rtr
	call	InitRestartCount
	jmp	SendConfReneg
rss_rtr:
	cmp	al,SM_RTR
	jnz	rss_ruc
	jmp	SendTermAck
rss_ruc:
	cmp	al,SM_RUC
	jnz	rss_rxjminus
	jmp	SendCodeReject
rss_rxjminus:
	cmp	al,SM_RXJMINUS
	jnz	rss_x
; this layer finished
	mov	ah,ST_STOPPED
	jmp	postnewstate
rss_x:
	ret
reqsent_state ENDP
ackrcvd_state PROC
	cmp	al,SM_DOWN
	jnz	ars_close
	mov	ah,ST_STARTING
	jmp	postnewstate
ars_close:
	cmp	al,SM_CLOSE
	jnz	ars_toplus
	mov	ah,ST_CLOSING
	call	postnewstate
	call	InitRestartCount
	jmp	SendTermReq
ars_toplus:
	cmp	al,SM_TOPLUS
	jnz	ars_tominus	
	mov	ah,ST_REQ_SENT
	call	postnewstate
	jmp	ReSendConfReq
ars_tominus:
	cmp	al,SM_TOMINUS
	jnz	ars_rcrplus
	mov	ah,ST_STOPPED
	
;this layer finished
	jmp	postnewstate
ars_rcrplus:
	cmp	al,SM_RCRPLUS
	jnz	ars_rcrminus
	call	SendConfAck
	mov	ah,ST_OPENED
	jmp	postnewstate
ars_rcrminus:
	cmp	al,SM_RCRMINUS
	jnz	ars_rca
	jmp	SendConfNak
ars_rca:
	cmp	al,SM_RCA
	jnz	ars_rcn
	mov	ah,ST_REQ_SENT
	call	postnewstate
	jmp	SendConfReq
ars_rcn:
	cmp	al,SM_RCN
	jnz	ars_rtr
	mov	ah,ST_REQ_SENT
	call	postnewstate
	jmp	SendConfReneg
ars_rtr:
	cmp	al,SM_RTR
	jnz	ars_ruc
	mov	ah,ST_REQ_SENT
	call	postnewstate
	jmp	SendTermAck
ars_ruc:
	cmp	al,SM_RUC
	jnz	ars_rxjminus
	jmp	SendCodeReject
ars_rxjminus:
	cmp	al,SM_RXJMINUS
	jnz	ars_x
; this layer finished
	mov	ah,ST_STOPPED
	jmp	postnewstate
ars_x:
	ret
ackrcvd_state ENDP
acksent_state PROC
	cmp	al,SM_DOWN
	jnz	ass_close
	mov	ah,ST_STARTING
	jmp	postnewstate
ass_close:
	cmp	al,SM_CLOSE
	jnz	ass_toplus
	mov	ah,ST_CLOSING
	call	postnewstate
	call	InitRestartCount
	jmp	SendTermReq
ass_toplus:
	cmp	al,SM_TOPLUS
	jnz	ass_tominus
	jmp	ReSendConfReq
ass_tominus:
	cmp	al,SM_TOMINUS
	jnz	ass_rcrplus
	mov	ah,ST_STOPPED
	
;this layer finished
	jmp	postnewstate
ass_rcrplus:
	cmp	al,SM_RCRPLUS
	jnz	ass_rcrminus
	jmp	SendConfAck
ass_rcrminus:
	cmp	al,SM_RCRMINUS
	jnz	ass_rca
	mov	ah,ST_REQ_SENT
	call	postnewstate
	jmp	SendConfNak
ass_rca:
	cmp	al,SM_RCA
	jnz	ass_rcn
	mov	ah,ST_OPENED
	call	postnewstate
	jmp	InitRestartCount
ass_rcn:
	cmp	al,SM_RCN
	jnz	ass_rtr
	call	InitRestartCount
	jmp	SendConfReneg
ass_rtr:
	cmp	al,SM_RTR
	jnz	ass_ruc
	jmp	SendTermAck
ass_ruc:
	cmp	al,SM_RUC
	jnz	ass_rxjminus
	mov	ah,ST_STOPPED
	call	postnewstate
	jmp	SendCodeReject
ass_rxjminus:
	cmp	al,SM_RXJMINUS
	jnz	ass_x
; this layer finished
	mov	ah,ST_STOPPED
	jmp	postnewstate
ass_x:
	ret
acksent_state ENDP
opened_state PROC
	cmp	al,SM_DOWN
	jnz	os_close
; this layer down
	mov	ah,ST_STARTING
	jmp	postnewstate
os_close:
	cmp	al,SM_CLOSE
	jnz	os_rcrplus
; this layer down
	mov	ah,ST_CLOSING
	call	InitRestartCount
	jmp	SendTermReq
os_rcrplus:
	cmp	al,SM_RCRPLUS
	jnz	os_rcrminus
; this layer down
	push	bx
	call	SendConfAck
	pop	bx
	mov	ah,ST_ACK_SENT
	call	postnewstate
	jmp	SendConfReq
os_rcrminus:
	cmp	al,SM_RCRMINUS
	jnz	os_rca
; this layer down
	push	bx
	call	SendConfNak
	push	bx
	mov	ah,ST_REQ_SENT
	call	postnewstate
	jmp	SendConfReq
os_rca:
	cmp	al,SM_RCA
	jnz	os_rcn
	mov	ah,ST_REQ_SENT
	call	postnewstate
	jmp	SendConfReq

os_rcn:
	cmp	al,SM_RCN
	jnz	os_rtr
; this layer down
	mov	ah,ST_REQ_SENT
	call	postnewstate
	jmp	SendConfReneg
os_rtr:
	cmp	al,SM_RTR
	jnz	os_rta
	mov	ah,ST_STOPPING
	call	postnewstate
	call	ZeroRestartCount
	jmp	SendTermAck
os_rta:
	cmp	al,SM_RTA
	jnz	os_ruc
	mov	ah,ST_REQ_SENT
	call	postnewstate
	jmp	SendConfReq
os_ruc:
	cmp	al,SM_RUC
	jnz	os_rxjminus
	mov	ah,ST_REQ_SENT
	call	postnewstate
	push	si
	push	bx
	call	SendCodeReject
	pop	bx
	pop	si
	jmp	SendConfReq
os_rxjminus:
	cmp	al,SM_RXJMINUS
	jnz	os_rxr
; this layer finished
	mov	ah,ST_STOPPING
	call	postnewstate
	call	InitRestartCount
	jmp	SendTermReq
os_rxr:
	cmp	al,SM_SER
	jnz	os_x
	jmp	SendEchoResponse
os_x:
	ret
opened_state ENDP
statetab	LABEL	WORD
	dw	sm_init
	dw	starting_state
	dw	close_state
	dw	stopped_state
	dw	closing_state
	dw	stopping_state
	dw	reqsent_state
	dw	ackrcvd_state
	dw	acksent_state
	dw	opened_state
	
;
; state machine- post new state
;
postnewstate	PROC
	cmp	[bx].sm_state,ST_OPENED	; was in opened state?
	mov	[bx].sm_state,AH		; save state
	mov	[bx].sm_msg,AL		; and message
	jnz	pnsok			; if not opened see if going into it
	cmp	ah,ST_OPENED		; else see if coming out of it
	jz	pnsx			; no exit
	jmp	[bx].sm_layerdown
pnsok:
	cmp	ah,ST_OPENED		; see if new state is opened
	jnz	pnsx			; no, exit
	jmp	[bx].sm_layerup
pnsx:
	ret
postnewstate	ENDP
;
; call the state machine
;
callnewstate PROC
	mov	al,[bx].sm_state		; bx = state *2
	sub	ah,ah
	mov	di,ax
	shl	di,1
	mov	al,[bx].sm_msg		; al = msg
	or	[receiveddispatch],IN_FSM	; stop interrupts
	call	[statetab+di]		; call state entry
	and	[receiveddispatch],NOT IN_FSM
	ret
callnewstate ENDP
;===========================================================================
;
; examine incoming packets and extract state info
;
; we heard a conf req, check it for validity
;
exconfreq PROC
	push	si
	mov	cx,[si+2]		; get count
	xchg	cl,ch
	sub	cx,4
	lea	si,[si + 4]		; point SI at data
	jcxz	okconf
excrl:
	clc                       	; no changes to packet
	call	[bx].sm_verifyconf
	jc	badconf			; no, bad conf
	mov	al,[si+1]		; else point at next
	sub	ah,ah
	add	si,ax
	sub	cx,ax
	jg	excrl			; loop till done
okconf:
	mov	[bx].sm_msg,SM_RCRPLUS	; we can accept it
	pop	si
	ret
badconf:
	mov	[bx].sm_msg,SM_RCRMINUS	; we can't accept it
	pop	si
	ret
exconfreq ENDP
;
; they like our conf
;
exconfack PROC
	push 	si
	mov	cx,[si+2]		; get count
	xchg	cl,ch
	sub	cx,4
	lea	si,[si+4]		; point at data
	jcxz	ecfax
pclca:
	call	[bx].sm_confacked
	mov	al,[si+1]		; get len field
	sub	ah,ah			; add to our pointer
	add	si,ax
	sub	cx,ax			; subtrackt from out count
	jg	pclca			; loop till done
ecfax:
	pop	si
	mov	[bx].sm_msg,SM_RCA
	inc	[bx].sm_index		; in case we have to retry...
	ret
exconfack ENDP
exconfrej PROC
	; ack and reject treated the same.
exconfrej ENDP
exconfNak PROC
	mov	[bx].sm_msg,SM_RCN
	ret
exconfNak ENDP
extermreq PROC
	mov	[bx].sm_msg,SM_RTR
	ret
extermreq ENDP
extermack PROC
	mov	[bx].sm_msg,SM_RTA
	ret
extermack ENDP
;
; ehco- only valid in opened state  
;
exechoreq PROC
	mov	[bx].sm_msg,SM_SER
	ret
erqd:
	ret
exechoreq ENDP
;
; we ignore these
;
excoderej PROC
excoderej ENDP
exprotrej PROC
exprotrej ENDP
exechorep PROC
exechorep ENDP
exdiscard PROC
exdiscard ENDP
	ret
;
; exmaine a received packet jump table
;
extab	label	word
	dw	exconfreq	; code 1 !!!
	dw	exconfack
	dw	exconfNak
	dw	exconfrej
	dw	extermreq
	dw	extermack
	dw	excoderej
	dw	exprotrej
	dw	exechoreq
	dw	exechorep
	dw	exdiscard
	dw	retpos		; code 12 is reserved, we just ignore it
retpos:	ret
itab db 0,1,1,1,0,1,1,1,0,1,0,0
testindex proc
	mov	al,[si+1]		; get the ident
	test	[di+itab],1		; is it a response?
	jnz	ti_sent			; yes, handle it
ti_rcvd:
	cmp	al,[bx].sm_rindex	; else see if they upped their id
	mov	[bx].sm_rindex,al	
	jb	ti_bad			; no, error
	clc
	ret
ti_sent:
	inc	al			; match our database
	cmp	al,[bx].sm_index	; see if matches
	jnz	ti_bad			; no, error
	ret

ti_bad:
	stc
	ret
testindex endp
;
; this does not initiate the connection, but waits for the restart mechanism
; to bump with the time in DX before it gets going.  Meanwhile we are
; listening just in case.
;
sm_init	PROC
	call	InitRestartCount
	mov	al,SM_UP
	mov	ah,ST_STARTING
	call	postnewstate
	jmp	callnewstate
	
sm_init endp
;
; when we receive something in PPP it comes here
;
sm_handler PROC
	push	ax
	push	si
	cmp	ax,[bx].sm_protocol; check uncompressed version
	jz	dosm		    ; 
	test	ah,1			; conpressed?
	stc
	jz	notthis			; no get out
	mov	dx,[bx].sm_protocol	; else calc compression
	add	dh,dl
	cmp	ah,dh			; match?
	stc
	jnz	notthis			; no, get out
dosm:
	lodsb
	dec	si
	sub	ah,ah
	mov	di,ax
	or	di,di
	jz	badcode
	cmp	di,13		    ; functions > 12 aren't valid
	jc	goodcode
badcode:
	call	SendCodeReject
	jmp	sm_x
;
; examine packet
;

goodcode:
	mov	[bx].sm_msg,SM_NONE	; save no-transistion message
	dec	di  			; now branch to listener state gatherr
	call	TestIndex		; now see if we can ignore the message based on index
	jc	sm_x
	shl	di,1
	call	[extab+di]
	call	callnewstate		; and go to state machine
sm_x:
	clc
notthis:
	pop	si
	pop	ax
	ret
sm_handler ENDP

;
; the foreground routine which handles the timer/counter
; needs to be called with the number of 18.2Hz ticks that have elapsed
; to process timer messages.
;
sm_timed PROC
	sub	[bx].sm_time,ax		; sub count
	jg	lcpix			; get out if not done
	or	[receiveddispatch],IN_FSM	; stop interrupts
	mov	ax,[bx].sm_deftime		; else reload timer
	mov	[bx].sm_time,ax		;
	mov	[bx].sm_msg,SM_TOPLUS	; assume timed out with counter NZ
	dec	[bx].sm_count		; dec counter
	jnz	lcpip			; yes, go send message
	mov	[bx].sm_msg,SM_TOMINUS	; no, counter = 0 timeout
	call	InitRestartCount
lcpip:
	jmp	callnewstate		; go hit the state machine
lcpix:
	ret
sm_timed ENDP
TSR 	ENDS
CONFIG	segment word public 'CODE'
CONFIG	ENDS
	end