/*
 *  RALIGN.CPP - the function is a part of User library.
 *  Copyleft (l) Stanislav Sokolov, June 1998 and onwards
 *
 *  This library is subject to GNU General Library Public License ver. 2 of 
 *  June 1991 and any later version. See COPYING.LIB for details.
 *
 *  You may freely use this function, provided due credits are given.
 *
 *  Contact the author by e-mail: stanislavs@hotmail.com
 *
 *  Internet:  http://members.tripod.com/~stanislavs/prog/prog.htm
 */


#include <conio.h>
#include <string.h>

#include "d:\tc\utils\user\user.h"

int RAlign(char Row, const char *Text, char Boundary = -1){
	char Cols, Col;

	asm{
		mov AH, 0x0F
		int 0x10
		mov Cols, AH
	}

	//Set right boundary, if it is given
	if((Boundary != -1) && (Boundary <= Cols)) Cols = Boundary;
	if(strlen(Text) > Cols) return 0;

	//Locate cursor
	Col = Cols - strlen(Text);
	if(Row == 0) return Col; //If Row == 0, the user does not want to print the text on screen - return coordinates.

	gotoxy(Col, Row);
	if(wherey() != Row) return 0; //Was cursor placement successful?

	cprintf(Text);
	return Col;
}

/*int main(void){
	textcolor(LIGHTGRAY);
	textbackground(BLACK);
	clrscr();

	RAlign(5, "Test right-aligning of a text.");
	RAlign(6, "==============================");

	RAlign(12, "Test user-defined boundary, set to 40", 40);
	RAlign(13, ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>", 40);

	cprintf("\r\n\r\nThe word 'Abrakatabra' would be right-aligned at x-location %i\r\n", RAlign(0, "Abrakatabra"));

	return 0;
}*/
