RHAPT2LM10RM75DATABASES o TNEUHAUS	   p.  PN  of FP 
Vol. 9, No. 16                      Filename:  VA$FI


PT2LM20RM50.5AL0LS2TS23


LM0RM100
[[CODE BOX]]
NWORDS.PRG
COMPLETE LISTING
[[include magnet logo]]



*********************************************************
* NWORDS.PRG
* Convert numbers to words
*********************************************************
PROCEDURE n2w
PARAMETERS m_number                && pass numeric value
*
* Return "Invalid number" if out of range
*
IF (m_number <= 0) .OR. (m_number > 999999999999.99)
   RETURN "Invalid number"
ENDIF
*
* Initialize
*
word = []
orig = m_number
cents = (m_number - INT(m_number))*100
*
* If less than $1.00, start with "Zero"
*
IF INT(m_number) = 0
   word = [Zero ]
ENDIF
*
* Set Up Arrays
*
DIMENSION mone(19), mten(9)
mone(1) = [One ]
mone(2) = [Two ]
mone(3) = [Three ]
mone(4) = [Four ]
mone(5) = [Five ]
mone(6) = [Six ]
mone(7) = [Seven ]
mone(8) = [Eight ]
mone(9) = [Nine ]
mone(10) = [Ten ]
mone(11) = [Eleven ]
mone(12) = [Twelve ]
mone(13) = [Thirteen ]
mone(14) = [Fourteen ]
mone(15) = [Fifteen ]
mone(16) = [Sixteen ]
mone(17) = [Seventeen ]
mone(18) = [Eighteen ]
mone(19) = [Nineteen ]

mten(1) = [Ten ]
mten(2) = [Twenty ]
mten(3) = [Thirty ]
mten(4) = [Fourty ]
mten(5) = [Fifty ]
mten(6) = [Sixty ]
mten(7) = [Seventy ]
mten(8) = [Eighty ]
mten(9) = [Ninety ]
*
*  Handle billions
*
x = INT(m_number/1000000000)
IF x > 0
   DO mkwords WITH x, word
   word = word + [Billion ]
ENDIF
m_number = m_number - (x * 1000000000)
*
*  Handle millions
*
x = INT(m_number/1000000)
IF x > 0
   DO mkwords WITH x, word
   word = word + [Million ]
ENDIF
m_number = m_number - (x * 1000000)
*
*  Handle thousands
*
x = INT(m_number/1000)

IF x > 0
   DO mkwords WITH x, word
   word = word + [Thousand ]
ENDIF
m_number = m_number - (x * 1000)
*
* Handle the rest
*
IF m_number >= 1
   DO mkwords WITH INT(m_number), word
ENDIF
*
* Setup "dollars" and cents
*
IF orig >= 2 .OR. int(orig) = 0
   word = word + [Dollars and ]
ELSE
   word = word + [Dollar and ]
ENDIF
IF cents # 0
   IF cents < 10
      word = word + '0' + STR(cents,1) + [/100]
   ELSE
      word = word + STR(cents,2) + [/100]
   ENDIF
ELSE
   word = word + [00/100]
ENDIF

RETURN word
*
* Procedure: MAKE_WORDS
*
PROCEDURE mkwords
PARAMETERS numb, string
* PRIVATE nstr, nlen, nlook
nstr = STR(numb)
DO WHILE SUBSTR(nstr,1,1)=' '
   nstr = SUBSTR(nstr,2)
ENDDO
DO WHILE ("" <> nstr)
   nlen = LEN(nstr)
   nlook = VAL(SUBSTR(nstr,1,1))
   IF nlook = 0
      IF nlen = 1
         nstr = ''
      ELSE
         nstr = SUBSTR(nstr,2)
      ENDIF
      LOOP
   ENDIF
   DO CASE
    CASE nlen = 3
      string = string + mone(nlook)
      string = string + "Hundred "
      nstr = SUBSTR(nstr,2)
    CASE nlen = 2
      IF VAL(SUBSTR(nstr,1,2)) < 20
         string = string + mone(VAL(SUBSTR(nstr,1,2)))
         nstr = ''
         LOOP
      ENDIF
      IF VAL(SUBSTR(nstr,1,2)) >= 20
         string = string + mten(nlook)
         nstr = SUBSTR(nstr,2)
      ENDIF
    CASE nlen = 1
      string = string + mone(nlook)
      nstr = ''
   ENDCASE
ENDDO
RETURN
* eof


BBPT7AL0LM0RM69.6LS2MDBOFigure C:MDNM This procedure converts numbers into English.
