         PAGE  60,132
         TITLE LODboot - Boot and partition sector reload program.
;        SUBTTL  General program description and use of common storage
; ----------------------------------------------------------------------------;
;        LODboot - ReLoad Boot or partition sectors from CHKboot created files;
;-----------------------------------------------------------------------------;
;   LODBOOT 1.0  PCDATA TOOLKIT Copyright (c) 1990 Ziff Communications Co.   ;
;                       PC Magazine  Wolfgang Stiller                        ;
;                                                                             ;
;-----------------------------------------------------------------------------;
;Purpose:                                                                     ;
;  To recover from damage to either the DOS boot sector or a hard disk's      ;
;  partition sector (table). LODBOOT will read the boot or partition          ;
;  sector reload file created by CHKboot, verify that it has not been         ;
;  corrupted and then reload the appropriate sector.                          ;
;-----------------------------------------------------------------------------;
;Format:                                                                      ;
;                                                                             ;
;    LODBOOT [/B] [/P] [/2]                                                   ;
;                                                                             ;
;  Only one of the above parameters can be specified at a time.               ;
;                                                                             ;
; /B  Reloads the boot record from the file @@BOOT.SCT which was previously   ;
;     created by an execution of "CHKboot /I".                                ;
; /P  Reloads the partition sector onto the first physical hard disk drive    ;
;     from file @@PARTIT.SCT.                                                 ;
; /2  Same as "/P" but writes to second physical fixed disk drive.            ;
;-----------------------------------------------------------------------------;
;Remarks:                                                                     ;
; LODBOOT will not reload both a boot and a partition sector at the same      ;
; time.  If both are damaged, the partition sector should be reloaded         ;
; first. LODBOOT will check the .SCT reload files and will refuse to          ;
; reload if the files have been corrupted. Both reload files contain 32       ;
; bits of integrity check information.                                        ;
;                                                                             ;
; In order to reload a DOS boot sector, the file @@BOOT.SCT must be in        ;
; the current directory which must be on the DOS disk(ette) to be             ;
; reloaded.  To reload a partition sector, the file @@PARTIT.SCT must be      ;
; in the current directory. This need not be on the disk to be reloaded.      ;
;                                                                             ;
; LODBOOT will return the following DOS errorlevels:                          ;
; 00 - Reload of boot or partition sector was successful.                     ;
; 32 - Invalid or missing reload file (@@BOOT.SCT or @@PARTIT.SCT).           ;
; 64 - I/O error occurred while trying disk read/write.                       ;
;128 - No parameters entered or invalid syntax.                               ;
;                                                                             ;
;-----------------------------------------------------------------------------;

;---------------------------------------------------------------;
; Constants:                                                    ;
;---------------------------------------------------------------;
BOX          EQU    254                   ;Small box character code
CR           EQU    0Dh
LF           EQU    0Ah
CRLF         EQU    0A0Dh                 ;Carriage return line feed.
Boot_type    EQU    0FFh                  ;Indicator of a boot sector (.PRM)
Part_type    EQU    055h                  ;Indicator of a partition sector(.PRM)
; Double line drawing character definitions
Horizontal   EQU    205                   ;Horizontal double line
Vertical     EQU    186                   ;Vertical double line
UPRT_corner  EQU    187                   ;Upper righthand corner
UPLT_corner  EQU    201                   ;Upper lefthand corner
LWLT_corner  EQU    200                   ;Lower lefthand corner
LWRT_corner  EQU    188                   ;Lower righthand corner

CSEG    SEGMENT
        ASSUME  CS:CSEG, DS:CSEG, ES:CSEG, SS:CSEG

        SUBTTL  Main program
;******************************************************************************;
;**   Main program begins here -LODBOOT-                                     **;
;******************************************************************************;
        ORG     100H                      ; THIS IS A COM TYPE PROGRAM
LODBOOT:
        CALL    Parse_parms               ;Parse cmdline paramters + prnt header

        MOV     DX, offset Header_Msg     ;Put out title display
        MOV     AH,09H                    ;DOS display string function
        INT     21H

; Check system sector size
        MOV     AH,36h                    ;Check sector size and free space
        XOR     DL,DL                     ;Check current disk (DL=0 is current)
        INT     21h
        MOV     Sector_Size,CX            ;Save # of bytes per sector

        XOR     BP,BP                     ;Zero out highest error level code
        CMP     Boot_wanted,'Y'           ;Does user want BOOT rec loaded?
        JNE     No_Boot                   ;  If not skip loading the boot rec
        CALL    Read_Boot_SCT             ;Read and verify the relaod file
        CALL    Write_Boot_Sector         ;Do actual write of sector 0 (DOS)
NO_BOOT:
        CMP     Partition_wanted,'Y'      ;Does user want Partition loaded?
        JNE     End_Execution             ;  If not skip loading the Partition
        CALL    Read_Part_SCT             ;Read and verify the relaod file
        CALL    Write_Part_Sector         ;Do actual BIOS write of partition
End_Execution:                            ;Successful termination of program
        MOV     AX,BP                     ;BP contains highest error level
        MOV     AH,4Ch                    ;DOS terminate with errorlevel funct
        INT     21h




;---------------------------------------------------;
; C O M P A R E      B U F F E R      S U M S       ;
;---------------------------------------------------;
;Register conventions:                              ;
;                                                   ;
; DI - Contains checksum for this file              ;
; DX - XOR sum                                      ;
;---------------------------------------------------;
Compare_Buffer_Sums:                      ;See if any changes to the sector
        CMP     WORD PTR[SCT_CW1],'oW'    ;Any change to check word?
        JNE     Buffer_change_detected    ;  If not =, report the change
        CMP     WORD PTR[SCT_CW2],'gn'    ;Any change to check word?
        JNE     Buffer_change_detected    ;  If not =, report the change
        CMP     WORD PTR[SCT_Ind],0FFFFh  ;Any change to indicator word?
        JNE     Buffer_change_detected    ;  If not =, report the change
        CMP     SCT_XOR,DX                ;Any change to XOR sum?
        JNE     Buffer_change_detected    ;  If not =, report the change
        CMP     SCT_CHK,DI                ;Is the checksum OK?
        JNE     Buffer_change_detected    ;  If not, report the change
                                          ;  ELSE all is OK with Buffer sector
        MOV     DX,offset OK_Msg          ;Explain that all is well
        MOV     AH,09H                    ;DOS display string function
        INT     21h
        RET

Buffer_Change_detected:                   ;Report problem with Buffer record
        MOV     DX,offset Bad_Msg         ;Explain that its bad
        MOV     AH,09H                    ;DOS display string function
        INT     21H
Missing_or_Invalid_Reload_File:
        CALL    Wait_For_Key              ;Beep and force user to hit a key
        MOV     AX,4C20h                  ;DOS terminate with 32 error level
        INT     21h

;---------------------------------------------------;
; W R I T E    B O O T   S E C T O R                ;
;---------------------------------------------------;
;Write the DOS boot sector using DOS I/O requests.  ;
;---------------------------------------------------;
Write_Boot_Sector:
        PUSH    BP                        ;Save all current registers
Try_boot_write_again:                     ;Come here to retry the extended
       ;form of the write if normal int 26h failed. Note, it is NOT an error
       ;that we re-execute the 19h function...some systems require this
        MOV     DX,offset Boot_Msg        ;Display message about boot record
        MOV     AH,09H                    ;DOS display string function
        INT     21H
        MOV     AH,19h                    ;DOS get current disk drive function
        INT     21h                       ;Get current disk drive in AL (0=A)
        CMP     DOS_Version,4             ;Are we running under DOS 4.x?
        JNE     Old_DOS                   ;If not, do normal int 26 call
; Process DOS 4.0 disks using extended format of INT26 (handles disks > 32mb)
        MOV     CX,-1                     ;Set indicator to handle >32 mb disks
        MOV     BX,Offset INT26_Parms     ;Point to 10 byte parameter block
        MOV     Buffer_Segment,DS         ;Segment address in parameter block
        JMP     SHORT DOS_Abs_Write       ;Do DOS Absolute sector read
Old_DOS:
        MOV     CX,1                      ;Write just one sector
        XOR     DX,DX                     ;DX=0 to write DOS relative sector 0
        MOV     BX,Offset buffer          ;Place to put the sector
DOS_Abs_Write:
        INT     26h                       ;DOS absolute disk write function
        JNC     Boot_write_OK             ;If I/O was successful
                                          ;Else we had an I/O error
;
; Since some OEM versions of DOS such as COMPAQ 3.31 also support the extended
; format of the int 26h call for disks > 32mb we will lie and say this is
; DOS 4.x and try the interrupt 4.0 using the extended format call.
        POPF                              ;Restore flags INT 26 put on stack
        CMP     DOS_Version,4             ;Did we already try DOS 4.x type int?
        JE      Unrecoverable_IO_Error    ;  If so, then boot Write failed
                                          ;  otherwise try extended int 26h
        MOV     DOS_Version,4             ;  Force extended int 26h use (lie)
        JMP     SHORT Try_Boot_Write_Again ;  do func 19h and then extd int 26h

Unrecoverable_IO_Error:                   ;Exit here if I/O has failed
        MOV     DX,offset IO_ERR_MSG      ;Explain that input/output failed
        MOV     AH,09H                    ;DOS display string function
        INT     21H
Error_termination:
        CALL    Wait_For_Key              ;Beep and force user to hit a key
        MOV     AX,4C40h                  ;   terminate with 64 DOS ERRORLEVEL
        INT     21h
Boot_write_OK:
        POPF                              ;restore flags pushed by INT 26h
        POP     BP                        ;Restore active registers
        MOV     DX,offset BOOT_Done       ;Tell user that all is OKeeDOKEY
        MOV     AH,09H                    ;DOS display string function
        INT     21H
        RET


Open_Failure:                             ;Come here when open of .SCT fails
        MOV     DX,offset Open_Fail_Msg   ;Explain that open failed
        MOV     AH,09H                    ;DOS display string function
        INT     21H
        JMP     SHORT Missing_or_Invalid_Reload_File  ;Alert to serious problem


;---------------------------------------------------;
; W R I T E    P A R T   S E C T O R                ;
;---------------------------------------------------;
;Write the partition sector using BIOS I/O request  ;
;---------------------------------------------------;
Write_part_Sector:
        MOV     DX,offset Part_Msg        ;Display writing partition sectr msg
        MOV     AH,09H                    ;DOS display string function
        INT     21H
        MOV     AH,03                     ;BIOS floppy write function of INT 13h
        MOV     DL,BYTE PTR[Drive_number] ;Drive 80 (1st) or 81 (2nd) hard drive
        MOV     AL,1                      ;Write only 1 sector
        MOV     CX,1                      ;Write (CH) track 0, (CL) sector 1
        XOR     DH,DH                     ;write head number zero
        MOV     BX,Offset buffer          ;Place to put the sector
        INT     13h                       ;BIOS absolute (floppy) disk write
        JNC     Part_write_OK             ;If I/O was successful
                                          ;Else the we had an I/O error
        MOV     DX,offset No_HardDisk_MSG ;Display message about missing part
        MOV     AH,09H                    ;DOS display string function
        INT     21H
        JMP     SHORT Unrecoverable_IO_Error
Part_write_OK:
        MOV     DX,offset Part_Done       ;Tell user that all is OKeeDOKEY
        MOV     AH,09H                    ;DOS display string function
        INT     21H
        RET

;---------------------------------------------------;
; R E A D    B O O T   S E C T O R   (F I L E)      ;
;---------------------------------------------------;
;Read the reloadable version of the boot sector from;
;DISK. Also validate the boot sector after reading. ;
;---------------------------------------------------;
Read_Boot_SCT:
        MOV     DX,offset BootR_MSG       ;Display msg about reading .SCT file
        MOV     AH,09H                    ;DOS display string function
        INT     21H
        MOV     AX,3D00h                  ;DOS open file for read command
        MOV     DX,Offset Boot_File_Name
        INT     21h
        JNC     Open_Boot_OK              ;IF all went OK then return
        JMP     Open_Failure              ;Inform user that open failed
Open_Boot_OK:
        MOV     BX,AX                     ;Handle for Boot sector file
        MOV     AH,3Fh                    ;DOS Read function code
        MOV     CX,581                    ;read 581 bytes from disk
        MOV     DX,OFFSET Read_Buffer     ;Location to put data from disk
        INT     21h                       ;Do the I/O
        JNC     Boot_Read_OK              ;If I/O was successful
                                          ;Else the we had an I/O error
        JMP     Buffer_Change_Detected    ;Tell user that reload file is bad
Boot_Read_OK:                             ;Read of reload file was OK
        MOV     AH,3Eh                    ;DOS close file function code
        INT     21h                       ;Close the file
        CALL    Calc_Sums                 ;Calculate CHK and XOR sums
        CALL    Compare_Buffer_Sums       ;Verify that they match
        CMP     BYTE PTR[SCT_Type],Boot_type  ;Is it really a boot sector?
        JE      Boot_Validate_Done        ;  yes it is...
        JMP     Buffer_Change_Detected    ;  else, Report the error to the user
Boot_Validate_Done:
        RET


;---------------------------------------------------;
; R E A D    P A R T   S E C T O R   (F I L E)      ;
;---------------------------------------------------;
;Read reloadable version of the partition sector.   ;
;Also validate the itegrity of the reload file.     ;
;---------------------------------------------------;
Read_Part_SCT:
        MOV     DX,offset PartR_MSG       ;Display msg about writing Part file
        MOV     AH,09H                    ;DOS display string function
        INT     21H
        MOV     AX,3D00h                  ;DOS open file for read command
        MOV     DX,Offset Part_File_Name
        INT     21h
        JNC     open_Part_OK              ;IF all went OK then return
        JMP     OPEN_Failure              ;Inform user that open failed
Open_Part_OK:
        MOV     BX,AX                     ;Handle for Part sector file
        MOV     AH,3Fh                    ;DOS Read function code
        MOV     CX,581                    ;Read 581 bytes from disk
        MOV     DX,OFFSET Read_Buffer     ;Location to put data from disk
        INT     21h                       ;Do the I/O
        JNC     Part_Read_OK              ;If I/O was successful
                                          ;Else the we had an I/O error
        JMP     Buffer_Change_Detected    ;Tell user that reload file is bad
Part_Read_OK:                             ;Read of partition reload file OK
        MOV     AH,3Eh                    ;DOS close file function code
        INT     21h                       ;Close the file
        CALL    Calc_Sums                 ;Calculate CHK and XOR sums
        CALL    Compare_Buffer_Sums       ;Verify that they match
        CMP     BYTE PTR[SCT_Type],Part_type  ;Is it really a boot sector?
        JE      Part_Validate_Done        ;  yes it is...
        JMP     Buffer_Change_Detected    ;  else, Report the error to the user
Part_Validate_Done:
        RET


        SUBTTL  General Purpose subroutines
        PAGE
;******************************************************************************;
;**   General purpose subroutines follow                                     **;
;******************************************************************************;
        SUBTTL  General purpose subroutines
        PAGE
;---------------------------------------------------;
; C A L C     S U M S  - Calculate XOR + CHK sums   ;
;---------------------------------------------------;
; INPUT:  reads 1st sector in BUFFER to scan        ;
;                                                   ;
;Register conventions:                              ;
;                                                   ;
; AL - Each new character read into this register   ;
; CX - number of chars read in -decreasing counter  ;
; DI - Contains checksum for this file              ;
; DX - XOR sum                                      ;
; SI - index pointing into file BUFFER              ;
; --------------------------------------------------;
Calc_Sums:
        MOV     SI,offset BUFFER          ;Point SI to buffer containing sector
        MOV     CX,Sector_Size            ;Process all bytes in a sector
        XOR     DX,DX                     ;Zero XOR sum
        XOR     DI,DI                     ;Zero CHK sum
        XOR     AH,AH                     ;Zero upper part of AX for addition

; Innermost read char loop  - keep this fast!
NEXT_CHAR:
        LODSB                             ;Get char into AL
        XOR     DL,AL                     ;cumulative XOR into DX
                                          ;following instr modified by /X parm
ROL_op: ROL     DX,1                      ;Keep shifting to XOR sum to left
                                          ;following instr modified by /C parm
ADD_op: ADD     DI,AX                     ;cumulative check sum
        LOOP    NEXT_CHAR                 ;CONTINUE SCANNING CHARS UNTIL EOB
        RET                               ;All done calculating sums!

;---------------------------------------------------;
; W A I T   F O R   K E Y                           ;
;---------------------------------------------------;
; 1) Send out a BEEP                                ;
; 2) Determine screen attribute (screen colors)     ;
; 3) Determine what line cursor is on               ;
; 4) Put out message to hit any key on that line    ;
; 5) Wait for any key press                         ;
; 6) Erase message using current screen attribute   ;
; 7) Position currsor back at start of current line.;
; --------------------------------------------------;
; *** NO REGISTERS ARE SAVED ***                    ;
; --------------------------------------------------;
Wait_For_Key:                             ;Force user to notice error
; Produce a beep to alert the user:  (use  BIOS TTY func to write an ASCII BELL)
        MOV     AX,0E07H                  ;BIOS func (0Eh) to write (07H) beep
        XOR     BH,BH                     ;Select page zero for output
        INT     10H                       ;BIOS video function (0Eh=write char)

;Find out what attribute is being used for display
        MOV     AH,08h                    ;read attrib + char function
        INT     10h                       ;Call BIOS
        PUSH    AX                        ;Save AH=attribute byte

;Find out what line the cursor is on
        MOV     AH,03h                    ;Read cursor position function
        INT     10h                       ;BIOS video services
        PUSH    DX                        ;DH contains row (line #) Save it!

; Position cursor to current line + column 28: (TO BIOS  row 27)
        MOV     AH,02                     ;BIOS int 10h set cursor position func
        XOR     BH,BH                     ;Set page to zero
                                          ;DH contains current row
        MOV     DL,1Bh                    ;Set cusor current row and col 27
        INT     10h                       ;BIOS video services

; Put -Hit any key- message out with inverse video attribute type on
;       XOR     BH,BH                     ;Set page to zero  (BH is still 0)
        MOV     BL,0F0h                   ;Inverse video attribute
        MOV     CX,1                      ;Character count
        MOV     SI,offset Hit_Key_Msg     ;The hit-any-key message
Display_next_video_char:
        MOV     AH,09H                    ;BIOS int 10h write attrib + char func
        LODSB                             ;Get next character for output
        PUSH    SI                        ;Save SI (int 10h may corrupt it)
        INT     10h                       ;Put character and attribute out
        INC     DX                        ;Advance cursor position
        MOV     AH,02                     ;Adv cursor function
        INT     10h                       ;   advance the cursor (BIOS)
        POP     SI                        ;Restore saved SI
        CMP     SI,offset Hit_key_Msg_end ;are we at end of message?
        JB      Display_next_video_char   ;  If not get next char for display
                                          ;  Else, wait for key press by user
; Wait for user to hit any key
        XOR     AX,AX
        INT     16h                       ;Wait for user to hit a key

; Erase HIT ANY KEY message
        POP     DX                        ;DH=current line number
        POP     BX                        ;BH=user's screen attribute
        MOV     AH,06h                    ;INIT window function
        XOR     AL,AL                     ;Zero AL to clear window
        MOV     CH,DH                     ;Current row (y coor upr lft)
        MOV     CL,00                     ;Start in first char position
        MOV     DL,79                     ;Last char pos - blank entire line
        INT     10h                       ;Blank out line

; Position cursor to start of blanked line
        MOV     AH,02                     ;BIOS int 10h set cursor position func
        XOR     DL,DL                     ;DH=cur line, DL=0: first char pos
        XOR     BX,BX                     ;Use video page zero
        INT     10h                       ;BIOS video services
        RET                               ;Return to caller


        SUBTTL  Initialization Code
        PAGE
; ----------------------------------------------------------------------------;
; Initialization code - parse parms + put out msgs                            ;
; ----------------------------------------------------------------------------;
Parse_parms:                              ;Parse input parameters
        MOV     AH,30h                    ;Check DOS version
        INT     21h                       ;    Ask DOS: "who are you?"
        OR      AL,AL                     ;Check if before DOS 2.x (AL=0)
        JNE     DOS_is_OK                 ;If good DOS vers, then continue
        MOV     DX, OFFSET Bad_DOS_Msg    ;   ELSE  Send MSG that
        MOV     AH,09h                    ;   DOS version is too low.
        INT     21h
        INT     20h                       ;  Old style DOS terminate interupt
DOS_is_OK:
        MOV     DOS_Version,AL            ;Save major DOS version number (0-4)
        MOV     SI,80H                    ;Parameter area in PSP
        MOV     CL,[SI]                   ;Get # of chars in input parm
        XOR     CH,CH                     ;CLEAR UPPER BYTE OF CHR COUNT
        OR      CL,CL                     ;CHECK FOR 0 CHARS (NO INPUT)
        MOV     DX, OFFSET Explanation    ;Give user full explanation of prgm
        JNZ     Continue_parse            ;If some parameters keep going
        JMP     Help_display              ; Else, give user some help info
Continue_parse:
        INC     SI                        ;POINT TO FIRST CHARACTER
        CLD                               ;FORWARD DIRECTION

DEL_SPACES:
        LODSB                             ;Get byte at DS:SI and inc SI
        CMP     AL,'/'                    ;Is it a "/"
        JE      Scan_for_parms            ;If so, we have a parameter
        LOOP    DEL_SPACES                ;CONT CHECKING UNTIL LAST CHAR
        JMP     Help_Display

;---------------------------------------------------------------------------;
; Conventions for command line parsing:                                     ;
;   SI points to next char to be checked in the parm field at DS:80         ;
;   CX is count of characters left to be scanned                            ;
;---------------------------------------------------------------------------;

Scan_for_parms:
        CMP     CX,01                     ;Check if we out of chars to scan
        JA      Parm_Scan                 ;If some are left, check parameters
        JMP     Help_display              ;If so, user needs HELP

Check_parm_chars_left:                    ;Check if enough chars left for a parm
        CMP     CX,01                     ;Check if we out of chars to scan
        JA      Parm_Scan                 ;  if not continue chcking for /parms
        RET                               ;  If so, return
Parm_Scan:                                ;Check for presence of a /_ parm
        CMP     AL,'/'                    ;check for "/" parm character
        JE      Parm_found
        CMP     AL,' '                    ;check for blanks
        JNE     Unrecog_parm              ;If other than blank its illegal...
        LODSB                             ;Keep checking next character
        LOOP    Parm_Scan
        RET                               ;All done

Parm_Found:                               ;Check if parm is valid
        DEC     CX                        ;Adjust chars remaining counter
        JCXZ    Unrecog_parm              ;IF no chars left then parm is invalid
        LODSB                             ;Get next char
        DEC     CX                        ;Adjust chars remaining counter
        CMP     AL,'2'                    ;Is it the Initialize parm?
        JE      Two_parm                  ;2 parm detected..
        AND     AL,5Fh                    ;Capitalize char
        CMP     AL,'P'                    ;Is it Partition table parm?
        JE      P_parm                    ;P parameter detected
        CMP     AL,'B'                    ;Is it the Boot record parm?
        JE      B_parm                    ;I parm detected..
Unrecog_parm:                             ; an illegal paramter:
        MOV     DX, offset Bad_Parm_Msg   ;indicate illegal parm was found
        MOV     AH,09H                    ;DOS display string function
        INT     21H
        JMP     SHORT ERR_Exit            ;terminate with error level set

Too_Many_Parms:                           ;User has entered more than 1 parm
        MOV     DX, offset Too_ManyP_Msg  ;indicate more than 1 found
        MOV     AH,09H                    ;DOS display string function
        INT     21H
        JMP     SHORT ERR_Exit            ;terminate with error level set

P_parm:
        CMP     Parm_Already_Found,'Y'    ;Is this the 2nd parm?
        JE      Too_Many_Parms            ;  If so, give error message
        MOV     Partition_wanted,'Y'      ;Indicate user wants partition table
        MOV     Parm_Already_Found,'Y'    ;Indicate user has entered a parm
        LODSB                             ;Keep checking next character
        JMP     SHORT Check_Parm_chars_left     ;Check for additional parms

B_parm:
        CMP     Parm_Already_Found,'Y'    ;Has user already selected /P
        JE      Too_Many_Parms            ;  If so, give error message
        MOV     Boot_wanted,'Y'           ;Indicate user wants boot record
        MOV     Parm_Already_Found,'Y'    ;Indicate user has entered a parm
        LODSB                             ;Keep checking next character
        JMP     SHORT Check_Parm_chars_left     ;Check for additional parms

Two_parm:                                 ;/2 parm (read partition on 2nd disk)
        CMP     Parm_Already_Found,'Y'    ;Has user already selected /P
        JE      Too_Many_Parms            ;  If so, give error message
        MOV     Partition_wanted,'Y'      ;Indicate user wants a partition table
        MOV     Partition2_wanted,'Y'     ;Indicate user wants 2nd partitn table
        MOV     Parm_Already_Found,'Y'    ;Indicate user has entered a parm
        INC     Drive_number              ;Write drive num 81 (2nd hard drive)
        LODSB                             ;Keep checking next character
        JMP     Check_Parm_chars_left     ;Check for additional parms

ERR_EXIT:
        CALL    Wait_For_Key              ;Beep and force user to hit a key
Syntax_msg_only:
        MOV     DX, offset Syntax_Msg     ;show user correct syntax
Help_Display:
        MOV     AH,09H                    ;DOS display string function
        INT     21H
        MOV     AX,4C80h                  ;   terminate with 128 DOS ERRORLEVEL
        INT     21h



        SUBTTL  Definition of Data structures
        PAGE
;******************************************************************************;
;**   Definition of Data areas follow                                        **;
;******************************************************************************;
Boot_wanted         DB 'N'                ;Read DOS boot sector Y or N?
Partition_Wanted    DB 'N'                ;Read any Partition sector Y or N?
Partition2_Wanted   DB 'N'                ;Read part on 2nd disk Y or N?
Parm_Already_found  DB 'N'                ;Read part on 2nd disk Y or N?
DOS_Version         DB 00                 ;Major version of DOS used (0 - 4)
Sector_Size         DW 00                 ;Number of bytes per sector

INT26_Parms         LABEL BYTE            ;DOS 4.0 INT25/26 parameter block
Sector_Number       DD  00                ;DOS logical sector number to write
Sector_Count        DW  01                ;Write 1 sector
Buffer_Offset       DW  OFFSET Buffer     ;Buffer address - offset
Buffer_Segment      DW  0                 ;  segment - set at run time

BootR_MSG     DB  'Reading "@@BOOT.SCT."',CR,LF,'$'
PartR_MSG     DB  'Reading "@@PARTIT.SCT".',CR,LF,'$'
IO_ERR_Msg    DB  'An unrecoverable I/O error has occurred.',CR,LF,'$'
No_hardDisk_MSG DB  'Partition sector not processed. Unable to write to disk'
              DB  CR,LF,'$'
Open_Fail_Msg DB  'Unable to open the (.SCT) reload file.',CR,LF,'$'
Part_Msg      DB  'Writing the partition sector....','$'
Boot_Msg      DB  'Writing the DOS boot sector....','$'
Part_done     DB  'Partition sector successfully reloaded.',CR,LF,'$'
Boot_done     DB  'Boot sector successfully reloaded.',CR,LF,'$'
Bad_DOS_Msg   DB  'DOS 2.x or higher required.',CR,LF,'$'
OK_Msg        DB  'Sector reload file (.SCT) is '
              DB  ' valid.',CR,LF,'$'
Bad_Msg       DB  ' Sector reload file (*.SCT) is corrupted (changed).',CR,LF
              DB  'It is not safe to reload from it.',CR,LF,'$'
Hit_Key_MSG   DB   '-Hit any key-'
Hit_Key_MSG_end EQU $
Boot_File_name DB '@@BOOT.SCT',00         ;ASCIIZ string of boot sector file
Part_File_name DB '@@PARTIT.SCT',00       ;ASCIIZ string of partition file
Drive_number  DW  80h                     ;Drive number for BIOS hard disk read
Too_ManyP_Msg DB  'Only one parameter may be used at a time (/B, /P or /2).'
              DB   cr,lf,lf,'$'
Bad_Parm_Msg  DB  'Unrecognized parameter detected.',cr,lf,'$'
Explanation DB  'LODBOOT will reload either the DOS boot record or the '
            DB   'partition sector',CR,LF
            DB  '(not both at the same time) from the "@@BOOT.SCT" or the'
            DB  ' "@@PARTIT.SCT"',CR,LF
            DB  'reload files. These files are created by "CHKboot/I".  These'
            DB  ' files must be on',CR,LF
            DB  'the disk and directory from which you run LODBOOT.'
            DB  CR,LF,LF
Syntax_Msg  DB  CR,LF,'Syntax is: LODBOOT  [/B] [/P] [/2]',CR,LF,LF
            DB  ' "/B"  Reads "@@BOOT.SCT" and reloads the DOS boot record on '
            DB  'the current disk.',CR,LF
            DB  ' "/P"  Reads "@@PARTIT.SCT" and reloads partition sector on '
            DB  '1st physical hard',CR,LF
            DB  '       disk drive.',CR,LF
            DB  ' "/2"  Reloads partition sector on 2nd physical hard disk.'
            DB  CR,LF,LF
            DB  'Only one of the above parameters may be specified at a time.'
            DB  CR,LF,LF
            DB  'The ".SCT" reload files must be created by program "CHKboot". '
            DB  'LODBOOT',CR,LF
            DB  'will detect if the ".SCT" files have changed.  If these files '
            DB  'have been',CR,LF
            DB  'corrupted (changed), LODBOOT will refuse to reload the sectors'
            DB  '.',CR,LF,LF

Header_msg    LABEL  BYTE
  DB UPLT_Corner,76 DUP(Horizontal),UPRT_Corner,CR,LF
  DB vertical,"  LODBOOT 1.0  PCDATA TOOLKIT Copyright (c) 1990 Ziff "
  DB "Communications Co.   ",vertical,CR,LF
  DB Vertical,"                     PC Magazine  Wolfgang Stiller    "
  DB "                     ",vertical,CR,LF
  DB LWLT_Corner,76 DUP(Horizontal),LWRT_Corner,CR,LF,'$'

Read_Buffer DB  'LODBOOT reload file. Copy me to a floppy.abc'
SCT_CW1     DB  'defghi'             ;Check word 1 in header
SCT_CW2     DB  'jklmnopqrs',CR,LF      ;word 2
SCT_Ind     DW  0FFFFh                  ;Special boot/partition indicator
SCT_TYPE    DB  0FFh                    ;Indicate if this is boot or part rec
                                        ; FF=Boot and 55=Partition sector
SCT_CHK     DW  00h                     ;CHK SUM
SCT_XOR     DW  00h                     ;XOR SUM
Buffer      label  byte                 ;All storage + code following is in
                                        ;   the input file buffer.
CSEG        EndS
            END     LODBOOT
