        name    tryqfn
        title   TRYQFN -- QFN demo
        page    55,132
 
;
; TRYQFN.ASM --- demo of QFN routine
;
; Ray Duncan, February 1988
;
 
cr      equ     0dh             ; ASCII carriage return
lf      equ     0ah             ; ASCII line feed
 
stdin   equ     0               ; standard input handle
stdout  equ     1               ; standard output handle
stderr  equ     2               ; standard error handle
 
 
DGROUP  group   _DATA
 
_DATA   segment word public 'DATA'
 
ibuff   db      80 dup (0)      ; input buffer
 
msg1    db      cr,lf,lf        
        db      'Enter filename:        '
msg1_len equ $-msg1
 
msg2    db      cr,lf
        db      'The full pathname is:  '
msg2_len equ $-msg2
 
msg3    db      cr,lf
        db      'Bad filename!'
msg3_len equ $-msg3
 
_DATA   ends
 
 
_TEXT   segment word public 'CODE'
 
        extrn   qfn:near
 
        assume  cs:_TEXT,ds:DGROUP
 
main    proc    near
                                
        mov     ax,_DATA        ; make our data segment
        mov     ds,ax           ; addressable...
        mov     es,ax
 
main1:                          ; display prompt...
                                ; address of message
        mov     dx,offset DGROUP:msg1
        mov     cx,msg1_len     ; length of message
        mov     bx,stdout       ; standard output handle
        mov     ah,40h          ; function 40h = write
        int     21h             ; transfer to MS-DOS
 
                                ; get a filename...
                                ; address of buffer
        mov     dx,offset DGROUP:ibuff  
        mov     cx,64           ; maximum entry length
        mov     bx,stdin        ; standard input handle
        mov     ah,3fh          ; function 3fh = read
        int     21h             ; transfer to MS-DOS
 
        cmp     ax,2            ; anything entered?
        je      main3           ; empty line, exit
 
                                ; call QFN routine to
                                ; validate and qualify
                                ; the filename...
 
        sub     ax,2            ; AX = length (decrease
                                ; to remove CR-LF)
                                ; DS:SI = addr of filename
        mov     si,offset DGROUP:ibuff
        call    qfn             ; go qualify filename
        jc      main2           ; jump if bad filename
 
        push    si              ; save qualified filename
        push    ax              ; address and length
 
                                ; first display title...
        mov     dx,offset DGROUP:msg2
        mov     cx,msg2_len     ; message length
        mov     bx,stdout       ; standard output handle
        mov     ah,40h          ; function 40h = write
        int     21h             ; transfer to MS-DOS
 
        pop     cx              ; get filename length
        pop     dx              ; get filename address
        mov     bx,stdout       ; standard output handle
        mov     ah,40h          ; function 40h = write
        int     21h             ; transfer to MS-DOS
 
        jmp     main1           ; get another filename
 
main2:                          ; display error message...
                                ; address of message
        mov     dx,offset DGROUP:msg3
        mov     cx,msg3_len     ; length of message     
        mov     bx,stdout       ; standard output handle
        mov     ah,40h          ; function 40h = write
        int     21h             ; transfer to MS-DOS
        jmp     main1           ; get another filename
                
main3:  mov     ax,4c00h        ; terminate with
        int     21h             ; return code = 0
 
main    endp
        
_TEXT   ends
 
 
STACK   segment para stack 'STACK'
        
        db      128 dup (?)
 
STACK   ends
 
        end     main
