//***************************************************************************
//
//  App1 demonstrates how to use FindWindow to detect previous instances
//  of Win32 apps.
//
//***************************************************************************

#include <windows.h>

LRESULT CALLBACK WndProc (HWND, UINT, WPARAM, LPARAM);

/////////////////////////////////////////////////////////////////////////////
// WinMain

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
    LPSTR lpszCmdLine, int nCmdShow)
{
    static char szAppName[] = "MyApp";
    static char szWndClass[] = "MyWindowClass";
    HWND hwnd, hwndPrev;
    WNDCLASS wc;
    MSG msg;

    if ((hwndPrev = FindWindow (szWndClass, NULL)) != NULL) {
        SetForegroundWindow (hwndPrev);
        return -1;
    }

    wc.style = 0;
    wc.lpfnWndProc = (WNDPROC) WndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon (NULL, IDI_APPLICATION);
    wc.hCursor = LoadCursor (NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
    wc.lpszMenuName = NULL;
    wc.lpszClassName = szWndClass;

    RegisterClass (&wc);

    hwnd = CreateWindow (szWndClass, szAppName,
        WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
        CW_USEDEFAULT, HWND_DESKTOP, NULL, hInstance, NULL);

    ShowWindow (hwnd, nCmdShow);
    UpdateWindow (hwnd);

    while (GetMessage (&msg, NULL, 0, 0)) {
        TranslateMessage (&msg);
        DispatchMessage (&msg);
    }
    return msg.wParam;
}

/////////////////////////////////////////////////////////////////////////////
// Window procedure

LRESULT CALLBACK WndProc (HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    switch (msg) {

    case WM_DESTROY:
        PostQuitMessage (0);
        return 0;
    }
    return DefWindowProc (hwnd, msg, wParam, lParam);
}
