//***************************************************************************
//
//  MASKDEMO.CPP
//
//***************************************************************************

#include <afxwin.h>
#include "maskbmp.h"
#include "maskdemo.h"

CMyApp myApp;

/////////////////////////////////////////////////////////////////////////////
// CMyApp member functions

BOOL CMyApp::InitInstance ()
{
    m_pMainWnd = new CMainWindow ();
    m_pMainWnd->ShowWindow (m_nCmdShow);
    m_pMainWnd->UpdateWindow ();
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainWindow message map and member functions

BEGIN_MESSAGE_MAP (CMainWindow, CFrameWnd)
    ON_WM_CREATE ()
    ON_WM_PAINT ()
END_MESSAGE_MAP ()

CMainWindow::CMainWindow ()
{
    Create (NULL, "Masked Bitmap Demo");
}

int CMainWindow::OnCreate (LPCREATESTRUCT lpCreateStruct)
{
    m_bitmap.LoadBitmap ("DriveImage");
    return 0;
}

void CMainWindow::OnPaint ()
{
    CPaintDC dc (this);
                
    CRect rect;
    GetClientRect (&rect);

    CBrush* pBrush[256];
    for (int i=0; i<256; i++)
        pBrush[i] = new CBrush (RGB (0, 0, 255 - i));

    int nIndex;
    int nWidth = rect.Width ();
    int nHeight = rect.Height ();
    CRect rectLine;

    for (i=0; i<nHeight; i++) {
        nIndex = (i * 255) / nHeight;
        rectLine.SetRect (0, i, nWidth, i + 2);
        dc.FillRect (&rectLine, pBrush[nIndex]);
    }

    for (i=0; i<256; i++)
        delete pBrush[i];

    BITMAP bm;
    m_bitmap.GetObject (sizeof (BITMAP), &bm);
    int cx = (rect.Width () / (bm.bmWidth + 8)) + 1;
    int cy = (rect.Height () / (bm.bmHeight + 8)) + 1;

    int x, y, j;
    for (i=0; i<cx; i++) {
        for (j=0; j<cy; j++) {
            x = 8 + (i * (bm.bmWidth + 8));
            y = 8 + (j * (bm.bmHeight + 8));
            m_bitmap.DrawTransparent (&dc, x, y, RGB (255, 0, 0));
        }
    }
}
