/*---------------------------------------
   MULTI2.C -- Multitasking Demo
               (c) Charles Petzold, 1993
  ---------------------------------------*/

#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <process.h>

typedef struct
     {
     HWND  hwnd ;
     short cxClient ;
     short cyClient ;
     BOOL  bKill ;
     }
     PARAMS, * PPARAMS ;

LONG APIENTRY WndProcMain (HWND, UINT, DWORD, LONG) ;

short cyChar ;

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow)
     {
     static char szAppName[] = "Multi2" ;
     HWND        hwnd ;
     MSG         msg ;
     WNDCLASS    wndclass ;

     wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
     wndclass.lpfnWndProc   = WndProcMain ;
     wndclass.cbClsExtra    = 0 ;
     wndclass.cbWndExtra    = 0 ;
     wndclass.hInstance     = hInstance ;
     wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
     wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
     wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
     wndclass.lpszMenuName  = NULL ;
     wndclass.lpszClassName = szAppName ;

     RegisterClass (&wndclass) ;

     hwnd = CreateWindow (szAppName, "Multitasking Demo",
                          WS_OVERLAPPEDWINDOW,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          NULL, NULL, hInstance, NULL) ;

     ShowWindow (hwnd, nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg, NULL, 0, 0))
          {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
          }
     return msg.wParam ;
     }

int CheckBottom (HWND hwnd, int cyClient, int iLine)
     {
     if (iLine * cyChar + cyChar > cyClient)
          {
          InvalidateRect (hwnd, NULL, TRUE) ;
          UpdateWindow (hwnd) ;
          iLine = 0 ;
          }
     return iLine ;
     }

// Window 1: Display increasing sequence of numbers
// ------------------------------------------------

void Thread1 (PPARAMS pparams)
     {
     int  iNum = 0, iLine = 0 ;
     char szBuffer [16] ;
     HDC  hdc ;

     while (!pparams->bKill)
          {
          if (iNum < 0)
               iNum = 0 ;

          iLine = CheckBottom (pparams->hwnd, pparams->cyClient, iLine) ;

          wsprintf (szBuffer, "%d", iNum++) ;

          hdc = GetDC (pparams->hwnd) ;
          TextOut (hdc, 0, iLine * cyChar, szBuffer, strlen (szBuffer)) ;
          ReleaseDC (pparams->hwnd, hdc) ;

          iLine++ ;
          }
     }

LONG APIENTRY WndProc1 (HWND hwnd, UINT message, DWORD wParam, LONG lParam)
     {
     static PARAMS params ;

     switch (message)
          {
          case WM_CREATE:
               params.hwnd = hwnd ;
               _beginthread (Thread1, 0, &params) ;
               return 0 ;

          case WM_SIZE:
               params.cyClient = HIWORD (lParam) ;
               return 0 ;

          case WM_DESTROY:
               params.bKill = TRUE ;
               return 0 ;
          }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }

// Window 2: Display increasing sequence of prime numbers
// ------------------------------------------------------

void Thread2 (PPARAMS pparams)
     {
     char szBuffer [16] ;
     int  iNum = 1, iLine = 0, i, iSqrt ;
     HDC  hdc ;

     while (!pparams->bKill)
          {
          do
               {
               if (++iNum < 0)
                    iNum = 0 ;

               iSqrt = (int) sqrt (iNum) ;

               for (i = 2 ; i <= iSqrt ; i++)
                    if (iNum % i == 0)
                         break ;
               }
          while (i <= iSqrt) ;

          iLine = CheckBottom (pparams->hwnd, pparams->cyClient, iLine) ;

          wsprintf (szBuffer, "%d", iNum) ;

          hdc = GetDC (pparams->hwnd) ;
          TextOut (hdc, 0, iLine * cyChar, szBuffer, strlen (szBuffer)) ;
          ReleaseDC (pparams->hwnd, hdc) ;

          iLine++ ;
          }
     }

LONG APIENTRY WndProc2 (HWND hwnd, UINT message, DWORD wParam, LONG lParam)
     {
     static PARAMS params ;

     switch (message)
          {
          case WM_CREATE:
               params.hwnd = hwnd ;
               _beginthread (Thread2, 0, &params) ;
               return 0 ;

          case WM_SIZE:
               params.cyClient = HIWORD (lParam) ;
               return 0 ;

          case WM_DESTROY:
               params.bKill = TRUE ;
               return 0 ;
          }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }

// Window 3: Display increasing sequence of Fibonacci numbers
// ----------------------------------------------------------

void Thread3 (PPARAMS pparams)
     {
     char szBuffer [16] ;
     int  iNum = 0, iNext = 1, iLine = 0, iTemp ;
     HDC  hdc ;

     while (!pparams->bKill)
          {
          if (iNum < 0)
               {
               iNum  = 0 ;
               iNext = 1 ;
               }

          iLine = CheckBottom (pparams->hwnd, pparams->cyClient, iLine) ;

          wsprintf (szBuffer, "%d", iNum) ;

          hdc = GetDC (pparams->hwnd) ;
          TextOut (hdc, 0, iLine * cyChar, szBuffer, strlen (szBuffer)) ;
          ReleaseDC (pparams->hwnd, hdc) ;

          iTemp  = iNum ;
          iNum   = iNext ;
          iNext += iTemp ;

          iLine++ ;
          }
     }

LONG APIENTRY WndProc3 (HWND hwnd, UINT message, DWORD wParam, LONG lParam)
     {
     static PARAMS params ;

     switch (message)
          {
          case WM_CREATE:
               params.hwnd = hwnd ;
               _beginthread (Thread3, 0, &params) ;
               return 0 ;

          case WM_SIZE:
               params.cyClient = HIWORD (lParam) ;
               return 0 ;

          case WM_DESTROY:
               params.bKill = TRUE ;
               return 0 ;
          }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }

// Window 4: Display circles of random radii
// -----------------------------------------

void Thread4 (PPARAMS pparams)
     {
     HDC hdc ;
     int iDiameter ;

     while (!pparams->bKill)
          {
          InvalidateRect (pparams->hwnd, NULL, TRUE) ;
          UpdateWindow (pparams->hwnd) ;

          iDiameter = rand() % min (pparams->cxClient, pparams->cyClient) ;

          hdc = GetDC (pparams->hwnd) ;

          Ellipse (hdc, (pparams->cxClient - iDiameter) / 2,
                        (pparams->cyClient - iDiameter) / 2,
                        (pparams->cxClient + iDiameter) / 2,
                        (pparams->cyClient + iDiameter) / 2) ;

          ReleaseDC (pparams->hwnd, hdc) ;
          }
     }

LONG APIENTRY WndProc4 (HWND hwnd, UINT message, DWORD wParam, LONG lParam)
     {
     static PARAMS params ;

     switch (message)
          {
          case WM_CREATE:
               params.hwnd = hwnd ;
               _beginthread (Thread4, 0, &params) ;
               return 0 ;

          case WM_SIZE:
               params.cxClient = LOWORD (lParam) ;
               params.cyClient = HIWORD (lParam) ;
               return 0 ;

          case WM_DESTROY:
               params.bKill = TRUE ;
               return 0 ;
          }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }

// Main window to create child windows
// -----------------------------------

LONG APIENTRY WndProcMain (HWND hwnd, UINT message, DWORD wParam, LONG lParam)
     {
     static char  * szChildClass  [] = { "Child1", "Child2",
                                         "Child3", "Child4" } ;
     static HWND    hwndChild [4] ;
     static WNDPROC lpfnChildProc [] = { WndProc1, WndProc2,
                                         WndProc3, WndProc4 } ;
     HINSTANCE      hInstance ;
     int            i ;
     short          cxClient, cyClient ;
     WNDCLASS       wndclass ;

     switch (message)
          {
          case WM_CREATE:
               hInstance = (HINSTANCE) GetWindowLong (hwnd, GWL_HINSTANCE) ;

               wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
               wndclass.cbClsExtra    = 0 ;
               wndclass.cbWndExtra    = 0 ;
               wndclass.hInstance     = hInstance ;
               wndclass.hIcon         = NULL ;
               wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
               wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
               wndclass.lpszMenuName  = NULL ;

               for (i = 0 ; i < 4 ; i++)
                    {
                    wndclass.lpfnWndProc   = lpfnChildProc [i] ;
                    wndclass.lpszClassName = szChildClass [i] ;

                    RegisterClass (&wndclass) ;

                    hwndChild [i] = CreateWindow (szChildClass [i], NULL,
                          WS_CHILDWINDOW | WS_BORDER | WS_VISIBLE,
                          0, 0, 0, 0, hwnd, (HMENU) i, hInstance, NULL) ;
                    }

               cyChar = HIWORD (GetDialogBaseUnits ()) ;
               return 0 ;

          case WM_SIZE:
               cxClient = LOWORD (lParam) ;
               cyClient = HIWORD (lParam) ;

               for (i = 0 ; i < 4 ; i++)
                    MoveWindow (hwndChild [i], (i % 2) * cxClient / 2,
                                               (i > 1) * cyClient / 2,
                                cxClient / 2, cyClient / 2, TRUE) ;
               return 0 ;

          case WM_CHAR:
               if (wParam == '\x1B')
                    DestroyWindow (hwnd) ;

               return 0 ;

          case WM_DESTROY:
               PostQuitMessage (0) ;
               return 0 ;
          }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }
