// WINAPP - WIN16 and WIN32 Portable Application Skeleton
// Copyright (C) 1992 Ray Duncan
// PC Magazine * Ziff Davis Publishing

#define dim(x) (sizeof(x) / sizeof(x[0]))   // returns no. of elements

#include "windows.h"
#include "winapp.h"

HANDLE hInst;                               // module instance handle
HWND hFrame;                                // handle for frame window

char szShortAppName[] = "WinApp";           // short application name
char szAppName[] = "Windows Demo App";      // long application name
char szMenuName[] = "WinAppMenu";           // name of menu resource
char szIconName[] = "WinAppIcon";           // name of icon resource

//
// Table of window messages supported by FrameWndProc()
// and the functions which correspond to each message.
//
struct decodeUINT messages[] = {
    WM_PAINT, DoPaint,
    WM_COMMAND, DoCommand,
    WM_DESTROY, DoDestroy, } ;

//
// Table of menubar item IDs and their corresponding functions.
//
struct decodeUINT menuitems[] = {
    IDM_EXIT, DoMenuExit,
    IDM_ABOUT, DoMenuAbout, } ;

//
// WinMain -- entry point for this application from Windows.
//
INT APIENTRY WinMain(HANDLE hInstance,
    HANDLE hPrevInstance, LPSTR lpCmdLine, INT nCmdShow)
{
    MSG msg;

    hInst = hInstance;                      // save this instance handle

    if(!hPrevInstance)                      // if first instance,
        if(!InitApp(hInstance))             // register window class
            return(FALSE);                  // exit if couldn't register

    if(!InitInstance(hInstance, nCmdShow))  // create this instance's window
        return(FALSE);                      // exit if create failed

    while(GetMessage(&msg, NULL, 0, 0))     // while message != WM_QUIT
    {
        TranslateMessage(&msg);             // translate virtual key codes
        DispatchMessage(&msg);              // dispatch message to window
    }

    TermInstance(hInstance);                // clean up for this instance
    return(msg.wParam);                     // return code = WM_QUIT value
}

//
// InitApp --- global initialization code for this application.
//
BOOL InitApp(HANDLE hInstance)
{
    WNDCLASS  wc;

    // set parameters for frame window class
    wc.style = CS_HREDRAW|CS_VREDRAW;       // class style
    wc.lpfnWndProc = FrameWndProc;          // class callback function
    wc.cbClsExtra = 0;                      // extra per-class data
    wc.cbWndExtra = 0;                      // extra per-window data
    wc.hInstance = hInstance;               // handle of class owner
    wc.hIcon = LoadIcon(hInst, szIconName); // application icon
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);       // default cursor
    wc.hbrBackground = GetStockObject(WHITE_BRUSH); // background color 
    wc.lpszMenuName =  szMenuName;          // name of menu resource
    wc.lpszClassName = szShortAppName;      // name of window class

    return(RegisterClass(&wc));             // register class, return status
}

//
// InitInstance --- instance initialization code for this application.
//
BOOL InitInstance(HANDLE hInstance, INT nCmdShow)
{
    hFrame = CreateWindow(                  // create frame window
        szShortAppName,                     // window class name
        szAppName,                          // text for title bar
        WS_OVERLAPPEDWINDOW,                // window style
        CW_USEDEFAULT, CW_USEDEFAULT,       // default position
        CW_USEDEFAULT, CW_USEDEFAULT,       // default size
        NULL,                               // no parent window
        NULL,                               // use class default menu
        hInstance,                          // window owner
        NULL);                              // unused pointer

    if(!hFrame) return(FALSE);              // error, can't create window

    ShowWindow(hFrame, nCmdShow);           // make frame window visible
    UpdateWindow(hFrame);                   // force WM_PAINT message
    return(TRUE);                           // return success flag
}

//
// TermInstance -- instance termination code for this application.
//
BOOL TermInstance(HANDLE hinstance)
{
    return(TRUE);                           // return success flag
}

//
// FrameWndProc --- callback function for application frame window.
//
LONG CALLBACK FrameWndProc(HWND hWnd, UINT wMsg, UINT wParam, LONG lParam)
{
    INT i;                                  // scratch variable

    for(i = 0; i < dim(messages); i++)      // decode window message and
    {                                       // run corresponding function
        if(wMsg == messages[i].Code)
            return((*messages[i].Fxn)(hWnd, wMsg, wParam, lParam));
    }
                                            // or hand off to Windows
    return(DefWindowProc(hWnd, wMsg, wParam, lParam));
}

//
// DoCommand -- process WM_COMMAND message for frame window by
// decoding the menubar item with the menuitems[] array, then
// running the corresponding function to process the command.
// 
LONG DoCommand(HWND hWnd, UINT wMsg, UINT wParam, LONG lParam)
{
    INT i;                                  // scratch variable

    for(i = 0; i < dim(menuitems); i++)     // decode menu command and
    {                                       // run corresponding function
        if(wParam == menuitems[i].Code)
            return((*menuitems[i].Fxn)(hWnd, wMsg, wParam, lParam));
    }

    return(DefWindowProc(hWnd, wMsg, wParam, lParam));
}

//
// DoDestroy -- process WM_DESTROY message for frame window.
// 
LONG DoDestroy(HWND hWnd, UINT wMsg, UINT wParam, LONG lParam)
{
    PostQuitMessage(0);                     // force WM_QUIT message to
    return(0);                              // terminate the event loop
}

//
// DoPaint -- process WM_PAINT message for frame window.
// 
LONG DoPaint(HWND hWnd, UINT wMsg, UINT wParam, LONG lParam)
{
    HDC hdc;
    PAINTSTRUCT ps;
    RECT rect;
    HFONT hfont;

    hdc = BeginPaint(hWnd, &ps);            // get device context
    GetClientRect(hWnd, &rect);             // get client area dimensions
    hfont = CreateFont(-36, 0, 0, 0, 700,   // get handle for pretty font
        TRUE, 0, 0, ANSI_CHARSET,
        OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
        DEFAULT_QUALITY, (FF_MODERN << 4) + DEFAULT_PITCH,
        "Ariel");
    SelectObject(hdc, hfont);               // realize font in DC
    DrawText(hdc, "Hey, Dude!", -1,         // paint text in window
        &rect, DT_CENTER | DT_VCENTER | DT_SINGLELINE); 
    EndPaint(hWnd, &ps);                    // release device context
    return(0);                              // terminate the event loop
}

//
// DoMenuExit -- process File-Exit command from menu bar.
// 
LONG DoMenuExit(HWND hWnd, UINT wMsg, UINT wParam, LONG lParam)
{
    SendMessage (hWnd, WM_CLOSE, 0, 0L);    // send window close message    
    return(0);                              // to shut down the app
}

//
// DoMenuAbout -- process File-About command from menu bar.
// 
LONG DoMenuAbout(HWND hWnd, UINT wMsg, UINT wParam, LONG lParam)
{
    WNDPROC lpProcAbout;                    // scratch far pointer

    lpProcAbout = MakeProcInstance((WNDPROC)AboutDlgProc, hInst);
    DialogBox(hInst, "AboutBox", hWnd, lpProcAbout);         
    FreeProcInstance(lpProcAbout);
    return(0);                              
}

//
// AboutDlgProc -- callback routine for About... dialog
// 
BOOL CALLBACK AboutDlgProc (HWND hwnd, UINT msg, UINT wParam, LONG lParam)
{
    if((msg == WM_COMMAND) && (wParam == IDOK))
        EndDialog(hwnd, 0);
    else
        return(FALSE);
}



