// myscroll.h RHS 11/5/91

#if !defined(MYSCROLL_H)
#define MYSCROLL_H

#include"scroller.h"
#include"keyboard.h"
#include"dupes.h"
#include"buffer.h"

const DIRNAMELEN = 68;

class MyScroller : public Scroller, public Dupes
    {
    int numRows;                // number of records in file
    int startRow;               // first record in buffer
    int endRow;                 // last record in buffer
    char far *DirNames;
    Window *pathW;
    BYTE purges_ok;
    BufMgr bufMgr;
    char file1[80], file2[80];

//    void DispBuffer(int line, int bufnum, BYTE attribute = SCROLLER_NORMAL);
    void BufMgt(int action);

public:
    MyScroller(Window *pathw,char *title, DWORD position, BYTE colors = SCROLLER_NORMAL_COLORS);
    ~MyScroller(void);
    void Init(int numbufs, int sizebufs);
    void Open(void);

    void KeyProcess(int key);
    void FillBufs(void);
    void FormatRecord(char *buf);
    void DispPath(void);
    void PurgeAttributes(void);
    void Delete(void);
    void Purge(void);
    char *CurFileName(char *buf);
    void Select(void);

    char *GetBuffer(int bufnum); //     {   return bufMgr[bufnum]->buffer;  }
    BYTE GetAttribute(int bufnum); //   {   return bufMgr[bufnum]->attribute;   }
    void SetBuffer(int bufnum, char *buffer); //    {   strcpy(bufMgr[bufnum]->buffer,buffer);  }
    void SetAttribute(int bufnum, BYTE attribute); //   {   bufMgr[bufnum]->attribute = attribute;  }
    int  MaxBufs(void);
    void Change(int item, char *contents, BYTE attribute, long recno);
    void OpenFiles(void);
    void CloseFiles(void);
    void ReInit(void);
    BOOL CompareSetup(void);
    BOOL FileCompare(void);
    BOOL IsDeleted(void);
    };

#endif


