CodeBox:

MARKDEMO.PAS 
COMPLETE LISTING




PROGRAM MarkDemo;                 

TYPE

  BasePtr = ^Base;
  Base = OBJECT                {NOTE: This declaration is identical }
    DESTRUCTOR Done; virtual;  {to what's in Borland's OBJECTS.TPU. }
  END;                         {If you use OBJECTS.TPU, omit it.    }

  Marker = RECORD END;

  NodeP = ^NodeO;
  NodeO = OBJECT(Base)
    Next : NodeP;        { You would not want to arbitrarily }
    Prev : NodeP;        { clear these pointers! }
    BeginData : Marker;  { Mark beginning of descendant's data items }
    CONSTRUCTOR Init;
  END;

  NameAddrO = OBJECT(NodeO)
    Name  : STRING[30];
    Addr  : STRING[30];
    City  : STRING[20];
    State : STRING[2];
    Zip   : STRING[9];
    PROCEDURE Show;
    CONSTRUCTOR Init;
  END;

  DESTRUCTOR Base.Done; BEGIN END;

  CONSTRUCTOR NodeO.Init;
  BEGIN
    Next := @self;        {Initialize pointers for circular list}
    Prev := @self;
    FillChar(BeginData, SizeOf(self)-SizeOf(NodeO), 0);
  END;

  CONSTRUCTOR NameAddrO.Init; BEGIN NodeO.Init; END;

  PROCEDURE NameAddrO.Show;
  BEGIN
    WriteLn('Name [',Name,']' );
    WriteLn('Addr [',Addr,']' );
    WriteLn('City [',City,']  State [',State,']  Zip [',Zip,']' );
  END;

VAR NameAddr : NameAddrO;

BEGIN
  NameAddr.Init;
  NameAddr.Show;
END.


Figure B: You can use FillChar to clear all of an object's data fields, but you have to avoid wiping out the VMT pointer.
 
