program mdp7;

{This program allows you to scroll through a file you specify on the comm- }
{and line.  The number of lines in the file is virtually unlimited - you'd }
{need many megabytes to overflow it.                                       }
{Note that this program uses a unit called BigArray, which uses DOS memory }
{calls.  This means you can have arrays larger than 64k.  This is how it   }
{can access such HUGE files.  It uses the same "array of offsets" that     }
{previous programs have.                                                   }

{$G+,R-,S-,N+,M 16384,0,0}

uses Test186, crt,Textutl2, DosMem, BigArray;

const TBuffSize = 20; {k}
      ScreenLen = 24;
      LineCount:word = 0;
      WinTop:integer = 1;

type TBuffPtr  = ^TBuffType;
     TBuffType = array [1..TBuffSize*1024] of byte; {20k text buffer}

var MaxLines:longint;
    LineBank:BigDOSArray;
    TBuff:TBuffPtr;
    Buffer:string;
    LinePtr:^longint;
    Loop,LNum:word;
    ch:char;
    f:text;

function Min (a,b:word):word;

begin
  if a < b then Min := a else Min := b;
end;

procedure PrLn (var s:string);

begin
  writeln (copy (s,1,79));
end;

begin
  {Set up text buffer}
  TBuff := ptr (DosMem.Alloc (TBuffSize * 64),0); { * 64 turns K into paras}
  {Initialise the line arrays}
  with linebank do begin
    SetElemSize (sizeof (longint));
    MaxLines := GetMaxSize;
    writeln ('There''s room for ',MaxLines,' lines in memory.');
    Init (MaxLines);
  end;
  writeln ('Reading...');
  assign (f,paramstr (1)); SetTextBuf (f,TBuff^); reset (f);
  while not (eof (f) or (LineCount = MaxLines)) do begin
    inc (LineCount);
    write (LineCount,#13);
    LinePtr := LineBank.Elem (LineCount);
    LinePtr^ := TextFilePos (f);
    readln (f);
  end;
  writeln;

  clrscr;
  if Linecount = 0 then begin
    writeln ('File is empty.');
    close (f);
    DosMem.Free (seg(TBuff^)); {not really needed, but here for looks.}
    LineBank.Done;
    halt;
  end;
  {Draw the initial screen}
  clrscr;
  TextSeek (f,0); {Move to the start of the file}
  for loop := 1 to min (ScreenLen,LineCount-WinTop+1) do begin
    readln (f,buffer); {print out the first screen}
    prLn (buffer);
  end;
  write ('            Use ''+'' to move forward, ''-'' to move back.  ''q'' to quit.');
  repeat
    ch := readkey;
    case ch of
      '-':if WinTop > 1 then begin
            dec (WinTop);
            gotoxy (1,ScreenLen);
            DelLine;
            gotoxy (1,1);
            InsLine;
            LinePtr := LineBank.Elem (WinTop);
            TextSeek (f,LinePtr^);
            readln (f,buffer);
            PrLn (buffer);
          end;
      '+':if WinTop < LineCount-ScreenLen+1 then begin
            inc (WinTop);
            gotoxy (1,1);
            DelLine;
            gotoxy (1,ScreenLen);
            InsLine;
            LinePtr := LineBank.Elem (WinTop+ScreenLen-1);
            TextSeek (f,LinePtr^);
            readln (f,buffer);
            PrLn (buffer);
          end;
      'q':;
      else write (#7);
    end;
    gotoxy (1,ScreenLen+1); write (WinTop:5,'/',LineCount,#13);
  until ch = 'q';

  close (f);
  DosMem.Free (seg(TBuff^));
  LineBank.Done;
end.

