;;************************************************************************* 
;;                         bootp.inc       bootp.inc
;;*************************************************************************
;;
;;  Copyright (C) 1989 Northwestern University, Vance Morrison
;;
;;
;; Permission to view, compile, and modify for LOCAL (intra-organization) 
;; USE ONLY is hereby granted, provided that this copyright and permission 
;; notice appear on all copies.  Any other use by permission only.
;;
;; Northwestern University makes no representations about the suitability 
;; of this software for any purpose.  It is provided "as is" without expressed 
;; or implied warranty.  See the copywrite notice file for complete details.
;;
;;*****************************************************************************
;;
;; AUTHOR: Vance Morrison
;;****************************************************************************
;; definition of Bootp structure

BOOTPC = 44h                          ;; udp port for server responces 
BOOTPS = 43h                          ;; udp port for client requests

;;****************************************************************************
;; definition of BOOTP structure

BOOTP_REQUEST = 1
BOOTP_REPLY = 2

MYID = 3845                                     ;; a unique ID

bootp           STRUC
    bootp_op            DB 0                ;; operation
    bootp_htype         DB 0                ;; hardware type (ethernet = 1)
    bootp_hlen          DB 0                ;; hardware address len
    bootp_hops          DB 0                ;; hop count (start at 0)
    bootp_xid           DD 0                ;; random transaction id
    bootp_secs          DW 0
    bootp_unused        DW 0
    bootp_ciaddr        DD 0                ;; client IP address
    bootp_yiaddr        DD 0                ;; client IP address (servers reply)
    bootp_siaddr        DD 0                ;; server IP address
    bootp_giaddr        DD 0                ;; gateway IP address
    bootp_chaddr        DB 16 DUP (0)       ;; client harware address
    bootp_sname         DB 64 DUP (0)       ;; server name 
    bootp_file          DB 128 DUP (0)      ;; file to boot from 
    bootp_magic         DD 0                ;; magic number 
    bootp_vendor        DB 60 DUP (0)       ;; vendor specific stuff
bootp           ENDS


;;******************************************************************************
;;  BOOTP_DECLARE name, udp, dls, udp_sock1, udp_sock2
;;       BOOTP_DECLARE delcares a BOOTP listener called 'name'.  'udp'
;;       is a udp object, 'udp_sock1', 'udp_sock2' are two unique numbers
;;       that can but used to create sockets with the udp object.  The
;;       Data link objects are assumed to be 1..<dls>.
;;
BOOTP_DECLARE   MACRO  name, udp, dls
    .errb <dls>

    .DATA
    bootp_&name&_udp = udp
    bootp_&name&_dls = dls
    bootp_&name&_my_ip = dl_ip_1_ip         ;; make equal to any of my addresses
    bootp_&name&_request_sock = (name*100+1)
    bootp_&name&_reply_sock = (name*100+2)
    global bootp_&name&_forward:dword
    .CODE

    UDP_SOCK_DECLARE %bootp_&name&_request_sock, %bootp_&name&_udp, BOOTPS
    UDP_SOCK_DECLARE %bootp_&name&_reply_sock, %bootp_&name&_udp, BOOTPC
ENDM


;;******************************************************************************
;;   BOOTP_DEFINE   my_ip, forward_host
;;       BOOTP_DEFINE sets aside the memory and acutally does the 
;;       initialization for the bootp object 'name'.  'forward_host'
;;       is the address of a IP address to forward any bootp request to.  
;;       This address can be a directed broadcast.  
;;
BOOTP_DEFINE   MACRO   name, forward_host
    local around, request_code, reply_code, drop, tftp_around, tftp_request
    .errb <forward_host>

    .DATA
    bootp_&name&_forward DD ?
    bootp_&name&_last_xid DD ?

    .CODE
    jmp around          ;; declare code objects
        request_code:
        reply_code:
            BOOTP_REQUEST_PACKET_in_AX_BX_CX_ES name, drop
            BOOTP_REPLY_PACKET_in_AX_BX_CX_ES name, drop
            drop:
            RET
    around:

    ;; this code should be thrown out when CISCO do bootp properly
    TFTP_PORT = 45H
    jmp tftp_around
        tftp_request:
        TFTP_REQUEST_PACKET_in_AX_BX_CX_ES name, %myip
        RET
    tftp_around:
    UDP_R_READ %bootp_&name&_udp, TFTP_PORT, tftp_request
    ;; end of KLUDGE code (dont forget to trough out TFTP_REQUEST_PACKET too)

    cmp word ptr forward_host, 0
    jz done
    cmp word ptr forward_host+2, 0
    jz done

        mov AX, word ptr forward_host               ;; save the forwarding host
        mov word ptr bootp_&name&_forward, AX
        mov AX, word ptr forward_host+2
        mov word ptr bootp_&name&_forward+2, AX

        mov AX, 0
        mov word ptr bootp_&name&_last_xid, AX
        mov word ptr bootp_&name&_last_xid+2, AX

        UDP_SOCK_DEFINE %bootp_&name&_request_sock, request_code
        UDP_SOCK_DEFINE %bootp_&name&_reply_sock, reply_code
    done:
ENDM


;;******************************************************************************
;;   BOOTP_REQUEST_PACKET   name
;;
BOOTP_REQUEST_PACKET_in_AX_BX_CX_ES MACRO name, drop
    local done
    .errb <drop>

        ;; since bootp requests are often sent to a broadcast address,
        ;; I am a bit paranoid about the packets I receive.  Basicly
        ;; I ONLY forward requests from that poor sap that doesn't know
        ;; his IP address.  Anyone else I assume can boot without my help 
    mov SI, BX
    cmp byte ptr ES:[SI+bootp_op], BOOTP_REQUEST
    jnz done
        mov AL, ES:[SI+bootp_hops]
        cmp AL, 2
        ja drop
        inc AL
        mov ES:[SI+bootp_hops], AL

        mov AX, word ptr ES:[SI+bootp_giaddr]       ;; is the gateway filled in
        or AX, AX
        jnz drop
        mov AX, word ptr ES:[SI+bootp_giaddr+2]     ;; is the gateway filled in
        or AX, AX
        jnz drop

        mov AX, 0									;; reset 
        mov word ptr bootp_&name&_last_xid, AX
        mov word ptr bootp_&name&_last_xid+2, AX

        mov AX, word ptr bootp_&name&_my_ip         ;; fill in me as gateway
        mov word ptr ES:[SI+bootp_giaddr], AX
        mov AX, word ptr bootp_&name&_my_ip+2
        mov word ptr ES:[SI+bootp_giaddr+2], AX

        mov AX, word ptr bootp_&name&_forward
        mov BX, word ptr bootp_&name&_forward+2
        or AX, AX
        jz drop
        or BX, BX
        jz drop
        mov CX, size bootp
        mov DX, BOOTPS

        push SI
        push ES
        UDP_SOCK_W_ACCESS_in_AX_BX_CX_DX_out_AX_DI_ES %bootp_&name&_reply_sock
        pop  DX
        pop  SI
        or AX, AX
        jnz drop

        mov BX, DS              ;; save DS
        mov DS, DX
        mov CX, size bootp
        rep                     ;; copy the packet
        movsb
        mov DS, BX              ;; restore DS

        mov CX, size bootp
        UDP_SOCK_W_WRITE_in_CX %bootp_&name&_reply_sock
    done:
ENDM


;;******************************************************************************
;;   BOOTP_REPLY_PACKET   name
;;
BOOTP_REPLY_PACKET_in_AX_BX_CX_ES MACRO name, drop
    local done, sendit, send_reply
    .errb <drop>

    mov SI, BX
    cmp ES:[SI+bootp_op], BOOTP_REPLY
    jnz done
		
	mov AL, ES:[SI+bootp_hops]
	cmp AL, 10
	ja done
	inc AL
	mov ES:[SI+bootp_hops], AL

	mov AX, word ptr bootp_&name&_my_ip     ;; only reply if I am the designated
	cmp word ptr ES:[SI+bootp_giaddr], AX	;; gateway
	jnz done
	mov AX, word ptr bootp_&name&_my_ip+2
	cmp word ptr ES:[SI+bootp_giaddr+2], AX
	jnz done

	mov AX, word ptr bootp_&name&_last_xid	;; dont send to same place twice
	cmp word ptr ES:[SI+bootp_xid], AX	
	jnz send_reply
	mov AX, word ptr bootp_&name&_last_xid+2
	cmp word ptr ES:[SI+bootp_xid+2], AX	
	jz done

	send_reply:
	mov AX, word ptr ES:[SI+bootp_xid]
	mov word ptr bootp_&name&_last_xid, AX
	mov AX, word ptr ES:[SI+bootp_xid+2]
	mov word ptr bootp_&name&_last_xid+2, AX

	mov AX, word ptr ES:[SI+bootp_yiaddr]       ;; load up the destination
	mov BX, word ptr ES:[SI+bootp_yiaddr+2]     

	IRP idx,<1,2,3,4,5,6,7,8>
	if idx le bootp_&name&_dls
		;; send it out the right interface
	BOOTP_GET_BROADCAST_DL_in_AX_BX_out_AX_BX_const_SI_ES name, idx, sendit
	endif
	endm
	jmp drop

	sendit:
	mov CX, size bootp
	mov DX, BOOTPC

	push SI
	push ES
	UDP_SOCK_W_ACCESS_in_AX_BX_CX_DX_out_AX_DI_ES %bootp_&name&_request_sock
	pop  DX
	pop  SI
	or AX, AX
	jnz drop

	mov BX, DS              ;; save DS
	mov DS, DX
	mov CX, size bootp
	rep                     ;; copy the packet
	movsb
	mov DS, BX              ;; restore DS

	mov CX, size bootp
	UDP_SOCK_W_WRITE_in_CX %bootp_&name&_request_sock
	done:
ENDM



;;************************************************************************* 
;; BOOTP_GET_BROADCAST checks to see if the address in AX,BX is on the
;; local dl 'mydl' and if it is loads AX,BX with the broadcast address 
;; for 'mydl' and jumps to 'success'.  AX, BX is not on 'mydl' then
;; AX,BX, is unchanged
;;
BOOTP_GET_BROADCAST_DL_in_AX_BX_out_AX_BX_const_SI_ES MACRO name, mydl, success
    local done
    .errb <success>

    cmp AX, word ptr dl_ip_&mydl&_net
    jnz done
    mov CX, BX
    and CX, word ptr dl_ip_&mydl&_mask+2
    cmp CX, word ptr dl_ip_&mydl&_net+2
    jnz done
    mov BX, word ptr dl_ip_&mydl&_broad+2
    jmp success
    done:
ENDM


;;******************************************************************************
;; TFTP_REQUEST_PACKET MACRO name
;; tftp_request_packet is a KLUGE that will make CISCO's boot properly though
;; a gateway.  You see Cisco's are brain dead and after they receive the 
;; bootp reply they ignore the fact that they now have the servers address
;; and try to TFTP their configuration file by broadcasting a TFTP command
;; on the local network.  Here i simply act as a repeater of these packets
;;
TFTP_REQUEST_PACKET_in_AX_BX_CX_ES MACRO bootp, ip
    local done
    .errb <ip>

        ;; much of this is TOTALLY ILLEGAL, and breaks every rule in the
        ;; book.  It essentially has the effect of sending out the
        ;; IP packet as if it came from a source other than here
        ;; (in this case it acts as if it came from the original
        ;; sender).  I only do this because I really hope that this
        ;; code will only be needed for a short time.
    mov SI, BX
    sub SI, size udp
    add CX, size udp
    mov AX, word ptr bootp_&bootp&_forward
    or AX, AX
    jz done
    mov BX, word ptr bootp_&bootp&_forward+2
    mov DL, UDP_PROTO
    push SI
    push ES
    push CX
    IP_W_ACCESS_in_AX_BX_CX_DL_out_AX_DI_ES ip
    pop CX
    pop DX
    pop SI
    or AX, AX
    jnz done

    mov BX, ES      ;; save ES
    mov ES, DX      ;; restore the input ES

    sub SI, 20
    mov AX, word ptr ES:[SI+ip_src]
    mov word ptr ip_&ip&_data.ip_write_src, AX
    mov AX, word ptr ES:[SI+ip_src+2]
    mov word ptr ip_&ip&_data.ip_write_src+2, AX
    add SI, 20

    mov ES, BX      ;; restore ES

    mov BX, DS      ;; save DS
    mov DS, DX      ;; DS = input ES

    mov DX, CX      ;; save CX
    inc CX
    shr CX, 1
    rep
    movsw
    mov DS, BX      ;; restore DS
    mov CX, DX      ;; restore CX

    IP_W_WRITE_in_CX ip
    done:
ENDM

