! Convert NROFF outut to plain ASCII
! Compile with 'tx asciify.t'

#include "C:/v/t3xr5/basic.inc"
#include "C:/v/t3xr5/ios.inc"


error(m) do
	select(1,2);
	writes("ASCIIFY: ");
	writes(m);
	newline();
	halt;
end


do
	var	in[IOS], inbuf::1024;
	var	out[IOS], outbuf::1024;
	var	ch0, ch1;

	if (ios_create(in, 0, inbuf, 1024, IOF_READ) = %1)
		error("cannot create input stream");
	if (ios_create(out, 1, outbuf, 1024, IOF_WRITE) = %1)
		error("cannot create output stream");
	ch0 := ios_rdch(in);
	ch1 := %1;
	while (\ios_eof(in)) do
		if (ch1 \= %1) ios_wrch(out, ch1);
		ch1 := ch0;
		ch0 := ios_rdch(in);
		if (ch0 = '\b') do
			ch0 := ios_rdch(in);
			ch1 := %1;
		end
	end
	if (ch1 \= %1) ios_wrch(out, ch1);
	ios_close(in);
	ios_close(out);
end

