Package IO

Interface

Def GetCar as Word

Const
     Text40x25,Text80x25,Text132x60,LastCRTMode

Sub SetCRTMode(M as Byte)

Def GetCurPos as Word
Sub Locate(NewLi,NewCol as Word)

Sub SetColor(C as Byte)

Sub PutCar(C As Byte)
Sub PrintCR
Sub PrintX(I As Word)
Sub PrintLX(I As LongWord)

Type
    String is @Array[0..&HFF] Of Byte

Sub PrintS(S as String)

Implementation

\
  Clavier
          \
Def GetCar as Word
Enter
  AX=0
  InLine(&HCD,&H16)
  Result=AX
  If Low(Result)<>0 Then Result&=&HFF;
Leave

\
  Machine access util
                      \
Var
   Screen as @Array[0..132*60-1] Of Word
   NbLig,NbCol as Word
   Li,Col as Word
   Color as Byte

Sub StoSW(Ptr as Pointer; V,N as Word)
Enter
\ CLD \
  InLine(&HFC)
\ LES DI,[Ptr] \
  InLine(&HC4,&HBE,Ptr)
\ MOV AX,[V] \
  InLine(&H8B,&H86,V)
\ MOV CX,[N] \
  InLine(&H8B,&H8E,N)
\ REPZ STOSW \
  InLine(&HF3,&HAB)
Leave

Sub MovSB(Src,Dest as Pointer; N as Word)
  OfsS,OfsD as LongWord
Enter
\ Mmes segments \
  If LongWord(Src) & &HFFFF0000=LongWord(Dest) & &HFFFF0000 Then
  \ Pas de dbordement \
    OfsS=Low(Src)
    OfsD=Low(Dest)
    If (OfsS+N<=&HFFFF) And (OfsD+N<=&HFFFF) Then
    \ Choix direction \
      If OfsS>OfsD Then
      \ CLD \
        InLine(&HFC)
      Else
      \ Se placer  la fin des deux blocs \
        Low(Src)+=N-1
        Low(Dest)+=N-1
      \ STD \
        InLine(&HFD)
      End
    \ PUSH DS \
      InLine(&H1E)
    \ LES SI,[Src] \
      InLine(&HC4,&HB6,Src)
    \ MOV BX,ES \
      InLine(&H8C,&HC3)
    \ MOV DS,BX \
      InLine(&H8E,&HDB)
    \ LES DI,[Dest] \
      InLine(&HC4,&HBE,Dest)
    \ MOV CX,[N] \
      InLine(&H8B,&H8E,N)
    \ REPZ MOVSB \
      InLine(&HF3,&HA4)
    \ POP DS \
      InLine(&H1F)
    End
  End
Leave

\
  CRT Modes
            \
Type
    Record CRTModeDescr is
      NbLig,NbCol as Byte
      Screen as Pointer
      BIOSAX as Byte
    End
Var
   Descr as Array[0..LastCRTMode-1] Of CRTModeDescr

Sub SetCRTMode(M as Byte)
Enter
  If M<LastCRTMode Then
    NbLig=Descr[M].NbLig
    NbCol=Descr[M].NbCol
    @Screen=Descr[M].Screen
    AX=Descr[M].BIOSAX
    InLine &H10CD
    Li=Col=1
    Color=7
  End
Leave

\
  Curseur
          \
Def GetCurPos as Word
Enter
  AX=&H0300
  BX=0
  InLine(&HCD,&H10)
\ Aprs a, (DH,DL)=(Li,Col) \
  Result=DX
Leave

Sub Locate(NewLi,NewCol as Word)
Enter
  Li=NewLi:Col=NewCol
  DX=((Li-1)<<8)+Col-1
  BX=0
  AX=&H0200
  InLine(&HCD,&H10)
Leave

\
  Miscellaneous
                \
Sub ClearScreen
Enter
  StoSW(@Screen,(Color,&H20),NbLig*NbCol)
  Li=Col=1
  Locate 1,1
Leave

Sub ScrollUpScreen
Enter
  MovSB(Pointer(High(@Screen),Low(@Screen)+NbCol*2),@Screen,(NbLig-1)*NbCol*2)
  StoSW(Pointer(High(@Screen),Low(@Screen)+(NbLig-1)*NbCol*2),(Color,' '),NbCol*2)
Leave

\
  Couleur
          \
Sub SetColor(C as Byte)
Enter
  Color=C
Leave

\
  Affichages
             \
Sub PutCar(C as Byte)
  W as Word
Enter
  Screen[(Li-1)*NbCol+Col-1]=(Color,C)
  Col+=1
  If Col>NbCol Then
    Col=1
    If Li=NbLig Then ScrollUpScreen Else Li+=1;
  End
\ MAJ pos curseur \
  Locate Li,Col
Leave

Sub PrintCR
Enter
  Col=1
  If Li=NbLig Then ScrollUpScreen Else Li+=1;
  Locate Li,Col
Leave

Var
   Digit as Array[0..&HF] Of Byte

Sub PrintX(I As Word)
Enter
  PutCar Digit[I>>12]
  PutCar Digit[High(I)&&HF]
  PutCar Digit[Low(I)>>4]
  PutCar Digit[I&&HF]
Leave

Sub PrintLX(I As LongWord)
Enter
  PrintX High(I)
  PrintX Low(I)
Leave

Sub PrintS(S as String)
Var
   B as Byte
Enter
  For B=1 To S[0] Do PutCar(S[B]);
Leave

Enter
\ Init Modes \
  Descr[Text40x25].NbLig=25
  Descr[Text40x25].NbCol=40
  Descr[Text40x25].Screen=Pointer(&HB800,&H0000)
  Descr[Text40x25].BIOSAX=1
  Descr[Text80x25].NbLig=25
  Descr[Text80x25].NbCol=80
  Descr[Text80x25].Screen=Pointer(&HB800,&H0000)
  Descr[Text80x25].BIOSAX=3
  Descr[Text132x60].NbLig=60
  Descr[Text132x60].NbCol=132
  Descr[Text132x60].Screen=Pointer(&HB800,&H0000)
  Descr[Text132x60].BIOSAX=&H4F
\ Init Digit \
  Digit[0]='0':Digit[4]='4':Digit[8]='8' :Digit[12]='C'
  Digit[1]='1':Digit[5]='5':Digit[9]='9' :Digit[13]='D'
  Digit[2]='2':Digit[6]='6':Digit[10]='A':Digit[14]='E'
  Digit[3]='3':Digit[7]='7':Digit[11]='B':Digit[15]='F'
\ Init CRTMode (c'est plus prudent...) \
  SetCRTMode Text80x25
Leave