		-------------
		-- Sorting --
		-------------

-- Sort a sequence of arbitrary objects into ascending order.

-- If you want to change the default ordering of objects in Euphoria
-- write your own global compare() function to override the builtin compare,
-- then include this file after it.

global function sort(sequence x)
-- Shell sort will sort any sequence of Euphoria objects. Shell sort is
-- a "stable" sort, i.e. it will not change the order of elements that 
-- are considered equal.

    integer gap, j, first, last
    object tempi, tempj

    last = length(x)
    gap = floor(last / 3) + 1
    while 1 do
	first = gap + 1
	for i = first to last do
	    tempi = x[i]
	    j = i - gap
	    while 1 do
		tempj = x[j]
		if compare(tempi, tempj) >= 0 then
		    j = j + gap
		    exit
		end if
		x[j+gap] = tempj
		if j <= gap then
		    exit
		end if
		j = j - gap
	    end while
	    x[j] = tempi
	end for
	if gap = 1 then
	    return x
	else
	    gap = floor(gap / 3) + 1
	end if
    end while
end function

