/*
 * err.c -- routines for producing error messages.
 */

#include "../h/gsupport.h"
#include "token.h"
#include "tlex.h"
#include "trans.h"
#include "tree.h"
#include "tcode.h"
#include "tsym.h"
#include "tproto.h"

/*
 * Prototype.
 */

char	*mapterm	Params((int typ,struct node *val));

static struct errmsg {
   int	e_state;		/* parser state number */
   char *e_mesg;		/* message text */
   } errtab[] = {

/*
 * Initialization of table that maps error states to messages.
 */

     0, "global, record, or procedure declaration expected",
     1, "end of file expected",
     2, "global, record, or procedure declaration expected",
    11, "missing record name",
    12, "missing semicolon",
    13, "invalid global declaration",
    14, "link list expected",
    15, "operation list expected",
    16, "missing procedure name",
    17, "global, record, or procedure declaration expected",
    21, "invalid global declaration",
    32, "missing field list in record declaration",
    34, "missing end",
    35, "missing semicolon or operator",
    50, "invalid operand for unary operator",
    51, "invalid operand for unary operator",
    52, "invalid operand for unary operator",
    53, "invalid operand for unary operator",
    54, "invalid operand for unary operator",
    55, "invalid operand for unary operator",
    56, "invalid operand for unary operator",
    57, "invalid operand for unary operator",
    58, "invalid operand for unary operator",
    59, "invalid operand for unary operator",
    60, "invalid operand for unary operator",
    61, "invalid operand for unary operator",
    62, "invalid operand for unary operator",
    63, "invalid operand for unary operator",
    64, "invalid operand for unary operator",
    65, "invalid operand for unary operator",
    66, "invalid operand for unary operator",
    67, "invalid operand for unary operator",
    68, "invalid operand for unary operator",
    69, "invalid operand for unary operator",
    70, "invalid operand for unary operator",
    71, "invalid operand for unary operator",
    72, "invalid operand for unary operator",
    73, "invalid operand for unary operator",
    83, "invalid create expression",
    86, "invalid break expression",
    87, "invalid expression",
    88, "invalid compound expression",
    89, "invalid expression",
    90, "invalid keyword construction",
    96, "invalid return expression",
    97, "invalid suspend expression",
    98, "invalid if control expression",
    99, "invalid case control expression",
   100, "invalid while control expression",
   101, "invalid until control expression",
   102, "invalid every control expression",
   103, "invalid repeat expression",
   106, "missing link file name",
   107, "missing operation name",
   108, "number of arguments missing",
   109, "missing parameter list in procedure declaration",
   111, "missing end",
   112, "identifier expected",
   113, "invalid initial expression",
   118, "missing end",
   119, "invalid operand",
   120, "invalid operand",
   121, "invalid operand in assignment",
   122, "invalid operand in assignment",
   123, "invalid operand in assignment",
   124, "invalid operand in assignment",
   125, "invalid operand in augmented assignment",
   126, "invalid operand in augmented assignment",
   127, "invalid operand in augmented assignment",
   128, "invalid operand in augmented assignment",
   129, "invalid operand in augmented assignment",
   130, "invalid operand in augmented assignment",
   131, "invalid operand in augmented assignment",
   132, "invalid operand in augmented assignment",
   133, "invalid operand in augmented assignment",
   134, "invalid operand in augmented assignment",
   135, "invalid operand in augmented assignment",
   136, "invalid operand in augmented assignment",
   137, "invalid operand in augmented assignment",
   138, "invalid operand in augmented assignment",
   139, "invalid operand in augmented assignment",
   140, "invalid operand in augmented assignment",
   141, "invalid operand in augmented assignment",
   142, "invalid operand in augmented assignment",
   143, "invalid operand in augmented assignment",
   144, "invalid operand in augmented assignment",
   145, "invalid operand in augmented assignment",
   146, "invalid operand in augmented assignment",
   147, "invalid operand in augmented assignment",
   148, "invalid operand in augmented assignment",
   149, "invalid operand in augmented assignment",
   150, "invalid operand in augmented assignment",
   151, "invalid operand in augmented assignment",
   152, "invalid operand in augmented assignment",
   153, "invalid to clause",
   154, "invalid operand in alternation",
   155, "invalid operand",
   156, "invalid operand",
   157, "invalid operand",
   158, "invalid operand",
   159, "invalid operand",
   160, "invalid operand",
   161, "invalid operand",
   162, "invalid operand",
   163, "invalid operand",
   164, "invalid operand",
   165, "invalid operand",
   166, "invalid operand",
   167, "invalid operand",
   168, "invalid operand",
   169, "invalid operand",
   170, "invalid operand",
   171, "invalid operand",
   172, "invalid operand",
   173, "invalid operand",
   174, "invalid operand",
   175, "invalid operand",
   176, "invalid operand",
   177, "invalid operand",
   178, "invalid operand",
   179, "invalid operand",
   180, "invalid operand",
   181, "invalid operand",
   182, "invalid operand",
   183, "missing right bracket",
   184, "missing right brace",
   185, "missing right parenthesis",
   186, "invalid field name",
   213, "missing right parenthesis",
   215, "missing right brace",
   216, "missing semicolon or operator",
   217, "missing right bracket",
   223, "missing then",
   224, "missing of",
   229, "missing identifier",
   234, "missing right parenthesis",
   236, "missing end",
   237, "invalid declaration",
   238, "missing semicolon or operator",
   304, "missing right bracket",
   307, "missing right brace",
   309, "missing right parenthesis",
   312, "missing right parenthesis or right bracket",
   314, "missing right brace",
   316, "invalid do clause",
   317, "invalid then clause",
   318, "missing left brace",
   319, "invalid do clause",
   320, "invalid do clause",
   321, "invalid do clause",
   323, "invalid argument list",
   329, "invalid by clause",
   331, "invalid section",
   336, "missing right brace",
   342, "invalid case clause",
   347, "missing right bracket",
   349, "missing right bracket",
   351, "invalid else clause",
   352, "missing right brace or semicolon",
   354, "missing colon",
   355, "missing colon",
   360, "invalid case clause",
   361, "invalid default clause",
   362, "invalid case clause",
    -1,  "syntax error"
   };

/*
 * yyerror produces syntax error messages.  tok is the offending token
 *  (yychar), lval is yylval, and state is the parser's state.
 *
 * errtab is searched for the state, if it is found, the associated
 *  message is produced; if the state isn't found, "syntax error"
 *  is produced.
 */
novalue yyerror(tok, lval, state)
int tok, state;
nodeptr lval;
   {
   register struct errmsg *p;


   if (tok_loc.n_file)
      fprintf(stderr, "File %s; ", tok_loc.n_file);
   if (tok == EOFX)   /* special case end of file */
      fprintf(stderr, "unexpected end of file\n");
   else {
      fprintf(stderr, "Line %d # ", Line(lval));
      if (Col(lval))
         fprintf(stderr, "\"%s\": ", mapterm(tok,lval));
      for (p = errtab; p->e_state != state && p->e_state >= 0; p++) ;
      fprintf(stderr, "%s\n", p->e_mesg);
      }
   tfatals++;
   }

/*
 * tfatal produces the translator error messages s1 and s2 (if nonnull).  The
 *  location of the error is found in tok_loc.
 */
novalue tfatal(s1, s2)
char *s1, *s2;
   {

   if (tok_loc.n_file)
      fprintf(stderr, "File %s; ", tok_loc.n_file);
   fprintf(stderr, "Line %d # ", tok_loc.n_line);
   if (s2)
      fprintf(stderr, "\"%s\": ", s2);
   fprintf(stderr, "%s\n", s1);
   tfatals++;
   }

/*
 * nfatal produces the error messages s1 and s2 (if nonnull), and associates
 *  it with source location of node.
 */
novalue nfatal(n, s1, s2)
nodeptr n;
char *s1, *s2;
   {

   if (n != NULL) {
      fprintf(stderr, "File %s; ", File(n));
      fprintf(stderr, "Line %d # ", Line(n));
      }
   if (s2)
      fprintf(stderr, "\"%s\": ", s2);
   fprintf(stderr, "%s\n", s1);
   tfatals++;
   }

/*
 * twarn produces s1 and s2 (if nonnull) as translator warning messages.
 *  The location of the error is found in tok_loc.
 */
novalue twarn(s1, s2)
char *s1, *s2;
   {

   if (tok_loc.n_file)
      fprintf(stderr, "File %s; ", tok_loc.n_file);
   fprintf(stderr, "Line %d # ", tok_loc.n_line);
   if (s2)
      fprintf(stderr, "\"%s\": ", s2);
   fprintf(stderr, "%s\n", s1);
   twarns++;
   }

/*
 * mapterm finds a printable string for the given token type
 *  and value.
 */
static char *mapterm(typ,val)
int typ;
nodeptr val;
   {
   register struct toktab *t;
   register struct optab *ot;
   register int i;

   i = typ;
   if (i == IDENT || i == INTLIT || i == REALLIT || i == STRINGLIT ||
      i == CSETLIT)
         return Str0(val);
   for (t = toktab; t->t_type != 0; t++)
      if (t->t_type == i)
         return t->t_word;
   for (ot = optab; ot->tok.t_type != 0; ot++)
      if (ot->tok.t_type == i)
         return ot->tok.t_word;
   return "???";
   }
