; GENERAL.INC
; Some general macros used by CMDEDIT.
;
; jmh 980511: Added the i286 conditionals - expects common.inc to be included
;	      first.

@pop	macro	parm
	irp	@@pop,<parm>
	ifnb	<@@pop>
	pop	@@pop
	endif
	endm
	endm

@save	macro	p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11,p12
	irp	@@save,<p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11,p12>
	ifnb	<@@save>
	push	@@save
	endif
	endm
@restore macro
	@pop	<p12,p11,p10,p9,p8,p7,p6,p5,p4,p3,p2,p1>
	endm
	endm

@saveall macro				;Created by jmh 980511
if i286
	pusha
	push   ds
	push   es
else
	@save ax,bx,cx,dx,si,di,bp,ds,es
endif
	endm

@restoreall macro			;Created by jmh 980511
if i286
	pop	es
	pop	ds
	popa
else
	@restore
endif
endm

@link	macro	storage 		;Created by jmh 980510
	push	si
	push	di
if i286
	enter	storage,0
else
	push	bp
	mov	bp,sp
	sub	sp,storage
endif
	endm

@unlink macro				;Modified by jmh 980510
if i286
	leave
else
	mov	sp,bp
	pop	bp
endif
	pop	di
	pop	si
	endm
