(**   TALKING BALANCE 1 PROGRAM (TLKBAL1E.PAS)  **)

(**   START GENERAL COMMENTS

    PROGRAM NAME: TLKBAL1E.PAS

    PURPOSE:  THIS PROGRAM WAS DESIGNED TO MAKE ACCURATE MASS
    MEASUREMENTS ACCESSIBLE TO SCIENCE STUDENTS WHO HAVE VISUAL
    IMPAIRMENTS. IT READS AN OHAUS MODEL CT OR TP SERIES ELECTRONIC
    BALANCE AND DISPLAYS THE BALANCE'S READINGS AND INSTRUCTIONS FOR
    THE USER AS LARGE TEXT ON THE COMPUTER SCREEN. READINGS AND
    INSTRUCTIONS CAN ALSO BE SPOKEN THROUGH A SPEECH SYNTHESIZER.
    BALANCE READINGS MAY BE SAVED IN A DISK FILE FOR LATER ANALYSIS.
    (THE PROGRAM THUS FUNCTIONS AS A SORT OF ELECTRONIC LAB NOTEBOOK.)

    SEVERAL DIFFERENT SPEECH SYNTHESIZERS MAY BE USED, INCLUDING THE
    CREATIVE LABS SOUND BLASTER SOUND CARD AND ITS TEXT-TO-SPEECH
    PROGRAM "SBTALKER". THE USE OF A SPEECH SYNTHESIZER IS NOT
    REQUIRED: FOR USERS WHO CAN SEE THE LARGE TEXT WELL ENOUGH, THE
    PROGRAM WILL RUN IN THE "SPEECHLESS" MODE.

    SEE THE FILES "README.BAL" AND "GUIDE1.BAL" FOR DETAILED
    INSTRUCTIONS.


        AUTHORS: Rosa M. McMillan, Jason M. Johnson,
                 Margaret M. Gemperline, Jonathon R. Hoggard,
                 and David Lunney

        ADDRESS: Department of Chemistry
                 East Carolina University
                 Greenville, NC 27858-4353
                 USA


        INQUIRIES REGARDING THIS PROGRAM SHOULD BE DIRECTED
        TO DAVID LUNNEY AT chlunney@ecuvm.cis.ecu.edu OR
        LUNNEY@DELPHI.COM


    COPYRIGHT  1992-1997
    East Carolina University, Greenville, NC. USA

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    A COPY OF THE GNU GENERAL PUBLIC SOFTWARE LICENSE HAS BEEN
    PROVIDED WITH THIS PROGRAM IN THE FILE "LICENSE.TXT"


    No Warranty.  EAST CAROLINA UNIVERSITY DISCLAIMS AND MAKES NO
    REPRESENTATIONS AND EXTENDS NO WARRANTIES, EITHER EXPRESS OR
    IMPLIED. THERE ARE NO EXPRESS OR IMPLIED WARRANTIES OF
    MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  The User
    shall assume all liability for all damages whatsoever that may or
    do arise from the User's use, inability to use, performance, or
    storage of TLKBAL1E.  East Carolina University shall not be
    liable to the User for any loss, claims, damages or demands
    whatsoever made by the User or made against the User by any other
    party, due to or arising from the performance of, use of, and/or
    inability to use TLKBAL1E by the User and/or anyone else.


    PROGRAM DATES: 1992-97
    LAST UPDATE: 3/22/97



    SUPPORTING UNITS REQUIRED BY THIS PROGRAM (SEE THE
    "USES" SECTION OF THE PROGRAM BELOW, ABOUT LINE 400,
    AND THE "USES" SECTIONS OF THE UNITS.)

    I. THE FOLLOWING UNITS ARE SUPPLIED WITH THE
       BORLAND TURBO PASCAL COMPILER

    CRT, DOS, GRAPH:   Turbo Pascal's crt, Dos, and graph units


    II. THE FOLLOWING UNITS ARE SUPPLIED WITH THIS PROGRAM

    SERIAL2A.PAS:  Serial communications unit by DL
    TXTUTIL4.PAS:  Text utilities unit by DL
    FILUTIL4.PAS:  File utilities unit by DL
    DOSFUNKS.PAS:  DOS functions unit by DL

    BGIDriv.TPU,
    BGIFont.TPU:   Graphics units compiled by JMJ
                   from Borland Pascal Graphics driver
                   EGAVGA.BGI and font file TRIPLEX.CHR.

    sbtlkgr3.PAS:  Speech output unit for Sound Blaster
                   and other synths by DL. Comment out this
                   unit reference if you want to compile the
                   program and you don't have BOTH the Creative
                   Labs Developer Kit for Turbo Pascal
                   Version 7 AND the text-to-speech engine
                   "SBTALKER."  See the unit sbtlkgr3.PAS
                   for details.

    BalTalk0.PAS:  Speech output unit for non-Sound Blaster
                   speech synths by DL. Use this unit if you
                   want to compile and run the program without
                   the Creative Labs Developer Kit and without
                   the text-to-speech engine "SBTALKER."
                   See the unit BalTalk0.PAS for details.


  III. THE FOLLOWING UNIT (IF NEEDED) MUST BE PURCHASED FROM
       CREATIVE LABS, INC.

    SBC_TP7.TPU:   The unit supplied with the Creative Labs
                   Developer Kit for Turbo Pascal V. 7.
                   (This unit is used by unit sbtlkgr3.pas.)
                   You don't need this unit unless you want
                   to RE-COMPILE and run the program with
                   a Sound Blaster Sound card and the
                   text-to-speech engine "SBTALKER."  The
                   compiled version of the program as
                   supplied (TLKBAL1D.EXE) includes this
                   unit, and will drive the Sound Blaster
                   sound card as well as other speech devices.


       Note: "Sound Blaster" and "SBTALKER" are registered
       trademarks of Creative Labs, Inc.  "Turbo Pascal"
       is a registered trademarks of Borland International, Inc.



                (PARTIAL) PROGRAM  SUMMARY

   PROCEDURES            DESCRIPTION

   VerifyQuit            Verifies that the user wants to quit program.
   SpeakKeyboardChar3    Says the character the user presses.
                         (modified by JRH 9-3-94)
   SpellOut              Spells out a string
   EraseBalText          Erases the information from the screen.
   ReadBalPort           Looks in Balport.dat for the port name
                          (COM1 or COM2;  new 6/24/96 DL)
   TellSaved             Tells the user data have been saved in data file.
   ShowBalNotOn          Displays error msg. (added by DL 7-96)
   ShowInputError        Displays error msg.        "
   TellBalNotOn          Speaks error msg.          "
   TellInputError        Speaks error msg.          "
   TellFixIt2            Tells the user to fix the prob.
   InitBalPort2          Initializes the communications port.
   InitBalance           Initializes the balance.
   InitializeGraf        Initializes the graphical interface.
   GraphicsAbort         Halts the program if graphics error
   SaveGraphics          Puts device drivers into .EXE file.
   GetStrang4            Gets input string from user with echo and text.
   BalanceInformation    Gives the user information about program.
   IntroBalance          The main menu of the balance.
   SayFileExists2        Tells the user that the datafile already exists.
   GetLogFileName2       Prompts the user to input data file to be used.
   GetUserName           Get the name of the user.
   AskLogFile            Asks user if data should be saved to a file.
   AskReadFile           Asks user if data should be read back from a file.
   InitBalText           Initialize the graphics driver and set up monitor.
   ShowInstructions      Writes balance directions to the screen.
   SayInstructions       Verbalizes the balance directions.
   GetCommand3           Gets balance command from the user.
                         renamed, DL 8-9-96
   SayUnstable           Says that the balance is unstable.
   ProcessResponse2      Processes the input string from the balance
   DisplayBalReading2    Puts the balance reading on the screen.
   GetComment            Allows the user to label a saved balance reading.
   AddData2              Appends current trial to data file.
   ReadBalance2          Reads data from the balance.
   ReadBalFile           Speaks the data file if the user chooses to.
   FixScreen             Returns the screen to CRT mode before exiting.
   EndProgram2           Does the finishing processing before terminating.
                          (renamed 7-25-96 DL)
   StartProgram          Contains the actual processing calls.

   CheckKeyOK            Added by DL 8-9-96; checks for valid
                           key and for extended codes

   FUNCTIONS             DESCRIPTION

   AskAppend             Asks if user wants to append data to an
   (was GetFileAction)   existing data file.

   MakeMassTalkString    Speaks a number digitwise (added by DL 7-96)
   BalPortNameOK         checks that the balance port name is a legal
                         DOS serial port. added by DL 7-31-96
   MakeUnitTalkString    Makes unit strings (added by DL 7-96)



                     MODIFICATION HISTORY

     DATE  INITIALS              DESCRIPTION

   06/29/92  DL   Reads Ohaus balance using asyncoh.pas (a modified
                  asyncxx.pas

   07/07/92  RMM  Addition of user interface: visual and audio output.

   07/13/92  RMM  Addition of code that writes balance readings to a text
                  file.

   07/14/92  RMM  Read port numbers from a file.

   12/01/93  MMG  This program was originally written by Rosa McMillan and
                  named  'OHAUS.PAS.'  In December, 1993, Peg Gemperline
                  began modifying the code and named the modified code
                  'OHAUSPEG.PAS.'  The original code is in the subdirectory
                  \TP\BALANCE.

   02/04/94  DL   Use serial1 instead of asynchoh; large procedures broken
                  up.  Added code to handle unstable readings.

   02/05/94  DL   Add code that informs the user if the reading is unstable
                  instead of displaying the mass. If reading is unstable,
                  display question marks.

   03/24/95  JJ   Placed the appropriate hand shake commands to allow
                  good communication. Also modified the talk string to say
                  when there happens to be a negative balance reading.
                  (Note added by DL 9-7-96: the original program was
                  written for an Ohaus CT200 that had been modified to
                  use standard RS-232 pinouts. This version uses the
                  stock unmodified non-standard Ohaus interface.)

   05/15/95  JJ   Modifications were made to the program to work out some
                  of the inherent glitches, and was thoroughly tested for
                  errors.

   05/17/95  JJ   Procedure FixScreen was added along with several changes
                  that will halt the program if the balance accidentally
                  get unpluged. One thing was found today that had not been
                  previously  discovered. Some machines will not run the
                  software if the command SMARTDRV.EXE has been loaded. If
                  the program receives a Critical Error Writing to Drive C:
                  and then hangs up, you must remove SMARTDRV.EXE from the
                  AUTOEXEC.BAT file. For some reason this only happens with
                  certain computers.

   05/18/95  JJ   Additional documentation added.

   05/21/95  JJ  Procedures added that would incorporate the EGAVGA.BGI
              and TRIP.CHR drivers into the executable  (.EXE) programs.
              By doing this the only program that now has to be given
              out is the executable  (.EXE) program. No extraneous files
              will be needed in order to run the program.

   05/23/95  JJ   Program modified to work with Ohaus CT200
                  centigram balances.

   09/13/95 MMG  Edited SayInstructions procedure so help instructions
              would be spoken when "H" is pressed.

   09/13/95 MMG  Edited string written to screen in AskLogFile
              from Oh House C T 200 to Ohaus CT200.

   09/14/95 MMG  Renamed program as TALKBAL1 to agree with distribution
             license from PKWARE, Inc.

   09/15/95 MMG  Removed periods from each field saved to data file
              in procedures AskLogFile and AddData.

    09/18/95 MMG  Removed period added to end of string read from data file
                  and written to screen in procedure ReadBalFile.

   09/18/95 MMG  Edited various texts of internal documentation.
   09/19/95 MMG  Edited the procedures:  AskLogFile, GetComment,
              GetLogFileName, AskReadFile, VerifyQuit, GetUserName,
              ReadBalance, and DisplayBalanceReading.  Done so text
              is written to screen before being spoken, to avoid
              having a blank screen while listening to information.

   09/21/95  MMG   Edited the procedure GetComment. Replaced 11 lines of
              code with one call to the procedure GetStrang.

   09/21/95 MMG  Edited the procedure AskLogFile so the word "Label"
              would be a column heading in the saved data file.
              Replaces the word, "Trial"

   09/21/95 MMG  Edited the copyright statements above and in the
              procedure EndProgram.

   09/21/95 MMG  Edited some procedure/function descriptions above.

    12/05/95 MMG  Edited user instructions in procedure GetPortNumber

    7/23/96 code to handle overload added DL
    (differs slightly from code by MMG)
    (tab character also removed DL 7/23/96)
    (code added to catch timeouts at EVERY read and write
    to and from the balance DL 7/24/96)
    text utils removed: uses txtutil2.pas instead.  DL 7/24/96

     floating point types changed from single to real to allow
     compilation without 80x87 coprocessor emulation. reduces
     code size by about 10k. DL 7/24/96

     Procedure Endprogram modified and renamed.  Skips code for
     reading back data file if SBTALKER or speech device is not
     present.  This allows the program to be run with visual
     display only (i.e., skips code that depends on a speech
     device being present.)  (DL 7-25-96)


     The speech output unit sbtlkgr3 allows for use of speech
     devices other than the Sound Blaster.  If the text-to-speech
     engine SBTALKER has not been loaded, the program looks for
     file talkport.dat.  If talkport.dat is present, the program
     writes text to the port given in that file (COM1, COM2, LPT1,
     etc.) If talkport.dat is absent, the program runs without speech.

     Getstrang renamed to Getstrang3 and code added to trap extended
     key codes; same for the key echo routine SpeakKeyboardChar2,
     which is now SpeakKeyboardChar3. Boolean variable ExtCode added
     to indicate extended key codes in several routines. (DL 7-30-96)

     Balance intialization separated from port initialization.
     InitBalPort2 now does only the port: InitBalance does the balance.
     (DL 7-30-96)

     Uses serial2a instead of serial1; serial2a  does not halt if
     an input error is detected.  (DL 7-31-96)

     ONE PROGRAM NOW READS BOTH MILLIGRAM AND CENTIGRAM BALANCES!
      (DL 7-31-96)

     THIS PROGRAM ALSO DRIVES A SPEECH SYNTHESIZER CONNECTED TO A
     SERIAL OR PARALLEL PORT (INSTEAD OF A SOUND BLASTER) AND CAN
     BE RUN WITH NO SPEECH AT ALL.  (DL 7-96)

     GetCommandX modified to echo keys and repeat instructions
       DL 8-9-96; renamed GetCommand3

     Zillions of asterisks and hyphens removed because they
     would be annoying to a blind person using a screen
     reader.  DL 8-96

     Version C uses unit filutil3 (which uses dosfunks) to
     check validity of file names, drives, and directories.
     This prevents bombing caused by bad file names.
     Function FileNotFound removed. (Replaced by Procedure
     CheckPath in filutil3.) DL 8-10-96

      Getstrang4 modified to display multiple lines of
      text. DL 8-12-96

      Many routines added for displaying error conditions,
      mostly during the entry of the data file name. DL 8-96

     Ver. D uses unit filutil4 and txtutil4 (DL 9-96)

     proc. FixUpFileName added to ver. D to correct potentially
     fatal errors in file names: also displays corrected name.

     proc. ShowVerifyFileName displays file name, in up to 5
     lines if need be. (DL 9-96)

     modified to beep at all wrong keys, whether speech is
     on or not. dl 10-23-96 (Mole Day '96!)

     modified to speak "Press any key..' etc. every time
     it appears on the screen.

     Garbage collection done in Mole Day '96 to remove dead
     code that had previously been commented out. This will
     improve readability for both blind and sighted
     programmers.  dl

     Renamed TLKBAL1E on Mole Day '96 dl

     The speech output unit sbtlkgr3 allows for use of speech
     devices other than the SB, and for running with no speech
     at all (see above) but it cannot be compiled without the
     unit SBC_TP7, which is part of the Creative Labs Developer
     Kit for Turbo Pascal V. 7.   The unit BalTalk0 was added on
     9-6-96 by DL to allow compiling and running the program without
     unit SBC_TP7, and without a Sound Blaster card at all. If you
     compile the program using BalTalk0 instead of sbtlkgr3,
     the program does not look for the Sound Blaster's SBTALKER
     text-to-speech engine, but writes the text to be spoken to the
     port given in file talkport.dat.  If talkport.dat.is absent,
     the program runs with no speech. See the "uses" section of the
     main program (below, about line 320) for instructions on changing
     the speech output unit.

     Note added by DL 9-6-96:
     I have tried to enter the names of the original authors
     of most of the important routines, but I can't remember
     who wrote what in all cases. Routines that Jason Johnson
     and Margaret M. Gemperline wrote or modified have been
     carefully documented above by them. My own documentation is
     less thorough, but I have noted briefly modifications and
     additions I have made either in the above history or in
     the routines themselves.


    PARAMETERS FOR OHAUS BALANCES  (SEE UNIT SERIAL2A.PAS)

    InShake:         DTR    (SIGNALS TO THE BALANCE THAT THE
                              COMPUTER IS READY FOR INPUT)
    OutShake:        CTS    (SIGNALS TO THE COMPUTER THAT THE
                              BALANCE IS READY FOR OUTPUT)
    InDelim:         CRLF   LINE TERMINATOR FOR INPUT = CR/LF
    OutDelim:        CRLF   LINE TERMINATOR FOR OUTPUT = CR/LF

    baud: Word = 2400;
    parity: Char = 'N';    (defaults for Ohaus balances DL 7-96)
    stopbits: Byte = 2;
    databits: Byte = 7;
                                                 END GENERAL COMMENTS ***)

(* START PROGRAM *)

Program TLKBAL1E;
{ READS OHAUS MILLIGRAM AND CENTIGRAM BALANCES DL 7-96 }
{ RENAMED TLKBAL1E by DL 10/23/96 (mole day!) }

Uses
  crt, DOS, graph, { Borland Pascal's own crt, Dos, and graph units }
  serial2a,  { serial communications unit by DL }
  txtutil4,  { text utilities unit by DL }
  filutil4,  { file utilities unit by DL  }
  
  BGIDriv, BGIFont, { graphics units compiled by JMJ from Pascal
  graphics driver EGAVGA.BGI and font file
  TRIPLEX.CHR.  }
  
  sbtlkgr3;   { speech output unit for Sound Blaster
                and other synths by DL. Comment out this
                unit reference if you don't have BOTH the
                Creative Labs Developer Kit for Turbo Pascal
                Version 7 AND the text-to-speech engine "SBTALKER."
                See the unit sbtlkgr3.pas for details. }

  {BalTalk0;}  { speech output unit for non-Sound Blaster
                speech synths by DL. Use this unit if you want
                to compile and run the program without the
                Creative Labs Developer Kit and without the
                text-to-speech engine "SBTALKER."  See the
                unit BalTalk0.pas for details. }

   (** NOTICE: DO NOT ATTEMPT TO USE BOTH sbtlkgr3 AND BalTalk0! **)

Type
  String20 = String[20];
  String2 = String[2];
  charset = Set Of Char; { added by DL 8-96 }
  
Const
  { serial I/O parameters for balance  }
  baud: Word = 2400;
  parity: Char = 'N';    { defaults for Ohaus balances DL 7-96 }
  stopbits: Byte = 2;
  databits: Byte = 7;
  PrintableChars: charset = [#32..#126];
  
  LegalFileNameChars: charset = ['0'..'9', 'A'..'Z', 'a'..'z',
  '!', '#',  '$', '%', '^', '&',
  '(', ')', '-', '_', '{', '}', '~', '\', '.', ':' ];
  
  TAB: Char = #9;
  
  { graph constants }
  LineStyle = 0;  { solid line  }
  Thickness = 1;  { thick lines }
  
  
Var
  PortNo: Byte;
  InShake, OutShake, indelim, outdelim, BalPortName: String4;
  OutString, talkstring, readmefile: String;
  GraphDriver: Integer;  { The Graphics device driver }
  GraphMode: Integer;  { The Graphics mode value }
  GraphErrorCode: Integer;  { Reports any graphics errors }
  LogFileName: String;  { File containing balance readings }
  stability, polarity, mass, units: String20;
  ROMVersion: String; { ROM version added by DL 9-16-96 }
  logfile,  datfile: Text;
  loggit,    { True if writing balance readings to a file }
  readit,    { True if speaking balance readings from the file }
  quit, unstable, BalError, Escape, BalanceSetup,
  GrafOpen: Boolean;  { GrafOpen DL 7-96 } {BalError MMG 5-13-96}
  Appendit: Boolean; {was local; made global by DL 8-13-96}
  StringInput: Boolean;
  LogDriveLetter, OldKey: Char; { added by DL 8-96 }
  hr, Min, s, s100: Word;
  numredes: Integer; { Number of reads }
  username, firstname: String;
  MaxX, MaxY: Word; { added by DL 8-96 }
  Xmult0, Xdiv0, Ymult0, Ydiv0:  Word;  { added by DL 9-96 so
  char size can be restored after changes }
  
  
Procedure FlushKeyBoardBuffer;
  { added by DL 12-2-96 }
  { flush keyboard buffer }
  Var
    dum: Char;
  Begin
    Repeat
      dum := ReadKey;
    Until Not KeyPressed;
  End;

Function SkipIt: Boolean;
  { added by DL 12-3-96 }
  { allows skipping past unwanted stuff by pressing the TAB key }
  Var
    dum: Char;
  Begin
    Skipit := False;
    If Not KeyPressed Then Exit
    Else
    Begin
      dum := ReadKey;
      { catch extended codes }
      If Ord(dum) >  0 Then
      Begin
        If dum = TAB Then Skipit := True;
      End Else dum := ReadKey;
    End;
    { get rid of multiple keystrokes }
    If KeyPressed Then FlushKeyBoardBuffer;
    { flush speech buffer }
    If Flushit Then FlushTalkBuffer(FlushDelay);
  End;



Procedure hold(GetXcape: Boolean);
  { added by DL 8-13-96 }
  { replaces many lines of  "repeat until keypressed"   }
  { if GetXcape = TRUE then the global variable Escape
    is set TRUE if ESC is pressed DL 8-13-96 }
  { modified to flush synth's text buffer dl 10-30-96 }
  Var
    dum: Char;
  Begin
    Repeat Until KeyPressed;
    If Flushit Then FlushTalkBuffer(FlushDelay); { flush synth buffer added dl 10-96 }
    dum := ReadKey;
    If ((dum = ESC) And (GetXcape)) Then Escape := True;
    { catch extended codes }
    If Ord(dum) = 0 Then dum := ReadKey;
    { get rid of multiple keystrokes; added by dl 12-3-96 }
    If KeyPressed Then FlushKeyBoardBuffer;
  End;

{                                                                          }
{  EraseBalText          Erase area of screen bounded by rectangle.        }
{                                                                          }
Procedure EraseBalText;

  Begin
    ClearDevice;
    Rectangle(1, 1, MaxX, MaxY);
  End; {EraseBalText}

Procedure ResetCharSize;
{ added by DL 9-96 to save old char size }
Begin
  SetUserCharSize(Xmult0, Xdiv0, Ymult0, Ydiv0);
End;

Procedure SetCharSize(Xm, Xd, Ym, Yd: Word);
{ added by DL 9-96 to save old char size }
Begin
  SetUserCharSize(Xm, Xd, Ym, Yd);
  { save values of Xmult0, etc. }
  Xmult0 := Xm;
  Xdiv0 := Xd;
  Ymult0 := Ym;
  Ydiv0 := Yd;
End;

Procedure ShowMessage(nlines: Byte; Y0: Word;
                           holdit, GetXcape: Boolean);
  { generic message output, 8 lines X about 22 chars max}
  { Y0 is initial Y  position in pixels. }
  { if holdit = TRUE, the procedures holds until a key is pressed. }
  { if GetXcape = TRUE then pressing the ESC key sets Escape = TRUE }
  { global variable BigText (in unit txtutil4) contains strings }
  { to be displayed.  added by DL 8-13-96 }
  Var
    X: Word;
    i, DY: Byte; { DY is line spacing in pixels }
    Y: Array[1..8] Of Word;
    
  Begin
    X := 20;
    Y[1] := Y0;
    DY := 53;
    { make Y values }
    For i := 2 To 8 Do Y[i] := Y[i - 1] + DY;
    EraseBalText;
    SetCharSize(11,8,7,4);
    For i := 1 To nlines Do OutTextXY(X, Y[i], BigText[i]);
    If holdit Then hold(GetXcape);
  End; {ShowMessage}

Procedure ShowKeyboardChar(key: Char; Ext: Boolean);
{ added by DL in the wee hours of 8/17/96 }
{ analogous to SpeakKeyboardChar: shows printable
  chars in a little window in the bottom right corner }

  Const
    X: Word = 559;
    Y: Word = 379;
    XChar: Word = 572;
    Ychar: Word = 369;
    
  Begin
    If Ext Then Exit;
    Rectangle(X, Y, MaxX, MaxY);
    If key In PrintableChars Then
    Begin
      { temporary big chars }
      SetUserCharSize(5,2,3,1);
      SetColor(Black);
      OutTextXY(Xchar, Ychar, OldKey );
      SetColor(White);
      OutTextXY(Xchar, YChar, key);
      OldKey := key;
    End;
    { reset to old size }
    ResetCharSize;
  End;

{  SpeakKeyboardChar3    Speaks the character passed into procedure. This  }
{                        procedure performs a call to talkit101.           }
{                        Modified original procedure SpeakKeyboardCharacter}
{                        to use a case statement instead of many if/else   }
{                        statements. (JRH090394)                           }

{                        modified to handle extended codes 7/96 DL         }
{                        modified to flush buffer on synths dl 10/96       }


Procedure SpeakKeyboardChar3(ans: Char; ext: Boolean);
{ original by RMM ca. 1993, modified by JRH (see above comments.) }
{ modified to handle extended key codes 7-96 DL }
{ unit GetKeysX.pas has a better approach to echoing keys, so
  this routine is *OBSOLETE*. DL 7-31-96 }
{ now exits if speech not ready DL 8-18-96 }
{ ability to flush synth buffer added dl 10-96 }

  Begin { SpeakKeyboardChar3 }
    If Not TalkReddy Then Exit;
    If Flushit Then FlushTalkBuffer(FlushDelay); { flush synth buffer added dl 10-96 }
    TalkString := 'no-name key';   { default name added DL 8-9-96 }
    If Not ext Then
    Begin
      ans := UpCase(ans);
      Case ans Of
        'B'..'Z' : TalkString := ans;
        '0'..'9' : TalkString := ans;
        'A'      : TalkString := 'ay';
        'Y'      : TalkString := 'wye';
        #32      : TalkString := 'space';
        #13      : TalkString := 'enter';
        #27      : TalkString := 'Escape';
        #8       : TalkString := 'back space';
        #9       : TalkString := 'tab';
        #91      : TalkString := 'left bracket';
        #93      : TalkString := 'right bracket';
        #94      : TalkString := 'circum flex';
        #92      : TalkString := 'back slash';
        #123     : TalkString := 'left curly bracket';
        #125     : TalkString := 'right curly bracket';
        #64      : TalkString := 'at symbol';
        #33      : TalkString := 'exclamation mark';
        #34      : TalkString := 'quotation mark';
        #35      : TalkString := 'pound key';
        #36      : TalkString := 'dollar sign';
        #37      : TalkString := 'percent sign';
        #38      : TalkString := 'and symbol';
        #39      : TalkString := 'a pos trofee';
        #40      : TalkString := 'left paren thesis';
        #41      : TalkString := 'right paren thesis';
        #42      : TalkString := 'asterisk';
        #43      : TalkString := 'plus';
        #44      : TalkString := 'comma';
        #45      : TalkString := 'my-nuss';
        #46      : TalkString := 'dot';
        #47      : TalkString := 'slash';
        #58      : TalkString := 'colon';
        #59      : TalkString := 'semi colon';
        #60      : TalkString := 'greater than';
        #61      : TalkString := 'equal';
        #62      : TalkString := 'less than';
        #63      : TalkString := 'question mark';
      End;
    End
    Else
    Begin  { extended (two-byte) key codes (a partial list!) }
      Case ans Of
        #75      : TalkString := 'left arrow';
        #77      : TalkString := 'right arrow';
        #72      : TalkString := 'up arrow';
        #80      : TalkString := 'down arrow';
        #71      : TalkString := 'home';
        #73      : TalkString := 'page up';
        #81      : TalkString := 'page down';
        #79      : TalkString := 'end';
        #82      : TalkString := 'insert';
        #83      : TalkString := 'delete';
        
        { new keys added DL 8-9-96 }
        
        #59   : TalkString:= ' F  1 ';
        #60   : TalkString:= ' F  2 ';
        #61   : TalkString:= ' F  3 ';
        #62   : TalkString:= ' F  4 ';
        #63   : TalkString:= ' F  5 ';
        #64   : TalkString:= ' F  6 ';
        #65   : TalkString:= ' F  7 ';
        #66   : TalkString:= ' F  8 ';
        #67   : TalkString:= ' F  9 ';
        #68   : TalkString:= ' F  10 ';
      End;
    End;
    talkit101(TalkString);
  End; { SpeakKeyboardChar3 }

{  VerifyQuit           Verifies that the user wants to quit the program. }

Procedure VerifyQuit2;

  Var
    ans: Char;
    Ext: Boolean;
    
  Begin
    Ext := False;
    talkstring := 'Are you sure you want to quit? ';
    talkit101(talkstring);
    SetCharSize(7,4,11,4);
    OutTextXY(90,150,'Press Q to Quit');
    talkstring := 'Press Q to quit, and any other key to go on.';
    talkit101(talkstring);
    Repeat Until KeyPressed;
    ans := UpCase(ReadKey);
    { get 2nd byte of extended code }
    If Ord(ans) = 0 Then
    Begin
      ans :=  ReadKey;
      Ext := True;
    End;
    SpeakKeyBoardChar3(ans, Ext);
    If ((ans =  'Q') And (Not Ext)) Then quit := True Else quit := False;
  End; {VerifyQuit}


{  SpellOut              Spells out string character by character with the }
{                        special case for a period (char #46) in which it  }
{                        speaks the word 'dot'.                            }
{                        Modified to call new procedure SpeakKeyboardChar3.}

Procedure SpellOut(strang: String);
 { original by DL ca. 1993 }
 { pauses introduced DL 8-1-96 }
  Var
    L, i: Byte;
    letter: Char;
    OldFlush: Boolean;
    
  Begin
    L := Length(strang);
    If L = 0 Then Exit;
    OldFlush :=  Flushit; { save it }
    Flushit := False;
    For i := 1 To L Do
    Begin
      letter := strang[i];
      If letter = dot Then talkit101(' dot ')
      Else SpeakKeyboardChar3(letter, False);
      Delay(150);
    End;
    Flushit := OldFlush;
  End; {SpellOut}

Procedure CheckKeyOK(Var key: Char; OKset: charset; Var OK, Xcode: Boolean);
  { added by DL 9-96}
  Begin
    Xcode := False;
    If Ord(key) = 0 Then
    Begin
      key := ReadKey;
      Xcode := True;
    End;
    If Xcode Then OK := False
    Else
    Begin
      If key In OKSet Then OK := True
      Else OK := False;
    End;
    { get rid of multiple keystrokes dl 12-3-96 }
    If ((Not StringInput) And (KeyPressed)) Then FlushKeyBoardBuffer;
  End;

Procedure Beep(f, dt, reps: Word);
  { added by DL 9-96}
Var
  i: Word;
  
Begin
  For i := 1 To reps Do
  Begin
    Sound(f);
    Delay(dt);
    NoSound;
    Delay(4*dt);
  End;
End;

Procedure ShowOrSayNoWarranty(SayIt: Boolean);

Var
  dumstg: String;
  infil: Text;
  
Begin
  If ((SayIt) And (Not TalkReddy)) Then Exit;
  If Not CheckFileExists2('NOWARR.GNU') Then Exit
  Else
  Begin
    Assign(infil, 'NOWARR.GNU');
    Reset(infil);
    While Not EoF(infil) Do
    Begin
      ReadLn(infil, dumstg);
      If Sayit Then
      Begin
        ConvertLowerCase(dumstg);
        talkit101(dumstg);
      End
      Else WriteLn(dumstg);
    End;
    Close(infil);
  End;
End;


Function MakeMassTalkString(strang: String): String;
{ added to force innumerate synths like the Echo to
  speak the decimal point in a number. adapted from
  SpellOut.  DL 7-30-96 }

  Var
    L, i: Byte;
    dumstg: String;
    
  Begin
    dumstg := '';
    L := Length(strang);
    If L = 0 Then
    Begin
      MakeMassTalkString := '';
      Exit;
    End;
    For i := 1 To L Do
    Begin
      If strang[i] = dot Then dumstg := dumstg + ' point, '
      Else dumstg := dumstg + strang[i] + ', ';
    End;
    MakeMassTalkString := dumstg;
  End;

Function MakeUnitTalkString(ustring: String20): String;
    {  DL 7-31-96 }
  Begin
    If ustring = 'g' Then
      MakeUnitTalkString := 'grammzz'
    Else If ustring = 'OZ' Then  MakeUnitTalkString := 'ounces'
    Else If ustring = 'OZT' Then  MakeUnitTalkString := 'troy ounces'
    Else If ustring = 'LB' Then  MakeUnitTalkString := 'pounds'
    Else If ustring = 'LB' Then  MakeUnitTalkString := 'pounds'
    Else If ustring = 'CT' Then  MakeUnitTalkString := 'carats'
    Else MakeUnitTalkString := ustring;
  End;


Function BalPortNameOK(portnam: String): Boolean;
 { checks that the balance port name is a legal
   DOS serial port, COM1 or COM2. no hardware checks!
   DL 7-31-96 }
Begin
  BalPortNameOK := False;
  If portnam = 'COM1' Then BalPortNameOK := True
  Else If portnam = 'COM2' Then BalPortNameOK := True;
End; { BalPortNameOK }


{  ReadBalPort;          Reads port data from file                          }

Procedure ReadBalPort(Var BalPortName: String4; Var balportno: Byte);
  { original by RMM ca. 1993, modified by JJ (see above history) }
  { modified by DL not to ask for balance port if file balport.dat
    is not found, but to default to COM1. (8-96) }
  Var
    portfilename, portstg: String;
    portfile: Text;
    erx, i, OrigMode: Integer;
    dum: Char;
    
  Begin
    portfilename := 'balport.dat';
    If  Not CheckFileExists2(portfilename) Then
    Begin
      PortNo := 1;
      BalPortName  := 'COM1';
      If Not nowrites Then
      Begin
        OrigMode := LastMode;
        ClrScr;
        TextMode(CO40);
        GotoXY(5,12);
        Beep(1568, 50, 2);
        WriteLn('FILE "BALPORT.DAT" NOT FOUND.');
        GotoXY(3,15);
        WriteLn('SETTING BALANCE DATA PORT TO COM1.');
        Delay(6000);
      End;
    End
    Else
    Begin
      Assign(portfile, portfilename);
      Reset(portfile);
      ReadLn(portfile, portstg);
      Close(portfile);
      eatblanks(portstg);
      allcaps(portstg);
      BalPortName := Copy(portstg, 1, 4);
      Val(Copy(portstg, 4, 1), balportno, erx);
      If ((erx > 0) Or (Not BalPortNameOK(BalPortName)))
      Then
      Begin
        OrigMode := LastMode;
        ClrScr;
        TextMode(CO40);
        GotoXY(1, 8);
        Beep(2960, 100, 5);
        WriteLn('    FILE "BALPORT.DAT" CONTAINS');
        WriteLn('    AN INVALID PORT NAME:  ', BalPortName, '.');
        WriteLn(' LEGAL PORT NAMES ARE COM1 OR COM2.');
        WriteLn('       PLEASE EDIT THE FILE.');
        WriteLn('         HALTING PROGRAM.');
        WriteLn;
        WriteLn('          PRESS ANY KEY.');
        hold(False);
        TextMode(OrigMode);
        NormVideo;
        Halt;
      End;
    End;
  End; { ReadBalPort}


{  TellSaved             Informs user that balance readings have been saved}
{                        to a file.                                        }

Procedure tellsaved;

  Begin
    talkit101('Your reedings have been saved in file. ');
    spellout(LogFileName);
  End; {TellSaved}


{  FixScreen             This procedure was written so that the program    }
{                        will close out of graph mode and return to CRT    }
{                        mode before exiting. Jason Johnson 5/17/95        }

Procedure FixScreen;

  Begin
    CloseGraph;
    RestoreCRTMode;
    ClrScr;
    TextMode(3);
  End;  {FixScreen}


{  TellFixit2            Tells the user to fix the problem with the        }
{                        balance.  If logging readings to a file, tell     }
{                        user that readings have been saved to a file.     }
{                        Restore screen to text mode, then halt program.   }


Procedure TellFixit2;                              { MMG 5-13-96 }
  Begin
    talkstring := 'Please turn off the computer and fix the problem.';
    talkit101(talkstring);
    If numredes  > 0 Then
      If ((loggit) And (TalkReddy)) Then tellsaved;
    talkstring := 'Halting program.';
    talkit101(talkstring);
    { delay for reading screen }
    If TalkReddy Then Delay(10000) Else Delay(45000);
    If GrafOpen Then FixScreen;
    Halt;
  End; {TellFixit2}

Procedure ShowInputError;
{ DL 7/30/96 }
  Var
    dum: Char;
  Begin
    EraseBalText;
    Beep(2960, 100, 5);
    SetCharSize(2,1,5,2);
    OutTextXY(0,25,  '   INPUT ERROR?');
    OutTextXY(0,100, '  CHECK BALANCE');
    OutTextXY(0,175, '     SETTINGS.');
    OutTextXY(0,300, ' HALTING PROGRAM.');
  End; { ShowInputError }

Procedure TellInputError;
  { added by DL 8-96}
  Begin
    If GrafOpen Then ShowInputError;
    talkstring := 'There may be an input error on port ' + balportname;
    talkit101(talkstring);
    talkstring := 'The serial port on the balance may not be set up correctly.';
    talkit101(talkstring);
    talkstring := 'The file, ';
    talkit101(talkstring);
    SpellOut(Readmefile);
    talkstring := ', contains information on setting up the balance.';
    talkit101(talkstring);
    TellFixit2;
  End;

Procedure ShowBalNotOn;
  Var
    dum: Char;
  Begin
    EraseBalText;
    Beep(2960, 100, 5);
    SetCharSize(2,1,5,2);
    OutTextXY(0,25,  '  BALANCE NOT ON');
    OutTextXY(0,100, '     OR NOT');
    OutTextXY(0,175, '   CONNECTED!');
    If BalanceSetup Then
      OutTextXY(80,360,'Press any key.')
    Else OutTextXY(0,300, ' HALTING PROGRAM.');
  End; {ShowBalNotOn}

Procedure TellBalNotOn;
Begin
  If GrafOpen Then ShowBalNotOn;
  talkstring := 'The balance is not on or is not connected.';
  talkit101(talkstring);
  If BalanceSetup Then
  Begin
    talkstring := 'Press any key for more information.';
    talkit101(talkstring);
    hold(False);
    TellInputError;
  End Else TellFixit2;
End;


Procedure ShowDriveNotValid(drvltr: Char);
{ DL 8-9-96 }
  Begin
    EraseBalText;
    Beep(2637, 70, 3);
    SetCharSize(7,4,5,2);
    OutTextXY(20,25,  'DRIVE '+ drvltr +  ': NOT VALID.');
    OutTextXY(20,100, '   ENTER A NEW ');
    OutTextXY(20,175, '    FILE NAME.   ');
    OutTextXY(80,350,' PRESS ANY KEY.');
  End;

Procedure TellDriveNotValid(drvltr: Char);
  { added by DL 8-96 }
  Var
    talkltr: String[3];
    
  Begin
    If GrafOpen Then ShowDriveNotValid(drvltr);
    If drvltr = 'A' Then talkltr := 'ay' Else talkltr := drvltr;
    talkstring := 'Drive, ' + talkltr + ' , is not ready,'
    + ' or is not a valid drive, or is defective. ';
    talkit101(talkstring);
    talkit101('Press any key to go on');
    hold(True);
  End;

Procedure ShowDriveDied(drvltr: Char);
{ DL 8-9-96 }
  Begin
    EraseBalText;
    Beep(2960, 100, 5);
    SetCharSize(7,4,5,2);
    OutTextXY(20,25,  'DRIVE '+ drvltr +  ': NOT READY,');
    OutTextXY(20,100, '   OR IS DEAD OR');
    OutTextXY(20,175, '     DEFECTIVE.');
    OutTextXY(80,300,'HALTING PROGRAM.');
  End;

Procedure TellDriveDied(drvltr: Char);
  { DL 8-9-96 }
  Var
    talkltr: String[3];
    
  Begin
    If GrafOpen Then ShowDriveDied(drvltr);
    If drvltr = 'A' Then talkltr := 'ay' Else talkltr := drvltr;
    talkstring := 'Drive, ' + talkltr + ' , is not ready,'
    + ' or is dead or defective. ';
    talkit101(talkstring);
    TellFixit2;
  End;

Procedure ShowPutInFloppy(drvltr: Char; Var ntries: Byte);
  { DL 8-9-96 }
  Begin
    EraseBalText;
    Beep(2489, 70, 2);
    SetCharSize(7,4,5,2);
    OutTextXY(20,25,  'DRIVE '+ drvltr +  ': NOT READY!');
    OutTextXY(20,100, '    INSERT A DISK, ');
    OutTextXY(20,175, '        THEN   ');
    OutTextXY(80,350,' PRESS ANY KEY.');
    ntries := ntries + 1;
  End;

Procedure TellPutInFloppy(drvltr: Char; Var ntries: Byte);
  { DL 8-9-96 }
  Var
    talkltr: String[3];
    
  Begin
    If GrafOpen Then ShowPutInFloppy(drvltr, ntries);
    If drvltr = 'A' Then talkltr := 'ay' Else talkltr := drvltr;
    talkstring := 'Drive ' + talkltr + ' is not ready';
    talkit101(talkstring);
    talkstring := 'Insert a disk and press any key.';
    talkit101(talkstring);
    hold(True);
  End;


Procedure FixUpFileName(Var fulnam: String; Var fixed,
                              NoExt, NoFileName, hopeless: Boolean);
 { removes chars that are legal but misplaced in a DOS file name.
   assumes that name has been entered with a routine that rejects
   illegal chars like *, /, ?, etc. added by DL 9/96 }

  Var
    i, j, k, L, extlen, ndx: Byte;
    coloncount, Len0, Len, ndirs: Byte;
    colonloc, dirlocs, dirlens: ByteRay128;
    subdirs: Array[1..8] Of String;
    dirn, fnam, ext, tempstg, tempext, tempdirn, tempfnam: String;
    drivepresent: Boolean;
    
  Begin
    NoFileName := False;
    Fixed := False;
    Hopeless := False;
    drivepresent := False;
    allcaps(fulnam);
    eatblanks(fulnam);
    Len0 := Length(fulnam);
    
    { delete illegal repeats (\\ .. ::  etc.) }
    If Pos('\\', fulnam) > 0 Then KillRepeats(BackSlash, fulnam);
    If Pos('..', fulnam) > 0 Then KillRepeats(dot, fulnam);
    If Pos('::', fulnam) > 0 Then KillRepeats(colon, fulnam);
    
    If Length(fulnam) <> Len0 Then fixed := True;
    
    { only one colon is legal, and only in pos 2 after a letter }
    If (fulnam[1] In ['A'..'Z']) Then
    Begin
      { check out-of-place colon; count colons }
      coloncount := 0;
      L := Length(fulnam);
      For i := 1 To L Do
      Begin
        If fulnam[i] = colon Then
        Begin
          coloncount := coloncount + 1;
          colonloc[coloncount] := i;
        End;
      End;
      If ((coloncount = 1) And (colonloc[1] = 2)) Then drivepresent := True;
      If ((coloncount > 1) Or ((coloncount = 1) And (colonloc[1] <> 2))) Then
      Begin
        { delete all colons }
        EatChar(colon, fulnam);
        { insert one in pos 2 }
        Insert(colon, fulnam, 2);
        fixed := True;
        drivepresent := True;
      End;
    End Else If Pos(colon, fulnam) > 0 Then EatChar(colon, fulnam);
    
    { remove extra dots }
    If Pos(dot, fulnam) > 0 Then
    Begin
      Repeat
        L := Length(fulnam);
        { remove trailing dot, if any }
        If fulnam[L] = dot Then Delete(fulnam, L, 1);
        L := Length(fulnam);
        { find last dot }
        ndx := L;
        Repeat ndx := ndx - 1 Until fulnam[ndx] = dot;
        extlen := L - ndx;
        tempext := Copy(fulnam, ndx + 1, extlen);
        { delete \ in ext }
        If Pos(backslash, tempext) > 0 Then EatChar(backslash, tempext);
        extlen := Length(tempext);
        tempstg := Copy(fulnam, 1, ndx - 1);
        If extlen = 0 Then fulnam := tempstg;
      Until ((extlen > 0) Or (Pos(dot, tempstg) = 0));
      { delete extraneous dots }
      If Pos(dot, tempstg) > 0 Then EatChar(dot, tempstg);
      fulnam := tempstg + dot + tempext;
    End;
    
    FSplit(fulnam, dirn, fnam, ext);
    If Length(fnam) =  0 Then
    Begin
      NoFileName := True;
      Hopeless := True;
      fixed := False;
      Exit;
    End;
    
    { insert backslash for root dir }
    If Pos(BackSlash, dirn) > 0 Then
    Begin
      If drivepresent Then ndx := 3 Else ndx := 1;
      If dirn[ndx] <> backslash Then
      Begin
        Insert(backslash, dirn, ndx);
        fixed := True;
      End;
    End;
    
    { shorten long subdirs }
    If Pos(BackSlash, dirn) > 0 Then
    Begin
      FindSubstringLocs(dirn, backslash, dirlocs, dirlens, ndirs);
      If drivepresent Then tempdirn := ''  Else tempdirn := backslash;
      For i := 1 To ndirs Do
      Begin
        If dirlens[i] > 8 Then
        Begin
          ndx := 8;
          fixed := True;
        End Else ndx := dirlens[i];
        SubDirs[i] := Copy(dirn, dirlocs[i], ndx);
        tempdirn := tempdirn + SubDirs[i] + backslash;
      End;
      dirn := tempdirn;
    End;
    fulnam := dirn + fnam + ext;
    If Length(fulnam) <> Len0 Then fixed := True;
  End;


{  InitBalPort2          Initializes port to which balance is connected.   }
{                        (balance init moved to initbalance, DL 7-96)      }

Procedure InitBalPort2;

  Begin { InitBalPort2 }
    ReadBalPort(BalPortName, PortNo);
    InShake := 'DTR';                                       {32495 JMJ}
    OutShake := 'CTS';
    indelim := 'CRLF';
    outdelim := 'CRLF';
    BIOSInitComPort(PortNo, baud, databits, parity, stopbits);
    InitHandShakes(PortNo); { initialize boolean variables }
    maxloops := 5.0E+3;     { about 5 s delay }
  End; { InitBalPort2 }

Procedure GetROMVersion;
 { gets ROM version DL 9-96 }
  Begin { GetROMVersion }
    { send "get ROM version" command }
    SendALine2(PortNo, 'V', OutShake, outdelim);
    ReadALine4(PortNo, ROMVersion, InShake, indelim);  { read it }
    If Timeout Then TellBalNotOn;
    If InputError[PortNo] Then TellInputError;
  End; { InitBalance }

{  InitBalance           Initializes the balance itself                    }
{                        (modified by DL 7-96)                             }

Procedure InitBalance;
 { error checking added by DL 7-96 }
 { also gets ROM version DL 9-96 }
  Var
    i, reddybyte: Byte;
    dumstg: String;
    
  Begin { InitBalance }
    InputError[PortNo] := False;
    { check handshake first }
    CheckCTS(PortNo, reddybyte);
    If reddybyte = 0 Then TellBalNotOn;
    SendALine2(PortNo, '0D', OutShake, outdelim); { turn off one s. delay }
    If Timeout Then TellBalNotOn;
    SendALine2(PortNo, '0S', OutShake, outdelim); { turn off stable data }
    If Timeout Then TellBalNotOn;
    SendALine2(PortNo, '00A', OutShake, outdelim); { disable Auto Print }
    If Timeout Then TellBalNotOn;
    { read 3x to catch phony CTS line! }
    BalanceSetup := True;
    For i := 1 To 3 Do
    Begin
      SendALine2(PortNo, 'P', OutShake, outdelim);   { send print command }
      ReadALine4(PortNo, dumstg, InShake, indelim);  { read it }
      If Timeout Then TellBalNotOn;
      If InputError[PortNo] Then TellInputError;
    End;
  End; { InitBalance }


{  InitializeGraf        Initialize graphics and report any errors that may}
{                        occur.                                            }

Procedure InitializeGraf;
  Begin { InitializeGraf }
    GraphDriver := Detect;                { use autodetection }
    InitGraph(GraphDriver, GraphMode, '');
    GraphErrorCode := GraphResult;             { preserve error return }
    If GraphErrorCode <> grOK Then             { error? }
    Begin
      WriteLn('Graphics error: ', GraphErrorMsg(GraphErrorCode));
      Halt(1);                          { terminate }
    End;
    
  End; { InitializeGraf }


{  GraphicsAbort         Displays an abort message if there are any        }
{                        problems encountered while compiling the BGI      }
{                        drivers into the executable { .EXE) file.         }

Procedure GraphicsAbort(Msg : String);
  Begin
    WriteLn(msg, ': ', GraphErrorMsg(GraphResult));
    Halt(1);
  End;  {GraphicsAbort}


{  SaveGraphics          Compiles the fonts and graphics driver into the   }
{                        executable { .EXE) file. This makes it so the     }
{                        program does not have to be distributed with both }
{                        the EGAVGA.BGI and TRIP.CHR files.                }

Procedure SaveGraphics;
  Begin
    If RegisterBGIDriver(@EGAVGADriverProc) < 0 Then
      GraphicsAbort('EGA/VGA');
    If RegisterBGIFont(@TriplexFontProc) < 0 Then
      GraphicsAbort('Triplex');
  End; {SaveGraphics}


{  GetStrang5            Get input from user. Error check for validity, if }
{                        not a valid answer tell user. If user backspaces  }
{                        then say 'wipe-out' to inform that old input was  }
{                        deleted.                                          }


Procedure GetStrang5(X0, Y0: Word; Var strang: String;
                       maxlen, maxlines, DY: Byte; filenamechars: Boolean);

 { original ver. written by DL ca. 1993 (who else would use a
    name like "GetStrang"?) (note added by DL 9-96) }

 { displays more than one line of text  to enable input
   of long strings (displays 8 lines max) DL 8-12-96 }

 { arguments: X0, Y0: starting X and Y positions.
              strang: the text entered (returned as one string)
              maxlen: max length of a line in chars.
              maxlines: max number of lines on the screen
              DY: spacing between lines, in pixels  }

 { if variable filenamechars is TRUE the input is limited to
   chars that are legal in a DOS file name. }

 { now handles extended key codes DL 7-96 }
 { rejects unprintable chars DL 8-9-96 }
 { turns off flushing of buffer on synth to prevent
   erasing chars that haven't been spoken yet. dl 10-29-96 }
 { v. 5 now flushes speech buffer when first key is pressed
    dl 10-30-96 }

  Var
    ans, oldans: Char;
    L, numlines, k, i, numchars:  Byte;
    NullStrang, ExtCode, OKans, maxchars, nochars,
    EnterPressed, BackPressed, OldFlush: Boolean;
    goodset: charset;
    Len: Array[1..8] Of Byte;
    Y : Array[1..8] Of Word;
    dumstg: Array[1..8] Of String20;
    X: Word;
    
  Begin
    {FlushKeyboardBuffer;}
    StringInput := True;
    OldFlush := Flushit; { save state of Flushit }
    Flushit := False; { turn off instant shut-up }
    numchars := 0;
    numlines := 1;
    maxchars := False;
    nochars := True;
    X := X0;
    Y[1] := Y0;
    { make Y table }
    For i := 2 To maxlines Do Y[i] := Y[i-1] + DY;
    For i := 1 To maxlines Do dumstg[i] := '';
    k := 1;
    If filenamechars Then goodset := LegalFileNameChars + [BS, CR]
    Else goodset := PrintableChars + [BS, CR];
    oldans := ' ';
    SetColor(White);
    Repeat
      Repeat
        Repeat Until KeyPressed;
        ans := ReadKey;
        If numchars = 0 Then If Flushable
        Then FlushTalkBuffer(FlushDelay); { flush synth buffer added dl 10-96 }
        { check for valid key and extended codes DL 7/96 }
        CheckKeyOK(ans, goodset, OKans, ExtCode);
        SpeakKeyboardChar3(ans, ExtCode);
        If ((ans = BS) And (OKans)) Then
          BackPressed := True
        Else BackPressed := False;
        
        If ((ans = CR) And (OKans)) Then
          EnterPressed := True
        Else EnterPressed := False;
        
        If BackPressed Then
        Begin
          L := Length(dumstg[k]);
          If L = 0 Then
          Begin
            If k > 1 Then k := k - 1 Else
            Begin
              Beep(466, 50, 3);
              nochars := True;
            End;
          End;
          If Not nochars Then
          Begin
            L := Length(dumstg[k]);
            SetColor(Black);
            OutTextXY(X, Y[k], dumstg[k]);
            oldans := dumstg[k, L];
            Delete(dumstg[k], L, 1);
            SetColor(White);
            OutTextXY(X, Y[k], dumstg[k]);
            talkit101('wipe-out  ');
            SpeakKeyboardChar3(oldans, False);
            maxchars := False;
          End;
        End
        Else
        Begin
          If OKans Then
          Begin
            If Not EnterPressed Then
            Begin
              If maxchars Then Beep(466, 50, 3)
              Else
              Begin
                nochars := False;
                dumstg[k] := dumstg[k] + ans;
                L := Length(dumstg[k]);
                OutTextXY(X, Y[k], dumstg[k]);
                If L = maxlen Then
                Begin
                  If k < maxlines Then
                  Begin
                    k := k + 1;
                    numlines := numlines + 1;
                  End
                  Else
                  Begin
                    Beep(466, 50, 3);
                    maxchars := True;
                  End;
                End;
              End;
            End;
          End
          Else
          Begin
            ShowKeyBoardChar(ans, ExtCode);
            Beep(2093, 30, 1);
            If TalkReddy Then talkit101('Illeegal key ignored. ');
          End;
        End;
      Until EnterPressed;
      strang := '';
      For i := 1 To numlines Do strang := strang + dumstg[i];
      If Length(strang) = 0 Then Nullstrang := True
      Else Nullstrang := False;
      If Nullstrang Then
      Begin
        Beep(988, 50, 4);
        If TalkReddy Then talkit101('No text entered. Please try again.');
      End;
    Until Not Nullstrang;
    Flushit := OldFlush; { set instant shut-up to original state }
    StringInput := False;
  End; {GetStrang4}


{  BalanceInfo2          This procedure took some of the general info      }
{                        from IntroBalance and broke it up so that the     }
{                        it is easier to decipher the code.                }
{                        Added by Jason Johnson 5-17-95                    }

{                        modified to remove specifics like balance         }
{                        model, capacity, readability, etc. DL 7-96        }

Procedure BalanceInfo3;
{ was BalanceInformation }
{ modified to speak warranty info dl 12-2-96 }

  Const
    goodset: charset = ['A'..'Z'];
    
  Var
    ans: Char;
    ExtCode, OKans: Boolean;
    
  Begin
    EraseBalText;
    If KeyPressed Then FlushKeyBoardBuffer;
    SetCharSize(3,2,5,2);
    OutTextXY(30,10,'THIS PROGRAM READS ');
    OutTextXY(30,80,'A BALANCE AND PUTS');
    OutTextXY(30,150,'THE READING ON THE ');
    OutTextXY(30,220,'SCREEN AND SPEAKS IT');
    OutTextXY(50,360,'Press any key to go on.');
    talkstring := 'This program reeds a balance, sends the ';
    talkstring := talkstring + 'balance reeding to the screen,';
    talkstring := talkstring + 'and speaks it...' ;
    talkit101(talkstring);
    talkstring :=  'Press any key to go on.';
    talkit101(talkstring);
    
    hold(False);
    
    EraseBalText;
    OutTextXY(50,10, ' THE MASS READINGS');
    OutTextXY(50,80, ' CAN BE SAVED IN A');
    OutTextXY(50,150,'DISK FILE FOR LATER');
    OutTextXY(50,220,'   EXAMINATION.');
    OutTextXY(50,360,'Press any key to go on.');
    talkstring := 'The mass reedings can be saved in '
    + ' a disk file for layter examination.';
    talkit101(talkstring);
    talkstring := 'Press any key to go on.';
    talkit101(talkstring);
    hold(False);
    
    
    If TalkReddy Then
    Begin
      EraseBalText;
      
      If KeyPressed Then FlushKeyBoardBuffer;
      OutTextXY(40,45,  ' PRESS THE "G" KEY');
      OutTextXY(40,120, ' TO HEAR THE GNU');
      OutTextXY(40,195, 'LICENSE NON-WARRANTY,');
      OutTextXY(40,270, '   AND ANY OTHER');
      OutTextXY(40,345, '   KEY TO GO ON. ');
      
      talkstring := 'Press the  G  key to hear the non-warranty '
      + 'from the guhnoo General Software License, and any other key to go on.';
      talkit101(talkstring);
      Repeat Until  KeyPressed;
      ans := ReadKey;
      ans := UpCase(ans);
      { check for valid key and extended codes DL 7/96 }
      CheckKeyOK(ans, goodset, OKans, ExtCode);
      ShowKeyboardChar(ans, ExtCode);
      SpeakKeyboardChar3(ans, ExtCode);
      If ((ans = 'G') And (Not ExtCode)) Then
      Begin
        ShowOrSayNoWarranty(True);
        If KeyPressed Then FlushKeyBoardBuffer;
      End;
    End;
  End; {BalanceInfo3 }


{  IntroBalance          Give general information and/or instructions. This}
{                        information is displayed on the screen as well as }
{                        spoken.                                           }

Procedure IntroBalance;

  Const
    goodset: CharSet = [#27,'I','C'];
    
  Var
    errorcode: Integer;
    ans, dum:Char;
    OKans, ExtCode: Boolean;
    
  Begin
    EraseBalText;
    If KeyPressed Then FlushKeyBoardBuffer;
    SetCharSize(2,1,5,2);                                  {13195JMJ}
    OutTextXY(0,0, '       PRESS    ');
    OutTextXY(0,75, ' I    - GENERAL ');
    OutTextXY(0,150,'    INFORMATION');
    OutTextXY(0,225,'   & INSTRUCTIONS');
    OutTextXY(0,295,' C    - CONTINUE');
    OutTextXY(0,370,' ESC  - QUIT');
    talkstring := 'Press  eye  for general information and Instructions, C';
    talkstring := talkstring + ' to Continue, and escape to quit.';
    talkit101(talkstring);
    Repeat
      Repeat Until  KeyPressed;
      ans := ReadKey;
      ans := UpCase(ans);
      { check for valid key and extended codes DL 7/96 }
      CheckKeyOK(ans, goodset, OKans, ExtCode);
      ShowKeyboardChar(ans, ExtCode);
      SpeakKeyboardChar3(ans, ExtCode);
      
      If Not OKans Then
      Begin
        Beep(2093, 30, 1);
        If TalkReddy Then
        Begin
          talkstring := 'In valid an sir. Try again.';
          talkit101(talkstring);
          talkstring := 'Press  eye  for general information and';
          talkstring := talkstring + ' instructions, C to Continue ';
          talkstring := talkstring + ' and escape to quit.'; {JMJ51795}
          talkit101(talkstring);
        End;
      End;
    Until OKans;
    If ans = ESC Then        {Added 5-17-95 by Jason M. Johnson}
    Begin
      EraseBalText;
      VerifyQuit2;
      If quit Then Exit Else IntroBalance;
    End;
    If ans = 'I' Then BalanceInfo3;
    If ans = 'C' Then Exit;
    Introbalance;       {JMJ51595}
    
  End; { IntroBalance }


{  SayFileExists2        Inform user that the filename entered already     }
{                        exists. Allow user to append data                 }
{                        to file or enter a new filename.                  }

Procedure SayFileExists2;
{ Option of overwriting the file removed 8-13-96 DL;
  you never erase a lab notebook! }

  Var
    X, Y: Word;
    DY:  Byte;
    dumstg: String;
    
  Begin
    X := 15;
    Y := 25;
    DY := 50;
    EraseBalText;
    SetCharSize(3,2,3,2);
    OutTextXY(X, Y,'THE FILE THAT YOU ');
    Y := Y + DY;
    OutTextXY(X, Y,'HAVE ENTERED:');
    Y := Y + DY;
    OutTextXY(X, Y, LogFileName);
    Y := Y + DY;
    OutTextXY(X, Y,'EXISTS. PRESS');
    Y := Y + DY;
    OutTextXY(X, Y,'A - TO ADD DATA TO FILE,');
    Y := Y + DY;
    OutTextXY(X, Y,'E - TO ENTER ANOTHER ');
    Y := Y + DY;
    OutTextXY(X, Y,'       FILE NAME');
    Y := Y + DY;
    OutTextXY(X, Y,'ESC - FOR MAIN MENU.');
    talkstring := 'The file that you have entered,';
    talkit101(talkstring);
    SpellOut(LogFileName);
    talkstring := ', exists.';
    talkit101(talkstring);
    talkstring := 'Press ay to add data to the file , E to enter';
    talkstring := talkstring + ' another file name,  or escape to return';
    talkstring := talkstring + ' to the main men-yoo';     {JMJ51695}
    talkit101(talkstring);
  End; {SayFileExists2}


Procedure ShowIllegalName(fnam: String);
  { 8-13-96 DL }
  Var
    Y0: Word;
    
  Begin
    Y0 := 25;
    BigText[1] := 'THE FILE NAME THAT YOU';
    BigText[2] := 'HAVE ENTERED:';
    BigText[3] :=  LogFileName;
    BigText[4] := 'CONTAINS THE NAME OF A ';
    BigText[5] := 'DOS DEVICE: '+ fnam + ',';
    BigText[6] := 'WHICH IS ILLEGAL. PLEASE';
    BigText[7] := 'ENTER A NEW FILENAME';
    BigText[8] := ' Press any key ';
    ShowMessage(8, Y0, False, False);
  End;

Procedure SayIllegalName(fnam: String);
  { 8-13-96 DL }
  Begin
    ShowIllegalName(fnam);
    talkstring := 'The file name that you have entered,';
    talkit101(talkstring);
    SpellOut(LogFileName);
    talkstring := ', contains the name of a D O S device, ';
    talkit101(talkstring);
    SpellOut(fnam);
    talkstring := ', which is illeegal.  Please enter a new file name.';
    talkit101(talkstring);
    talkit101('Press any key to continue');
    hold(True);
  End;

Procedure ShowReadOnly;
  { 8-14-96 DL }
  Var
    Y0: Word;
    
  Begin
    Y0 := 25;
    BigText[1] := 'THE FILE NAME THAT';
    BigText[2] := 'YOU HAVE ENTERED:';
    BigText[3] :=  LogFileName;
    BigText[4] := 'CANNOT BE WRITTEN';
    BigText[5] := 'TO. PLEASE ENTER';
    BigText[6] := 'A NEW FILE NAME';
    BigText[7] := '';
    BigText[8] := ' Press any key ';
    ShowMessage(8, Y0, False, False);
  End;

Procedure SayReadOnly;
  { 8-14-96 DL }
  Begin
    ShowReadOnly;
    talkstring := 'The file name that you have entered,';
    talkit101(talkstring);
    SpellOut(LogFileName);
    talkstring := ', cannot be written to. ';
    talkit101(talkstring);
    talkstring := ',  Please enter a new file name.';
    talkit101(talkstring);
    talkit101('Press any key to continue.');
    hold(True);
  End;

Procedure ShowReadOnlyDrive(drvltr: Char);
  { 8-14-96 DL }
  Var
    Y0: Word;
    
  Begin
    Y0 := 25;
    BigText[1] := 'DRIVE '+ drvltr + ': IS A READ-';
    BigText[2] := 'ONLY DRIVE. IT CAN''T';
    BigText[3] := 'BE WRITTEN TO. PLEASE';
    BigText[4] := 'ENTER A NEW DRIVE NAME';
    BigText[5] := '';
    BigText[6] := '';
    BigText[7] := '';
    BigText[8] := ' Press any key ';
    ShowMessage(8, Y0, False, False);
  End;

Procedure SayReadOnlyDrive(drvltr: Char);
  { 8-14-96 DL }
  Var
    talkltr: String[3];
    
  Begin
    ShowReadOnlyDrive(drvltr);
    If drvltr = 'A' Then talkltr := 'ay' Else talkltr := drvltr;
    talkstring := 'Drive,  ' + talkltr + ', is a reed-only drive.';
    talkit101(talkstring);
    SpellOut(LogFileName);
    talkstring := 'It can''t be written to. ';
    talkit101(talkstring);
    talkstring := ',  Please enter a new file name.';
    talkit101(talkstring);
    talkit101('Press any key to continue.');
    hold(True);
  End;

Procedure ShowNameFixed(oldnam: String);
  { 9-2-96 DL }
  Var
    Y0: Word;
    
  Begin
    Y0 := 25;
    BigText[1] := 'THE FILE NAME THAT';
    BigText[2] := 'YOU ENTERED:';
    BigText[3] :=  oldnam;
    BigText[4] := 'HAD ERRORS IN IT.';
    BigText[5] := 'IT HAS BEEN CORRECTED.';
    BigText[6] := 'THE NEW NAME IS:';
    BigText[7] :=  LogFileName;
    BigText[8] := 'Press any key ';
    ShowMessage(8, Y0, False, False);
  End;


Procedure SayNameFixed(oldnam: String);
  { 9-2-96 DL }
  Begin
    ShowNameFixed(oldnam);
    talkstring := 'The file name that you entered,';
    talkit101(talkstring);
    SpellOut(oldnam);
    talkstring := ', had errors in it. It has been corrected. ';
    talkit101(talkstring);
    talkstring := ', The new name is, ';
    talkit101(talkstring);
    SpellOut(LogFileName);
    Talkit101('Press any key to continue.');
    hold(True);
  End;

Procedure ShowVerifyFileName;
  { 9-3-96 DL }
  Var
    Y0: Word;
    lnam, ndx, i: Byte;
    tudamlong: Boolean;
    
  Begin
    Y0 := 25;
    lnam := Length(LogFileName);
    For i := 1 To 8 Do BigText[i] := '';
    lnam := Length(LogFileName);
    
    If lnam < 13 Then BigText[4] := LogFileName
      { call
      Procedure SplitString1(instg: String; sepchar: Char;
      maxlen, ndx1, ndx2: Byte; Var TooLong: Boolean); }
      { a long file name MUST have subdirs }
    Else SplitString1(LogFileName, backslash, 14, 3, 7, tudamlong);
    BigText[1] := 'THE FILE NAME';
    BigText[2] := 'YOU ENTERED IS:';
    BigText[8] := 'OK? (Y/N/ESC)';
    ShowMessage(8, Y0, False, False);
  End;

Procedure SayVerifyFileName(Var NameOK: Boolean);
  { 9-3-96 DL }
  Const
    goodset: charset = [#27, 'Y', 'N'];
    
  Var
    ans: Char;
    OKans, ExtCode: Boolean;
    
  Begin
    ShowVerifyFileName;
    NameOK := False;
    talkstring := ' The file name that you entered is.  ';
    talkit101(talkstring);
    SpellOut(LogFileName);
    talkstring := 'Press wye to accept, N to reject, '+
    ' or escape to return to main men-yoo. ';
    talkit101(talkstring);
    Repeat
      Repeat Until KeyPressed;
      ans := ReadKey;
      ans := UpCase(ans);
      { check for valid key and extended codes DL 7/96 }
      CheckKeyOK(ans, goodset, OKans, ExtCode);
      ShowKeyboardChar(ans, ExtCode);
      SpeakKeyboardChar3(ans, ExtCode);
      
      If Not OKans Then
      Begin
        Beep(2093, 30, 1);
        If TalkReddy Then
        Begin
          talkstring := 'In valid answer. Please try again. ';
          talkstring := talkstring + ' Press  wye, N,  or escape. ';
          talkit101(talkstring);
        End;
      End;
    Until OKans;
    If ans = 'Y' Then  NameOK := True
    Else If ans = ESC Then Escape := True;
  End;


Procedure ShowTooLong(oldnam: String);
  { 8-13-96 DL }
  Var
    Y0: Word;
    
  Begin
    Y0 := 25;
    BigText[1] := 'THE FILE NAME THAT YOU';
    BigText[2] := 'HAVE ENTERED:';
    BigText[3] :=  oldnam;
    BigText[4] := 'IS TOO LONG. IT HAS BEEN';
    BigText[5] := 'SHORTENED TO:';
    BigText[6] :=  LogFileName;
    BigText[7] := '';
    BigText[8] := ' Press any key ';
    ShowMessage(8, Y0, False, False);
  End;

Procedure SayTooLong(oldnam: String);
   { 8-13-96 DL }
  Begin
    ShowTooLong(oldnam);
    talkstring := 'The file name that you have entered,';
    talkit101(talkstring);
    SpellOut(oldnam);
    talkstring := ', is too long. It has been shortened to, ';
    talkit101(talkstring);
    SpellOut(LogFileName);
    Talkit101('Press any key to continue.');
    hold(True);
  End;


Procedure ShowNoFileName;
  { 8-13-96 DL }
  Var
    Y0: Word;
    
  Begin
    Y0 := 25;
    BigText[1] := 'THE TEXT THAT YOU ';
    BigText[2] := 'HAVE ENTERED:';
    BigText[3] :=  LogFileName;
    BigText[4] := 'CONTAINS NO FILE';
    BigText[5] := 'NAME.';
    BigText[6] := '';
    BigText[7] := '';
    BigText[8] := ' Press any key ';
    ShowMessage(8, Y0, False, False);
  End;

Procedure SayNoFileName;
  { 8-13-96 DL }
  Begin
    ShowNoFileName;
    talkstring := 'The text that you have entered,';
    talkit101(talkstring);
    SpellOut(LogFileName);
    talkstring := ', contains  the no file name. ';
    talkstring := ' Please enter a legal file name.';
    talkit101(talkstring);
    Talkit101('Press any key to continue.');
    hold(True);
  End; {SayNoFileName}


Procedure ShowNoSubDir(dirnam: String);
  { 8-13-96 DL }
  Var
    Y0: Word;
    
  Begin
    Y0 := 25;
    BigText[1] := 'THE DIRECTORY YOU ';
    BigText[2] := 'HAVE ENTERED:';
    BigText[3] :=  dirnam;
    BigText[4] := 'DOES NOT EXIST.';
    BigText[5] := '';
    BigText[6] := 'PLEASE ENTER';
    BigText[7] := 'A NEW FILENAME';
    BigText[8] := ' Press any key ';
    ShowMessage(8, Y0, False, False);
  End;

Procedure SayNoSubDir(dirnam: String);
   { 8-13-96 DL }
  Begin
    ShowNoSubDir(dirnam);
    talkstring := 'The directory you have entered,';
    talkit101(talkstring);
    SpellOut(dirnam);
    talkstring := ', does not exist.'
    + ' Please enter another file name.';
    talkit101(talkstring);
    Talkit101('Press any key to continue.');
    hold(True);
  End; {SayIllegalFileName}

Procedure CheckLogDrive(drvltr: Char);
  { DL 8-96 }
  Var
    ntries: Byte;
    rdy: Boolean;
    
  Begin
    ntries := 0;
    rdy := CheckDriveReddy(drvltr);
    If Not rdy Then
    Begin
      If drvltr In ['A','B'] Then
        Repeat
          TellPutInFloppy(drvltr, ntries);
          { ignore escapes }
          If Escape Then Escape := False;
          rdy := CheckDriveReddy(drvltr);
        Until ((ntries = 6) Or (rdy))
    End;
    If Not rdy Then TellDriveDied(drvltr);
  End;


{  AskAppend                                                                }
{  (was GetFileAction)     Decides whether to append an existing            }
{                          file, or to enter a new filename.                }


Function AskAppend: Char;
  { original by RMM ca. 1993. Renamed by DL 8-96 }
  Const
    goodset: CharSet= [#27,'E', 'A'];
    
  Var
    ans: Char;
    OKans, ExtCode: Boolean;
    
  Begin
    Repeat
      Repeat Until KeyPressed;
      ans := ReadKey;
      ans := UpCase(ans);
      { check for valid key and extended codes DL 7/96 }
      CheckKeyOK(ans, goodset, OKans, ExtCode);
      ShowKeyboardChar(ans, ExtCode);
      SpeakKeyboardChar3(ans, ExtCode);
      
      If Not OKans Then
      Begin
        Beep(2093, 30, 1);
        If TalkReddy Then
        Begin
          talkstring := 'In valid answer. Please try again. ';
          talkstring := talkstring + ' Enter  ay.  E . or escape. ';
          talkit101(talkstring);
        End;
      End;
      
    Until OKans;
    AskAppend := ans;
  End; { AskAppend }


{  GetLogFileName2       Get the name of the file to which the user wants  }
{                        to save the balance readings.                     }

Procedure GetLogFileName2;

  Begin
    EraseBalText;
    SetCharSize(3,2,3,2);
    OutTextXY(30, 20,'FILE TO WRITE BALANCE ');
    OutTextXY(30, 70,'READINGS TO ? ');
    talkstring := 'Enter name of file to rite balance reedings to.';
    talkit101(talkstring);
    { call
    GetStrang5(X0, Y0: Word; Var strang: String;
    maxlen, maxlines, DY: byte; filenamechars: Boolean); }
    GetStrang5(30, 120, LogFileName, 15, 4, 50, True);
    EatBlanks(LogFileName); { EatBlanks added 8-9-96 DL }
    AllCaps(LogFileName);
  End; {GetLogFileName2}


{  GetUserName           Get the name of the user.                         }

Procedure GetUserName(Var Name, first: String);

  Var
    ans: Char;
    
  Begin
    EraseBalText;
    SetCharSize(3,2,3,2);
    OutTextXY(30, 100,'YOUR NAME?');
    talkstring := 'Please enter your name.  ';
    talkit101(talkstring);
    { call
    GetStrang4(X0, Y0: Word; Var strang: String;
    maxlen, maxlines, DY: byte; filenamechars: Boolean); }
    getstrang5(30, 200, Name, 17, 3, 40, False);
    FixName(username, firstname);
    talkit101('Thank you, '  + firstname + '.');
    EraseBalText;
  End; {GetUserName}


Procedure WriteFileHeader2;
 { code removed from AskLogFile to shorten it DL 8-9-96}
  Var
    yr, mo, Day, daywk: Word;
    ntries: Byte;
    
  Begin
    GetUserName(username, firstname);
    GetDate(yr, mo, Day, daywk);
    { check for drive not ready }
    CheckLogDrive(LogDriveLetter);
    If appendit  Then
    Begin
      Assign(logfile, LogFileName);
      Append(logfile);
      { write a couple of blank lines }
      WriteLn(logfile);
      WriteLn(logfile);
    End
    Else
    Begin
      Assign(logfile, LogFileName);
      Rewrite(LogFile);
    End;
    WriteLn(logfile);
    Write(logfile, 'Balance Readings from Ohaus Balance. ');
    WriteLn(logfile, ' ROM Version: ', ROMVersion);
    Write(logfile,'Experimenter''s name: ', username, '     Date: ');
    WriteLn(logfile,mo:2,'/',Day:2,'/',yr:4,' ');       {JMJ13195}
    WriteLn(logfile);
    WriteLn(logfile, '  Time         Mass              Label ');
    WriteLn(logfile);
    Close(logfile);
  End; { WriteFileHeader }

Procedure GetLegalLogFileName;
    { added by DL 8-96, 9-96. stringent error checking
      prevents entry of illegal file names. }
  Var
    FileAction: Char;
    drvltr: Char;
    DirName, FName, Ext, OldName: String;
    NoExt, fixed, hopeless, DriveReddy, IllegalName, OkayDir, InCurDir,
    FileExists, TooLong, NoName, NameOK, HunkyDory: Boolean;
    ntries: Byte;
    { if HunkyDory = TRUE then EVERYTHING is OK }
  Begin
    Repeat
      HunkyDory := True;
      Escape := False;
      loggit := False;
      appendit := False;
      Repeat
        GetLogFileName2;
        { call
        FixUpFileName(Var fulnam: String; Var fixed,
        NoExt, NoFileName, hopeless: Boolean);}
        OldName := LogFileName;
        FixUpFileName(LogFileName, fixed, NoExt, NoName, hopeless);
        
        If fixed Then
        Begin
          SayNameFixed(OldName);
          If Escape Then Exit;
        End
        Else
        Begin
          If NoName Then SayNoFileName;
          If Escape Then Exit;
        End;
        
        { call
        CheckPath2(fullname: String; Var drvltr: Char;
        Var DirName, FName, Ext: String; Var DriveReddy, IllegalName,
        OkayDir, InCurDir, FileExists: Boolean);
        this routine checks EVERYTHING. }
        
        CheckPath2(LogFileName, drvltr, DirName, FName, Ext, DriveReddy,
        IllegalName, OkayDir, InCurDir, FileExists);
        SayVerifyFileName(NameOK);
        If Escape Then Exit;
        NoName := Not NameOK;
      Until Not NoName;
      OldName := LogFileName;
      CheckNameLength(OldName, LogFileName, TooLong);
      If TooLong Then SayTooLong(OldName);
      If Escape Then Exit;
      { first, take care of illegal names }
      If IllegalName Then
      Begin
        SayIllegalName(FName);
        If Escape Then Exit;
        HunkyDory := False;
      End;
      { then catch drive not ready }
      If ((Not DriveReddy) And (drvltr In ['A', 'B'])) Then
      Begin
        ntries := 0;
        Repeat
          TellPutInFloppy(drvltr, ntries);
          If Escape Then Exit;
          DriveReddy := CheckDriveReddy(drvltr);
        Until ((ntries = 3) Or (DriveReddy));
      End;
      If Not DriveReddy Then
      Begin
        HunkyDory := False;
        TellDriveNotValid(drvltr);
        If Escape Then Exit;
      End
      Else
      Begin  { 1 drive ready loop }
        If Not IllegalName Then
        Begin  { 2 legal name loop }
          { then catch no subdir }
          If Not OkayDir Then
          Begin
            SayNoSubDir(DirName);
            If Escape Then Exit;
            HunkyDory := False;
          End
          Else
          Begin  { 3 no subdirectory loop }
            { then catch existing file }
            If FileExists Then
            Begin  { 4 file exists loop }
              If Not ((WritableFile(LogFileName))
                 And (CheckTextFile(LogFileName)))
              Then
              Begin
                SayReadOnly;
                If Escape Then Exit;
                HunkyDory := False;
              End
              Else
              Begin
                SayFileExists2;
                HunkyDory := False;
                FileAction := AskAppend;
                Case FileAction Of
                  'A': Appendit := True;
                  #27: Escape := True;
                End;
                If Appendit Then HunkyDory := True;
              End;
            End  { 4 file exists loop }
            Else
              { check for read-only drives }
              If CantOpenOutFile(LogFileName) Then
              Begin
                HunkyDory := False;
                SayReadOnlyDrive(drvltr);
                If Escape Then Exit;
              End;
          End;  { 3 no subdir loop }
        End;  { 2 legal name loop }
      End;   { 1 drive reddy loop }
    Until ((HunkyDory) Or (Escape));
    If Escape Then Exit;
    loggit := HunkyDory;
    talkit101('Reedings will be saved in file ');
    spellout(LogFileName);
    { assign global drive letter }
    LogDriveLetter := drvltr;
    WriteFileHeader2;
  End;

{  AskLogData            Ask the user if balance readings should be        }
{                        written to a file.                                }

Procedure AskLogData;
  { original by RMM ca. 1993. }
  { ESCAPE added by JMJ. }
  { was AskLogFile; broken into smaller parts DL 8-13-96 }

  Const
    goodset: CharSet = [#27, 'Y', 'N'];
    
  Var
    i: Integer;
    ans, FileAction: Char;
    ExtCode, OKans: Boolean;
    
  Begin
    Escape := False;
    
    EraseBalText;
    
    SetCharSize(3,2,3,2);
    OutTextXY(30,50,'WRITE BALANCE READINGS ');
    OutTextXY(30,100,'TO A FILE (Y/N/ESC)? ');
    talkstring := 'Write Balance Reedings to a File ? ';
    talkit101(talkstring);
    talkstring := 'Press wye for yes, enn for no,';
    talkstring := talkstring + 'escape to return to main men-yoo.'; {JMJ51595}
    talkit101(talkstring);
    Repeat
      Repeat Until KeyPressed;
      ans := UpCase(ReadKey);
      { check for valid key and extended codes DL 7/96 }
      CheckKeyOK(ans, goodset, OKans, ExtCode);
      ShowKeyboardChar(ans, ExtCode);
      SpeakKeyboardChar3(ans, ExtCode);
      If Not OKans
      Then
      Begin
        Beep(2093, 30, 1);
        If TalkReddy Then
        Begin
          talkstring := 'In-valid key... Press wye for yes, enn for no, ';
          talkstring := talkstring + 'escape to return to main men-yoo.';
          talkit101(talkstring);
        End;
      End;
      
    Until OKans;
    If ans = ESC Then
    Begin
      Escape := True;
      Exit;
    End;
    If ans = 'N' Then loggit := False Else If ans = 'Y' Then loggit := True;
    If Not loggit Then
    Begin
      EraseBalText;
      Exit;
    End
    Else GetLegalLogFileName;
  End;


{  AskReadFile           Ask the user if balance readings saved to a file  }
{                        should be spoken back.                            }

Procedure AskReadFile;
{ original by DL ca. 1994 }
{ modified for extended codes 7-96 DL }
  Const
    goodset: CharSet= ['Y', 'N'];
    
  Var
    i: Integer;
    ans: Char;
    ExtCode, OKans: Boolean;
    
  Begin
    EraseBalText;
    If KeyPressed Then FlushKeyBoardBuffer;
    SetCharSize(3,2,3,2);
    OutTextXY(30,50,'SPEAK BALANCE READINGS ');
    OutTextXY(30,100,'FROM THE FILE (Y/N)? ');
    talkstring := 'Speak balance reedings from the file ? ';
    talkit101(talkstring);
    talkstring := 'Press wye for yes, enn for no.';
    talkit101(talkstring);
    Repeat
      Repeat Until KeyPressed;
      ans := UpCase(ReadKey);
      { check for valid key and extended codes DL 7/96 }
      CheckKeyOK(ans, goodset, OKans, ExtCode);
      ShowKeyboardChar(ans, ExtCode);
      SpeakKeyboardChar3(ans, ExtCode);
      If Not OKans Then
      Begin
        Beep(2093, 30, 1);
        If TalkReddy Then
          talkit101('In-valid key... Press wye for yes, enn for no.');
      End;
    Until OKans;
    If ans = 'N' Then readit := False Else readit := True;
    EraseBalText;
    
  End; {AskReadFile}


Procedure ShowSignOn;
  { added on Mole Day '96 by dl }
  Var
    i, Y0: Word;
    
  Begin
    Y0 := 100;
    For i := 1 To 8 Do BigText[i]  := '';
    BigText[1] := '    TALKING BALANCE 1,';
    BigText[3] := '    A PROGRAM TO READ';
    BigText[5] := '     OHAUS BALANCES';
    ShowMessage(8, Y0, False, False);
  End;

{  InitBalText           Initialize graphics, set background color, line   }
{                        color and type. Draw rectangle border and set the }
{                        font.                                             }

Procedure InitBalText2;
{ orig. by RMM, modified by JMJ.}
{ modified to save MaxX and MaxY as global vars rather than
  calling the functions GetMaxX and GetMaxY repeatedly DL 8-96 }
  Begin
    SaveGraphics;
    InitializeGraf;
    SetBkColor(Black);
    SetColor(White);
    SetLineStyle(LineStyle, 0, Thickness);
    MaxX :=  GetMaxX;
    MaxY :=  GetMaxY;
    Rectangle(1, 1, MaxX, MaxY);
    SetTextStyle(TriplexFont, HorizDir,4);
  End; {InitBalText}


{  ShowInstructions      Write instructions on how to operate balance to   }
{                        the screen.                                       }

Procedure ShowInstructions;
  { original by RMM ca. 1993. modified by DL 8-96
    to simplify specification of char lcations. }
  Var
    dum: Char;
    X, Y, DY: Word;
    
  Begin
    EraseBalText;
    SetCharSize(3,2,3,2);
    dy := 63;
    Y := 10;
    X := 30;
    OutTextXY(X,Y ,'    INSTRUCTIONS');
    Y := Y + DY;
    OutTextXY(X,Y,'PRESS THE SPACE BAR ');
    Y := Y + DY;
    OutTextXY(X,Y,'TWICE TO ZERO BALANCE.');
    Y := Y + DY;
    OutTextXY(X,Y,'PRESS THE SPACE BAR ');
    Y := Y + DY;
    OutTextXY(X,Y,'ONCE TO READ BALANCE.');
    Y := Y + DY;
    OutTextXY(X,Y,'PRESS ESCAPE FOR MAIN.');
    Y := Y + DY;
    OutTextXY(X,Y,'PRESS H FOR HELP.');
    
  End; {ShowInstructions}


{  SayInstructions       Speak instructions on how to operate the balance. }

Procedure SayInstructions;
   { original by RMM ca. 1993. }
  Begin
    If numredes = 0 Then talkit101('When I say,  Ready  to  reed. ');
    talkstring := '   Press the space bar twice to zee-ro the balance.';
    talkit101(talkstring);
    talkstring := '   Press the space bar once to reed the balance.';
    talkit101(talkstring);
    talkstring := '   Press Escape to return to the Main men-yoo.';
    talkit101(talkstring);
    talkstring := '   Press H for these instructions. ';
    talkit101(talkstring);
  End; {SayInstructions}


{  GetCommand3           Process users response. Allow user to press Enter,}
{                        Q for Quit, H for Instructions, or SpaceBar to    }
{                        start reading the balance.                        }


Procedure GetCommand3(Var Command: Char);
  { original by RMM and DL ca. 1993. }

  { modified by DL 8-96 to echo keys and repeat
    SayInstructions if an invalid key is pressed. }
  Const
    GoodSet: CharSet = [#32, 'H', #27];
    
  Var
    i, numspaces: Integer;
    hr, Min, s, s100: Word;
    DT, tdelay, realt1, realt2: Real;
    dum, inkey: Char;
    ExtCode, OKinkey: Boolean;
    
  Begin
    tdelay := 1.0;   { delay in s }
    Repeat
      Repeat Until KeyPressed;
      inkey := UpCase(ReadKey);
      
      { check for valid key and extended codes DL 7/96 }
      CheckKeyOK(inkey, goodset, OKinkey, ExtCode);
      ShowKeyboardChar(inkey, ExtCode);
      If inkey <> SP Then
        SpeakKeyboardChar3(inkey, ExtCode)
      Else If Flushable Then FlushTalkBuffer(FlushDelay);
      { flush synth buffer added dl 10-96 }
      
      If Not OKinkey Then
      Begin
        Beep(2093, 30, 1);
        
        If TalkReddy Then
        Begin
          talkit101('In-valid key. Please try again.');
          SayInstructions;
        End;
      End;
      
    Until OKinkey;
    EraseBalText;
    If inkey = 'H' Then
    Begin
      Command := 'H';
      Exit;
    End;
    { check for Escape }
    If inkey = ESC Then Escape := True
    Else
      { look for second space }
    Begin
      command := 'P';
      GetTime(hr, Min, s, s100);
      realt1 :=  1.0*s + 0.01*s100;
      Repeat
        Delay(10);
        GetTime(hr, Min, s, s100);
        realt2 :=  1.0*s + 0.01*s100;
        DT :=   realt2 - realt1;
        If KeyPressed Then
        Begin
          inkey := ReadKey;
          { handle two-byte codes DL 7/96 }
          If Ord(inkey) = 0 Then dum := ReadKey;
          If inkey = SP Then command := 'T';
        End;
      Until ((KeyPressed) Or (DT > tdelay));
    End;
  End; { GetCommand3 }


{  SayUnstable           Informs user that the balance reading is not      }
{                        stable.                                           }

Procedure SayUnstable;
  Begin
    talkstring := 'Balance reeding is not staybul';
    talkit101(talkstring);
  End; {SayUnstable}

Procedure SayBalError;
  Begin
    talkstring := 'Error in balance reeding. Check for overload.';
    talkit101(talkstring);
  End;

{  ProcessResponse       Process the response from the balance. If '?' is  }
{                        found in the balance string then the reading is   }
{                        unstable otherwise it is Ok. Determine the mass,  }
{                        units, and stability. Updated for milligram       }
{                        balance on 2-18-95 by JMJ. Field lengths had      }
{                        been changed by the manufacturer from the cg. to  }
{                        the mg. balance. Major changes include the an     }
{                        increas in the number of mass digits sent from    }
{                        the balance, as well as an increase in the number }
{                        of spaces occupied by the mode - from 3 to 5.     }

Procedure ProcessResponse3(Var BalString: String);
 { flexible data string length introduced 7-31-96 DL }

    { CENTIGRAM BALANCE }
    { Balance String Format                                  }
    { Field              Length        Start Pos    End Pos  }
    {                                                        }
    { Polarity              1              1           1     }
    { Mass (inc. decimal)   6              2           7     }
    { unused                1              8           8     }
    { Units (mode)          3              9          11     }
    { Stability             1             12          12     }
    { Carriage Return       1             13          13     }
    { Line Feed             1             14          14     } {JMJ 5-23-95}


    { newer CT balances have minus sign in front of first
      non-zero digit instead of being fixed in in pos 1.
      modified to accomodate this change  dl 3-24-97 }

    { MILLIGRAM BALANCE                                      }
    { Balance String Format                                  }
    { Field              Length        Start Pos    End Pos  }
    {                                                        }
    { Polarity              1              1           1     }
    { Mass (inc. decimal)   8              2           9     }
    { unused                1             10          10     }
    { Units (mode)          5             11          15     }
    { Stability             1             16          16     } {JMJ 2-18-95}


  Const
    numset: CharSet= ['0'..'9', '.', ' '];
    { includes blank to catch blanks in mass display }
    
  Var
    errorcode: Integer;
    ans: Char;
    i, k, Len, Ltail: Byte;
    tail: String;
    
  Begin { ProcessResponse2 }
    
    { if '?' is found anywhere in string then reading must be
    unstable, otherwise it is not }
    
    If Pos('?', BalString) > 0 Then unstable := True
    Else unstable := False;
    
    { Begin code to detect balance error condition added by MMG 5-13-96 }
    { if 'Err' is found in BalString, the balance is in an error condition }
    If Pos('Err', BalString) > 0 Then BalError := True
    Else BalError := False;
    If BalError Then
    Begin
      SayBalError;
      unstable := True; { treat error same as unstable rdg: display ????. DL}
      Exit;
    End;
    { End code added 5-13-96 by MMG }
    { inform user if reading is unstable }
    If unstable Then
    Begin
      SayUnstable;
      Exit;
    End;
    
    { new code 3-24-97 dl; trim leading blanks down to sign
    or first digit }
    TrimFirstBlanks(BalString);
    
    { determine polarity, 1 char starting at position 1 }
    polarity := Copy(BalString, 1, 1);
    
    If ((polarity = '-') Or (polarity = '+'))  Then k := 2
    Else
    Begin
      k := 1;
      polarity := '';
    End;
    
    Len := Length(BalString);
    
    { new code DL 7-96 copies all numeric chars and blanks after pos. 1 }
    
    mass := '';
    
    While BalString[k] In numset Do
    Begin
      mass := mass + BalString[k];
      k := k + 1;
    End;
    
    EatBlanks(mass);
    
    tail := Copy(BalString, k, len - k + 1);
    Ltail := Length(tail);
    { units are the tail minus last char DL }
    units := tail;
    Delete(units, Ltail, 1);
    
    EatBlanks(units);
    AllCaps(units);
    
    { end new code DL 7-31-96 }
    If Pos('G', units) > 0  Then units := 'g';
    
  End; { ProcessResponse2 }


{  DisplayBalReading2     Display the balance reading to the screen as well}
{                         as speaking it. Prompt user to press any key to  }
{                         continue. (Was DisplayBalanceReading)            }

Procedure DisplayBalReading2;
  { modified to center the display (approx)
    and use smaller chars for long strings DL 7-96, 8-96 }

  Var
    ans: Char;
    bigstg: String;
    xpos: Word;
    Lstg: Byte;
    
  Begin
    EraseBalText;
    
    { if rdg is unstable or there is a balance error (e.g. overload)
    variables mass, polarity, and units are not defined for the
    current rdg. DL 8-4-96 }
    
    If unstable Then bigstg := '? ? ? ?'
    Else bigstg := polarity + mass + ' ' + units;
    
    Lstg := Length(bigstg);
    
    SetCharSize(3,2,3,2);
    OutTextXY(15,50,'THE BALANCE READING IS');
    { horiz size reduced to get six digits + units on the
    screen, and vert size increased  DL 7-96 }
    { wider chars used for shorter strings DL 8-3-96 }
    { was SetUserCharSize(3,1,5,1) }
    If Lstg > 10 Then
    Begin
      xpos := 8 + 15*(15-Lstg);
      SetCharSize(5,2,7,1);
    End
    Else
    Begin
      xpos := 8 + 17*(10-Lstg);
      SetCharSize(13,4,7,1);
    End;
    
    OutTextXY(xpos, 85, bigstg);
    
    If Not unstable Then      { if statement reorganized 9/19/95 MMG }
    Begin
      If polarity = '-' Then talkstring := 'mynuss' Else talkstring := '';
      talkstring := talkstring + ', ' + MakeMassTalkString(mass) + ', ' +
      MakeUnitTalkString(units);
      talkit101(talkstring);
    End;
    SetCharSize(3,2,3,2);
    OutTextXY(20,375,'PRESS ANY KEY.');
    talkstring := 'Press any key to continue.';
    talkit101(talkstring);
    hold(False);
    EraseBalText;
  End; { DisplayBalanceReading }


{  GetComment            Get label for balance readings from user.         }

Procedure GetComment(Var comment: String);
  Var
    answer, dum: Char;
    
  Begin
    EraseBalText;
    SetCharSize(3,2,3,2);
    comment := '';
    OutTextXY(30, 50, 'Label for balance reading: ');
    talkstring := 'Please enter a laybel for balance reeding.';
    talkit101(talkstring);
    { call
    GetStrang4(X0, Y0: Word; Var strang: String;
    maxlen, maxlines, DY: byte; filenamechars: Boolean); }
    GetStrang5(30, 125, comment, 18, 4, 75, False);
    { replaces 11 lines of }
    { Jason's code MMG 9/21/95 }
    EraseBalText;
  End; { GetComment }



Procedure MakeTimeString(t: Word; Var tstg: String2);
  { added by dl 11-12-96 }
  Begin
    If t < 10 Then
    Begin
      Str(t:1, tstg);
      tstg := '0' + tstg;
    End
    Else Str(t:2, tstg);
  End;



{  AddData2              Appends or Adds data to file specified by user.   }
{                        Added by Jason Johnson on 5/15/95                 }

Procedure AddData3;
 { slightly modified and renamed. now writes
   polarity and mass as a single string to improve alignment
   of text in the log file DL 8-96 }
 { also checks for drive not ready DL 8-14-96 }
 { improved format of time dl 11-12-96 }

  Var
    comment : String;
    DriveReddy: Boolean;
    massstg: String;
    ntries: Byte;
    hrstg, minstg, secstg: String[2];
    
  Begin
    massstg := polarity + mass;
    GetComment(comment);
    { check for drive not ready }
    CheckLogDrive(LogDriveLetter);
    Append(logfile);
    MakeTimeString(hr, hrstg);
    MakeTimeString(Min, minstg);
    MakeTimeString(s, secstg);
    Write(logfile, hrstg:2, ':', minstg:2,':',secstg:2);
    WriteLn(logfile, massstg:12, ' ', units, '     ',   comment);
    Close(logfile);
  End; {Add Data}


{  ReadBalance2          Read the balance by processing user's response,   }
{                        sending and reading data to and from the balance, }
{                        processing the balance string, logging the data   }
{                        if needed, and displaying to the user.            }


Procedure ReadBalance2;
{ modified to do 3 reads to empty buffer of Ohaus  TP200 balance. }
{ traps for timeouts added all over the place DL 7/23/96 thru 7/25/96 }

  Var
    Command: Char;
    InString: String;
    i: Byte;
    
  Begin
    talkit101('Ready to reed.');
    GetCommand3(Command);
    If Escape Then Exit;
    If Command = 'H' Then
    Begin
      ShowInstructions;                                { added 9/19/95 MMG }
      SayInstructions;
      Exit;
    End;
    
    If Command = 'T' Then
    Begin
      talkit101('Setting balance to zee-ro.');
      SendALine2(PortNo, 'T', OutShake, outdelim);
      If Timeout Then TellBalNotOn;
    End;
    
    If  (command = 'P') Then
    Begin
      For i := 1 To 3 Do  { do 3 reads to empty buffer }
      Begin
        SendALine2(PortNo, 'P', OutShake, outdelim);
        ReadALine4(PortNo, InString, InShake, indelim);
        GetTime(hr,Min,s,s100);
        { code added to catch timeouts 7-96 DL }
        If Timeout Then TellBalNotOn;
        If InputError[PortNo] Then TellInputError;
      End;
      ProcessResponse3(InString);
      DisplayBalReading2;
      If ((Not unstable) And (loggit)) Then AddData3;
    End;
  End; { ReadBalance }


Procedure SpeakTime(timestg: String);
  { added by dl 11-12-96 }
  Var
    hrstg, minstg, secstg: String[2];
    outstg: String;
  Begin
    hrstg := Copy(timestg, 1, 2);
    minstg := Copy(timestg, 4, 2);
    secstg := Copy(timestg, 6, 2);
    outstg := hrstg + ' hours, '+ minstg + ' minutes, '+ secstg + ' seconds.';
    talkit101(outstg);
  End;



{  ReadBalFile2           Reads data file                                   }

Procedure ReadBalFile2;
  { written by DL ca. 1993 }
  { added ability to spell out data string and to speak time
    more intelligibly dl 11-12-96 }
  Var
    dumstg, timestg, numstg, labelstg: String;
    len: Byte;
    
  Begin
    Assign(datfile, LogFileName);
    Reset(datfile);
    talkit101('Reeding data from file. ');
    spellout(LogFileName);
    While Not EoF(datfile) Do
    Begin
      ReadLn(datfile, dumstg);
      { skip empty lines }
      If Length(dumstg) > 0 Then
      Begin
        { add a period before speaking, for pause between lines }
        talkit101('.');
        TrimFirstBlanks(dumstg);
        len := Length(dumstg);
        timestg := Copy(dumstg, 1, 8);
        If CharCount(':', timestg) = 2 Then
        Begin
          SpeakTime(timestg);
          numstg := Copy(dumstg, 10, 15);
          TrimFirstBlanks(numstg);
          TrimLastBlanks(numstg);
          Talkit101(MakeMassTalkString(numstg));
          labelstg := Copy(dumstg, 26, len-25);
          Talkit101(labelstg);
        End
        Else Talkit101(dumstg);
      End;
    End;
    Close(datfile);
    talkit101('End of data file.');
    spellout(LogFileName);
  End;  {ReadBalFile}



{  EndProgram2           This procedure was written so that the several    }
{                        things could be done before the program halts.    }
{                        Added by Jason Johnson on 5/15/95                 }
{                        (renamed 7-25-96 DL)                              }

Procedure EndProgram2;

  Begin
    If TalkReddy Then { skip code with no visual display }
    Begin             { if there is no speech. DL 7-96 }
      If loggit Then
      Begin
        tellsaved;
        AskReadFile;
        If readit Then ReadBalFile2;
      End;
      talkstring := 'This ends the balance program.';
      talkit101(talkstring);
      talkstring := 'Press any key to exit.';
      talkit101(talkstring);
      hold(False);
    End;
    FixScreen;
    If TalkToPort Then
    Begin
      If Accent Then ResetAccent; { reset Accent to factory defaults }
      Close(talkdev);             { added by dl 10-28-96 }
    End;
    WriteLn('             Copyright 1992-1997, East Carolina University.');
    ShowOrSayNoWarranty(False);
    Halt(1);
  End;  {End Program}

{  StartProgram          This procedure was written so that an escape      }
{                        sequence could be utilized to back a user out of  }
{                        any part of the program. It seemed as though at   }
{                        times one could get stuck and have difficulties   }
{                        returning to the main menu.                       }
{                        Added by Jason Johnson 5/15/95                    }

Procedure StartProgram2;

  Begin
    IntroBalance;
    If quit Then EndProgram2;
    AskLogData;
    If Escape Then
    Begin
      Escape := False;
      StartProgram2;
    End;
    ShowInstructions;
    SayInstructions;
    Repeat
      If numredes > 0 Then ShowInstructions;
      ReadBalance2;
      If quit Then
      Begin
        FixScreen;
        Halt(1);
      End;
      numredes := numredes + 1;
    Until Escape;
    StartProgram2;
    
  End;  {StartProgram}

{                         M A I N    P R O G R A M                         }

Begin
  GetSynthParam2;
  StringInput := False;
  Flushit := Flushable;  { flush speech buffer if possible }
  loggit := False;
  Nowrites := False;
  quit := False;
  BalanceSetup := False;
  numredes := 0;
  GrafOpen := False;
  OldKey := ' ';
  readmefile := 'README.BAL';
  InitBalPort2;
  InitBalTalk(BalPortName);  { Initializes the speech device }
  InitBalText2;
  Nowrites := True;
  GrafOpen := True;
  talkstring := 'Talking Balance one, a program to reed Oh House Balances. ';  {JMJ52395}
  ShowSignOn;
  If Not SkipIt Then
  Begin
    If TalkReddy Then talkit101(talkstring) Else Delay(2000);
  End;
  If ((SkipIt) And (Flushable)) Then FlushTalkBuffer(FlushDelay);
  InitBalance;
  GetROMVersion;  { new DL 9-16-96 }
  StartProgram2;  {Starts the actual balance reading portion of program}
  
End.  {Main Program}

