/*
 *	xdistrans.c  --  xor display transformation function for edtrans().
 *
 *	9 july 1989  Olle Olsson.
 */

#include "edtrans.h"

void xdistrans( tp, ap )
transform *tp;		/* the transform */
area *ap;
{
#define NPT 6			/* number of points */
register int i, j;
double xt;
double x[NPT], y[NPT];		/* transformation corners */
int sxy[NPT * 2];		/* xorpolyline() x,y coordinates */

/* (xor-) display the the transform */

/* set corners (origin first and last) */
/*x[0] = x[3] = x[4] = ap -> xlow;
y[0] = y[1] = y[4] = ap -> ylow;
x[1] = x[2] = ap -> xlow + ap -> xlen;
y[2] = y[3] = ap -> ylow + ap -> ylen;
*/
x[0] = x[3] = x[4] = 0;
y[0] = y[1] = y[4] = 0;
x[1] = x[2] = 1;
y[2] = y[3] = 1;

/* mark the origin (and the direction of the x axis) with a fifth line */
x[5] = x[1] / 5;
y[5] = y[2] / 20;

/* do the transformation */
for (i = 0; i < NPT; ++i)
	{
	xt   = tp -> a11 * x[i] + tp -> a12 * y[i] + tp -> b1;
	y[i] = tp -> a21 * x[i] + tp -> a22 * y[i] + tp -> b2;
	x[i] = xt;
	}


/* find the screen coordinates (y is upside down) */
for (i = j = 0; i < NPT; ++i)
	{
	/* x */
	sxy[j++] = MAX_COL * (x[i] - ap -> xlow) / ap -> xlen;

	/* y */
	sxy[j++] = MAX_ROW * (1 - (y[i] - ap -> ylow) / ap -> ylen);
	}

/* draw it */
xorpolyline( NPT, sxy );

#undef NPT
}



