/*
 *	sbifeps.c  --  simple binary image file to postscript format.
 *
 *	5 sep 1989  Olle Olsson.
 */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
/*#include <conio.h>*/
#include <io.h>
#include <string.h>
#include <process.h>
#include <bios.h>
#include "sbif.h"


/* the functions */
void main( int argc, char *argv[] );
void beep( void );
void psbegin( int xsize, int ysize, int square_flag );
void psend( void );
void error( char *s, ... );
void warning( char *s, ... );
void usage( void );

static void usage( void )
{
fprintf( stderr, "Usage:\n" );
fprintf( stderr, "\tsbifps [options] sbif_file\n" );
fprintf( stderr, "Options are:\n" );
fprintf( stderr, "\t-o string\toutput file name\n" );
fprintf( stderr, "\t-b\t\tblack background\n" );
fprintf( stderr, "\t-s\t\tsquare image output (default: fill paper)\n" );
/*fprintf( stderr, "\t-i num\tindent amount (characters)\n" );*/
fprintf( stderr, "\n" );
}


void main( argc, argv )
int argc;
char *argv[];
{
FILE *inf;			/* data file */
int xlines, ylines;		/* x and y pixel count */
int xbytes;			/* x byte count */
int bbg;			/* flag for black background */
int square;			/* flag for square image output */
long nbytes;			/* total byte count */
/*int indent;			/* line indent amount */
int trace;			/* trace flag */
char datafile[100];		/* data file name */
char outfile[100];		/* output file name */
char *ap, **p;			/* argument pointers */
int i, c;			/* argument count */
char hbuf[SBHSIZE];		/* buffer for the sbif header */
char nbuf[100];			/* buffer for the name in the sbif header */
unsigned char obuf[32];		/* output conversion buffer */
register unsigned char *op;	/* output byte pointer */
register int n;			/* output dot count */

/* read arguments */
datafile[0] = outfile[0] = '\0';
square = bbg = 0;
trace = 0;
/*indent = 0;*/

for (p = argv + 1, c = 1; c < argc; ++c)
	{
	if (trace) printf( "%s:\n", *p );
	ap = *p++;

	if (*ap == '-')	for (i = 1; ap[i]; ++i) switch (ap[i])
		{
		case 'o':
			if (++c >= argc)
				error( "-o: output file name missing");

			if (outfile[0])
				error( "-o: too many output files" );

			strcpy( outfile, *p++ );
			continue;

/*		case 'i':	/* indent */
/*			if (++c >= argc)
				error( "-i: indent value missing");

			indent = atoi( *p++ );

			if (indent < 0)
				error( "-i: indent < 0" );

			continue;
*/
		case 'b':
			bbg++;
			continue;

		case 's':
			square++;
			continue;

		case 't':
			trace++;
			continue;

		default:
			usage();
			error( "don't understand flag '-%c'", ap[i] );
		}
	else if (!datafile[0])
		{
		strcpy( datafile, ap );
		}
	else
		{
		usage();
		error( "too many data files specified" );
		}
	}

/* open the data file */
if (!datafile[0])
	error( "No SBIF data file specified" );

if ((inf = fopen( datafile, "rb" )) == NULL)
	error( "Can't open input file '%s'", datafile );

/* write to stdout or a named file? */
if (outfile[0])
	if (freopen( outfile, "w", stdout ) == NULL)
		error( "Can't create output file '%s'", outfile );

/* read the header */
if (fread( hbuf, sizeof( hbuf ), 1, inf ) < 1)
	error( "premature end of file '%s'", datafile );

/* read the sizes */
xlines = ylines = 0;
sscanf( hbuf, "%s %d %d", nbuf, &xlines, &ylines );
xbytes = XBYTES( xlines );

/* use full bytes */
xlines = xbytes * 8;

if (trace) fprintf( stderr, "%s x:%d y:%d  xbytes:%d\n",
			 nbuf, xlines, ylines, xbytes );

if (xlines <= 0 || ylines <= 0)
	error( "don't understand contents of file '%s'", datafile );

/* start output */
psbegin( xlines, ylines, square );

/* convert the picture */
for (nbytes = (long) xbytes * ylines; nbytes > 0;)
	{
	/* read one buffer full  (or the rest) */
	n = sizeof (obuf);
	if (n > nbytes) n = nbytes;

	if (fread( obuf, n, 1, inf ) < 1)
		{
		if (trace) fprintf( stderr, "%ld bytes missing ", nbytes );
		error( "premature end of file '%s'", datafile );
		}

	/* bump count */
	nbytes -= n;
	
	/* black background? */
	if (!bbg)
		{
		/* the ps image operator uses zero for black */
		/* invert to get a white background */
		for (op = &obuf[n]; --op >= obuf;)
			*op ^= 0xff;
		}
	
	/* print */
	for (op = obuf; n > 0; --n, ++op)
		printf( "%02x", *op );

	printf( "\n" );
	}

/* end */
psend();

/* ready */
exit( 0 );
}


void psbegin( x, y, square )
int x, y;	/* sizes */
int square;	/* flag */
{
/* print the prologue */
printf( "%%! IFS bit image\n\n" );
printf( "/picstr 256 string def      %% tmp storage \n\n" );

if (square)
	{
	/* unit is inch/72, an a4 standard paper is 598 by 842 */
	/* (in the U.S. I think the standard is 8 by 11 inches, 576 by 792) */
	printf( "50 200 translate            %% lower left corner\n" );
	printf( "500 500 scale               %% map to 500 points square\n\n" );
	}
else
	{
	/* fill the paper */
	printf( "10 10 translate               %% lower left corner\n" );
	printf( "580 810 scale                 %% map to fill the paper\n\n" );
	}

printf( "%d %d 1                     %% source data dimensions\n", x, y );
printf( "[%d 0 0 -%d 0 %d]           %% map to unit square (flip y)\n", x, y, y );
printf( "{                           %% procedure to read hex data\n" );
printf( "  currentfile picstr readhexstring pop\n" );
printf( "}\n" );
printf( "%% hex data  %d * %d * 1 / 4 = %ld digits\n", x, y, ((long) x * y) / 4 );
printf( "%% (don't put anything between the image operator and the hex data)\n" );
printf( "image\n\n" );
}

void psend( void )
{
int i;
/*
 * This is fix for x sizes that are not a multiple of 8.
 * The readhexstring command seems to want more characters than needed.
 * (Maybee the data must be a multiple of the "picstr" size?)
 * Hide some "white space" behind a comment for readhexstring.
 */
for (i = 0; i < 5; ++i)
	printf( "%% ffffffffffffffffffffffffffffffffffffffff\n" );
 

/* show it */
printf( "showpage\n" );
}



void error( s, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10 )
char *s;
int v1, v2, v3, v4, v5, v6, v7, v8, v9, v10;
{
fprintf( stderr, "\nError:" );
fprintf( stderr, s, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10 );
fprintf( stderr, "\n" );

exit( 2 );
}

void warning( s, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10 )
char *s;
int v1, v2, v3, v4, v5, v6, v7, v8, v9, v10;
{
fprintf( stderr, "\nWarning:" );
fprintf( stderr, s, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10 );
fprintf( stderr, "\n" );
}


