/*
 *	edprob.c  --  edit probabilities.
 *
 *	11 july 1989  Olle Olsson.
 */

#include <stdlib.h>		/* for atof() prototype */
#include <string.h>		/* for strlen() prototype */
#include "edtrans.h"

/* factor for increase/decrease value */
#define INCDEC_FACT 1.1

/* local variables */

static menudescr pmenu =		/* the menu */
	{
	"quit",
	"density",
	"equal", "=area",
	"Grp#+", "grp#-",
	"Prgrp+", "prgrp- ",
	"0.1", ".5",
	"+ ", "- "
	};

void edprob( ifsdes *dp )
{
int i;
struct gm_status gs;		/* mouse status */
transform *tpc;			/* current transform */
char *fv = " Pr: %.4f ";	/* value formatting */
char *fgv = " Grp %d: %.3f ";	/* group value formatting */
int dvx;			/* x position for value display */
int dgvx;			/* x position for group value */
int dgvy;			/* y position for group value */
double gpr;			/* group prob. */
transform *tp;			/* tmp */
char buf[100];			/* tmp */

/*
 * The sum of the probability values in the ifsdes struct (tp -> prob) is 1.
 * The value shown for a transform is relative to the group sum.
 */

/* normalize */
normprob( dp -> tp, dp -> size );

/* hide the mouse pointer */
gm_hide();

/* show the menu (the caller has removed its menu) */
setcolor( dp -> textcolor );
showmenu( &pmenu );

/* assume that the menu doesn't cover all of the top line */
sprintf( buf, fv, 0.0 );
dvx = MAX_COL - textwidth( buf );

/* the group value is shown below the menu line */
dgvy = textheight( buf );
sprintf( buf, fgv, dp -> maxgroup, 0.0 );
dgvx = MAX_COL - textwidth( buf );


gm_show();

for (tpc = 0;;)
	{
	switch (wbup(), getkey( &gs ))
		{
		case 'q':	/* quit */
			/* remove the menu */
			gm_hide();
			nomenu();
			gm_show();
			return;

		case 'd':	/* edit density */
			/* remove the menu and ask for a new value */
			gm_hide();
			nomenu();
			setcolor( dp -> textcolor );
			moveto( 0, 0 );
			sprintf( buf,
			 "Density %g (%ld iter; prev %.3g), new: ",
				dp -> density,
				DENS2ITER( dp -> density ),
				dp -> prrdens );

			gputs( buf );
			ggets( buf );

			/* there could be more checking here... */
			if (strlen( buf ) > 0)
				dp -> density = atof( buf );

			/* show the menu again */
			/* cheat a bit to avoid redrawing */
			showmenu( &pmenu );
			nomenu();		/* (clears the menu area) */
			showmenu( &pmenu );

			gm_show();
			break;

		case 'G':	/* increase group number */
			if (!tpc)
				break;

			/* wrap to zero if necessary */
			if (++tpc -> group > dp -> maxgroup)
				tpc -> group = 0;

			break;

		case 'g':	/* decrease group number */
			if (!tpc)
				break;

			/* wrap backwards from zero if necessary */
			if (--tpc -> group < 0)
				tpc -> group = dp -> maxgroup;

			break;

		case 'P':	/* increase group probability */
			if (!tpc)
				break;

			/* increase all members of the group */
			for (tp = dp -> tp, i = dp -> size; i > 0; ++tp, --i)
				if (tp -> group == tpc -> group)
					tp -> prob *= INCDEC_FACT;

			/* normalize */
			normprob( dp -> tp, dp -> size );

			break;

		case 'p':	/* decrease group probability */
			if (!tpc)
				break;

			/* decrease all members of the group */
			for (tp = dp -> tp, i = dp -> size; i > 0; ++tp, --i)
				if (tp -> group == tpc -> group)
					tp -> prob /= INCDEC_FACT;

			/* normalize */
			normprob( dp -> tp, dp -> size );

			break;

		case '+':	/* increase */
			if (!tpc)
				break;

			/* get group prob. */
			gpr = grprob( dp -> tp, dp -> size, tpc -> group );

			tpc -> prob *= INCDEC_FACT;

			/* if it was zero it still is zero, check! */
			if (tpc -> prob < MINPROB)
				tpc -> prob = MINPROB;

			/* normalize group */
			normgprob( dp -> tp, dp -> size, tpc -> group, gpr );

			break;

		case '-':	/* decrease */
			if (!tpc)
				break;

			/* get group prob. */
			gpr = grprob( dp -> tp, dp -> size, tpc -> group );

			tpc -> prob /= INCDEC_FACT;

			/* not too small */
			if (tpc -> prob < MINPROB)
				tpc -> prob = MINPROB;

			/* normalize group */
			normgprob( dp -> tp, dp -> size, tpc -> group, gpr );

			break;

		case '0':	/* 0.1 */
			if (!tpc)
				break;

			/* get group prob. */
			gpr = grprob( dp -> tp, dp -> size, tpc -> group );

			/* make it .1 (within group) after normalization */
			tpc -> prob = (gpr - tpc -> prob) / 9;

			/* normalize group */
			normgprob( dp -> tp, dp -> size, tpc -> group, gpr );

			break;

		case '.':	/* .5 */
			if (!tpc)
				break;

			/* get group prob. */
			gpr = grprob( dp -> tp, dp -> size, tpc -> group );

			/* make it .5 (within group) after normalization */
			tpc -> prob = gpr - tpc -> prob;

			/* normalize group */
			normgprob( dp -> tp, dp -> size, tpc -> group, gpr );

			break;

		case 'e':	/* equal values */
			for (tp = dp -> tp, i = dp -> size; i > 0; ++tp, --i)
				tp -> prob = 1.0 / dp -> size;

			break;

		case '=':	/* normalize (area proportional) */
			for (tp = dp -> tp, i = dp -> size; i > 0; ++tp, --i)
				{
				tp -> prob = dett( tp );

				/* not too small */
				if (tp -> prob < MINPROB)
					tp -> prob = MINPROB;
				}

			/* normalize */
			normprob( dp -> tp, dp -> size );

			break;

		case 0:		/* a mouse button */

			/* a transform is selected, find out which one! */
			i = findtrans( dp -> tp, dp -> size, &dp -> area,
						 gs.gm_xpos, gs.gm_ypos );

			/* found it? */
			if (i < 0)
				break;	/* no */

			/* set the pointer for current transform */
			tpc = dp -> tp + i;

			break;

		default:	/* ?? */
			break;
		}

	/* show the value */
	if (tpc)
		{
		gm_hide();

		/* get group prob. */
		gpr = grprob( dp -> tp, dp -> size, tpc -> group );

		/* show the probability within the group */
		sprintf( buf, fv, (gpr > 0) ? tpc -> prob / gpr : 0 );
		moveto( dvx, 0 );
		gputs( buf );

		/* show the group number and probability */
		sprintf( buf, fgv, tpc -> group, gpr );
		moveto( dgvx, dgvy );
		gputs( buf );

		gm_show();
		}
	}
}

