/* $ vflat.h   12/07/99 21:03 $
 * Virtual Flat Frame Buffer. Revision 1.1
 *
 * Copyright (C) 1999  Dmitry Uvarov <mit@pc2o205a.pnpi.spb.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __VFLAT_H__
#define __VFLAT_H__

#include "vfdef.def"
#include "bool.h"

typedef enum {
   vferrOK = 0,
   vferrNoVBE,
   vferrDeviceNotSupported,
   vferrEmulationFailed,
   /* error codes can be returned during mode set */
   vferrErrorModeSet,     /* if VBE mode set call fails */
   vferrLFBNotSupported,  /* LFB not supported by this mode */
   vferrModeNotSupported, /* mode not avaible */
   } vfErrorCodes;

typedef struct {
   char *physbase;  /* physical address. Zero if software emulation active */
   char *linbase;   /* mapped linear address                               */
   word  mode;      /* current mode number */
   word  vendor_id; /* consist of device and vendor id if hardware avaible */
   word  device_id;
   word  maptype;   /* base address mapping type: vfSoftware, vfHardware or vfVBESupport
                     * Note! if maptype = vfVBESupport then linbase and physbase will
                     *       be defined only after mode set, and vendor_id and device_id
                     *       will be not defined at all.
                     */
   void *lfb_enable;/* pointer to LFB initialization procedure, that must be called
                     * after mode set. Defined only if hardware detection was forced
                     */
#ifdef __VF__SE__
 /* Additional VFlat Software Edition record */
   void *bankswitch;/* pointer to chipset specific bank switch code. Procedure
                     * takes bank number in dx register, and have no return instruction
                     * code end defined by MAGIC_ID = 0x11223344
                     */
#endif

   } vfStatus;

#define vfSoftware      1
#define vfHardware      2
#define vfVBESupport    3

#ifdef __VF__SE__
  /* additional definition for VFlat Software Edition         */
  /* Use this definition to force standart Int10 driver usage */
  #define vfUseStandartDriver  0x10
#endif

int   vfInit(int forcemode = vfVBESupport);  /* by default force VBE detection */
void  vfDone();
int   vfSetMode(word);
void  vfCloseMode();
void  vfReturnStatus(vfStatus *);

#endif // __VFLAT_H__