/*****************************************************************************
*   Program to draw EE diagrams on epson compatible printers.		     *
*									     *
* Written by:  Gershon Elber			IBM PC Ver 1.0,	Oct. 1989    *
*****************************************************************************/

#include <stdio.h>
#include <string.h>

#ifdef __MSDOS__
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <alloc.h>
#include <dir.h>
#endif /* __MSDOS__ */

#include "program.h"
#include "config.h"
#include "igraph.h"
#include "eelibs.h"
#include "eeredraw.h"
#include "eeload.h"

/* Undef DEBUG_MALLOC_TC20 iff you have TurboC 2.0. It assumes the offset    */
/* part of the pointer is always 8 which is TRUE only of TC 2.0.	     */
/* #define DEBUG_MALLOC_TC20  /* Add debugging aid for malloc/free routines. */

/* Clipping boundaries of current page size (A4 by default). */
int EEPageSizeX = PAGE_A4_XSIZE * PAGE_SCALER / 2,
    EEPageSizeY = PAGE_A4_YSIZE * PAGE_SCALER / 2;
DrawGenericStruct *EEDrawList = NULL;         /* All objects are saved here. */

#ifdef __MSDOS__
static char *VersionStr =
	"EEDEPSON IBMPC "
	EEDRAW_VERSION
	"	Gershon Elber,  "
	__DATE__ ",   " __TIME__ "\n"
	"(C) Copyright 1989 Gershon Elber, Non commercial use only.\n";
#else
static char *VersionStr =
	"EEDEPSON	Unix version 1.2	Gershon Elber,  \n\
	(C) Copyright 1990 Gershon Elber, Non commercial use only.\n";
#endif /* __MSDOS__ */

static char *UsageStr =
	"Usage: EEDEpson [-g] [-r] [-1] [-2] [-3] [-d] [-z] EEDrawFile.EED\n";
static char *LoadLibraryList = NULL;
static ConfigStruct SetUp[] =
{
    { "Libraries",	(VoidPtr) &LoadLibraryList,	SU_STRING_TYPE },
};
#define NUM_SET_UP	(sizeof(SetUp) / sizeof(ConfigStruct))

#ifdef __MSDOS__
extern unsigned int _stklen = 32766;	     /* Increase default stack size. */
#endif /* __MSDOS__ */

/*****************************************************************************
* Main routine - Read Parameter	line and do what you need...		     *
*****************************************************************************/
void main(int argc, char **argv)
{
    int i = 1, DoubleDensity = FALSE, GifOutput = FALSE, RowOutput = FALSE,
	DirectPrint = 0;
    char FullName[LINE_LEN_SHORT];
    FILE *f;

    while (i < argc) {
	if (strcmp(argv[i], "-z") == 0) {
	    fprintf(stderr, "%s%s", UsageStr, VersionStr);
	    MyExit(-1);
	}
	else if (strcmp(argv[i], "-d") == 0)
	    DoubleDensity = TRUE;
	else if (strcmp(argv[i], "-g") == 0)
	    GifOutput = TRUE;
	else if (strcmp(argv[i], "-r") == 0)
	    RowOutput = TRUE;
	else if (strcmp(argv[i], "-1") == 0)
	    DirectPrint = 1;
	else if (strcmp(argv[i], "-2") == 0)
	    DirectPrint = 2;
	else if (strcmp(argv[i], "-3") == 0)
	    DirectPrint = 3;
	else if (i + 1 != argc || argv[i][0] == '-')
	    FatalError(UsageStr);

	i++;
    }

    if (argv[i - 1][0] == '-' || argc == 1) {
	fprintf(stderr, UsageStr);
	FatalError("No EED file specified.\n");
    }

    if ((f = fopen(argv[i - 1], "rt")) == NULL) {
	strcpy(FullName, argv[i - 1]);
	strcat(FullName, FILE_EXTENSION);
	if ((f = fopen(FullName, "rt")) == NULL) {
	    fprintf(stderr, UsageStr);
	    FatalError("Failed to open EED file");
	}
    }

    Config("eedepson", SetUp, NUM_SET_UP);   /* Read config. file if exists. */

    IGInitGraph();			     /* Initiate the graphic driver. */

    if (LoadLibraryList != NULL) {
	LoadLibraries(LoadLibraryList);
	free(LoadLibraryList);
	LoadLibraryList = NULL;
    }

    LoadEEFile(f);
    fclose(f);
    RedrawAllScreen();

    if (GifOutput)
	IGDumpScreen(OUTPUT_GIF, DirectPrint, DoubleDensity);
    else if (RowOutput)
	IGDumpScreen(OUTPUT_RAW, DirectPrint, DoubleDensity);
    else {
	IGDumpScreen(OUTPUT_EPSON, DirectPrint, DoubleDensity);
    }

    MyExit(0);
}

/*****************************************************************************
* My Routine to	allocate dynamic memory. All program requests must call this *
* routine (no direct call to malloc). Dies if no memory.		     *
*****************************************************************************/
VoidPtr MyMalloc(unsigned size)
{
    VoidPtr p;

    p = malloc(size);
    if (p == NULL)
	FatalError("Not enough memory, exit\n");

#ifdef DEBUG_MALLOC_TC20
    if (FP_OFF(p) != 8)
	FatalError("Bogus pointer detected. This should be reported.\n");
#endif /* DEBUG_MALLOC_TC20 */

    return p;
}

/*****************************************************************************
* My Routine to	free dynamic memory. All program requests must call this     *
* routine (no direct call free).					     *
*****************************************************************************/
void MyFree(VoidPtr p)
{
#ifdef DEBUG_MALLOC_TC20
    if (FP_OFF(p) != 8)
	FatalError("Bogus pointer detected. This should be reported.\n");
#endif /* DEBUG_MALLOC_TC20 */

    free(p);
}

/*****************************************************************************
* MyExit routine. Note it might call to CloseGraph without calling	     *
* InitGraph(), or call MouseClose() without MouseInit() etc. and it is the   *
* responsibility of the individual modules to do nothing in these cases.     *
*****************************************************************************/
void MyExit(int ExitCode)
{
    IGCloseGraph();				/* Close the graphic driver. */

    exit(ExitCode);
}

/*****************************************************************************
* Same as MyExit routine, but print error message to stderr.		     *
*****************************************************************************/
void FatalError(char *ErrMsg)
{
    IGCloseGraph();				/* Close the graphic driver. */

    fprintf(stderr, "EEDRAW: %s\n", ErrMsg);

    exit('F');
}
