/******************************************************************************
* STACK - TC stack usage measuring routines.				      *
*									      *
*					Written by Gershon Elber,  Dec. 1990  *
*******************************************************************************
* History:								      *
*  10 Dec 90 - Version 1.0 by Gershon Elber.				      *
******************************************************************************/

#include <stdio.h>
#include <string.h>
#include <dos.h>

/* #define DEBUG_TC_STACK */

#define TC_STACK_CHAR	'S'

/******************************************************************************
* Clear all the stack space to a known pattern.				      *
******************************************************************************/
void TCStackTestInit(void)
{
    unsigned int i = _SP - 10;			       /* To play it safe... */
    char far *p = MK_FP(_SS, 0);

    while (i-- > 0) *p++ = TC_STACK_CHAR;	  /* Preset all stack space. */
}

/******************************************************************************
* Scans the stack to decide what part of it has be overwritten by the stack   *
* during run time. Returns this unused space size in bytes.		      *
******************************************************************************/
int TCStackTestSize(void)
{
    unsigned int i = 0;
    char far *p = MK_FP(_SS, 0);

    while (*p++ == TC_STACK_CHAR) i++;

    return i;
}

#ifdef DEBUG_TC_STACK

/******************************************************************************
* Simple tests for the above routines.					      *
******************************************************************************/
void main(void)
{
    TCStackTestInit();

    /* Do all your program here. */

    printf("%d bytes of stack are unused.\n", TCStackTestSize());
}

#endif /* DEBUG_TC_STACK */
