//
// Cthugha - Audio Seeded Image Processing
//
// Zaph, Digital Aasvogel Group, Torps Productions 1993-1995
//


#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include <bios.h>
#include <memory.h>
#include <assert.h>

#include "cthugha.h"
#include "charset.h"
#include "zorilkey.h"
#include "audio.h"
#include "translat.h"
#include "hi.h"

//unsigned char tempscrn[BUFF_SIZE];
#define UNROLL 16

// Use two half-sized tables because MSC can then optimize the code
// to be almost TWICE as fast (no >64k blocks)
static unsigned int mapping1[102][BUFF_WIDTH];
static unsigned int mapping2[102][BUFF_WIDTH];

#define MAXTRANS  20

int nrtrans=1;  // =no transtable because of notrans: translate=0
int translate=0, oldtrans=0;
_vmhnd_t transh1[MAXTRANS],transh2[MAXTRANS];

// static int have_table=0;

void translate_screen(void)
{

	register unsigned int x;
	register char *screen;
	register unsigned int *map;

	if (nrtrans<=1 || !translate)
		return;

	if(translate!=oldtrans && nrtrans>2){
		hi2real((char *)mapping1,transh1[translate-1],0,sizeof(mapping1));
		hi2real((char *)mapping2,transh2[translate-1],0,sizeof(mapping2));
		oldtrans=translate;
	}

	screen=shadow;

//	memcpy(tempscrn,buff,BUFF_SIZE);

	buff[0]=0;  // Set 0,0 to black - for safety reasons :-)

	map=mapping1;
	for (x=0; x<(102*BUFF_WIDTH); x+=UNROLL) {
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
	}

	map=mapping2;
	for (x=0; x<(102*BUFF_WIDTH); x+=UNROLL) {
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
		*screen++=buff[*map++];
	}

	flip_screens();

}


// int translate=1;
// int translate=0;

#define M_PI 3.14159265358979323846
#define RADEG (180.0/M_PI)
char maptabfile[255]="";

extern char swirl[5];
extern int swirlnum;

int read_tabfile(char *maptabfile);

int init_translate(void)
{
	int x,y;
	unsigned int offset=0;
	int badfile=0,i;
	struct find_t dos_f;

//	FILE *fp;

	if (nrtrans==0)  // Translation Tables DISABLED!
		return 1;

	for (y=0; y<102; y++)
		for (x=0; x<BUFF_WIDTH; x++)  {
			mapping1[y][x]=0;
			mapping2[y][x]=0;
		}

	nrtrans=1;

	if (*maptabfile) {
		if (read_tabfile(maptabfile)) {
			nrtrans=2;
			oldtrans=1;
			return 0;
		} else {
			nrtrans=1;
			oldtrans=0;
			return 1;
		}
	} else {
		if (!_dos_findfirst("*.tab",_A_NORMAL,&dos_f)) {
			do {
				if(nrtrans==2){   //if only one table no need for himem
					if(!pinghi()){
						gotoxy(0,23);
						printf("No Himem for translate,loading only one table    ");
						break;
					}
					for(i=0;i<MAXTRANS;i++)
						transh1[i]=transh2[i]=0;
					if( (transh1[0]=himalloc(sizeof(mapping1)))==0)
						break;
					if( (transh2[0]=himalloc(sizeof(mapping2)))==0){
						hifree( transh1[0]);
						break;
					}
					real2hi(transh1[0],0,(char *)mapping1,sizeof(mapping1));
					real2hi(transh2[0],0,(char *)mapping2,sizeof(mapping2));
				}
				sprintf(maptabfile,"%-12s",dos_f.name);
				if( read_tabfile(maptabfile)){
					if(nrtrans>=2){
						if( (transh1[nrtrans-1]=himalloc(sizeof(mapping1)))==0)
							break;
						if( (transh2[nrtrans-1]=himalloc(sizeof(mapping2)))==0){
							hifree( transh1[nrtrans-1]);
							break;
						}
						real2hi(transh1[nrtrans-1],0,(char *)mapping1,sizeof(mapping1));
						real2hi(transh2[nrtrans-1],0,(char *)mapping2,sizeof(mapping2));
					}
					nrtrans++;
				}
			}while (!_dos_findnext(&dos_f) && nrtrans<=MAXTRANS);
		} else {
				gotoxy(11,20);
			printf("None found");
		}
		oldtrans=nrtrans-1;
	}

}


int read_tabfile(char *tabfile){
        int x,y;
        unsigned int offset=0;
        int badfile=0;

        FILE *fp;

        for (y=0; y<102; y++)
                for (x=0; x<BUFF_WIDTH; x++)  {
                        mapping1[y][x]=0;
                        mapping2[y][x]=0;
        }

        if ((fp=fopen(tabfile,"rb"))!=NULL) {
				gotoxy(11,20);
                printf(tabfile);

                for (y=0; y<102; y++) {
                        fread(&mapping1[y],sizeof(unsigned int),BUFF_WIDTH,fp);
                }
                for (y=0; y<102; y++) {
                        fread(&mapping2[y],sizeof(unsigned int),BUFF_WIDTH,fp);
                }
                fclose(fp);
                for (y=0; y<102; y++)
                        for (x=0; x<BUFF_WIDTH; x++) {
                                /*if (mapping1[y][x]<0) {
									gotoxy(0,23);
                                        printf("Tab File: Neg at %d,%d   ",x,y);
                                        mapping1[y][x]=0;
                                        badfile++;
                                }*/

                                if (mapping1[y][x]>=(unsigned int)BUFF_SIZE) {
									gotoxy(0,23);
                                        printf("Tab file: %s  High at %d,%d   ",tabfile,x,y);
                                        mapping1[y][x]=0;
                                        badfile++;
                                }
                                /*if (mapping2[y][x]<0) {
                                        printf("Neg at %d,%d\n",x,y);
                                        mapping2[y][x]=0;
                                        badfile++;
                                }*/

                                if (mapping2[y][x]>=(unsigned int)BUFF_SIZE) {
									gotoxy(0,23);
                                        printf("Tab file: %s  High at %d,%d    ",tabfile,x,y);
                                        mapping2[y][x]=0;
                                        badfile++;
                                }

                        }

                return 1;
        } else {
				gotoxy(0,23);
                printf("Unable to open: %s     ",tabfile);
                return 0;
        }
}



void exit_translate(void){
        int i;
        for(i=0;i<MAXTRANS;i++){
                if(transh1[i]) hifree(transh1[i]);
                if(transh2[i]) hifree(transh2[i]);
        }
}


