//
// Cthugha - Audio Seeded Image Processing
//
// Zaph, Digital Aasvogel Group, Torps Productions 1993-1995
//
// Soundblaster Stereo version by Daniel Sachs, 1995
//


#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include <assert.h>

#include "sb_drive.h"
#include "dma.h"

#include "cthugha.h"
//#include "sb.h"

extern int (*init_audio)(void);
extern void (*close_audio)(void);
extern int (*audio_firsttime)(void);
extern int (*audio_everytime)(int wait);

extern int  (*get_level)(int channel);
extern void (*set_level)(int channel, int level);
extern int  (*level_incr)(int channel);

extern void (*set_input)(enum device_list device);

extern enum device_list { CDInput, LineInput, MicInput } device;
extern void draw_text(int xpos, int ypos, int size, int colour, char *tbuf);

int load_drv(void);

int SBok=0;

extern int sample_stereo;

struct dsp_device_caps *caps;

int port, dma, irq,dma16;

extern int SBport;

extern int display_flag;
extern int wait_flag;
extern unsigned actual_rate;

static unsigned last_rate = 65535;
static int last_stereo = -1;

void SB_close(void)
{
	if (SBok) {
		dsp_reset();
		dsp_close();
	}
}


int SB_firsttime(void)
{
	static int prev=128;
	int noisy=0,last=0;
	static int firsttime=1;

	dma_reset(SBdma);
	dsp_reset();

	if( sample_stereo && !(caps->max_8bit_rec_s) )
		sample_stereo = 0;

	set_input(device);

	if( sample_stereo )
		sample_rate = min(sample_rate,caps->max_8bit_rec_s);
	else
		sample_rate = min(sample_rate,caps->max_8bit_rec);

	sample_rate = max(sample_rate,caps->min_speed);

	if( !(actual_rate = dsp_set_record(sample_rate,sample_stereo,8,0)) )
		assert( (actual_rate = dsp_set_record(11111,0,8,0)) );

	last_rate   = sample_rate;
	last_stereo = sample_stereo;

	return 0;
}


int SB_everytime(int wait)
{
	int x,y;
	static int prev=128;
	unsigned char far *sbuff ;
	int noisy=0,last=0;
	static int firsttime=1;

	static int page;

	if( (sample_rate != last_rate) || (sample_stereo != last_stereo) )
			SB_firsttime();

//	if( page == 0 )

	{
		while (dsp_read(voice_buffer) > 1)
			if( wait )
			{
				if( _kbhit() )
				break;
			}
			else
			{
				wait_flag = 0;
				return 0;
			}
	}

/*	page = 1;
	if( sample_stereo )
		while( dsp_read(voice_buffer + buffer_size) > 1 )
			if( wait )
			{
				if( _kbhit() )
					break;
			}
			else
			{
				wait_flag = 0;
				return 0;
			}

	page = 0;
*/

	sbuff=voice_buffer ;
	sbuff += 6;

	last=*sbuff;
//	sbuff++;

	for (x=0; x<30; x+=2) {
		//align...
		if ((*sbuff)>=prev && last<prev-1) {
			break;
		} else {
			last= *sbuff;
			sbuff++;

			if( sample_stereo )
				sbuff++;
		}
	}

	prev=*sbuff;

	if( sample_stereo )
		for (x=0; x<BUFF_WIDTH; x++) {
			stereo[x][0]=*sbuff++;
			stereo[x][1]=*sbuff++;
		}
	else
		for (y=0; y<2; y++)
			for (x=0; x<BUFF_WIDTH; x++) {
				stereo[x][y]=*sbuff++;
			}

	return 1;
}


void SB_set_input(enum device_list device)
{
	static int mono[] =  { CD_IN  , LINE_IN  , MIC_IN };
	static int left[] =  { CD_IN_L, LINE_IN_L, MIC_IN };
	static int right[] = { CD_IN_R, LINE_IN_R, MIC_IN };

	if( SBtype == 3 )
	{
		mix_set_input(mono[device]);
	}
	else if( SBtype >= 4 )
	{
		if( sample_stereo )
		{
			mix_set_sb16_input(MIXleft ,left [device]);
			mix_set_sb16_input(MIXright,right[device]);
		}
		else
			mix_set_sb16_input(MIXboth,mono[device]);
	}
}

void SB_set_level(int channel, int level)
{
	mix_write(channel,MIXboth,level);
}

int SB_get_level(int channel)
{
	return mix_read(channel,MIXboth);
}

int SB_level_incr(int channel)
{
	if( SBtype >= 4 )
	switch( channel )
	{
		case MIXtreble:
		case MIXbass:
				return 16;

		case MIXgain:
		case MIXin_gain:
		case MIXspeaker:
				return 64;

		default:
				return 8;
	}
	else
		return( channel == MIXmicrophone ? 64 : 32 );
}

int SB_init(void)
{
	sb_get_params(&port,&dma,&irq,&dma16);

//	buffer_size=2*BUFF_WIDTH+100;
	buffer_size=2*BUFF_WIDTH+80;

	gotoxy(23,17);
	printf("%x",port);

	gotoxy(42,17);
	printf("%d",irq);

	gotoxy(33,17);
	printf("%d",dma);

//	printf("IO 0x%x  IRQ %d  DMA %d  DMA16 %d\n",port, irq, dma, dma16);
//	SBok = dsp_open(port,dma,irq,dma16,buffer_size,2);
	SBok = dsp_open(port,dma,irq,dma16,buffer_size,2);
	SBport=port;

	if( !SBok )
		return 1;

	caps = dsp_get_device_caps();

	sample_rate = caps->max_8bit_rec_s;
	sample_stereo = 1;

	if( sample_rate == 0 ) {
		sample_rate = caps->max_8bit_rec;
		sample_stereo = 0;
	}

	voice_buffer = malloc(buffer_size*2);

	assert( voice_buffer != NULL );

	close_audio = SB_close;
	audio_firsttime = SB_firsttime;
	audio_everytime = SB_everytime;

	set_input = SB_set_input;

	get_level = SB_get_level;
	set_level = SB_set_level;

	level_incr = SB_level_incr;

	return !SBok;

}
