#ifndef _CLIPPER_H_
#define _CLIPPER_H_

/** 3DGPL *************************************************\
 *  ()                                                    *
 *  Header for clipping functions.                        *
 *                                                        *
 *  clipp-2d.c               3-D volume and Z clipping;   *
 *  clipp-3d.c               2-D plane clipping.          *
 *                                                        *
 *  (6/1995) By Sergei Savhenko. (savs@cs.mcgill.ca).     *
 *  Copyright (c) 1995 Sergei Savchenko.                  *
 *  THIS SOURCE CODE CAN'T BE USED FOR COMERCIAL PURPOSES *
 *  WITHOUT AUTHORISATION                                 *
\**********************************************************/

#include "../hardware/hardware.h"           /* screen dimensions */

#define C_MAX_DIMENSIONS          5         /* dims in N-dimensional lines */
#define C_Z_CLIPPING_MIN         10         /* where viewing plane is */
#define C_X_CLIPPING_MIN          0         /* clipping cube */
#define C_X_CLIPPING_MAX   HW_SCREEN_X_MAX
#define C_Y_CLIPPING_MIN          0
#define C_Y_CLIPPING_MAX   HW_SCREEN_Y_MAX

int C_volume_clipping(int *from,int *to,int *vertex,int dimension,int length);

int C_line_z_clipping(int **vertex1,int **vertex2,int dimension);
int C_polygon_z_clipping(int *from,int *to,int dimension,int length);

int C_line_x_clipping(int **vertex1,int **vertex2,int dimension);
int C_line_y_clipping(int **vertex1,int **vertex2,int dimension);
int C_polygon_x_clipping(int *from,int *to,int dimension,int length);

/**********************************************************/

#endif
