{Ŀ
  Genetic Algorithms F6                                                
  Written by Jou-Nan Chen                                              
 Ĵ
                                    Sin(X+Y)-0.5                 
  Problem:           MaxF(X,Y)=0.5+ĳ, -100X,Y100 
                                   (1.0+0.001(X+Y))               
  Solution:          X,Y=0, F(X,Y)=1                                   
  Fitness Function:  F(X,Y)                                            
  Population Size:   30                                                
  Generations:       100                                               
  Encoding Length:   22+22 Bits                                        
  Crossover Rate:    0.8                                               
  Mutation Rate:     0.001                                             
  Run Times:         100                                               
 }

uses Crt,Graph;

const
  Pop=30;
  Gen=100;
  Bits=22;
  Cro=80;      { /100 }
  Mut=10;      { /10000 }
  Runs=100;
  BitsMax:longint=(1 shl Bits)-1;
  BitsMax2:longint=1 shl (Bits-1);
  RunMax:real=0;
var X,Y:array[1..Pop,1..2] of longint;    { Individuals }
    F,S:array[1..Pop] of real;            { Fitness }
    Avg,Max,Sum,SumAvg,SumMax,RunMaxLocal:real;
    MaxNo:integer;

{  Local Search  }
procedure LocalSearch;
var I:integer;
    A,B,N:longint;
    R,C,D:real;
begin
  N:=Trunc(BitsMax/1000);
  RunMaxLocal:=RunMax;
  for I:=-10 to 10 do begin
    A:=X[MaxNo,1]+I*N;
    B:=X[MaxNo,2]+I*N;
    if (A>=0) and (A<=BitsMax) and (B>=0) and (B<=BitsMax) then begin
      C:=(A-BitsMax2)/BitsMax*200;
      D:=(A-BitsMax2)/BitsMax*200;
      R:=C*C+D*D;
      R:=0.5-(Sqr(Sin(Sqrt(R)))-0.5)/Sqr(1+0.001*R);
      if R>RunMaxLocal then RunMaxLocal:=R;
    end;
  end;
end;
{  Initialize Population  }
procedure InitPopulation;
var I,J:integer;
begin
  Randomize;
  for I:=1 to Pop do for J:=1 to 2 do X[I,J]:=Trunc(Random*(BitsMax+1));
end;
{  Fitness  }
procedure Fitness;
var I:integer;
    R,C,D:real;
begin
  { Fitness }
  for I:=1 to Pop do begin
    C:=(X[I,1]-BitsMax2)/BitsMax*200;
    D:=(X[I,2]-BitsMax2)/BitsMax*200;
    R:=C*C+D*D;
    F[I]:=0.5-(Sqr(Sin(Sqrt(R)))-0.5)/Sqr(1+0.001*R);
  end;
  { Average, Maximum, & Sum of Fitness }
  Sum:=0; Max:=F[1]; MaxNo:=1;
  for I:=1 to Pop do begin
    if F[I]>Max then begin Max:=F[I]; MaxNo:=I; end;
    Sum:=Sum+F[I];
    S[I]:=Sum;
  end;
  Avg:=Sum/Pop;
  { Run Maximum }
  if RunMax<Max then RunMax:=Max;
  { Sum of Average, Maximum Fitness }
  SumAvg:=SumAvg+Avg;
  SumMax:=SumMax+Max;
end;
{  Selection  }
procedure Selection;
var I,J,K:integer;
    R:real;
begin
  for I:=1 to Pop do begin
    R:=Random*Sum;
    for J:=1 to Pop do if S[J]>R then Break;
    for K:=1 to 2 do Y[I,K]:=X[J,K];
  end;
  X:=Y;
end;
{  Crossover  }
procedure Crossover;
var I,J,P:integer;
    A,B,T:longint;
begin
  for I:=1 to Pop div 2 do if Random(100)<Cro then for J:=1 to 2 do begin
    P:=Random(Bits-1)+1;
    B:=(1 shl P)-1; A:=BitsMax-B;
    T:=X[2*I-1,J];
    X[2*I-1,J]:=(X[2*I-1,J] and A)+(X[2*I,J] and B);
    X[2*I,J]:=(X[2*I,J] and A)+(T and B);
  end;
end;
{  Mutation  }
procedure Mutation;
var I,J,P:integer;
begin
  for I:=1 to Pop do for P:=0 to Bits-1 do
    if Random(10000)<Mut then for J:=1 to 2 do
      if (X[I,J] shr P) and 1=0
	then X[I,J]:=X[I,J] or (1 shl P)
	else X[I,J]:=X[I,J] and ((1 shl P) xor BitsMax);
end;
{  Screen  }
procedure Screen;
var A,B,I,J:integer;
    St:string;
begin
  A:=InstallUserDriver('SVGA256',nil); B:=2;
  InitGraph(A,B,'');
  SetTextStyle(1,0,4);
  SetColor(15);
  OutTextXY(80,20,'Genetic Algorithms F6');
  for I:=30 to 60 do for J:=80 to 500 do
    if GetPixel(J,I)=15 then PutPixel(J,I,80+(I-30) div 2);
  SetTextStyle(2,1,7);
  OutTextXY(10,150,'Fitness');
  SetTextStyle(2,0,7);
  OutTextXY(420,440,'Generation');
  SetTextStyle(2,0,5);
  SetColor(53);
  for I:=0 to 10 do begin
    Str(I/10:3:1,St);
    OutTextXY(53,392-30*I,St);
    Line(75,400-30*I,80,400-30*I);
  end;
  for I:=0 to 10 do begin
    Str(Trunc(I*(Gen/10)):3,St);
    OutTextXY(65+50*I,405,St);
    Line(80+50*I,405,80+50*I,400);
  end;
  SetColor(53);
  Rectangle(80,100,600,400);
end;
{  Plot  }
procedure Plot(N:integer);
const
   Gap=500/Gen;
   Avg0:real=0;
   Max0:real=0;
begin
  if N>0 then begin
    SetLineStyle(0,0,3);
    SetColor(12);
    Line(81+Trunc((N-1)*Gap),401-Trunc(Max0*300),
	 81+Trunc(N*Gap),401-Trunc(Max*300));
    SetColor(64+N mod 40);
    Line(81+Trunc((N-1)*Gap),401-Trunc(Avg0*300),
	 81+Trunc(N*Gap),401-Trunc(Avg*300));
  end;
  Avg0:=Avg; Max0:=Max;
end;
{  Repaint  }
procedure Repaint;
begin
  SetLineStyle(0,0,1);
  SetFillStyle(1,0);
  Bar(80,100,600,400);
  SetColor(53);
  Rectangle(80,100,600,400);
end;
{  Results  }
procedure Results(N:integer);
var St:string;
begin
  SetTextStyle(2,0,6);
  SetColor(15);
  Str(RunMaxLocal:10:8,St);
  OutTextXY(210,300,'RunMaxLocal='+St);
  Str(N,St);
  OutTextXY(120,320,'Run '+St);
  Str(RunMax:10:8,St);
  OutTextXY(210,320,'RunMax='+St);
  Str(SumMax/(Gen+1):10:8,St);
  OutTextXY(210,340,'AvgMax='+St);
  Str(SumAvg/(Gen+1):10:8,St);
  OutTextXY(210,360,'AvgAvg='+St);
end;

{  Main Program  }

var I,N:integer;
    File1:text;
begin
  if ParamCount=1 then begin
    {$I-} Assign(File1,ParamStr(1)); Reset(File1); {$I+}
    if IOResult<>0 then Rewrite(File1) else Append(File1);
  end;
  Screen;
  for N:=1 to Runs do begin
    { Start Evolution }
    RunMax:=0; SumAvg:=0; SumMax:=0;
    InitPopulation;
    Fitness;
    Plot(0);
    for I:=1 to Gen do begin
      Selection;
      Crossover;
      Mutation;
      Fitness;
      LocalSearch;
      Plot(I);
    end;
    { End Evolution }
    Repaint;
    Results(N);
    if ParamCount=1 then Writeln(File1,N:5,'  ',RunMaxLocal:10:8,
      '  ',RunMax:10:8,'  ',SumMax/(Gen+1):10:8,'  ',SumAvg/(Gen+1):10:8);
    if keyPressed then if ReadKey=#27 then Break;
  end;
  CloseGraph;
  RestoreCrtMode;
  if ParamCount=1 then Close(File1);
end.
