        page    55,132
        title   'DUMP --- Hex and ASCII Dump Filter'
; DUMP --- filter to transform the Standard Input stream into a
;          Hex and ASCII dump, which is written to the Standard Output.
;
; Version 1.0 Richard G. Markley  July 20, 1985
;   From Dr Dobbs Journal, November 1985
; Version 1.1 Ted Shapin, Dec. 18, 1985
;   Modified to also take a name on the command line

cr              equ     0dh             ;ASCII carriage return
lf              equ     0ah             ;ASCII line feed
space           equ     20h             ;ASCII space
tab             equ     09h             ;ASCII tab

;DOS 2.x predefined handles

Std_Input       equ     0               ;Standard Input device or file
Std_Output      equ     1               ;Standard Output device or file
Std_Err         equ     2               ;Standard Error device or file

;DOS function numbers

Get_Version     equ     030h            ;get current DOS version
Device_Input    equ     03fh            ;read from file or device
Device_Output   equ     040h            ;write to file or device
Exit            equ     04ch            ;exit with return code

code            segment para public 'CODE'

                assume  cs:code,ds:code,es:code,ss:code

                org     100h

dump            proc    far

                jmp     start

; data area

Column_Guide    db      11 dup  (' ')
                db      '0  1  2  3  4  5  6  7  8  9  '
                db      'A  B  C  D  E  F',cr,lf
Col_Guide_Size  equ     $-Column_Guide

Data_String     db      3 dup (' ')

Byte_Counter    db      '000000  '

Hex_String      dw      25 dup (?)

ASCII_String    dw      8 dup (?)
                db      cr,lf
String_Size     equ     $-Data_String
Appx_String_Len equ     (LENGTH Hex_String)+(LENGTH ASCII_String)

New_Lines       db      cr,lf     ;one blank line
New_Lines_Size  equ     $-New_Lines

Line_Count      db      ?               ;Count of lines per block

filen           db      40 dup(0) ; File name (paths OK)
fileh           dw      0000H     ; File handle

; error messages
Pre_DOS_Error   db      cr,lf,'DUMP: DOS 2 or greater required',cr,lf
Pre_DOS_Size    equ     $-Pre_DOS_Error

Input_Error     db      cr,lf,'DUMP: input device error',cr,lf
Input_Size      equ     $-Input_Error

Empty_Error     db      cr,lf,'DUMP: missing input error',cr,lf
Empty_Size      equ     $-Empty_Error

Output_Error    db      cr,lf,'DUMP: output device error',cr,lf
Output_Size     equ     $-Output_Error

Disk_Full_Error db      cr,lf,'DUMP: disk is full',cr,lf
Disk_Full_Size  equ     $-Disk_Full_Error

Start:          mov     ah,Get_Version  ;check version of DOS
                int     21h

                or      al,al           ;is it DOS v. 2.0 or higher?
                jnz     Prepare         ;yes, proceed
                jmp     Error_1         ;no, output error message

Prepare:                                ;prepare for processing
                cld
                mov     bp,-1           ;prevent output if no input
                call    Findname        ;see if a name on command line
                call    Input           ;perform input of data

Main_Loop:                              ;output heading'
                mov     cx,Col_Guide_size
                mov     dx,offset Column_Guide
                call    Output
                                        ;now dump a block
                mov     Line_Count,8    ;number of lines per block
                jmp     Do_Block
Output_Lines:                           ;send 1 blank lines
                mov     cx,New_lines_Size
                mov     dx,offset New_Lines
                call    Output
                jmp     Main_Loop

Do_Block:                               ;initialize part of data
                                        ;template with spaces
                mov     ax,2020h
                mov     cx,Appx_String_Len
                mov     di,offset Hex_String
                rep stosw
                                        ;initialize pointers
                                        ;and convert data
                mov     bx,offset Hex_String
                mov     dx,size ASCII_String
                mov     di,offset ASCII_String
                jmp     Do_Line

Output_Data:    mov     cx,String_Size  ;write a line to Std Output
                mov     dx,offset Data_String
                call    Output
                                        ;set pointer to sixteen's
                                        ;place of byte counter
                mov     di,offset Byte_Counter+4
                                        ;number of places in byte
                mov     cx,5            ;counter minus one

Adjust_Counter:                         ;increment input offset counter
                inc     byte ptr [di]   ;incr current number place value
                mov     al,[di]
                cmp     al,'9'          ;is it 9 or less?
                jbe     Check_line_Cnt  ;yes, check no. of lines output
                cmp     al,'A'          ;no is it larger than A?
                ja      check_For_F     ;yes, jump
                mov     byte ptr [di],'A'
                jmp     short Check_Line_Cnt

Check_For_F:    cmp     al,'F'          ;is it 'F' or less?
                jbe     Check_Line_Cnt  ;yes, check number of lines output
                mov     byte ptr [di],'0' ;no, make the digit '0'
                dec     di              ;move ptr to next higher place
                Loop    Adjust_Counter  ;carry into next higher digit

                                        ;check number of lines output
Check_line_Cnt: dec     Line_Count      ;has block been output?
                jne     do_Block        ;no, output another line
                jmp     Output_Lines    ;yes, output blank

                                        ;place ASCII equivalent of
                                        ;byte in string
Do_Line:        mov     al,[si]         ;get byte from buffer
                mov     ch,al           ;keep copy
                cmp     al,' '          ;control code?
                jb      Not_Printable   ;yes, jump
                cmp     al,'~'          ;no, is char a tilde or less?
                jbe     Printable       ;yes, use it

Not_Printable:  mov     al,'.'          ;substitute '.' if not printable

Printable:      stosb                   ;store into ASCII section of output
                                        ;place hex equivalent of byte
                                        ;in output string
                mov     ah,2            ;number of nibbles in a byte
                xchg    di,bx           ;get hex section offset
Swap_Nibbles:   mov     cl,4            ;size of nibble in bits
                rol     ch,cl           ;exchange nibbles
                mov     al,ch           ;save copy
                and     al,0fh          ;mask off high 4 bits
                add     al,'0'          ;convert to ASCII char.
                cmp     al,'9'          ;is it '0-9'?
                jbe     Place_Digit     ;yes, store result
                add     al,7            ;put it into range 'A-F'

Place_Digit:    stosb                   ;store into hex section of output
                dec     ah              ;any more nibbles?
                jnz     Swap_Nibbles    ;yes, convert again

                                        ;reposition pointers
                xchg    di,bx           ;get ASCII section offset
                inc     bx              ;skip space in hex section
                inc     si              ;move input pointer

                                        ;input data when buffer empty
                dec     bp              ;buffer used up yet?
                jnz     Check_Item_Cnt  ;no, check item count
                call    input

                                        ;check number of items stored
Check_Item_Cnt: dec     dx              ;store more data in string?
                jnz     Do_Line         ;yes, get another byte
                jmp     Output_Data     ;no, send a line

                                        ;output last data string
                                        ;if necessary
Finish_Output:  or      bp,bp           ;was there any input?
                jnz     Error_3         ;no, send error message
                mov     cx,String_Size  ;yes get size & addr of string
                mov     dx,offset Data_String
                call    Output          ;send the line
                                        ;exit to DOS with ERRORLEVEL set
                sub     al,al           ;return code = 0 for success

Exit_to_DOS:    mov     ah,Exit         ;terminate with AL=return code
                int     21h

findname        proc
                mov     bh,00h          ; Look for a filename on command line
                mov     bl,ds:[0080h]   ; Look in the FCB location
                cmp     bl,00h          ; BL has the length of the string
                jne     findnm1         ; If something; else
noname:         mov     ds:[fileh],Std_input ; use std input for file handle
                ret

findnm1:        mov     cx,bx
                add     cx,2            ; Save length for later
                add     bx,0081h        ; Put null byte at end to make ASCIIZ string
                mov     byte ptr [bx],00h
                mov     bx,0080h
                cld

findnm:                                 ; Find actual start of filename
                dec     cx
                inc     bx
                cmp     byte ptr [bx],space ; by skipping leading spaces
                je      findnm
                cmp     byte ptr [bx],tab ; and tabs
                je      findnm
                cmp     byte ptr [bx],00 ; End of string?
                je      noname          ; Yes. Just blank(s)
                mov     di,offset filen ; Where to put it
                mov     si,bx
                rep     movsb

                mov     dx,bx
                mov     ds:[fileh],ax ; Save file handle
                mov     dx,offset filen
                mov     al,0    ; Read access
                mov     ah,3dh  ; Try to open the file
                int     21h
                jnc     filefound
                cmp     ax,2
                je      Error_3         ; File not found
                jmp     Error_2         ; Input error
filefound:      mov     ds:[fileh],ax ; Save file handle
                ret
findname        endp
 
Error_1:        mov     cx,Pre_Dos_Size ;wrong DOS version
                mov     dx,offset Pre_Dos_Error
                mov     bp,1            ;save ERRORLEVEL value
                jmp     Output_Err_Msg  ;send error message

Error_2:        mov     cx,Input_Size   ;input device error
                mov     dx,offset Input_Error
                mov     bp,2            ;save ERRORLEVEL value
                jmp     Output_Err_Msg  ;send error message

Error_3:        mov     cx,Empty_Size   ;empty input stream
                mov     dx,offset Empty_Error
                mov     bp,3            ;save ERRORLEVEL value
                jmp     Output_Err_Msg  ;send error message

Error_4:        mov     cx,Output_Size  ;output device error
                mov     dx,offset Output_Error
                mov     bp,4            ;save ERRORLEVEL value
                jmp     Output_Err_Msg  ;send error message

Error_5:        mov     cx,Disk_Full_Size ;output device is full
                mov     dx,offset Disk_Full_Error
                mov     bp,5            ;save ERRORLEVEL value

Output_Err_Msg:                         ;send error message to Standard
                                        ;Error device & pass return
                                        ;code back to DOS
                mov     ah,Device_Output
                mov     bx,Std_Err      ;use handle for Standard Error dev.
                int     21h
                mov     ax,bp           ;recover return code
                jmp     Exit_to_DOS     ;go terminate

Input           proc    near            ;get data from Standard Input
                push    bx              ;save hex section offset
                push    dx              ;save item count
                mov     ah, Device_Input
                mov     bx,ds:[fileh]   ;use handle for input
                mov     cx,60*1024      ;size of input buffer
                mov     dx,offset Buffer;address of buffer for data
                int     21h
                jc      Error_2         ;jump if input device error
                or      ax,ax           ;any input?
                jnz     input2          ;yes.
                jmp     Finish_Output   ;no, send last string & exit
Input2:         mov     si,offset Buffer;set pointer to input
                mov     bp,ax           ;Length of input
                pop     dx              ;restore item count
                pop     bx              ;restore hex section offset
                ret
Input           endp

Output          proc    near            ;send string to Standard Output
                mov     ah,Device_Output
                mov     bx,Std_Output   ;use handle for Standard Output
                int     21h
                jc      Error_4         ;jump if output device error
                cmp     ax,cx           ;all requested bytes written?
                jne     Error_5         ;jump, output device full
                ret
Output          endp

Buffer          equ     $               ;beginning of input buffer

Dump            endp

Code            ends

                end     Dump
