/* This program splits the input file into smaller files.

   USAGE: CHOP FILENAME SIZE [OUTPATH] -SWITCHES
   Version 1.23.  Written by W. J. Kennamer and released into the public domain.
                  Enhanced by Edgar Swank         "           "         "
     Enhancements/Changes:
      1)Performance improvement by reading/writing in large blocks.
      2)Support for non-ASCII files with -b option.
      3)Add optional disk/path for output files.
      4)Add -w option to wait after each output file (except last).
      Note: this source is now for Turbo C Compiler.
            Compile with HUGE memory model -mh.
     FILENAME is any valid MS-DOS filename.  Wildcards are not supported.
     Output file names will be FILENAME.001, FILENAME.002, etc.
     Output files are always terminated with a carriage return and
     a <ctrl>Z, UNLESS -b is specified.
     SIZE is the desired file size for each new file.
     OUTPATH is an optional disk/pathname (A: or \path\ or a:\path\)
     to put output files on a different disk and/or directory from input file.
     If using -p with OUTPATH, enter some dummy argument for SIZE.
     SWITCHES must follow the FILENAME,SIZE and OUTPATH parameters,
       and may be entered in any order.  Switches may be combined.
     Valid SWITCHES are:
       -b  binary     do not add cr/lf/^z to output files.
                        forces -s.
       -s  strict     chop file at exact SIZE boundary.
       -w  wait       wait after closing each output file.
                       can change output diskette if separate from input.
       -r  return     chop file at first carriage return
                        following SIZE characters (default).
       -px partition  partition file into x equal units.
                        SIZE is ignored (and may be omitted) if
                        you choose this option.

File pointer fp1 is the input file.  fp2 is always the output
   file, though its name changes as new output files are
   opened.

*/

#include  <fcntl.h>
#include  <dos.h>
#include  <stdio.h>
#include  <ctype.h>
#include  <string.h>
#include  <alloc.h>
#include  <stdlib.h>
#include  <io.h>

#define VERSION "1.24"
#define PROGNAME "CHOP"
#define CTRL_Z   0x1a
#define CR       0x0d
#define LF       0x0a
#define OFF   0
#define ON   1

int binary = OFF;                   /* do not add CR,LF,EOF             */
int wait   = OFF;                   /* Wait after each output file close*/
int count;                          /* no. of digits in size            */
int c;                              /* current character                */
int lc;                             /* last char written                */
int j;                              /* index                            */
long inpleft;                       /* Bytes input left to read         */
long inplimit;                      /* Bytes input left to read low lim */
long bfsiz;                         /* I/O buffer size                  */
long bread;                         /* Bytes read into buffer           */
long pbread;                        /* Bytes read this partition        */
long bwrit;                         /* Bytes written from buffer        */
long pbwrit;                        /* Bytes written this partition     */

long size = 0;                      /* partition value -- file size     */
long byte_count = 0;                /* total bytes in original file     */
long inpfz = 0;                     /* total bytes in original file     */
long out_file_size = 0;             /* total bytes in output file       */

char *bfpa[20];                     /* I/O buffer pointer array         */

FILE *fp1,*fp2;                     /* fp1=input, fp2=output            */
int derno,erno;

 int bfx;                           /* buffer array index               */
 int num_output_files = 0;          /* no of files successfully created */
 int length;                        /* length of matching string        */
 int normal = ON;                   /* normal CR breaks                 */
 int strict = OFF;                  /* break exactly at boundary        */
 int partition = OFF;               /* strict or normal                 */
 int num_part;                      /* number of partitions             */
 int int_size;                      /* integer for file size            */
 int nmb;                           /* number of 16k blocks IO          */
 unsigned int  w;

 char *p;                           /* pointer to switch string         */
 char *period_p;                    /* location of period in filename   */
 char *output_file;                 /* output file name                 */
 char filename[80];                 /* original file name               */
 char fnwork[80];                   /* workarea for file name           */

 char outpath[64];                  /* optional output disk/path        */
 char line1[80];                    /* data buffer                      */
 char line2[30];                    /* data buffer                      */
 char *switches;                    /* string to hold switches          */
 char infile[80];                   /* input filename                   */

 void help();
 void close_out();
 void block_read();
 void block_write();
 void copy_to_eol();
 void construct_output_filename();
 void delete_file();
 void set_switches();
 void check_extra_files();
 int file_exists(char *);

main(argc,argv)
int argc;
char *argv[];
   {


   /* test code to prints args **********
   printf("ARGC=%d\n",argc);
   for (j=0;j<argc ;j++ )
   {
   printf("ARGV[%d]=%s\n",j,argv[j]);
   }
   ***************************************/
   bfsiz=0;
   for (nmb=1;nmb<=20 ;nmb++ )
   {
   bfpa[nmb-1]=malloc(16384);
   if (bfpa[nmb-1]==NULL)
    {
   break;
    }
    else
    {
   bfsiz=(long)nmb*16384;
    }
   } /*for (nmb=1;nmb<=10 ;nmb++ )*/
   nmb--;
   if (nmb==0)
   {
    printf ("Insufficient Memory for I/O Buffer.\n");
    exit(8);
   }
   else
    printf ("%ld (%u*16384) bytes allocated for I/O Buffers.\n",bfsiz,nmb);


   if( argc > 5 || argc < 3 || strcmp(argv[2],"-?")==0
                            || strcmp(argv[3],"-?")==0
                            || strcmp(argv[4],"-?")==0 )
      {
      help();
      exit(1);
      }

   /* see which argument is the switch */
   switches = line2;
   strcpy(switches,"");
   for (j=2;j<argc;j++)
   {
   if( argv[j][0]=='-')
      {
      strcpy(switches,argv[j]);
      break;
      }
    } /*for*/
    if (j>3)
     strcpy(outpath,argv[3]);
    else
     outpath[0]=0;

     set_switches();

   if( (fp1 = fopen(argv[1],"rb") ) == NULL)
      {
      printf("Cannot open %s for input.\n",argv[1]);
      exit(1);
      }

      if( fseek(fp1,0L,2) == -1)            /* position at EOF */
         {
         printf("Error seeking end of input file.\n");
         exit(1);
         }

      inpfz = ftell(fp1);                   /* tell EOF  */
      rewind(fp1);                          /* back to beginning of file */
      printf("  Input file size = %ld bytes\n",inpfz);

   /* determine file size */
   if(partition == ON)
      {

      /* each partition requires 3 extra bytes -- CTRL_Z, newline */
      size = ((inpfz + 3*(long)num_part) / (long)num_part ) + 1 ;

      printf("   Partition size = %ld bytes\n",size);
      printf("No. of partitions = %ld\n\n",(long)num_part);

      }
   else                                 /* partition is not ON */
      {                                 /* read SIZE from command line */

      count = sscanf(argv[2],"%D",&size); /* convert string to long integer */
      if(count == 0)
         {
         printf("Invalid size\n");
         exit(1);
         }
      } /*else*/
      if (size>inpfz)
        {
        printf("Requested Size > Input File Size. Continue? (y/n): ");
        c=getche();
        printf("\n");
        if (c=='n' || c=='N')
         exit(1);
        }

   strcpy(filename,argv[1]);
   strcpy(infile,argv[1]);

   period_p = strchr(filename,'.');         /* locate the period, if any */

   if( period_p != NULL )
      *period_p = '\0';                     /* chop off the period  */

   if (outpath[0]!=0)                       /* if outpath specified */
     construct_output_filename();

   inpleft=inpfz;
   if (binary==ON)
    inplimit=0;
   else
    inplimit=3;
   bread=0;pbread=0;w=16384;
   bwrit=0;pbwrit=0;bfx=0;
   while (inpleft>inplimit)
    {
      block_read();

      if (pbwrit==0)
      {
      (num_output_files)++;
      if(num_output_files > 999)
         {
         printf("Too many files--%d.\nExiting program\n.",num_output_files);
         exit(1);
         }

      output_file = line1;                /* initialize output_file pointer */

      /* create the next filename */
      sprintf(output_file,"%s.%03d",filename,num_output_files);
      if (num_output_files == 1)
       {
        char oftest [80];
        char *p;
        strcpy(oftest,output_file);
        p=oftest + strlen(oftest) - 3;
        while (1)
         {
          if (file_exists(oftest)) break;
          if (p[0] != '0') break;
          p[0]=p[1];
          p[1]=p[2];
          p[2]=0;
         }
        if (file_exists(oftest))
         {
          while (1)
           {
            printf ("File %s already exists. Specify Overlay or Skip (O/S): ",
                    oftest);
            c=toupper(getche());
            printf("\n");
            if (c == 'S')
             {
              while (1)
               {
                num_output_files++;
                if(num_output_files > 999)
                   {
                   printf("Too many files--%d.\nExiting program\n.",num_output_files);
                   exit(1);
                   }
                sprintf(output_file,"%s.%03d",filename,num_output_files);
                strcpy(oftest,output_file);
                p=oftest + strlen(oftest) - 3;
                while (1)
                 {
                  if (file_exists(oftest)) break;
                  if (p[0] != '0') break;
                  p[0]=p[1];
                  p[1]=p[2];
                  p[2]=0;
                 }
                if (!file_exists(oftest)) break;
                printf ("File %s exists. Skipping\n",oftest);
               }
              break;
             }
            if (c == 'O')
             {
              break;
             }
           }
         }
       }


      fp2 = fopen(output_file,"wb");
      if (fp2 == NULL)
         {
         printf("Cannot open %s for output\n",output_file);
         printf("Exiting the program.\n");
         printf("%d files created.\n",(num_output_files) - 1 );
         printf("Actual original filesize = %u bytes.\n",byte_count);
         exit(1);
         }
       } /*pbwrit==0 */

      block_write();

         if( inpleft == 0 )
            {
            close_out(fp2,output_file);
            check_extra_files();
            delete_file();
            exit(0);
            }
      if (pbwrit>=size)
       {
        if( normal == ON )
         copy_to_eol();

        close_out(fp2,output_file);
        pbwrit=0;pbread=0;
       } /*if (pbwrit>=size)*/
   bfx=0;bread=0;w=16384;
   bwrit=0;
      } /*while (inpleft>inplimit)*/
   while(1)
      {
      c = getc(fp1);
      if( c == EOF )
         {
         close_out(fp2,output_file);
         check_extra_files();
         delete_file();
         exit(0);
         }
     inpleft--;
     if (binary==ON || c != CTRL_Z)
     {
      lc=c;
      putc(c,fp2);
     }
    } /*while(1)*/
   } /*main(argc,argv)*/
/***************************************************************************/
 void set_switches()
  {
   for( p = switches ; (p - switches) < strlen(switches)  ; p++ )
      {
      if( *p == 's' )
         {
         strict = ON;
         normal = OFF;
         }
      else if( *p == 'b' )
         {
         strict = ON;
         normal = OFF;
         binary = ON;
         }
      else if ( *p == 'r' || *p == 'n')
         {
         normal = ON;
         strict = OFF;
         binary = OFF;
         }
      else if ( *p == 'p')
         {
         partition = ON;
         if(sscanf((p+1),"%d",&num_part) == 0 || num_part<=0)
            {
            printf("Invalid number of partitions.\n");
            exit(1);
            }
         }
      else if ( *p == 'w')
         {
         wait = ON;
         }
      } /*for( p = switches ...*/
  } /*void set_switches()*/
/***************************************************************************/
 void construct_output_filename()
    {
     p=outpath+strlen(outpath)-1;           /* ensure outpath properly terminated*/
     if (*p!='\\' && *p!=':')
      {
       *(p+1)='\\';
       *(p+2)=0;
      }

     if (filename[1]==':')                  /* strip disk/path from input filename*/
      {
      strcpy(fnwork,(filename+2));
      strcpy(filename,fnwork);
      }
    for (p=filename+strlen(filename);p>=filename;p--)
     {
      if (*p=='\\')
       {
       strcpy(fnwork,p+1);
       strcpy(filename,fnwork);
       break;
       } /*if*/
     } /* for (p=filename+strlen(filename),p>=filename,p--)*/
     if (strlen(outpath)+strlen(filename)<75)
     {
     strcpy(fnwork,outpath);
     strcat(fnwork,filename);
     strcpy(filename,fnwork);
     }
     else
      {
      printf("Syntax Error generating output filename\n");
      exit(8);
      }
    } /*void construct_output_filename()*/
/***************************************************************************/
void block_read()
   {
      while (pbread<size && bread<bfsiz && inpleft>inplimit && w==16384)
      {
       if (bfsiz>=bread+16384 && size>=pbread+16384 && inpleft>inplimit+16384)
        {
        w=fread(bfpa[bfx],1,16384,fp1);
        }
       else
       if (size-pbread>bfsiz-bread && inpleft-inplimit>bfsiz-bread)
       {
        w=fread(bfpa[bfx],1,(int)(bfsiz-bread),fp1);
       }
       else
       if (inpleft-inplimit>size-pbread)
       {
        w=fread(bfpa[bfx],1,(int)(size-pbread),fp1);
       }
       else
       {
        w=fread(bfpa[bfx],1,(int)(inpleft-inplimit),fp1);
       }
       if (ferror(fp1))
        {
         printf("File read error.\n");
         exit(8);
        }
       bfx++;
       bread+=(long)w;
       pbread+=(long)w;
       inpleft-=(long)w;
      } /* while (pbread<size && bread<bfsiz && inpleft>inplimit && w==16384)*/
   }/* void block_read()*/
/***************************************************************************/
 void block_write()
  {
      bfx=0;w=16384;
      bwrit=0;
      while (pbwrit<size && bwrit<bread && w==16384)
      {
       if (bread>=bwrit+16384 && size>=pbwrit+16384)
       {
        w=fwrite(bfpa[bfx],1,16384,fp2);
       }
       else
       if ((size-pbwrit)>(bread-bwrit))
        {
        w=fwrite(bfpa[bfx],1,(int)(bread-bwrit),fp2);
        lc=bfpa[bfx][w-1];
        }
       else
        {
        w=fwrite(bfpa[bfx],1,(int)(size-pbwrit),fp2);
        lc=bfpa[bfx][w-1];
        }
       if (ferror(fp2))
        {
         printf("File write error.\n");
         exit(8);
        } /*ferror(fp2)*/
       bfx++;
       bwrit+=(long)w;
       pbwrit+=(long)w;

      } /*while (pbwrit<size && bwrit<bread && w==16384)*/
  } /*void block_write()*/
/***************************************************************************/
 void copy_to_eol()
         {
         if (lc == LF) return;
         while(1)
          {
            c = getc(fp1);
            if( c == EOF )
               {
               close_out(fp2,output_file);
               check_extra_files();
               exit(0);
               }
           lc=c;
           inpleft--;
           putc(lc,fp2);
           pbwrit++;
           if (lc == LF) break;
          } /*while(1)*/
         } /*void copy_to_eol()*/
/***************************************************************************/
void help()
   {
   printf("Version %s -- 05/16/95\n",VERSION);
   printf("USAGE: %s FILENAME SIZE [OUTPATH] -SWITCHES\n\n",PROGNAME);
   printf("Written by W. J. Kennamer (74025,514) and released into the public domain.\n");
   printf("Enhanced by Edgar Swank <edgar@spectrx.saigon.com>.\n");
   printf("  FILENAME is any valid MS-DOS filename.  Wildcards are not supported.\n");
   printf("  Output file names will be FILENAME.001, FILENAME.002, etc.\n");
   printf("  Output files are always terminated with a carriage return and\n");
   printf("  a <ctrl>Z, UNLESS -b is specified.\n");
   printf("  SIZE is the desired file size for each new file.\n");
   printf("  OUTPATH is an optional disk/pathname (A: or \\path\\ or a:\\path\\)\n");
   printf("  to put output files on a different disk and/or directory from input file.\n");
   printf("  If using -p with OUTPATH, enter some dummy argument for SIZE.\n");
   printf("  SWITCHES must follow the FILENAME,SIZE and OUTPATH parameters,\n");
   printf("    and may be entered in any order.  Switches may be combined.\n");
   printf("Press any key to continue:\n");
    getchar();
   printf("  Valid SWITCHES are:\n");
   printf("ͻ\n");
   printf("   -b  binary     do not add cr/lf/^z to output files.          \n");
   printf("                    forces -s.                                  \n");
   printf("Ķ\n");
   printf("   -s  strict     chop file at exact SIZE boundary.             \n");
   printf("Ķ\n");
   printf("   -w  wait       wait after closing each output file.          \n");
   printf("                  can change output diskette if separate        \n");
   printf("                  from input.                                   \n");
   printf("Ķ\n");
   printf("   -r  return     chop file at first carriage return            \n");
   printf("                    following SIZE characters (default).        \n");
   printf("Ķ\n");
   printf("   -px partition  partition file into x equal units.            \n");
   printf("                    SIZE is ignored (and may be omitted) if     \n");
   printf("                    you choose this option.                     \n");
   printf("ͼ\n");
   }

/***************************************************************************/

void close_out(fp,filename)

FILE *fp;
char *filename;                    /* output file name                 */

   {
   long file_size;

   if (binary==OFF)
   {
   if (lc != LF)
    {
     putc(CR,fp);                    /* terminating CR */
     putc(LF,fp);                    /* terminating LF */
    }
   putc(CTRL_Z,fp);                /* terminate file with EOF mark    */
   }

   if( fseek(fp,0L,2) == -1 )         /* position at EOF                 */
                {
                printf("Error seeking end of output file.\n");
                exit(1);
                }
   file_size = ftell(fp);          /* report EOF position             */
   fclose(fp);
   printf("Created %s -- %ld bytes\n" , filename , file_size);
   if (wait==ON && inpleft>0)
    {
     printf("Press any key to continue.\n");
     getchar();
    }
   }

/***************************************************************************/
void delete_file()
 {
  int u;

  while (1)
   {
    printf("Delete/Wipe/Leave Input File? (D/W/L): ");
    c=toupper(getche());
    printf("\n");
    if (c=='D')
     {
        u=unlink(infile);
        if (u==0)
         {
          printf("%s Deleted.\n",infile);
         }
        else
         {
          derno=_doserrno;erno=errno;
          printf("Error Deleting %s.\n",infile);
          printf ("DOS ERROR %4X errno %d %s\n",derno,erno,sys_errlist[erno]);
         } /* endif */
       return;
     }
    if (c == 'W')
     {
      char *b,*c;
      int i;
      long fl;
      FILE *fp;
      fcloseall();
      b=bfpa[0];
      for (c=b,i=0;i<16384/2;i++,c+=2)
       {
        *(int *)c=rand();
       }

      fp=fopen(infile,"r+b");
      if (fp == NULL)
       {
        printf ("Can't open %s for wipe. Request Ignored.\n",infile);
        exit(8);
       }
      if( fseek(fp,0L,2) == -1 )         /* position at EOF                 */
                   {
                   printf("Error seeking end of input file.\n");
                   exit(1);
                   }
      fl=ftell(fp);
      rewind(fp);
      printf("Wiping file %s with random data..",infile);
      while (1)
       {
        if (fl < 16384)
         {
          fwrite(b,1,fl,fp);
          fcloseall();
          printf("\n");
          u=unlink(infile);
          if (u==0)
           {
            printf("%s Deleted.\n",infile);
           }
          else
           {
            derno=_doserrno;erno=errno;
            printf("Error Deleting %s.\n",infile);
            printf ("DOS ERROR %4X errno %d %s\n",derno,erno,sys_errlist[erno]);
           } /* endif */
         return;
         }
        else
         {
          fwrite(b,1,16384,fp);
          fl-=16384;
         }
       }
     }
    if (c == 'L')
     {
      return;
     }
   }
 }

void check_extra_files()
 {
  num_output_files++;
  if(num_output_files < 1000)
   {
    char oftest [80];
    char *p;
    sprintf(output_file,"%s.%03d",filename,num_output_files);
    strcpy(oftest,output_file);
    p=oftest + strlen(oftest) - 3;
    while (1)
     {
      if (file_exists(oftest))
       {
        printf ("WARNING: File %s exists. Delete? (y/n): ",oftest);
        c=toupper(getche());
        printf("\n");
        if (c == 'Y')
         {
          int u;
          u=unlink(oftest);
          if (u==0)
           {
            printf("%s Deleted.\n",oftest);
           }
          else
           {
            derno=_doserrno;erno=errno;
            printf("Error Deleting %s.\n",oftest);
            printf ("DOS ERROR %4X errno %d %s\n",derno,erno,sys_errlist[erno]);
           } /* endif */
         }

       }
      if (p[0] != '0') break;
      p[0]=p[1];
      p[1]=p[2];
      p[2]=0;
     }
   }
 }
int file_exists(char *filename)
 {
   return (access(filename, 0) == 0);
 }
