From:	IN%"lenoil@APPLE.COM"  "Robert Lenoil"  9-DEC-1988 16:24
To:	p150bk19@VB.CC.CMU.EDU
Subj:	AUTOSAVE.E

Received: from apple.com by VB.CC.CMU.EDU; Fri, 9 Dec 88 16:23 EST
Received: by apple.com (5.59/25-eef) id AA17206; Fri, 9 Dec 88 13:09:24 PST
Date: Fri, 9 Dec 88 13:09:24 PST
From: Robert Lenoil <lenoil@APPLE.COM>
Subject: AUTOSAVE.E
To: p150bk19@VB.CC.CMU.EDU
Message-Id: <8812092109.AA17206@apple.com>

/* The following copyright and trademark notice applies to some of the code
 * herein; all other material is Copyright (c) 1986, 1987 by Robert Lenoil,
 * with free copying allowed for any purpose, provided that this copyright
 * notice is included.
 */

/************************************************************************
* "Epsilon", "EEL" and "Lugaru" are trademarks of Lugaru Software, Ltd. *
*                                                                       *
*     Copyright (C) 1985 Lugaru Software Ltd.  All rights reserved.     *
*                                                                       *
* Limited permission is hereby granted to reproduce and modify this     *
* copyrighted material provided that the resulting code is used only in *
* conjunction with Lugaru products and that this notice is retained in  *
* any such reproduction or modification.                                *
************************************************************************/

/*
 * My Epsilon customizations
 */

#include <eel.h>

/* This file modifies the following Epsilon commands/procedures:
COMMAND              SOURCE FROM VERSION
make_mode               3.1
normal_character        3.1

   And adds the following commands/procedures:
COMMAND           WRITTEN FOR VERSION
auto_save_mode          3.1

   And defines the following globals:
GLOBAL            WRITTEN FOR VERSION
auto_save               3.1
auto_save_interval      3.1
*/

/* Implement auto-save */
buffer int auto_save = 0;
int auto_save_interval = 200;

command auto_save_mode()
{  auto_save = has_arg? (iter != 0) : auto_save? -auto_save : 1;
   make_mode();
   iter = 1;
}

/* NORMAL_CHARACTER modified to increment buffer typein count and perform
 * auto-save after auto-save-interval characters.  Modified from version 3.1
 * source.
 */
command normal_character()
{
   if (key >= 256) return;
   if (key == '\n') {
      insert('\n');
      if (auto_indent && indenter)
         (*indenter)();
   } else if (over_mode && point < size() && curchar() != '\n') {
      if (curchar() == '\t')
         tabs_to_spaces(point, point + 1);
      replace(point++, key);
   } else
      insert(key);
   if (auto_save > 0 && ++auto_save > auto_save_interval) {
      char savename[FNAMELEN];
      sayput("Auto saving. . .");
      strcpy(savename, *filename? filename : "autosave");
      strcpy(get_extension(savename), ".sav");
      say( "Auto saving. . . %s",
           file_write(savename, strip_returns)? "failed" : "done" );
      auto_save = modified = 1;
   }
}

/* MAKE_MODE modified to include auto-save mode.  Modified from version 3.1
 * source.
 */
make_mode()
{
   strcpy(mode, major_mode);
   if (fill_mode)
      strcat(mode, " Fill");
   if (auto_save > 0)
      strcat(mode, " Save");
   if (over_mode)
      strcat(mode, " Over");
   if (!strip_returns)
      strcat(mode, " NoTrans");
}
