/* ------------------------------------------------------------------------ */
/* ShowPix.C (C) CopyLeft Bill Buckels 1991-1999                            */
/* All Rights Reversed.                                                     */
/*                                                                          */
/* Licence Agreement                                                        */
/* -----------------                                                        */
/*                                                                          */
/* You have a royalty-free right to use, modify, reproduce and              */
/* distribute this source code in any way you find useful,                  */
/* provided that you agree that Bill Buckels has no warranty obligations    */
/* or liability resulting from said distribution in any way whatsoever.     */
/* If you don't agree, remove this source code from your computer now.      */
/*                                                                          */
/* Written by   : Bill Buckels                                              */
/*                589 Oxford Street                                         */
/*                Winnipeg, Manitoba, Canada R3M 3J2                        */
/*                                                                          */
/* Email: bbuckels@escape.ca                                                */
/* WebSite: http://www.escape.ca/~bbuckels                                  */
/*                                                                          */
/* Date Written : November 10, 1991                                         */
/* Purpose      : An MCGA File Viewer                                       */
/* Revision     : 2.0 Last Release                                          */
/* ------------------------------------------------------------------------ */
/* Written in Large Model Mix Power C Version 2.0                           */
/* ------------------------------------------------------------------------ */

/* writing direct to screen */
/* using bios calls to set the adapter */

#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <bios.h>
#include <conio.h>
#include <direct.h>
#include <malloc.h>
#include <fcntl.h>
#include <io.h>
#include <stdlib.h>

/* a group of handy definitions */

#define BLACK   0
#define BLUE    1
#define GREEN   2
#define CYAN    3
#define RED     4
#define MAGENTA 5
#define BROWN   6
#define WHITE   7
#define GRAY      8
#define LBLUE     9
#define LGREEN    10
#define LCYAN     11
#define LRED      12
#define LMAGENTA  13
#define YELLOW    14
#define BWHITE    15

#define ESCAPE  '\x1b'
#define TEXT     3
#define CGA_320  4
#define HERCULES 99

int ADAPTER = CGA_320;
int screen_mode = CGA_320;

#define BLANK     32
#define FAT       219

#define ENTERKEY   '\x0d' /* character generated by the Enter Key          */
#define ESCKEY     '\x1b' /* character generated by the Esc key            */
#define FUNCKEY    '\x00' /* first character generated by function keys    */
#define UPARROW    'H'    /* second character generated by up-arrow key    */
#define DOWNARROW  'P'    /* second character generated by down-arrow key  */
#define LTARROW    'K'    /* second character generated by left-arrow key  */
#define RTARROW    'M'    /* second character generated by right-arrow key */
#define PGUP       'I'    /* second character generated by page up key     */
#define PGDOWN     'Q'    /* second character generated by page down key   */

/* starting at character 59*/
#define F1         ';'    /* second character generated by numerical fkeys */
#define F2         '<'
#define F3         '='
#define F4         '>'
#define F5         '?'
#define F6         '@'
#define F7         'A'
#define F8         'B'
#define F9         'C'
#define F10        'D'
/* ending at character 68  */

#define CRETURN '\x0d'
#define LFEED   '\x0A'
#define CTRLZ   '\x1a'
#define DELETE  '\x7f'

#define SINGLE    218
#define DOUBLE    201

typedef unsigned char     uchar;
typedef unsigned int      uint;
typedef unsigned long     ulong;


char wildfiles[200][15];

int filecords[84][2]=
{
    2,  4,  2,  23,  2, 42,  2, 61,
    3,  4,  3,  23,  3, 42,  3, 61,
    4,  4,  4,  23,  4, 42,  4, 61,
    5,  4,  5,  23,  5, 42,  5, 61,
    6,  4,  6,  23,  6, 42,  6, 61,
    7,  4,  7,  23,  7, 42,  7, 61,
    8,  4,  8,  23,  8, 42,  8, 61,
    9,  4,  9,  23,  9, 42,  9, 61,
    10, 4, 10,  23, 10, 42, 10, 61,
    11, 4, 11,  23, 11, 42, 11, 61,
    12, 4, 12,  23, 12, 42, 12, 61,
    13, 4, 13,  23, 13, 42, 13, 61,
    14, 4, 14,  23, 14, 42, 14, 61,
    15, 4, 15,  23, 15, 42, 15, 61,
    16, 4, 16,  23, 16, 42, 16, 61,
    17, 4, 17,  23, 17, 42, 17, 61,
    18, 4, 18,  23, 18, 42, 18, 61,
    19, 4, 19,  23, 19, 42, 19, 61,
    20, 4, 20,  23, 20, 42, 20, 61,
    21, 4, 21,  23, 21, 42, 21, 61,
    22, 4, 22,  23, 22, 42, 22, 61};

int getfiles(char *filetype0, char *filetype1, char *filetype2)
{
  char buffer[15];
  int wildcounter = 0;
  int idx;
  
  struct ffblk wild_card;
  
  memset(wildfiles, 0, sizeof(wildfiles));

  for (idx = 0; idx < 3; idx++) {
    switch(idx) {
      case 0:
        sprintf(buffer, "*.%s", filetype0);break;
      case 1:
        sprintf(buffer, "*.%s", filetype1);break;
      case 2:
        sprintf(buffer, "*.%s", filetype2);break;
    }
    if(findfirst(buffer, &wild_card, FA_NORMAL) == 0) {
      strcpy(wildfiles[wildcounter], wild_card.ff_name);
      wildcounter++;
    
      while(findnext(&wild_card) == 0) {
        strcpy(wildfiles[wildcounter], wild_card.ff_name);
        wildcounter++;
      }
    }
  }
  
  if(wildcounter > 1)qsort(wildfiles, wildcounter, 15, strcmp);
  return wildcounter;
}

unsigned char rgbinfo[256][3];
#define MCGA '\x13'

unsigned char setcrtmode(unsigned char vidmode)
{
  union REGS inregs, outregs;
  
  /* set mode */
  inregs.h.ah = 0;
  inregs.h.al = vidmode;
  int86(0x10, &inregs, &outregs);
  
  /* get mode */
  inregs.h.ah = 0xf;
  int86(0x10, &inregs, &outregs);
  
  /* return mode */
  return outregs.h.al;
  
}


int loadpalette()
{
  union REGS regs;
  struct SREGS segregs;
  
  regs.h.ah = 0x10;                    /* fuction 10h */
  regs.h.al = 0x12;
  /* subfunction 12h - set block of color registers */
  regs.x.bx = 0;                       /* start with this reg */
  regs.x.cx = 256;                     /* do this many */
  regs.x.dx = (unsigned int)rgbinfo;   /* offset to array */
  segregs.es = (unsigned int)((long)rgbinfo >> 16);
  /* segment of array */
  int86x(0x10, &regs, &regs, &segregs);/* dump data to color registers */
  
  return 0;
  
}

/* type conversion functions */
unsigned int byteword(unsigned char a, unsigned char b){
  return b << 8 | a;
}
unsigned char lsb(unsigned int word){
  return word &0xff;
}
unsigned char msb(unsigned int word){
  return word >> 8;
}

int checkforpcx(unsigned char *pcxheader)
{
  unsigned int zsoft,version,codetype,pixbits;
  unsigned int xmin, ymin, xmax, ymax;
  unsigned int hres, vres;
  unsigned int no_planes, bytesperline;
  int invalid = - 1, valid = 0, status = valid;
  
  /* read the file header */
  
  zsoft = pcxheader[0];
  version = pcxheader[1];
  codetype = pcxheader[2];
  pixbits = pcxheader[3];
  
  if(zsoft != 10)        status = invalid;
  if(version != 5)       status = invalid;
  if(codetype != 1)      status = invalid;
  if(pixbits != 8)      status = invalid;
  
  xmin = byteword(pcxheader[4], pcxheader[5]);
  ymin = byteword(pcxheader[6], pcxheader[7]);
  xmax = byteword(pcxheader[8], pcxheader[9]);
  ymax = byteword(pcxheader[10], pcxheader[11]);
  no_planes = pcxheader[65];
  bytesperline = byteword(pcxheader[66], pcxheader[67]);
  
  
  if(xmin != 0)       status = invalid;
  if(ymin != 0)       status = invalid;
  if(xmax != 319)       status = invalid;
  if(ymax != 199)       status = invalid;
  if(no_planes != 1)      status = invalid;
  if(bytesperline != 320)status = invalid;
  return status;
  
}


int BVXREAD(char *filename)
{
  char buffer[66];
  char buffer1[66];
  char buffer2[66];
  char *wordptr, *bufptr, *ptr;
  int fh, fh2;
  
  strcpy(buffer, filename);
  wordptr = strtok(buffer, ". \n");
  sprintf(buffer1, "%s.MCG", buffer);
  sprintf(buffer2, "%s.RGB", buffer);
  
  if((fh = open(buffer1, O_RDONLY | O_BINARY)) == - 1) {
    return - 1;
  }
  if((fh2 = open(buffer2, O_RDONLY | O_BINARY)) == - 1) {
    close(fh);
    return - 1;
  }
  
  memset((char *)0xa0000000l, 0, (unsigned)64000);
  read(fh2, (char *)&rgbinfo[0][0], 7);
  read(fh2, (char *)&rgbinfo[0][0], 768);
  close(fh2);
  loadpalette();
  
  read(fh, buffer, 7);
  read(fh, (char *)0xa0000000l, 64000);
  close(fh);
  
  return 0;
}


int VCXREAD(char *pcxfilename)
{
  unsigned int byteoff = 0,packet,width = 0;
  int fh,status;
  unsigned char *packbuffer;
  unsigned char byte,bytecount;
  unsigned char *ptr,*ptr2;
  unsigned int temp;
  unsigned int target;
  int x,y;
  
  if((packbuffer = malloc(65000l)) == NULL)return - 1;
  if((fh = open(pcxfilename, O_RDONLY | O_BINARY)) == - 1) {
    free(packbuffer);
    return - 1;
  }
  
  target = read(fh, packbuffer, 65000l);
  close(fh);
  ptr2 = (unsigned char *)&packbuffer[0];
  
  if((status = checkforpcx(ptr2)) != - 1) {
    memset((char *)0xa0000000l, 0, (unsigned)64000);
    
    /* read the palette */
    target -= 769;
    ptr2 = (char *)&packbuffer[target];
    while((temp = *ptr2++) != 12);
    for(y = 0;y < 256;y++)
      for(x = 0;x < 3;x++) {
      temp = *ptr2++;
      temp >>= 2;
      rgbinfo[y][x] = temp;
    }
    
    loadpalette();
    ptr = (unsigned char *)0xa0000000l;
    ptr2 = (unsigned char *)&packbuffer[128];
    
    do {
      bytecount = 1;                   /* start with a seed count */
      byte = *ptr2++;
      
      /* check to see if its raw */
      if(0xC0 == (0xC0 &byte)) {
        /* if its not, run encoded */
        bytecount = 0x3f &byte;
        byte = *ptr2++;
      }
      for(packet = 0;packet < bytecount;packet++) {
        *ptr++ = byte;
        byteoff++;
      }
    }while(byteoff < 64000l);
  }
  free(packbuffer);
  return(status);
}


/* ---------------------------------------------------------------------- */
/* Added BMP support                                                      */
/* ---------------------------------------------------------------------- */

// translate a 16 color line  to an svga line
void Vga2Svga(unsigned char *src, unsigned char *dest,unsigned width)
{
     int i,j;

     j=0;
     for(i=0;i<width;i++)
     {
        dest[j] = src[i]>>4;  j++;
        dest[j] = src[i]&0xf; j++;
     }
}

// translate a 2 color line to an svga line
void Mono2Svga(unsigned char *src, unsigned char *dest,unsigned width)
{
     int i,j,k;
     uchar msk[]={0x80,0x40,0x20,0x10,0x8,0x4,0x2,0x1};

     j=0;
     for(i=0;i<width;i++)
     {

        for(k=0;k<8;k++)
        {
            if(src[i]&msk[k])dest[j] = 1;  /* Foreground */
            else dest[j] = 0;              /* BackGround */
            j++;
        }
     }
}

/* Windows BMP structures and constants */

#define SVGA     256
#define VGA      16
#define MONO     2
#define PIXEL    1

typedef struct
{
    uchar    rgbBlue;
    uchar    rgbGreen;
    uchar    rgbRed;
    uchar    rgbReserved;
} RGBQUAD;

typedef struct
{
    ulong   biSize;
    ulong   biWidth;
    ulong   biHeight;
    uint    biPlanes;
    uint    biBitCount;
    ulong   biCompression;
    ulong   biSizeImage;
    ulong   biXPelsPerMeter;
    ulong   biYPelsPerMeter;
    ulong   biClrUsed;
    ulong   biClrImportant;
} BITMAPINFOHEADER;

// constants for the biCompression field
#define BI_RGB      0L
#define BI_RLE8     1L
#define BI_RLE4     2L

typedef struct
{
    BITMAPINFOHEADER bmiHeader;
    RGBQUAD          bmiColors[256];
} BITMAPINFO;

typedef struct
{
    uchar   bfType[2];
    ulong   bfSize;
    uint    bfReserved1;
    uint    bfReserved2;
    ulong   bfOffBits;
} BITMAPFILEHEADER;

/* globals required for BMP */
BITMAPFILEHEADER BitMapFileHeader;
BITMAPINFO       bmp;

/* ---------------------------------------------------------------------- */
/* Read a 256 Color 320 x 200 BMP File Into a screen buffer.              */
/* Also, 16 color and 2 color.                                            */
/* ---------------------------------------------------------------------- */
int BMPREAD(uchar *lpszBmpFile)
{
    FILE *fp;
    int i;
    ulong dwSeekSize;
    uint wHres,wVres,wXoff,wYoff;
    char szScanLine[360];
    uchar far *bmpbuffer = (uchar far *)0xa0000000L;

    int iFormat,
        iByteBoundary,
        iPalColors,
        iDivisor;

    if((fp=fopen(lpszBmpFile,"rb"))==NULL)return -1;

    // read the header stuff into the appropriate structures
    fread((char *)&BitMapFileHeader.bfType,
	             sizeof(BITMAPFILEHEADER),1,fp);
    fread((char *)&bmp.bmiHeader.biSize,
                 sizeof(BITMAPINFO),1,fp);

    if(bmp.bmiHeader.biCompression!=BI_RGB ||
       bmp.bmiHeader.biWidth != 320L ||
       bmp.bmiHeader.biHeight != 200L)
       {
        fclose(fp); return -1;
       }

    iFormat = 0;
    if(bmp.bmiHeader.biPlanes==1 && bmp.bmiHeader.biBitCount==8)
    {
       iFormat        = SVGA;
       iByteBoundary  = 4 * PIXEL;
       iPalColors     = SVGA;
       iDivisor       = PIXEL;
    }
    if(bmp.bmiHeader.biPlanes==1 && bmp.bmiHeader.biBitCount==4)
    {
       iFormat       = VGA;
       iByteBoundary = 8 * PIXEL;
       iPalColors    = VGA;
       iDivisor      = 2 * PIXEL;
    }
    if(bmp.bmiHeader.biPlanes==1 && bmp.bmiHeader.biBitCount==1)
    {
       iFormat       = MONO;
       iByteBoundary = 32 * PIXEL;
       iPalColors    = MONO;
       iDivisor      = 8 * PIXEL;
    }

    if(iFormat == 0)
    {
        fclose(fp);
        return -1;
    }

    memset((char *)0xa0000000l, 0, (unsigned)64000);

    for(i=0;i<iPalColors;i++)
    {
       rgbinfo[i][0]=bmp.bmiColors[i].rgbRed  >>2;
       rgbinfo[i][1]=bmp.bmiColors[i].rgbGreen>>2;
       rgbinfo[i][2]=bmp.bmiColors[i].rgbBlue >>2;
    }

    loadpalette();

    wHres = (uint )bmp.bmiHeader.biWidth;
    while(wHres%iByteBoundary!=0)wHres++;
    wVres = (uint )bmp.bmiHeader.biHeight;

    dwSeekSize =  0L;
    dwSeekSize += BitMapFileHeader.bfOffBits;

    // our palette will not always be a full 256 colors...
    // even in some 256 color images

    fseek(fp,dwSeekSize,SEEK_SET);
    for(i=wVres;i>0;i--)
    {
      fread(szScanLine,wHres/iDivisor,1,fp);
      switch(iFormat)
       {
         case MONO:  Mono2Svga(szScanLine, &bmpbuffer[(i-1)*320],
                               wHres/iDivisor);
                               break;
         case VGA:   Vga2Svga(szScanLine, &bmpbuffer[(i-1)*320],
                               wHres/iDivisor);
                               break;
         default:    memcpy(&bmpbuffer[(i-1)*320],szScanLine, 320);
                               break;

        }
    }
    fclose(fp);

return 0;
}



void cursoroff(void)
{
  union REGS regs;
  
  regs.h.ah = 0x01;
  regs.x.cx = 0x2000;
  int86(0x10, &regs, &regs);
}


void cursoron(void)
{
  union REGS regs;
  
  regs.h.ah = 0x01;
  regs.x.cx = 0x0607;
  int86(0x10, &regs, &regs);
}


void cls(int BACK, int FRONT)
{
  union REGS reg;
  
  reg.h.ah = 6;
  reg.h.al = 0;
  reg.h.ch = 0;
  reg.h.cl = 0;
  reg.h.dh = 24;
  reg.h.dl = 79;
  reg.h.bh = (BACK << 4) + FRONT;
  int86(0x10, &reg, &reg);
}



void DMC(int Row, int Column, unsigned BYTE, int BACK, int FRONT, int QUANT)
{
  /*  DMA replacement for writechs function */
  
  unsigned segment = 0xB000, offset;
  int One_Too_Many = (QUANT + 1);
  int i, Attribute;
  
  Attribute = (BACK << 4) + FRONT;
  
  if(ADAPTER != HERCULES)segment = 0xB800;
  /* CGA or Equivalent */
  offset = 160 * Row + 2 * Column ;
  for(i = 1; i < One_Too_Many ; i++) {
    poke(segment, offset, BYTE | Attribute << 8);
    offset += 2;
  }
}


void DMM(char *String, int Row, int Column, int BACK, int FRONT)
{
  /*  DMA replacement for puts
  centre justified string    */
  
  unsigned Character, segment = 0xB000, offset;
  int Attribute;
  
  Attribute = (BACK << 4) + FRONT;
  
  Column = ((Column + 1) - (.5*(strlen(String))));
  
  if(ADAPTER != HERCULES)segment = 0xB800;
  /* CGA or Equivalent */
  offset = 160 * Row + 2 * Column ;
  while((Character = *String++) != 0) {
    if(Character != '\n') {
      poke(segment, offset, Character | Attribute << 8);
      offset += 2;
    }
  }
}


void DML(char *String, int Row, int Column, int BACK, int FRONT)
{
  /*  DMA replacement for puts
  left justified string    */
  unsigned Character, segment = 0xB000, offset;
  int Attribute;
  
  Attribute = (BACK << 4) + FRONT;
  
  if(ADAPTER != HERCULES)segment = 0xB800;
  /* CGA or Equivalent */
  offset = 160 * Row + 2 * Column ;
  while((Character = *String++) != 0) {
    if(Character != '\n') {
      poke(segment, offset, Character | Attribute << 8);
      offset += 2;
    }
  }
}


void PAINT(int *cor, int fore, int bk, unsigned char Character)
{
  int trow = cor[0],tcol = cor[1],brow = cor[2],bcol = cor[3];
  int index,linelength = ((bcol + 1) - (tcol));
  for(index = (trow); index < brow + 1; index++)
    DMC(index, tcol, Character, bk, fore, linelength);
}

void BORDERBOX(int *cor, int fore, int bk, unsigned char BRDR)
{
  int trow = cor[0],tcol = cor[1],brow = cor[2],bcol = cor[3];
  /* draws an outline only using a specified border character */
  int index;
  int homerow = (brow - 1);
  int homecol = (tcol + 1);
  int linelength = ((bcol) - (tcol + 1));
  
  int TLcorner,TRcorner,BLcorner,BRcorner,HORT,VERT;
  
  switch(BRDR) {
    case DOUBLE: { 
    TLcorner = 201;
    TRcorner = 187;
    BLcorner = 200;
    BRcorner = 188;
    HORT = 205;
    VERT = 186;
    break;
  }
    case SINGLE: { 
    TLcorner = 218;
    TRcorner = 191;
    BLcorner = 192;
    BRcorner = 217;
    HORT = 196;
    VERT = 179;
    break;
  }
    default: {    
    TLcorner = BRDR;
    TRcorner = BRDR;
    BLcorner = BRDR;
    BRcorner = BRDR;
    HORT = BRDR;
    VERT = BRDR;
  }
  }
  DMC(trow, tcol, TLcorner, bk, fore, 1);
  /* top */
  DMC(trow, homecol, HORT, bk, fore, linelength);
  DMC(trow, bcol, TRcorner, bk, fore, 1);
  for(index = (trow + 1); index < brow; index++) {
    DMC(index, tcol, VERT, bk, fore, 1);
    DMC(index, bcol, VERT, bk, fore, 1);
  }
  DMC(brow, tcol, BLcorner, bk, fore, 1);
  DMC(brow, homecol, HORT, bk, fore, linelength);
  DMC(brow, bcol, BRcorner, bk, fore, 1);
  /* bottom */
}



unsigned char far *crt    =(unsigned char *) 0xB8000000l;

void getadaptertype(void)
{
  if(((biosequip() >> 4) &3) < 3)ADAPTER = CGA_320;
  else {
    ADAPTER = HERCULES;
    crt = (unsigned char far *)0xb0000000l;
  }
}


unsigned char far *textscreen;
void initgraphbuffers()
{
  textscreen = _fmalloc(4000);
}

void freegraphbuffers()
{
  _ffree(textscreen);
  
}

void bronx(void)
{
  sound(60, 4);
  sound(40, 8);
}


/* THE LOADER */
int vux(char *picfile)
{
  int status = 0;
  char c;
  char buffer[66];
  
  strcpy(buffer, picfile);
  
  memcpy(textscreen, crt, 4000);
  if((setcrtmode(MCGA)) != MCGA) {
    cls(BLACK, WHITE);
    bronx();
    puts("VGA or MCGA adapter required...press any key");
  }
  else {
    if((status = VCXREAD(buffer)) != 0) {
      if((status = BMPREAD(buffer)) != 0) {
        status = BVXREAD(buffer);
      }
    }
  }
  if(!status)
    while((c = getch()) != 27)
      {
        if (c==0)
          getch();
      }
  else bronx();
  
  setcrtmode(TEXT);
  cursoroff();
  memcpy(crt, textscreen, 4000);
  return 0;
  
}

int displayfiles(char *filetype0, char *filetype1, char *filetype2)
{
  int i;
  int hotfile = 0;
  int coldfile = 0;
  int filecount = getfiles(filetype0, filetype1, filetype2);
  char c;
  int background = BLUE, foreground = LCYAN;
  int cor[4];
  int breverse = BLACK,freverse = BWHITE;

  if(ADAPTER == HERCULES) {
    breverse = WHITE;
    freverse = BLACK;
  }
  
  if(filecount == 0){
    printf("No files of type %s, %s or %s in current directory.\n",
            filetype0, filetype1, filetype2);
    return 1;
  }
  cls(background, foreground);
  cursoroff();
  
  cor[0] = 0;
  cor[1] = 0;
  cor[2] = 24;
  cor[3] = 79;
  
  BORDERBOX(cor, foreground, background, DOUBLE);
  DMC(0, 1, 1, background, foreground, 78);
  DMM(
    " SHOWPIX(C) CopyLeft Bill Buckels 1991-1999 * MCGA .BMP/.PCX/.MCG Viewer ",
    0, 39, background, foreground);
  DMM(
    
    " Use Arrow Keys To Select * Press Enter To View | Press ESCape to Exit ", 
    24, 39, background, foreground);
  
  
  if(filecount > 84)filecount = 84;
  
  
  for(i = 0;i < filecount;i++)
    DML(wildfiles[i], filecords[i][0], filecords[i][1], 
      background, foreground);
  DML(wildfiles[hotfile], filecords[hotfile][0], filecords[hotfile][1], 
    breverse, freverse);
  
  while((c = getch()) != ESCKEY) {
    if(c == ENTERKEY)vux(wildfiles[hotfile]);
    if(c == FUNCKEY) {
      c = getch();
      switch(c) {
        case UPARROW  : if(hotfile < 4)break;
        hotfile -= 4;
        break;
        
        case DOWNARROW: if(hotfile > (filecount - 5))break;
        hotfile += 4;
        break;
        
        case RTARROW  :
        if(hotfile < (filecount - 1))
          hotfile++;
        break;
        
        case LTARROW  : if(hotfile == 0)break;
        hotfile--;
        break;
        case PGUP     :
        case PGDOWN   : break;
      }
    }
    if(hotfile != coldfile) {
      DML(wildfiles[coldfile], 
        filecords[coldfile][0], filecords[coldfile][1], 
        background, foreground);
      DML(wildfiles[hotfile], 
        filecords[hotfile][0], filecords[hotfile][1], 
        breverse, freverse);
      coldfile = hotfile;
    }
  }
  
  cursoron();
  cls(BLACK, WHITE);
  return 0;
  
}


main(int argc, char **argv)
{
  getadaptertype();
  initgraphbuffers();
  displayfiles("BMP", "MCG", "PCX");
  freegraphbuffers();
  exit(0);
  
}
