/* Copyright (C) Stephen Chung, 1991-1993.  All rights reserved. */

#include <stdio.h>

typedef struct {
	unsigned char strokes;
    unsigned char bushu;
    unsigned short int index;
    unsigned char grade;
    unsigned char on:4;
    unsigned char kun:4;
    unsigned char unknown:4;
    unsigned char meanings:4;
    unsigned char padding;           /* To pad it to 32-bits */
    unsigned long int offset;
} KINFORECORD;

typedef struct {
    unsigned char strokes;
    unsigned char bushu;
    short int index;
} IDXRECORD;

IDXRECORD rec[7000];


int BushuStrokes(IDXRECORD *s1, IDXRECORD *s2)
{
    if (s1->bushu == s2->bushu) {
        if (s1->strokes == s2->strokes) {
            return (s1->index - s2->index);
        } else {
            return (s1->strokes - s2->strokes);
        }
    } else {
        return (s1->bushu - s2->bushu);
    }
}



int StrokesBushu(IDXRECORD *s1, IDXRECORD *s2)
{
    if (s1->strokes == s2->strokes) {
        if (s1->bushu == s2->bushu) {
            return (s1->index - s2->index);
        } else {
            return (s1->bushu - s2->bushu);
        }
    } else {
        return (s1->strokes - s2->strokes);
    }
}


short int IndexToJIS(int index)
{
    int div, rem;
    short int ch;

    div = index / 94;
    rem = index % 94;

    ch = (div << 8) | rem;
    ch += 0x3021;

    return (ch);
}



main()
{
    long int i, j;
    FILE *ifp, *ofp;
    KINFORECORD record;
    int num;

    ifp = fopen("kinfo.dat", "rb");

    fseek(ifp, 0L, 0);
    fread(&record, sizeof(KINFORECORD), 1, ifp);
	num = record.offset / sizeof(KINFORECORD);

    printf("%d records...\n", num);

    fseek(ifp, 0L, 0);

    for (i = j = 0; i < num; i++) {
        if (i % 10 == 9) printf("Record #%d...\r", i);
        fread(&record, sizeof(KINFORECORD), 1, ifp);
        if (record.strokes <= 0 || record.bushu <= 0) continue;

        rec[j].index = IndexToJIS(i);
        rec[j].bushu = record.bushu;
        rec[j].strokes = record.strokes;
        j++;
    }

    num = j;

    printf("%d records indexed\n", j);

    fclose(ifp);

    printf("Creating index...\n");

    ofp = fopen("kinfo.idx", "wb");

    printf("Sorting Bushu / Strokes...\n");

    qsort(rec, num, sizeof(IDXRECORD), StrokesBushu);

    fseek(ofp, 0L, 0);
    fwrite(rec, sizeof(IDXRECORD), num, ofp);

    printf("Sorting Strokes / Bushu...\n");

    qsort(rec, num, sizeof(IDXRECORD), BushuStrokes);

    fwrite(rec, sizeof(IDXRECORD), num, ofp);

    fclose(ofp);
}
