/******************************************************************************
* Module    :   Parser header file.
*
* Author    :   John W. M. Stevens
******************************************************************************/

#if ! defined(PARSER_HEADER_FILE)
#define     PARSER_HEADER_FILE

#include    "regexp.h"
#include    "uudec.h"

#define PRS_NO_SEGMENT  -1L     /*  Found end of file before SEGMENT begin. */
#define PRS_NO_ID_STR   -2L     /*  Did not find an ID string.              */
#define PRS_NO_UU_LN    -3L     /*  Did not find a UU line in SEGMENT.      */
#define PRS_NO_BEGIN    -4L     /*  Did not find expected uuencode begin.   */
#define PRS_NO_SEG_NUM  -5L     /*  Did not find a SEGMENT number.          */
#define PRS_NO_NUM_SEGS -6L     /*  Did not find total number of SEGMENTs.  */
#define PRS_UNX_END_SEG -7L     /*  Found unexpected end of segment.        */

/*  Part numbering parsing RE's.    */
typedef struct  {
    char            *ReExpStr;  /*  RE source string.                   */
    int             IDStr;      /*  Sub-Expr. number for ID string.     */
    int             SegNo;      /*  Sub-Expr. for segment number.       */
    int             NoSegs;     /*  Sub-Expr. for number of segments.   */
    int             AltIDStr;   /*  Sub-Expr. for alternate ID string.  */
    CASE_CMP        Case;       /*  Case sensitivity switch.            */
    REG_EXP_NODE    *ReExpr;    /*  Pointer to compiled RE.             */
} PART_RE;

/*  Subject line structure. */
typedef struct  {
    char            *ReExprStr; /*  Pointer to RE source string.        */
    PART_RE         *IdParts;   /*  List of part number parsing RE's.   */
    REG_EXP_NODE    *ReExpr;    /*  Pointer to compiled RE.             */
} IDENT;

/*  Segment RE structure.   */
typedef struct  {
    char            *ReExprStr; /*  Pointer to RE source string.        */
    IDENT           *Header;    /*  Header ID regular expressions.      */
    IDENT           *Body;      /*  Body ID regular expressions.        */
    REG_EXP_NODE    *ReExpr;    /*  Pointer to compiled RE.             */
} SEGMENT;

/*  Define a structure to store the results of the first pass.  */
typedef struct  {
    char        *SrcFlNm;   /*  Source file name.                       */
    long        SegOfs;     /*  Offset of begining of segment.          */
    long        UUOfs;      /*  Offset of first UU line in segement.    */
    int         Exists;     /*  Segment exists.                         */
    int         SegNo;      /*  Segment number.                         */
    int         SegLstOrd;  /*  Segment list ordinal.                   */
} SEGS;

/*  File list structure.    */
typedef struct  {
    char        *IDString;  /*  Pointer to SEGMENT ID string.           */
    char        *FlName;    /*  File name.                              */
    int         Success;    /*  Successful unpost flag.                 */
    int         NoSegs;     /*  Number of segments in binary.           */
    CRC_TYPE    PostCRC;    /*  POST CCITT CRC.                         */
    int         ChkCRC;     /*  Flag to check CRC.                      */
    SEGS        *Segs;      /*  Pointer to list of segment desc.        */
} FL_LIST;

/*  Segment information.    */
typedef struct  {
    int         NoSegs;
    int         SegNo;
    long        SegOfs;
    long        UUOfs;
    CRC_TYPE    PostCRC;
    int         ChkCRC;
    char        *IDString;
    char        *FlName;
} SEG_INFO;

/*  Function prototypes.    */
extern
int     GetBinFlNm(FILE     *InFlPtr,
                   char     **RetStrs,
                   char     *FlName);
extern
int     MatchEnd(char   *Line);
extern
int     MatchBegin(char     *Line,
                   char     ***RetStrs);
extern
int     MatchSegment(char       *Line,
                     IDENT      **Hdr,
                     IDENT      **Body);
extern
long    Parse(FILE      *InFlPtr,
              char      *SegLine,
              char      *IDLine,
              SEG_INFO  *SegInfo);
extern
void    SetSegBegin(char    *SegType);
extern
void    LoadCfg(char   *CfgFlNm);
extern
void    ParseInit(void);

#endif
