/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/
/*
  src_fun.c
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include "str_fun.h"
#include "ix02_fun.h"
#include "fl_ut.h"
#include "src_fun.h"
#include "l_menu.h"
#include "abbruch.h"
#include "keycodes.h"

 extern char fehlermeldung[250];
 extern char quell_name[];
 extern char quell_pix_name[];
 extern char wrtxtbu[WRTXTBU_LEN];

 extern quell_rec one_quell_rec;
 quellpix_rec ix_quell_rec;
 extern config_set one_config_set;


 FILE * ix_quell;
 FILE * dat_quell;
 extern FILE * ix02file;

void journal_menu(char * z_kennung)
{
     int taste, schleife_ok;
     static char eingabe_zeile[ZEITSCHRIFT_LEN + 2];
     int eingabe_taste;

     schleife_ok = 1;
     do
     {
        taste = lotus_menu(JOURNAL_MENU_TXT01);
        if (taste == 0) schleife_ok = 0;
        if (taste == 2) enter_journal_names(z_kennung);
        if (taste == 1)
        {
             do
             {

                sc_gotoxy(1,one_config_set.sl-1);
                info_zeile("Substring of journal name to select or empty field to view all JOURNAL names");

                strcpy(wrtxtbu,"Substring..........");
                wrtxt(wrtxtbu);
                eingabe_taste = e_zle(
                            1+strlen(wrtxtbu),
                            one_config_set.sl-1,
                            eingabe_zeile,
                            80-strlen(wrtxtbu)-3,
                            ZEITSCHRIFT_LEN-1,
                            0
                         );
                sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
                if (eingabe_taste==ESC_KEY) break;
             } while (eingabe_taste!=ENTER_KEY && eingabe_taste != F10_KEY);
             if (eingabe_taste==ESC_KEY) return;
             upper(eingabe_zeile);
             if (taste == 1) show_journal_names(eingabe_zeile);
        }

          if (taste == 3)
          {
             delete_quell();
          }

     } while (schleife_ok);
}


void show_journal_names(const char * suchmuster)
{
    int taste;
    long anzahl_quell, i, j;
    long rec_zeiger, byte_zeiger;
    quellpix_rec ix_quell_rec_lokal;
    char test_zeile[ZEITSCHRIFT_LEN +1];
    char ausgabe_zeile[SCREENLINE_LEN +1];
    int gezeigte_src; 

    cls_line("");
    wrtxt("Searching journal names ..."); sc_gotoxy(1,one_config_set.sl-1);
    if (!isfile (quell_pix_name))
    {
       beeps();
       sc_clreol();
       wrtxt("\n[No JOURNAL INDEX file found]>");
       sc_clreol();
       tastelesen();
       return;
    }
    if (filesize(quell_pix_name) < sizeof(ix_quell_rec_lokal))
    {
       beeps();
       sc_clreol();
       wrtxt("\n[No JOURNAL names found]>");
       sc_clreol();
       tastelesen();
       return;
    }

    if ((dat_quell=fopen(quell_name,"rb"))==NULL)
    {
       sprintf(fehlermeldung,"ERROR: Cannot open for reading %s",quell_name);
       beenden(fehlermeldung,1);
    }
    read_ix02(quell_pix_name);
    anzahl_quell =lastkey02(&ix_quell_rec_lokal);
    i=firstkey02(&ix_quell_rec_lokal);
    rec_zeiger = ix_quell_rec_lokal.quell_rptr;
    byte_zeiger = rec_zeiger * sizeof(one_quell_rec);
    fseek(dat_quell,byte_zeiger,SEEK_SET);
    fread(&one_quell_rec,sizeof(one_quell_rec),1,dat_quell);
    j = 1;
    /* added Nov 21 2000 (begin) */
    gezeigte_src = 0;
    /* added Nov 21 2000 (end) */
    if (strlen(suchmuster) > 0)
    {
       strncpy(test_zeile,one_quell_rec.quell_zeitschrift,ZEITSCHRIFT_LEN);
       upper(test_zeile);
       if (is_substring(suchmuster,test_zeile))
       {
          sprintf(ausgabe_zeile,"%-4s: ",one_quell_rec.quell_kuerzel);
          strncat(ausgabe_zeile,one_quell_rec.quell_zeitschrift,SCREENLINE_LEN-8);
          ausgabe_zeile[SCREENLINE_LEN] = '\0';
          sprintf(wrtxtbu,"%-78s\n",ausgabe_zeile);
          wrtxt(wrtxtbu);
          j++;
          /* added Nov 21 2000 (begin) */
          gezeigte_src++;
          /* added Nov 21 2000 (begin) */
       }
    }
    else
    {
          sprintf(ausgabe_zeile,"%-4s: ",one_quell_rec.quell_kuerzel);
          strncat(ausgabe_zeile,one_quell_rec.quell_zeitschrift,SCREENLINE_LEN-8);
          ausgabe_zeile[SCREENLINE_LEN] = '\0';
          sprintf(wrtxtbu,"%-78s\n",ausgabe_zeile);
          wrtxt(wrtxtbu);
          j++;
          /* added Nov 21 2000 (begin) */
          gezeigte_src++;
          /* added Nov 21 2000 (begin) */
    }
    for (i=1;i<=anzahl_quell;i++)
    {
       if ((j % (one_config_set.sl-3))==0)
       {
         wrtxt("\n");
         taste = lotus_menu(
            "NextPage$Show the next page of text@"
            "Cancel$Finish viewing the current text"
                           );
         if (taste==0 || taste==2)
         {
            sc_gotoxy(1,one_config_set.sl-2); break;
         }
         j++;
       }
       if (fread(&ix_quell_rec_lokal,sizeof(ix_quell_rec_lokal),1,ix02file)==0)
       {
           sc_gotoxy(1,one_config_set.sl);sc_clreol();sc_gotoxy(1,one_config_set.sl-1);
           beeps();
           wrtxt("[Unexpected ERROR in show_journal_names(), cannot read more journal names]>");
           tastelesen();
           sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
       }
       rec_zeiger = ix_quell_rec_lokal.quell_rptr;
       byte_zeiger = rec_zeiger * sizeof(one_quell_rec);
       fseek(dat_quell,byte_zeiger,SEEK_SET);
       fread(&one_quell_rec,sizeof(one_quell_rec),1,dat_quell);
       if (strlen(suchmuster) > 0)
       {
          strncpy(test_zeile,one_quell_rec.quell_zeitschrift,ZEITSCHRIFT_LEN);
          upper(test_zeile);
          if (is_substring(suchmuster,test_zeile))
          {
             sprintf(ausgabe_zeile,"%-4s: ",one_quell_rec.quell_kuerzel);
             strncat(ausgabe_zeile,one_quell_rec.quell_zeitschrift,SCREENLINE_LEN-8);
             ausgabe_zeile[SCREENLINE_LEN] = '\0';
             sprintf(wrtxtbu,"%-78s\n",ausgabe_zeile);
             wrtxt(wrtxtbu);
             j++;
             /* added Nov 21 2000 (begin) */
             gezeigte_src++;
             /* added Nov 21 2000 (begin) */
          }
       }
       else
       {
             sprintf(ausgabe_zeile,"%-4s: ",one_quell_rec.quell_kuerzel);
             strncat(ausgabe_zeile,one_quell_rec.quell_zeitschrift,SCREENLINE_LEN-8);
             ausgabe_zeile[SCREENLINE_LEN] = '\0';
             sprintf(wrtxtbu,"%-78s\n",ausgabe_zeile);
             wrtxt(wrtxtbu);
             j++;
             /* added Nov 21 2000 (begin) */
             gezeigte_src++;
             /* added Nov 21 2000 (begin) */
       }
    }
    if (gezeigte_src < 1)
    {
       /* added Nov 21 2000 (begin) */
       sc_gotoxy(1,one_config_set.sl-3);
       strcpy(wrtxtbu,"No JOURNAL NAME found");
       wrtxt(wrtxtbu);
       /* added Nov 21 2000 (begin) */
    }
    
    sc_clreol();
    wrtxt("\n");

    close_ix02();
    fclose(dat_quell);
    return;
}


void enter_journal_names(char * z_kenn)
{
    FILE * tmpix;
    char tmpix_name[150];
    int taste;
    quellpix_rec ix_quell_rec_lokal;
    char eingabe_zeile[QUELLKUERZEL_LEN + 2];
    long ix_zeiger, rec_zeiger, byte_zeiger;

    strcpy(tmpix_name,"tmp_src.ix");
    byte_zeiger = 0;

    do
    {
       strcpy(eingabe_zeile,z_kenn);
       memset(&one_quell_rec,0,sizeof(one_quell_rec));
       memset(&ix_quell_rec,0,sizeof(ix_quell_rec));
       ix_quell_rec.quell_rptr=-1;

       info_zeile("Enter four letter code of a new or an existing journal entry, [Esc] Quit");
       strcpy(wrtxtbu,"Journal.-code......");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   eingabe_zeile,
                   QUELLKUERZEL_LEN,
                   QUELLKUERZEL_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
       if (taste==ESC_KEY) break;
    }
    while ((taste!=ENTER_KEY) || (strlen(eingabe_zeile)==0));
    if (taste==ESC_KEY)
    {
       return;
    }

    strcpy(ix_quell_rec.quell_kuerzel,eingabe_zeile);
    if (!isfile(quell_name))
    {
            sprintf(fehlermeldung,"ERROR: Cannot find %s",quell_name);
            beenden(fehlermeldung,1);
    }

    if (!isfile(quell_pix_name))
    {
            sprintf(fehlermeldung,"ERROR: Cannot find %s",quell_pix_name);
            beenden(fehlermeldung,1);
    }
    if (filesize(quell_pix_name) < sizeof(ix_quell_rec))
    {
       ix_zeiger = -1;
    } else
    {
       read_ix02(quell_pix_name);
       ix_zeiger = locate_ix02(eingabe_zeile, &ix_quell_rec_lokal);
       close_ix02();
    }
    if (ix_zeiger==-1)
    {
       /* neuen Datensatz einlesen */

       one_quell_rec.in_use_quell = 1;
       strcpy(one_quell_rec.quell_kuerzel,eingabe_zeile);
       if (!get_quell_rec(&one_quell_rec)) return;
    }
    else
    {
       /*
          rec_zeiger zuweisen, alten Datensatz in quell_name einlesen,
          Datei schliessen, editieren
       */
       ix_quell_rec=ix_quell_rec_lokal;
       rec_zeiger=ix_quell_rec.quell_rptr;
       byte_zeiger=rec_zeiger*sizeof(quell_rec);
       if ((dat_quell=fopen(quell_name,"rb"))==NULL)
       {
          sprintf(fehlermeldung,"ERROR: Cannot read in %s",quell_name);
          beenden(fehlermeldung,1);
       }
       fseek(dat_quell,byte_zeiger,SEEK_SET);
       fread(&one_quell_rec,sizeof(one_quell_rec),1,dat_quell);
       fclose(dat_quell);
       if (!get_quell_rec(&one_quell_rec)) return;

    }

    if (ix_zeiger==-1)
    {
       /*
          Datei quell_name oeffnen, Datensatz an das Ende scheiben, Dateizeiger
          ist rec_zeiger
       */
       if ((dat_quell=fopen(quell_name,"r+b"))==NULL)
       {
          sprintf(fehlermeldung,"ERROR: Cannot write into %s",quell_name);
          beenden(fehlermeldung,1);
       }
       fseek(dat_quell,0L,SEEK_END);
       byte_zeiger = ftell(dat_quell);
       rec_zeiger = byte_zeiger/sizeof(one_quell_rec);
       fwrite(&one_quell_rec,sizeof(one_quell_rec),1,dat_quell);
       fclose(dat_quell);
       ix_quell_rec.quell_rptr = rec_zeiger;

       /* Einen neuen Eintrag in Indexdatei schreiben Anfang */

         if ((tmpix=fopen(tmpix_name,"wb"))==NULL)
         {
             sprintf(fehlermeldung,"ERROR: Cannot create %s",tmpix_name);
             beenden(fehlermeldung,1);
         }
         fwrite(&ix_quell_rec,sizeof(ix_quell_rec),1,tmpix);
         fclose(tmpix);

         if (isfile(quell_pix_name))
         {
           if (filesize(quell_pix_name)==0) remove(quell_pix_name);
         }

         if (!isfile(quell_pix_name))
         {
             rename(tmpix_name,quell_pix_name);
             sc_gotoxy(1,one_config_set.sl-1);
         }
         else
         {
             mrgeix02(quell_pix_name,tmpix_name,"tmp02.ix$");
             remove(quell_pix_name);remove(tmpix_name);
             rename("tmp02.ix$",quell_pix_name);
             sc_gotoxy(1,one_config_set.sl-1);
         }

       /* Entrag in Index Ende */
    } else
    {
       /*
          Datei quell_name oeffnen, Datenatz an die alte Position scheiben,
          Dateizeiger ist rec_zeiger, Indexdateisatz aktualisieren
       */
       if ((dat_quell=fopen(quell_name,"r+b"))==NULL)
       {
          sprintf(fehlermeldung,"ERROR: Cannot write into %s",quell_name);
          beenden(fehlermeldung,1);
       }
       fseek(dat_quell,byte_zeiger,SEEK_SET);
       fwrite(&one_quell_rec,sizeof(one_quell_rec),1,dat_quell);
       fclose(dat_quell);
    }
}

int get_quell_rec(quell_rec * rec)
{
       int taste, posit,POSIT_ENDE;
       POSIT_ENDE = 4;
       posit = 1;
       taste = ESC_KEY;
       sc_gotoxy(1,one_config_set.sl-1);
       do
       {
          if (posit==1)
          {
            info_zeile("Four-letter-code of journal - for editing, please continue with [Enter]");
            strcpy(wrtxtbu,"Journal-Code.......");
            wrtxt(wrtxtbu);
            taste = e_zle(
                        1+strlen(wrtxtbu),
                        one_config_set.sl-1,
                        rec->quell_kuerzel,
                        QUELLKUERZEL_LEN,
                        QUELLKUERZEL_LEN,
                        1
                     );
            sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
            info_zeile("");
           }

           else if (posit==2)
           {
            info_zeile("Enter title of journal in full length");
            strcpy(wrtxtbu,"Journal............");
            wrtxt(wrtxtbu);
            taste = e_zle(
                        1+strlen(wrtxtbu),
                        one_config_set.sl-1,
                        rec->quell_zeitschrift,
                        80-strlen(wrtxtbu)-3,
                        ZEITSCHRIFT_LEN,
                        0
                     );
            sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
           }
           else if (posit==3)
           {
            info_zeile("Enter title of journal in abbreviated form - [F10] save, [Esc] cancel");
            strcpy(wrtxtbu,"Journal (short)....");
            wrtxt(wrtxtbu);
            taste = e_zle(
                        1+strlen(wrtxtbu),
                        one_config_set.sl-1,
                        rec->quell_kurzform,
                        80-strlen(wrtxtbu)-3,
                        KURZFORM_LEN,
                        0
                     );
            sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
           }
           else if (posit==4)
           {
            info_zeile("International Standard Serial number - [F10] save, [Esc] cancel");
            strcpy(wrtxtbu,"ISSN...............");
            wrtxt(wrtxtbu);
            taste = e_zle(
                        1+strlen(wrtxtbu),
                        one_config_set.sl-1,
                        rec->quell_issn,
                        ISSN_LEN,
                        ISSN_LEN,
                        0
                     );
            sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
           }
           if (taste==ENTER_KEY || taste==TAB_KEY || taste==DOWN_KEY ||
               taste==PGDN_KEY)
           {
              if (posit < POSIT_ENDE) posit++;
           }
           if (taste ==SHIFTTAB_KEY || taste==UP_KEY || taste==PGUP_KEY)
           {
             if (posit > 1) posit--;
           }
           if (taste==CTRLHOME_KEY) posit=1;
           if (taste==CTRLEND_KEY) posit=POSIT_ENDE;
           if (taste==ESC_KEY)
           {
              return 0;
           }
       } while (taste!=F10_KEY);
       return 1;
}


int show_quell(const char * key, char * shows)
{
    FILE * dat_quell;
    quellpix_rec ix_rec_lokal;
    long ix_zeiger, rec_zeiger, byte_zeiger;
    quell_rec quell_rec_lokal;

    if (!isfile(quell_pix_name))
    {

       strlimcat(shows,"[",SHOWREC_LEN);
       strlimcat(shows,key,SHOWREC_LEN);
       strlimcat(shows,"] ",SHOWREC_LEN);
       return 0;
    }
    if (filesize(quell_pix_name) < sizeof(ix_quell_rec))
    {
       strlimcat(shows,"[",SHOWREC_LEN);
       strlimcat(shows,key,SHOWREC_LEN);
       strlimcat(shows,"] ",SHOWREC_LEN);
       return 0;
    }
    read_ix02(quell_pix_name);
    ix_zeiger = locate_ix02(key, &ix_rec_lokal);
    close_ix02();
    if (ix_zeiger==-1)
    {
       strlimcat(shows,"[",SHOWREC_LEN);
       strlimcat(shows,key,SHOWREC_LEN);
       strlimcat(shows,"] ",SHOWREC_LEN);
       return 0;
    }
    rec_zeiger=ix_rec_lokal.quell_rptr;
    byte_zeiger = rec_zeiger*sizeof(quell_rec);
    if ((dat_quell=fopen(quell_name,"rb"))==NULL)
    {
       sprintf("ERROR: Cannot read in %s",quell_name);
       beenden(fehlermeldung,1);
    }
    fseek(dat_quell,byte_zeiger,SEEK_SET);
    fread(&quell_rec_lokal,sizeof(quell_rec),1,dat_quell);
    fclose(dat_quell);
    strlimcat(shows,quell_rec_lokal.quell_zeitschrift,SHOWREC_LEN);
    if (strlen(quell_rec_lokal.quell_issn) > 0)
    {
       strlimcat(shows," (ISSN: ",SHOWREC_LEN);
       strlimcat(shows,quell_rec_lokal.quell_issn,SHOWREC_LEN);
       strlimcat(shows,")",SHOWREC_LEN);
    }

    strlimcat(shows," ",SHOWREC_LEN);
    return 1;
}



void delete_quell(void)
{

    FILE * tmpix;
    char tmpix_name[150];
    char newix_name[150];

    int taste;
    quellpix_rec        ix_quell_rec_lokal;
    quell_rec           one_quell_rec_lokal;

    char eingabe_zeile[QUELLKUERZEL_LEN + 2];
    long ix_zeiger, rec_zeiger, byte_zeiger;

    strcpy(tmpix_name,"tmp_src.ix");
    strcpy(newix_name,"new_src.ix");

    do
    {
       strcpy(eingabe_zeile,"");
       memset(&one_quell_rec_lokal,0,sizeof(one_quell_rec_lokal));
       memset(&ix_quell_rec,0,sizeof(ix_quell_rec));
       memset(&ix_quell_rec_lokal,0,sizeof(ix_quell_rec_lokal));

       info_zeile("Enter four letter code of a new or an existing journal entry, [Esc] Quit");
       strcpy(wrtxtbu,"Journal.-code......");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   strlen(wrtxtbu)+1,
                   one_config_set.sl-1,
                   eingabe_zeile,
                   QUELLKUERZEL_LEN,
                   QUELLKUERZEL_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
       if (taste==ESC_KEY) break;
    }
    while ((taste!=ENTER_KEY) || (strlen(eingabe_zeile)==0));
    if (taste==ESC_KEY) return;

    taste=lotus_menu("Cancel$Do not delete JOURNAL entry@"
                     "Ok$Delete JOURNAL entry");
    if (taste==0 || taste==1) return;

    if (!isfile(quell_pix_name))
    {
       beeps();
       sprintf(wrtxtbu,"[Index file %s does not exist, cannot "
           "delete JOURNAL names]>",quell_pix_name);
       wrtxt(wrtxtbu);
       tastelesen();
       return;
    }
    if (filesize(quell_pix_name) < 2 * sizeof(ix_quell_rec))
    {
       beeps();
       wrtxt("[Number of JOURNAL entries too small "
            "(n < 3) for deleting]>");
       tastelesen();
       return;
    }
    read_ix02(quell_pix_name);
    ix_zeiger = locate_ix02(eingabe_zeile, &ix_quell_rec_lokal);
    close_ix02();

    if (ix_zeiger==-1)
    {
       beeps();
       sprintf(wrtxtbu,"[JOURNAL entry corresponding to %s not found]>",eingabe_zeile);
       wrtxt(wrtxtbu);
       tastelesen();
       return;
    }
    rec_zeiger = ix_quell_rec_lokal.quell_rptr;
    byte_zeiger = rec_zeiger * sizeof(one_quell_rec_lokal);
    if ((dat_quell=fopen(quell_name,"r+b"))==NULL)
    {
       sprintf(fehlermeldung,"ERROR: Cannot read/write file %s",quell_name);
       beenden(fehlermeldung,1);
    }
    fseek(dat_quell,byte_zeiger,SEEK_SET);
    fread(&one_quell_rec_lokal,sizeof(one_quell_rec_lokal),1,dat_quell);
    one_quell_rec_lokal.in_use_quell = 0;
    fseek(dat_quell,byte_zeiger,SEEK_SET);
    fwrite(&one_quell_rec_lokal,sizeof(one_quell_rec_lokal),1,dat_quell);
    fclose(dat_quell);
    if ((tmpix = fopen(tmpix_name,"wb"))==NULL)
    {
        sprintf(fehlermeldung,"ERROR: Cannot create %s",tmpix_name);
        beenden(fehlermeldung,1);
    }
    fwrite(&ix_quell_rec_lokal,sizeof(ix_quell_rec_lokal),1,tmpix);
    fclose(tmpix);

    deleteix02(quell_pix_name,tmpix_name,newix_name);
    remove(quell_pix_name); remove(tmpix_name);
    rename(newix_name,quell_pix_name);
    return;
}
