/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/
/*
    str_refs.c
*/
#include <stdio.h>
#include <string.h>
#include <conio.h>
#if defined(__EMX__)
  #include <stdlib.h>
#endif
#include "str_fun.h"
#include "keycodes.h"
#include "l_menu.h"
#include "str_refs.h"


#if defined(__EMX__)
int abbrechen(void)
{
   int taste, wahl;
   if ((taste=_read_kbd(0,0,0))!=-1)
   {
       if (taste==0) _read_kbd(0,0,0);
       if (taste==ESC_KEY)
       {
          wrtxt("\nInterrupted with [ESC]\n\n");
          wahl = lotus_menu("Cancel$Resume the current function"
                            "@Ok$Finish the current function");
         if (wahl==2) return 1; else return 0;
       }
       else return 0;
   }
   return 0;
}
#endif
#if defined(__DJGPP__)
int abbrechen(void)
{
   int taste, wahl;
   if (kbhit())
   {
       taste = tastelesen();
       if (taste==ESC_KEY)
       {
          wrtxt("\nInterrupted with [ESC]\n\n");
          wahl = lotus_menu("Cancel$Resume the current function"
                            "@Ok$Finish the current function");
         if (wahl==2) return 1; else return 0;
       }
       else return 0;
   }
   return 0;
}
#endif


/*
     Aus funktionsaehnlichen Strings vom Typ "%edit(, )" das Argument
     in Klammern extrahieren. fmodel ist die "Schablone" "%edit()" mit
     der der eingegebene String instring verglichen wird. Das extrahierte
     Argument wird outstring uebergeben.

     Gibt '0' zurueck, wenn fmodel nicht passt oder das 'Argument' nicht
     extrahiert werden kann, bei Erfolg '1'.
*/

int extractargument(const char * fmodel, char * instring, char * outstring)
{
   unsigned int i, j;
   unsigned open_pos;
   open_pos = 0;
   j=0;
   strcpy(outstring,"");

   if (instring[strlen(instring)-1]!=')') return 0;
   if (fmodel[strlen(fmodel)-1]!=')') return 0;
   if (strlen(fmodel) > strlen(instring)) return 0;

   for (i=0;i<strlen(fmodel)-1;i++)
   {
      if (fmodel[i]!=instring[i]) return 0;
      if (fmodel[i]=='(')
      {
         if (instring[i]=='(')
         {
             open_pos = i;   /* Position der oeffnenden Klammer */
             break;
         }
         else return 0;
      }
   }
   j = 0;
   for (i=open_pos+1;i<strlen(instring)-1;i++)
   {
      outstring[j]=instring[i];
      j++;
   }
   outstring[j]='\0';
   return 1;
}

int extractargument_curly(const char * fmodel, char * instring, char * outstring)
{
   unsigned int i, j;
   unsigned open_pos;
   open_pos = 0;
   j=0;
   strcpy(outstring,"");

   if (instring[strlen(instring)-1]!='}') return 0;
   if (fmodel[strlen(fmodel)-1]!='}') return 0;
   if (strlen(fmodel) > strlen(instring)) return 0;

   for (i=0;i<strlen(fmodel)-1;i++)
   {
      if (fmodel[i]!=instring[i]) return 0;
      if (fmodel[i]=='{')
      {
         if (instring[i]=='{')
         {
             open_pos = i;   /* Position der oeffnenden Klammer */
             break;
         }
         else return 0;
      }
   }
   j = 0;
   for (i=open_pos+1;i<strlen(instring)-1;i++)
   {
      outstring[j]=instring[i];
      j++;
   }
   outstring[j]='\0';
   return 1;
}

int satzzeichen(const char * zeile)
{
   unsigned int lzch;
   lzch = strlen(zeile)-1;
   if (
       zeile[lzch]=='.' ||
       zeile[lzch]==',' ||
       zeile[lzch]==':' ||
       zeile[lzch]=='?' ||
       zeile[lzch]=='!'
       ) return 1; else return 0;
}

/*
   Fuegt 'trenner' in einen abgekuerzten Zeitschriftennamen 'inzeile' ein, Ausgabe
   in 'auszeile':
   inzeile:     N Engl J Med
   trenner      '. '
   auszaile:    N. Engl. J. Med
*/


void fdjsdelimiter(char * inzeile, char * auszeile, char * trenner, unsigned int MAXL)
{
  unsigned int laenge, i,j;
  laenge = strlen(inzeile);
  strcpy(auszeile,"");
  if (strlen(trenner)==0)
     strcpy(trenner," ");
  j=0;
  for (i=0;i<=laenge-1;i++)
  {
     if (inzeile[i]!=' ')
     {
        auszeile[j]=inzeile[i];
        j++;
        if (j==MAXL)
        {
          auszeile[j] = '\0';
          return;
        }
     }
     else
     {
        unsigned int k;
        for (k=0;k<=strlen(trenner)-1;k++)
        {
           auszeile[j] = trenner[k];
           j++;
           if (j==MAXL)
           {
             auszeile[j] = '\0';
             return;
           }
        }
     }
  }
  auszeile[j] = '\0';
  return;
}

int seitenziffern(char * vons, char * biss)
{
   unsigned int i, laenge;
   if (strlen(vons)==0 || strlen(biss)==0) return 0;
   if (strlen(vons)!=strlen(biss)) return 0;
   if (!strcmp(vons,biss))
   {
      strcpy(biss,"");
      return 0;
   }
   laenge = strlen(vons);
   for (i=0;i<laenge;i++)
   {
      if (vons[i]==biss[i]) biss[i]=' ';
        else break;
   }
   ltrim(biss,' ');
   return 1;
}

/* Seite 1233 - 43  -> biss_neu: 1243 */
int seitenziffern_komplettieren(char * vons, char * biss, char * biss_neu)
{
   int vonlen, bislen, i, j;
   vonlen=strlen(vons);
   bislen=strlen(biss);
   strcpy(biss_neu,"");
   if (bislen==0 || vonlen==0)
   {
     return 1;
   }
   if (bislen >= vonlen)
   {
     strcpy(biss_neu,biss);
     return 1;
   }
   strcpy(biss_neu,vons);
   j = bislen - 1;
   for (i=vonlen-1;i>=0;i--)
   {
       if (j>=0)
       {
          biss_neu[i] = biss[j];
       }
       j--;
   }
   return 1;
}

