/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/
/*  fl_ut.h */
#include <stdio.h>

#ifndef FL_UT_H
#define FL_UT_H

#define KATDATEINAME_LEN        16
#define KAT_SORTIER_N          500
  /* so viele Namen sollen sortiert werden koennen bei Dateiauswahl */

typedef struct
{
   char dname[KATDATEINAME_LEN + 1];
} d_katalogstapel_rec;

int datei_suchen(const char * suchpfad, char * dateiname);
int datei_suchen_default(const char * suchpfad, char * dateiname, int * vorgabe);
int dir_kat_schreiben(void);
int dir_kat_lesen(void);
void dir_kat_schliessen(void);
int isfile(const char * test_datei_name);
void programmpfad(const char * programm, char * pfad);
int isdirectory(char *dirname);
int iseof(FILE * datei);
long filesize(char * datname);


int dateikatalog_sortieren(void);
int slash_to_backslash(char * zle);

#endif
