/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/


/*
   btch_fun.c: write/edit/process/convert BBT-, TBT-files
   version 3.6
*/

#include <stdio.h>
#include <malloc.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <dos.h>
#include "refs.h"
#include "str_fun.h"
#include "fl_ut.h"
#include "ix01_fun.h"
#include "sortbbf1.h"
#include "l_menu.h"
#include "sortbbf2.h"
#include "bbf_fun.h"
#include "keycodes.h"
#include "abbruch.h"
#include "cfg_fun.h"

#define BATCHTITEL "REFERENCES VERSION 3.6 * BATCH FILE FUNCTIONS"
#define BBTZEILE_LEN 32000
#define ZIFFER_LEN 4
#define INFO_Z_LEN 100
  /* Laenge Info-Zeile */


 extern char journal_name[PFAD_LEN];
 extern char journal_pix_name[PFAD_LEN];
 extern char autorjl_name[PFAD_LEN];
 extern char autorbu_name[PFAD_LEN];
 
 static char bbt_name[PFAD_LEN];
 static char tmpbbt_name[PFAD_LEN];
 static char text_name[PFAD_LEN];
 extern char book_name[PFAD_LEN];

 extern char fehlermeldung[250];
 extern char wrtxtbu[WRTXTBU_LEN];

 long delaywrite;

 extern journal_rec one_journal_rec;
 extern config_set one_config_set;



 extern FILE * fpjournal;
 extern FILE * fpautorjl;
 extern FILE * fpautorbu;
 static FILE * tmpbbt;
 static FILE * fptext;
 static FILE * fpbbt;
 extern FILE * fpbuch;

 extern FILE * ix01file;


 static char * zeile;
 static char * ex_zeile;
 static char * exex_zeile;


 int btch_fun_main(char * datpath,char * exepfad);
 static void hauptmenu_btch_fun(void);
 static int db_oeffnen(void);
 static void db_schliessen(void);
 static void text2bbt(void);
 static void bbt2text(void);
 static int enternameyear(void);
 static void sortbbt_text(void);
 static void sortbbt_recno(void);
 static void append_bbt(void);
 static void remove_double_keys(void);
 static void copy_all_records(void);
 static void extract_range(void);
 static int extract_text_duplicates(void);
 static long verschluesseln(char * zeile);
 static int write_urid(void);
 static int remove_double_but_1st(void);
 static int writebbt(void);
 static int edit_bbt_rec(bbatchtable_rec * one_bbt_rec, long zeiger, long max);
 static int remove_empty_records(void);
 static int invertbbt_order(void);

int btch_fun_main(char * datpath,char * exepfad)
{
   delaywrite=one_config_set.delay_list_write;

   strcpy(tmpbbt_name,datpath);strcat(tmpbbt_name,"TMP.BB$");

   if  ((zeile = (char *) malloc((BBTZEILE_LEN+1) * sizeof(char)))==NULL)
   {
      wrtxt("ERROR in 'BatchT'-functions: cannot allocate memory for zeile\n");
      return 1;
   }
   if  ((ex_zeile = (char *) malloc((BBTZEILE_LEN+1) * sizeof(char)))==NULL)
   {
      wrtxt("ERROR in 'BatchT'-functions: cannot allocate memory for ex_zeile\n");
      return 1;
   }
   if  ((zeile = (char *) malloc((BBTZEILE_LEN+1) * sizeof(char)))==NULL)
   {
      wrtxt("ERROR in 'BatchT'-functions: cannot allocate memory for exex_zeile\n");
      return 1;
   }

   hauptmenu_btch_fun();
   free(zeile);
   free(ex_zeile);
   free(exex_zeile);
   if (isfile(tmpbbt_name))
   {
      remove(tmpbbt_name);
   }

   return 0;

}

static void hauptmenu_btch_fun(void)
{
   int taste;
   static int menupos;
   cls_line(BATCHTITEL);

   taste = lotus_menu_default(&menupos,
   "@BBTtoText$Write a *.BBT-file into a text file"
   "@TexttoBBT$Convert a text file into a *.BBT-file"
   "@Write$Edit a BBT-file"
   "@SortBBT$Sort a *.BBT-file (reference numbers, text field)"
   "@EnterAEY$Enter automatically authors' or editors' names, year of publication"
   "@AppendF$Append a BBT-file to another BBT-file"
   "@XDupl$Remove duplicate keys from a BBT-file after sorting (reference number)"
   "@1stOnly$Remove duplicate references from a BBT-file: preserve only 1st occurrence"
   "@More$More BBT-file functions: write URID, all references, range of references"
                 );
   if (taste==1)
   {
     bbt2text();
   }
   else if (taste==2)
   {
      text2bbt();
   }
   else if (taste==3)
   {
      writebbt();
   }
   else if (taste==4)
   {
      int taste1;
      static int menupos;
      taste1 = lotus_menu_default(&menupos,
           "@ReferenceN$Sort *.BBT-file according to reference number"
           "@TextField$Sort *.BBT-file according to text field"
           "@Invert$Make a copy of a BBT-file with the reverse order of records"
                                );
      if (taste1==1)
      {
         sortbbt_recno();
      }
      else if (taste1==2)
      {
         sortbbt_text();
      }
      else if (taste1==3)
      {
         invertbbt_order();
      }

   }
   else if (taste==5)
   {
      enternameyear();
   }
   else if (taste==6)
   {
      append_bbt();
   }
   else if (taste==7)
   {
      remove_double_keys();
   }
   else if (taste==8)
   {
      remove_double_but_1st();
   }
   else if (taste==9)
   {
      int taste1;
      static int menupos;
      taste1=lotus_menu_default(&menupos,
                  "@AllReferences$Write all reference numbers of current database into a *.BBT-file"
                  "@Range$Extract a range of reference numbers into a *.BBT-file"
                  "@ExtractDupl$Extract duplicate records (text field) from a BBT-file into a new file"
                  "@UniqueRecId$Write 'UNIQUE RECORD IDENTIFIER' (URID) into text field of a BBT-file"
                  "@Clear$Remove records with empty RECORD NUMBER field from BBT-file"
                               );

      if (taste1==1)
      {
        copy_all_records();
      }
      else if (taste1==2)
      {
          extract_range();
      }
      if (taste1==3)
      {
          extract_text_duplicates();
      }
      if (taste1==4)
      {
          write_urid();
      }
      if (taste1==5)
      {
          remove_empty_records();
      }
   }
}


static int db_oeffnen(void)
{
     if ((fpjournal=fopen(journal_name,"rb"))==NULL)
     {
        sprintf(wrtxtbu,"[ERROR: Cannot read %s]>",journal_name);
        wrtxt(wrtxtbu);
        tastelesen();
        return 0;
     }
     if ((ix01file=fopen(journal_pix_name,"rb"))==NULL)
     {
        sprintf(wrtxtbu,"[ERROR: Cannot read %s]>",journal_pix_name);
        wrtxt(wrtxtbu);
        tastelesen();
        fclose(fpjournal);
        return 0;
     }
     if ((fpautorjl=fopen(autorjl_name,"rb"))==NULL)
     {
        fclose(fpjournal);
        fclose(ix01file);
        sprintf(wrtxtbu,"[ERROR: Cannot read %s]>",autorjl_name);
        wrtxt(wrtxtbu);
        tastelesen();
        return 0;
     }
     if ((fpautorbu=fopen(autorbu_name,"rb"))==NULL)
     {
        fclose(fpjournal);
        fclose(ix01file);
        fclose(fpautorjl);
        sprintf(wrtxtbu,"[ERROR: Cannot read %s]>",autorbu_name);
        wrtxt(wrtxtbu);
        tastelesen();
        return 0;
     }
   return 1;
}

static void db_schliessen(void)
{
  fclose(fpjournal);
  fclose(ix01file);
  fclose(fpautorjl);
  fclose(fpautorbu);
}


static void text2bbt(void)
{
   static char eingabe[DOSDATEIVORNAME_LEN+1];
   int taste, option, anzahl_token;
   bbatchtable_rec one_bbt_rec;
   long textpos;
   char textpos_str[ZIFFER_LEN +1];

   if (!datei_suchen("*.T?T",text_name))
   {
      sprintf(wrtxtbu,"\n[Please press any key]>");
      wrtxt(wrtxtbu);
      tastelesen();
      return;
   }

   wrtxt("\n\n");
   sc_gotoxy(1,one_config_set.sl-1);


   do
   {
       info_zeile("Enter a filename for the output batch-table, [Esc] to leave");
       strcpy(wrtxtbu,"Batch table........");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   eingabe,
                   DOSDATEIVORNAME_LEN,
                   DOSDATEIVORNAME_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
       if (taste==ESC_KEY) return ;
       if (isdosfilename(eingabe)==0)
       {
           taste=200;
           continue;
       }
       upper(eingabe);
   }
   while (taste!=ENTER_KEY);
   if (!strcmp(eingabe,"")) return;
   if (taste==ESC_KEY) return;
   cls_line("");
   strcpy(bbt_name,eingabe);
   strcat(bbt_name,".BBT");
   if (isfile(bbt_name))
   {
      option = lotus_menu("Cancel$Quit the Text->BBT procedure@"
                          "Overwrite$Overwrite the existent BBT-file");
      if (option<=1) return;
   }
   strcpy(textpos_str,"2");
   do
   {
       int ok;

       info_zeile("Enter the position of the text element to be entered [ > 1], [Esc] to leave");
       strcpy(wrtxtbu,"Text-position......");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   textpos_str,
                   ZIFFER_LEN,
                   ZIFFER_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
       if (taste==ESC_KEY) return;
       string_in_long(textpos_str, &textpos, &ok);
       if (!ok || textpos < 2)
       {
           taste=200;
           continue;
       }
       upper(eingabe);
   }
   while (taste!=ENTER_KEY && taste!=ESC_KEY);
   if (taste==ESC_KEY) return;

   if ((fpbbt=fopen(bbt_name,"wb"))==NULL)
   {
      sprintf(wrtxtbu,"[ERROR: Cannot open %s]>",bbt_name);
      wrtxt(wrtxtbu);
      tastelesen();
      return;
   }
   if ((fptext=fopen(text_name,"r"))==NULL)
   {
      fclose(fpbbt);
      sprintf(wrtxtbu,"[ERROR: Cannot open %s]>",text_name);
      wrtxt(wrtxtbu);
      tastelesen();
      return;
   }
   cls_line("");
   sprintf(wrtxtbu,"Converting text file %s into binary batch table %s...\n",
     text_name,bbt_name);
   wrtxt(wrtxtbu);
   while (fgets(zeile,BBTZEILE_LEN,fptext)!=NULL)
   {
      memset(&one_bbt_rec,0,sizeof(one_bbt_rec));
      if (strlen(zeile) > BBTZEILE_LEN)
      {
         wrtxt("[Problem: line too long]>");
         tastelesen();
         break;
      }
      if (zeile[0]!='*') continue;
      rtrim(zeile,'\n');
      anzahl_token=countitem(zeile,"*");
      if (anzahl_token < 1) continue;
      if (anzahl_token < textpos)
      {
         strcpy(one_bbt_rec.sortierfeld,"");
      }
      else
      {
         extractitem((int) textpos,zeile,"*",ex_zeile);
         trim(ex_zeile,' ');
         ex_zeile[SORTIERFELD_LEN]='\0';
         strcpy(one_bbt_rec.sortierfeld,ex_zeile);
      }
      extractitem(1,zeile,"*",ex_zeile);
      trim(ex_zeile,' ');
      if (strlen(ex_zeile)>KENNZIFFER_LEN) continue;
      if (strlen(ex_zeile)==0) continue; /* records with empty fields ignored */
      ex_zeile[KENNZIFFER_LEN]='\0';
      strcpy(one_bbt_rec.kennziffer,ex_zeile);

      fwrite(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
   }
   fclose(fpbbt);
   fclose(fptext);
   sprintf(wrtxtbu,"\n[File %s closed]>",bbt_name);
   wrtxt(wrtxtbu);
   tastelesen();
   sc_gotoxy(1,one_config_set.sl);sc_clreol();
   return;
}

static void bbt2text(void)
{
   static char eingabe[DOSDATEIVORNAME_LEN+1];
   int taste, option;
   bbatchtable_rec one_bbt_rec;
   long i,  byte_zeiger, anzahl_records;

   if (!datei_suchen("*.BBT",bbt_name))
   {
      wrtxt("\n[Please press any key]>");
      tastelesen();
      return;
   }

   wrtxt("\n\n");
   sc_gotoxy(1,one_config_set.sl-1);

   do
   {
       info_zeile("Enter a filename for the output text file, [Esc] to leave");
       strcpy(wrtxtbu,"Text file..........");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   eingabe,
                   DOSDATEIVORNAME_LEN,
                   DOSDATEIVORNAME_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
       if (taste==ESC_KEY) return ;
       if (isdosfilename(eingabe)==0)
       {
           taste=200;
           continue;
       }
       upper(eingabe);
   }
   while (taste!=ENTER_KEY);
   if (!strcmp(eingabe,"")) return;
   if (taste==ESC_KEY) return;
   cls_line("");
   strcpy(text_name,eingabe);
   strcat(text_name,".TBT");
   if (isfile(text_name))
   {
      option = lotus_menu("Cancel$Quit the BBT->Text procedure@"
                          "Overwrite$Overwrite the existent text-file");
      if (option<=1) return;
   }

   if ((fpbbt=fopen(bbt_name,"rb"))==NULL)
   {
       sprintf(wrtxtbu,"[Cannot read %s]>",bbt_name);
       wrtxt(wrtxtbu);
       tastelesen();
       return;
   }

   if ((fptext=fopen(text_name,"w"))==NULL)
   {
       sprintf(wrtxtbu,"[Cannot read %s]>",text_name);
       wrtxt(wrtxtbu);
       tastelesen();
       return;
   }

   fseek(fpbbt,0L,SEEK_END);
   byte_zeiger = ftell(fpbbt);
   anzahl_records = byte_zeiger / sizeof(one_bbt_rec);
   anzahl_records--;
   rewind(fpbbt);
   wrtxt("Converting *.BBT-file...\n");
   for (i=0;i<=anzahl_records;i++)
   {
      fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
      fprintf(fptext,"* %-*s * %-*s *\n",
         KENNZIFFER_LEN,
         one_bbt_rec.kennziffer,
         SORTIERFELD_LEN,
         one_bbt_rec.sortierfeld);
   }

   fclose(fpbbt);
   fclose(fptext);
   wrtxt("\n[Please press any key]>");
   tastelesen();
}


static int enternameyear(void)
{
    long byte_zeiger, ix_zeiger, anzahl_records, i;
    bbatchtable_rec     one_bbt_rec;
    refspix_rec         ix01rec;
    journal_rec         one_journal_rec;
    author_rec          one_aued_rec;

    char sortierstring[SORTIERFELD_LEN+20];

    if (!datei_suchen("*.BBT",bbt_name))
    {
       wrtxt("\n[Please press any key]>");
       tastelesen();
       return 0;
    }
    wrtxt("\n\n");
    sc_gotoxy(1,one_config_set.sl-1);


    if (filesize(bbt_name) < sizeof(one_bbt_rec))
    {
       sprintf(wrtxtbu,"\n[%s is empty, please press any key]>",bbt_name);
       wrtxt(wrtxtbu);
       tastelesen();
       return 0;
    }
    if ((fpbbt=fopen(bbt_name,"rb"))==NULL)
    {
        sprintf(wrtxtbu,"[ERROR: Cannot read %s]>",bbt_name);
        wrtxt(wrtxtbu);
        tastelesen();
        return 0;
    }
    if (setvbuf(fpbbt,NULL,_IOFBF,15000)!=0)
    {
        sprintf(wrtxtbu,"ERROR: Unable to allocate memory for buffering %s",bbt_name);
        wrtxt(wrtxtbu);
        tastelesen();
        fclose(fpbbt);
        return 0;
    }
    if ((tmpbbt=fopen(tmpbbt_name,"wb"))==NULL)
    {
        sprintf(wrtxtbu,"ERROR: Cannot create %s",tmpbbt_name);
        wrtxt(wrtxtbu);
        tastelesen();
        fclose(fpbbt);
        return 0;
    }
    if (setvbuf(tmpbbt,NULL,_IOFBF,12000)!=0)
    {
        sprintf(wrtxtbu,"ERROR: Unable to allocate memory for buffering %s",tmpbbt_name);
        wrtxt(wrtxtbu);
        tastelesen();
        fclose(fpbbt);
        fclose(tmpbbt);
        return 0;
    }

    if (!db_oeffnen())
    {
        fclose(fpbbt);
        fclose(tmpbbt);
        return 0;
    }
    fseek(fpbbt,0L,SEEK_END);
    byte_zeiger = ftell(fpbbt);
    anzahl_records = byte_zeiger / sizeof(one_bbt_rec);
    anzahl_records--;
    rewind(fpbbt);
    sprintf(wrtxtbu,"Searching names and publication years for %li references, please wait...\n",anzahl_records+1);
    wrtxt(wrtxtbu);
    for (i=0;i<=anzahl_records;i++)
    {

       if (delaywrite > 0)
       {
#if defined(__EMX__)
          if (((i+1) % 200)==0) { _sleep2 ((unsigned int) delaywrite); }
#endif
#if defined(__DJGPP__)
          if (((i+1) % 200)==0) { delay ((unsigned int) delaywrite); }
#endif
       }

       fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
       ix_zeiger = locate_ix01(one_bbt_rec.kennziffer,&ix01rec);
       if (ix_zeiger!=-1)
       {
          byte_zeiger = ix01rec.journal_rptr * sizeof(one_journal_rec);
          fseek(fpjournal,byte_zeiger,SEEK_SET);
          fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
          if (!strcmp(one_journal_rec.reftyp,"j1") ||
            (!strcmp(one_journal_rec.reftyp,"b2")))
          {
            byte_zeiger = ix01rec.autorjl_rptr * sizeof(one_aued_rec);
            fseek(fpautorjl,byte_zeiger,SEEK_SET);
            fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
          }
          else
          {
            byte_zeiger = ix01rec.autorbu_rptr * sizeof(one_aued_rec);
            fseek(fpautorbu,byte_zeiger,SEEK_SET);
            fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
          }
          sprintf(sortierstring,"%*s%*s%*s",
              -AUNAME_LEN,one_aued_rec.au_nachname,
              -AUVORNAMEN_LEN,one_aued_rec.au_vornamen,
              -JAHRGANG_LEN,one_journal_rec.jahrgang
                  );
          sortierstring[SORTIERFELD_LEN] = '\0';
          upper(sortierstring);
          strncpy(one_bbt_rec.sortierfeld,sortierstring,SORTIERFELD_LEN+1);

          fwrite(&one_bbt_rec,sizeof(one_bbt_rec),1,tmpbbt);
       }
    }
    fclose(fpbbt);
    fclose(tmpbbt);
    db_schliessen();
    remove(bbt_name);
    rename(tmpbbt_name,bbt_name);
    wrtxt("\n[Please press any key]>");
    tastelesen();
    return 1;
}


static void sortbbt_text(void)
{

    if (!datei_suchen("*.BBT",bbt_name))
    {
       wrtxt("\n[Please press any key]>");
       tastelesen();
       return;
    }
    wrtxt("\n\n");
    sc_gotoxy(1,one_config_set.sl-1);

    if (filesize(bbt_name) <= sizeof(bbatchtable_rec))
    {
       sprintf(wrtxtbu,"\n[%s is empty or contains only one record]>",bbt_name);
       wrtxt(wrtxtbu);
       tastelesen();
       return;
    }
    domergebbf2(bbt_name,tmpbbt_name);
    remove(bbt_name);
    rename(tmpbbt_name,bbt_name);
    wrtxt("\n\n[Please press any key]>");
    tastelesen();

}




static void sortbbt_recno(void)
{

    if (!datei_suchen("*.BBT",bbt_name))
    {
       wrtxt("\n[Please press any key]>");
       tastelesen();
       return;
    }
    wrtxt("\n\n");
    sc_gotoxy(1,one_config_set.sl-1);

    if (filesize(bbt_name) <= sizeof(bbatchtable_rec))
    {
       sprintf(wrtxtbu,"\n[%s is empty or contains only one record]>",bbt_name);
       wrtxt(wrtxtbu);
       tastelesen();
       return;
    }
    domergebbf1(bbt_name,tmpbbt_name);
    remove(bbt_name);
    rename(tmpbbt_name,bbt_name);
    wrtxt("\n\n[Please press any key]>");
    tastelesen();

}

static void append_bbt(void)
{
    long i, anzahl_records, byte_zeiger;
    bbatchtable_rec one_bbt_rec;
    FILE * fpsourcebbt;
    char source_bbt_name[150];

    cls_line("");
    wrtxt("\n[In the next file selection screen, please select the TARGET file]>");
    tastelesen();
    sc_gotoxy(1,one_config_set.sl);sc_clreol();
    if (!datei_suchen("*.BBT",bbt_name))
    {
       wrtxt("\n[Please press any key]>");
       tastelesen();
       return;
    }
    wrtxt("\n[In the next file selection screen, please select the SOURCE file]>");
    tastelesen();
    sc_gotoxy(1,one_config_set.sl);sc_clreol();
    if (!datei_suchen("*.BBT",source_bbt_name))
    {
       wrtxt("\n[Please press any key]>");
       tastelesen();
       return;
    }
    wrtxt("\n");


    if (filesize(source_bbt_name) < sizeof(bbatchtable_rec))
    {
       sprintf(wrtxtbu,"[%s is empty, please press any key]>",source_bbt_name);
       wrtxt(wrtxtbu);
       tastelesen();
       return;
    }
    if (!stricmp(source_bbt_name,bbt_name))
    {
       wrtxt("[Problem: you have selected the same file as SOURCE and TARGET]>");
       tastelesen();
       return;
    }

    if ((fpbbt = fopen(bbt_name,"r+b"))==NULL)
    {
       sprintf(fehlermeldung,"ERROR: Cannot write into %s",bbt_name);
       beenden(fehlermeldung,2);
    }

    if ((fpsourcebbt = fopen(source_bbt_name,"rb"))==NULL)
    {
       sprintf("ERROR: Cannot read %s",source_bbt_name);
       beenden(fehlermeldung,2);
    }
    fseek(fpsourcebbt,0L,SEEK_END);
    byte_zeiger = ftell(fpsourcebbt);
    anzahl_records=byte_zeiger / sizeof(one_bbt_rec);
    anzahl_records--;
    fseek(fpbbt,0L,SEEK_END);
    rewind(fpsourcebbt);
    sprintf(wrtxtbu,"Copying %li records to %s, please wait...\n",anzahl_records+1,bbt_name);
    wrtxt(wrtxtbu);
    for (i=0;i<=anzahl_records;i++)
    {
       fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpsourcebbt);
       fwrite(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
    }
    fclose(fpbbt);
    fclose(fpsourcebbt);
    wrtxt("\n[Please press any key]>");
    tastelesen();
}


static void remove_double_keys(void)
{
    if (!datei_suchen("*.BBT",bbt_name))
    {
       wrtxt("\n[Please press any key]>");
       tastelesen();
       return;
    }
    wrtxt("\n\n");
    sc_gotoxy(1,one_config_set.sl-1);

    if (filesize(bbt_name) <= sizeof(bbatchtable_rec))
    {
       sprintf(wrtxtbu,"\n[%s is empty or contains only one record]>",bbt_name);
       wrtxt(wrtxtbu);
       tastelesen();
       return;
    }

    domergebbf1(bbt_name,tmpbbt_name);
    remove(bbt_name);
    dupl_ex_bbf(tmpbbt_name,bbt_name);
    remove(tmpbbt_name);
    wrtxt("\n\n[Please press any key]>");
    tastelesen();

}

static void copy_all_records(void)
{
   bbatchtable_rec one_bbt_rec;
   long i, anzahl_records, byte_zeiger;
   int taste, option;
   static char eingabe[DOSDATEIVORNAME_LEN+1];
   refspix_rec ix01rec;

   do
   {
       info_zeile("Enter a filename for the output batch-table, [Esc] to leave");
       strcpy(wrtxtbu,"Batch table........");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   eingabe,
                   DOSDATEIVORNAME_LEN,
                   DOSDATEIVORNAME_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
       if (taste==ESC_KEY) return ;
       if (isdosfilename(eingabe)==0)
       {
           taste=200;
           continue;
       }
       upper(eingabe);
   }
   while (taste!=ENTER_KEY);
   if (!strcmp(eingabe,"")) return;
   if (taste==ESC_KEY) return;
   cls_line("");
   strcpy(bbt_name,eingabe);
   strcat(bbt_name,".BBT");
   if (isfile(bbt_name))
   {
      option = lotus_menu("Cancel$Quit the current procedure (do not write "
                                      "all records into BBT-file)@"
                          "Overwrite$Overwrite the existent BBT-file");
      if (option<=1) return;
   }

   if ((ix01file=fopen(journal_pix_name,"rb"))==NULL)
   {
      sprintf(fehlermeldung,"ERROR: Cannot read %s",journal_pix_name);
      beenden(fehlermeldung,2);
   }
   if ((fpbbt=fopen(bbt_name,"wb"))==NULL)
   {
      sprintf(fehlermeldung,"ERROR: Cannot create %s",bbt_name);
      beenden(fehlermeldung,2);
   }
   fseek(ix01file,0L,SEEK_END);
   byte_zeiger = ftell(ix01file);
   anzahl_records = byte_zeiger / sizeof(ix01rec);
   anzahl_records--;

   rewind(ix01file);
   memset(&one_bbt_rec,0,sizeof(one_bbt_rec));
   memset(&ix01rec,0,sizeof(ix01rec));
   sprintf(wrtxtbu,"Writing %s with all records, please wait...\n",bbt_name);
   wrtxt(wrtxtbu);
   for (i=0;i<=anzahl_records;i++)
   {
       fread(&ix01rec,sizeof(ix01rec),1,ix01file);
       strncpy(one_bbt_rec.kennziffer,ix01rec.kennziffer,KENNZIFFER_LEN+1);
       fwrite(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
   }
   fclose(fpbbt);
   fclose(ix01file);
   sprintf(wrtxtbu,"\n[%s closed, please press any key]>",bbt_name);
   wrtxt(wrtxtbu);
   tastelesen();
}

static void extract_range(void)
{
    int taste,option;
    bbatchtable_rec one_bbt_rec;
    static char eingabe[DOSDATEIVORNAME_LEN+1];
    char keyu[KENNZIFFER_LEN + 1];
    char keyo[KENNZIFFER_LEN + 1];
    static char eingabe_zeileu[KENNZIFFER_LEN + 1];
    static char eingabe_zeileo[KENNZIFFER_LEN + 1];
    long i, byte_zeiger, ix_zeiger, ugrenze, ogrenze;
    refspix_rec ix01rec;


    do
    {
        info_zeile("Enter a filename for the output batch-table, [Esc] to leave");
        strcpy(wrtxtbu,"Batch table........");
        wrtxt(wrtxtbu);
        taste = e_zle(
                    1+strlen(wrtxtbu),
                    one_config_set.sl-1,
                    eingabe,
                    DOSDATEIVORNAME_LEN,
                    DOSDATEIVORNAME_LEN,
                    0
                 );
        sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
        if (taste==ESC_KEY) return ;
        if (isdosfilename(eingabe)==0)
        {
            taste=200;
            continue;
        }
        upper(eingabe);
    }
    while (taste!=ENTER_KEY);
    if (!strcmp(eingabe,"")) return;
    if (taste==ESC_KEY) return;
    cls_line("");
    strcpy(bbt_name,eingabe);
    strcat(bbt_name,".BBT");
    if (isfile(bbt_name))
    {
       option = lotus_menu("Cancel$Quit the current procedure@"
                           "Overwrite$Overwrite the existent BBT-file");
       if (option<=1) return;
    }

    read_ix01(journal_pix_name);

    do
    {

       info_zeile("Enter reference number of the lower limit, [Esc] quit");
       strcpy(wrtxtbu,"Lower limit........");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   eingabe_zeileu,
                   KENNZIFFER_LEN,
                   KENNZIFFER_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
       if (taste==ESC_KEY) break;
    }
    while ((taste!=ENTER_KEY) || (strlen(eingabe_zeileu)==0));
    if (taste==ESC_KEY)
    {
      cls_line("");
      close_ix01();
      return;
    }
    cls_line("");
    strcpy(keyu,eingabe_zeileu);
    ix_zeiger = locate_ix01(eingabe_zeileu,&ix01rec);
    if (ix_zeiger == -1)
    {
       sprintf(wrtxtbu,"\n[Record with key %s not found]>",eingabe_zeileu);
       wrtxt(wrtxtbu);
       tastelesen();
       close_ix01();
       return;
    }
    ugrenze = ix_zeiger;

    do
    {

       info_zeile("Enter reference number of the upper limit, [Esc] quit");
       strcpy(wrtxtbu,"Upper limit........");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   eingabe_zeileo,
                   KENNZIFFER_LEN,
                   KENNZIFFER_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
       if (taste==ESC_KEY) break;
    }
    while ((taste!=ENTER_KEY) || (strlen(eingabe_zeileo)==0));
    if (taste==ESC_KEY)
    {
      cls_line("");
      close_ix01();
      return;
    }
    cls_line("");
    strcpy(keyo,eingabe_zeileo);
    ix_zeiger = locate_ix01(eingabe_zeileo,&ix01rec);
    if (ix_zeiger == -1)
    {
       sprintf(wrtxtbu,"\n[Record with key %s not found]>",eingabe_zeileo);
       wrtxt(wrtxtbu);
       tastelesen();
       close_ix01();
       return;
    }
    ogrenze = ix_zeiger;
    if (ugrenze > ogrenze)
    {
       wrtxt("\n[Reverse order of lower and upper limits]>");
       tastelesen();
       close_ix01();
       return;
    }

    if ((fpbbt = fopen(bbt_name,"wb"))==NULL)
    {
       sprintf(fehlermeldung,"ERROR: Cannot write into %s",bbt_name);
       beenden(fehlermeldung,2);
    }
    memset(&one_bbt_rec,0,sizeof(one_bbt_rec));
    byte_zeiger = ugrenze * sizeof(ix01rec);
    fseek(ix01file,byte_zeiger,SEEK_SET);
    sprintf(wrtxtbu,"Writing %s, please wait...\n",bbt_name);
    wrtxt(wrtxtbu);
    for (i=ugrenze; i<=ogrenze;i++)
    {
      fread(&ix01rec,sizeof(ix01rec),1,ix01file);
      strncpy(one_bbt_rec.kennziffer,ix01rec.kennziffer,KENNZIFFER_LEN +1);
      fwrite(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
    }

    fclose(fpbbt);
    close_ix01();

    sprintf(wrtxtbu,"\n[%s closed, please press any key]>",bbt_name);
    wrtxt(wrtxtbu);
    tastelesen();


}


static int extract_text_duplicates(void)
{

   static char eingabe[DOSDATEIVORNAME_LEN+1];
   bbatchtable_rec new_bbt_rec, old_bbt_rec;
   char in_bbt_name[PFAD_LEN];
   FILE * fpinbbt;
   char out_bbt_name[PFAD_LEN];
   FILE * fpoutbbt;
   int taste, option;
   long i, anzahl_records;
       /* last comparison equal: 0 no 1 yes */
   int lce;
       /* in_bbt_name sorted? 0 no 1 yes */
   int in_sortiert;


   if (!datei_suchen("*.BBT",in_bbt_name))
   {
      wrtxt("\n[Please press any key]>");
      tastelesen();
      return 0;
   }
   upper(in_bbt_name);
   wrtxt("\n\n");
   sc_gotoxy(1,one_config_set.sl-1);

   do
   {
       info_zeile("Enter a filename for the output BBT file, [Esc] to leave");
       strcpy(wrtxtbu,"BBT file...........");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   eingabe,
                   DOSDATEIVORNAME_LEN,
                   DOSDATEIVORNAME_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
       if (taste==ESC_KEY) return 0;
       if (isdosfilename(eingabe)==0)
       {
           taste=200;
           continue;
       }
       upper(eingabe);
   }
   while (taste!=ENTER_KEY);
   sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
   sc_gotoxy(1,one_config_set.sl);sc_clreol();
   sc_gotoxy(1,one_config_set.sl-1);

   if (!strcmp(eingabe,"")) return 0;
   if (taste==ESC_KEY) return 0;
   strcpy(out_bbt_name,eingabe);
   strcat(out_bbt_name,".BBT");
   if (!strcmp(in_bbt_name,out_bbt_name))
   {
      wrtxt("\n[Problem: the same file selected for input and output]>");
      tastelesen();
      return 0;
   }
   if (isfile(out_bbt_name))
   {
      option = lotus_menu("Cancel$Quit the 'extract duplicate records' procedure@"
                          "Overwrite$Overwrite the existent BBT-file");
      if (option<=1) return 0;
   }

   if (filesize(in_bbt_name) < sizeof(new_bbt_rec)*2)
   {
       sprintf(wrtxtbu,"\n[File %s contains < 2 records, please press any key]>",
       in_bbt_name);
       wrtxt(wrtxtbu);
       tastelesen();
       return 0;
   }

   if ((fpinbbt=fopen(in_bbt_name,"rb"))==NULL)
   {
      sprintf(fehlermeldung,"ERROR: unable to read %s",in_bbt_name);
      beenden(fehlermeldung,2);
   }

   memset(&new_bbt_rec,0L,sizeof(new_bbt_rec));
   memset(&old_bbt_rec,0L,sizeof(old_bbt_rec));

   in_sortiert = 1;
   fseek(fpinbbt,0L,SEEK_END);
   anzahl_records = ftell(fpinbbt)/sizeof(new_bbt_rec);
   anzahl_records--;
   rewind(fpinbbt);

   for (i=0;i<=anzahl_records;i++)
   {
      fread(&new_bbt_rec,sizeof(new_bbt_rec),1,fpinbbt);
      if (strcmp_fun(old_bbt_rec.sortierfeld,
                     new_bbt_rec.sortierfeld,
                     SSTRING) > 0)
      {
           in_sortiert = 0;
           break;
      }
      old_bbt_rec = new_bbt_rec;
   }
   fclose(fpinbbt);

   if (in_sortiert==0)
   {
     sprintf(wrtxtbu,"Sorting %s...\n",in_bbt_name);
     wrtxt(wrtxtbu);
     domergebbf2(in_bbt_name,tmpbbt_name);
     remove(in_bbt_name);
     rename(tmpbbt_name,in_bbt_name);
   }
   else
   {
      sprintf(wrtxtbu,"Data in %s found sorted...",in_bbt_name);
      wrtxt(wrtxtbu);
   }
   if ((fpinbbt=fopen(in_bbt_name,"rb"))==NULL)
   {
      sprintf(fehlermeldung,"ERROR: unable to read %s",in_bbt_name);
      beenden(fehlermeldung,2);
   }
   if ((fpoutbbt=fopen(out_bbt_name,"wb"))==NULL)
   {
      sprintf(fehlermeldung,"ERROR: unable to create/write "
        "into %s",out_bbt_name);
      beenden(fehlermeldung,2);
   }
   rewind(fpinbbt);
   memset(&new_bbt_rec,0L,sizeof(new_bbt_rec));
   memset(&old_bbt_rec,0L,sizeof(old_bbt_rec));
   lce = 0;
   for (i=0;i<=anzahl_records;i++)
   {
      fread(&new_bbt_rec,sizeof(new_bbt_rec),1,fpinbbt);

      if (strcmp(new_bbt_rec.sortierfeld,old_bbt_rec.sortierfeld)==0)
      {
         lce = 1;
         if (i>0) fwrite(&old_bbt_rec,sizeof(old_bbt_rec),1,fpoutbbt);
         if (i==anzahl_records)
         {
            fwrite(&new_bbt_rec,sizeof(new_bbt_rec),1,fpoutbbt);
         }
      }

      if (strcmp(new_bbt_rec.sortierfeld,old_bbt_rec.sortierfeld)!=0 &&
         lce==1)
      {
          lce = 0;
          fwrite(&old_bbt_rec,sizeof(old_bbt_rec),1,fpoutbbt);

      }
      else if (strcmp(new_bbt_rec.sortierfeld,old_bbt_rec.sortierfeld)!=0 &&
         lce==0)
      {
         lce = 0;
      }
      old_bbt_rec = new_bbt_rec;
   }
   fclose(fpinbbt);
   fclose(fpoutbbt);
   sprintf(wrtxtbu,"\n\n[Transfer of duplicate records to %s completed]>",
     out_bbt_name);
   wrtxt(wrtxtbu);
   tastelesen();

   return 1;
}


static long verschluesseln(char * zeile)
{
    unsigned char zeichen;
    unsigned int i;
    unsigned int laenge;
    long zaehler;

    zaehler = 0;
    if (strlen(zeile) == 0) return 0L;
    laenge = strlen (zeile);
    for (i=0;i<laenge;i++)
    {
       zeichen = zeile[i];
       if (zeichen != ' ' &&
           zeichen != '.' &&
           zeichen != ',' &&
           zeichen != '?' &&
           zeichen != '-' &&
           zeichen != '\"' &&
           zeichen != '\'' &&
           zeichen != '-' &&
           zeichen != ')' &&
           zeichen != '(' &&
           zeichen != '!' &&
           zeichen != ';'
           )
       zaehler = zaehler + zeichen;
    }
    return zaehler;
}



static int write_urid(void)
{
     long byte_zeiger, i, j, anzahl_records, ix_zeiger;
     bbatchtable_rec     one_bbt_rec;
     refspix_rec         ix01rec;
     journal_rec         one_journal_rec;
     author_rec          one_aued_rec;
     buch_rec            one_buch_rec;
     long titel_kennung, autoren_kennung;
     char kennstring[SORTIERFELD_LEN+1];
     int caseins;  /* 0: case insensitive 1: case sensitive */
     int taste;

     taste = lotus_menu("@CaseSensitive$Write UNIQUE RECORD IDENTIFIER case sensitive into BBT-file"
                        "@Insensitive$Write UNIQUE RECORD IDENTIFIER case insensitive into BBT-file");
     if (taste==0) return 0;
     if (taste==1) caseins = 0;
     else caseins = 1;

     if (!datei_suchen("*.BBT",bbt_name))
     {
       wrtxt("\n[Please press any key]>");
       tastelesen();
       return 0;
     }
     if (filesize(bbt_name) < sizeof(one_bbt_rec))
     {
        sprintf(wrtxtbu,"\n[File %s is empty, please press any key]>",
          bbt_name);
        wrtxt(wrtxtbu);
        tastelesen();
        return 0;
     }
     wrtxt("\n");

     if ((fpbbt=fopen(bbt_name,"rb"))==NULL)
     {
         sprintf(fehlermeldung,"ERROR: Cannot read %s",bbt_name);
         beenden(fehlermeldung,2);
     }
     if (setvbuf(fpbbt,NULL,_IOFBF,5000)!=0)
     {
         sprintf(fehlermeldung,"ERROR: Unable to allocate memory "
            "for buffering %s",bbt_name);
         beenden(fehlermeldung,2);
     }
     if ((tmpbbt=fopen(tmpbbt_name,"wb"))==NULL)
     {
         sprintf(fehlermeldung,"ERROR: Cannot create %s",
             tmpbbt_name);
         beenden(fehlermeldung,2);
     }
     if (setvbuf(tmpbbt,NULL,_IOFBF,2000)!=0)
     {
         sprintf(fehlermeldung,"ERROR: Unable to allocate memory "
            "for buffering %s",tmpbbt_name);
         beenden(fehlermeldung,2);
     }
     if ((fpjournal=fopen(journal_name,"rb"))==NULL)
     {
         sprintf(fehlermeldung,"ERROR: Cannot read %s",
              journal_name);
         beenden(fehlermeldung,2);
     }
     if ((ix01file=fopen(journal_pix_name,"rb"))==NULL)
     {
         sprintf(fehlermeldung,"ERROR: Cannot read %s",
              journal_pix_name);
         beenden(fehlermeldung,2);
     }
     if ((fpautorjl=fopen(autorjl_name,"rb"))==NULL)
     {
         sprintf(fehlermeldung,"ERROR: Cannot read %s",
              autorjl_name);
         beenden(fehlermeldung,2);
     }
     if ((fpautorbu=fopen(autorbu_name,"rb"))==NULL)
     {
         sprintf(fehlermeldung,"ERROR: Cannot read %s",
              autorbu_name);
         beenden(fehlermeldung,2);
     }
     if ((fpbuch=fopen(book_name,"rb"))==NULL)
     {
         sprintf(fehlermeldung,"ERROR: Cannot read %s",
              book_name);
         beenden(fehlermeldung,2);
     }
     fseek(fpbbt,0L,SEEK_END);
     byte_zeiger = ftell(fpbbt);
     anzahl_records = byte_zeiger / sizeof(one_bbt_rec);
     anzahl_records--;
     rewind(fpbbt);
     wrtxt("Writing unique identifiers, please wait...\n");
     for (i=0;i<=anzahl_records;i++)
     {

         if (delaywrite > 0)
         {
#if defined(__EMX__)
            if (((i+1) % 200)==0) { _sleep2 ((unsigned int) delaywrite); }
#endif
#if defined(__DJGPP__)
            if (((i+1) % 200)==0) { delay ((unsigned int) delaywrite); }
#endif
         }

         titel_kennung = 0;
         autoren_kennung = 0;
         memset(&one_bbt_rec,0,sizeof(one_bbt_rec));
         fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
         ix_zeiger = locate_ix01(one_bbt_rec.kennziffer,&ix01rec);
         if (ix_zeiger>-1)
         {
            byte_zeiger = ix01rec.journal_rptr*sizeof(one_journal_rec);
            fseek(fpjournal,byte_zeiger,SEEK_SET);
            fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
            if (!strcmp(one_journal_rec.reftyp,"j1"))
            {
                if (caseins) upper (one_journal_rec.reftyp);
                if (caseins) upper (one_journal_rec.titel);
                titel_kennung = titel_kennung +
                    verschluesseln(one_journal_rec.titel);
                if (caseins) upper (one_journal_rec.seite_von);
                titel_kennung = titel_kennung +
                    verschluesseln(one_journal_rec.seite_von);
                if (caseins) upper (one_journal_rec.seite_bis);
                titel_kennung = titel_kennung +
                    verschluesseln(one_journal_rec.seite_bis);
                byte_zeiger = ix01rec.autorjl_rptr * sizeof(one_aued_rec);
                fseek(fpautorjl,byte_zeiger,SEEK_SET);
                fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
                fseek(fpautorjl,byte_zeiger,SEEK_SET);
                for (j=1;j <= one_aued_rec.au_n;j++)
                {
                  fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);

                  if (caseins) upper (one_aued_rec.au_nachname);
                  autoren_kennung = autoren_kennung +
                       verschluesseln(one_aued_rec.au_nachname);
                  if (caseins) upper (one_aued_rec.au_vornamen);
                   autoren_kennung = autoren_kennung +
                       verschluesseln(one_aued_rec.au_vornamen);
                    if (j >= 20) break;
                }

            }  /* Ende j1 */
            else if (!strcmp(one_journal_rec.reftyp,"b1"))
            {
                if (caseins) upper (one_journal_rec.reftyp);
                byte_zeiger = ix01rec.buch_rptr*sizeof(one_buch_rec);
                fseek(fpbuch,byte_zeiger,SEEK_SET);
                if (fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch)!=1)
                {
                   sprintf(fehlermeldung,"ERROR: cannot read %s",book_name);
                   beenden(fehlermeldung,2);
                }
                if (caseins) upper (one_buch_rec.titel_bu);
                titel_kennung = titel_kennung +
                    verschluesseln(one_buch_rec.titel_bu);
                if (caseins) upper (one_buch_rec.verlag);
                titel_kennung = titel_kennung +
                    verschluesseln(one_buch_rec.verlag);
                if (caseins) upper (one_journal_rec.seite_von);
                titel_kennung = titel_kennung +
                    verschluesseln(one_journal_rec.seite_von);
                if (caseins) upper (one_journal_rec.seite_bis);
                titel_kennung = titel_kennung +
                    verschluesseln(one_journal_rec.seite_bis);
                if (caseins) upper (one_journal_rec.band);
                titel_kennung = titel_kennung +
                    verschluesseln(one_journal_rec.band);
                byte_zeiger = ix01rec.autorbu_rptr * sizeof(one_aued_rec);
                fseek(fpautorbu,byte_zeiger,SEEK_SET);
                fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
                fseek(fpautorbu,byte_zeiger,SEEK_SET);
                for (j=1;j <= one_aued_rec.au_n;j++)
                {
                  fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
                  if (caseins) upper (one_aued_rec.au_nachname);
                  autoren_kennung = autoren_kennung +
                       verschluesseln(one_aued_rec.au_nachname);
                  if (caseins) upper (one_aued_rec.au_vornamen);
                  autoren_kennung = autoren_kennung +
                       verschluesseln(one_aued_rec.au_vornamen);
                    if (j >= 20) break;
                }
            }  /* Ende b1 */
            else
            {
                if (caseins) upper (one_journal_rec.reftyp);
                byte_zeiger = ix01rec.buch_rptr*sizeof(one_buch_rec);
                fseek(fpbuch,byte_zeiger,SEEK_SET);
                if (fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch)!=1)
                {
                   sprintf(fehlermeldung,"ERROR: cannot read %s",book_name);
                   beenden(fehlermeldung,2);
                }
                if (caseins) upper (one_buch_rec.titel_bu);
                titel_kennung = titel_kennung +
                    verschluesseln(one_buch_rec.titel_bu);
                if (caseins) upper (one_buch_rec.verlag);
                titel_kennung = titel_kennung +
                    verschluesseln(one_buch_rec.verlag);
                if (caseins) upper (one_journal_rec.titel);
                titel_kennung = titel_kennung +
                    verschluesseln(one_journal_rec.titel);
                if (caseins) upper (one_journal_rec.seite_von);
                titel_kennung = titel_kennung +
                    verschluesseln(one_journal_rec.seite_von);
                if (caseins) upper (one_journal_rec.seite_bis);
                titel_kennung = titel_kennung +
                    verschluesseln(one_journal_rec.seite_bis);
                if (caseins) upper (one_journal_rec.band);
                titel_kennung = titel_kennung +
                    verschluesseln(one_journal_rec.band);

                byte_zeiger = ix01rec.autorjl_rptr * sizeof(one_aued_rec);
                fseek(fpautorjl,byte_zeiger,SEEK_SET);
                fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
                fseek(fpautorjl,byte_zeiger,SEEK_SET);
                for (j=1;j <= one_aued_rec.au_n;j++)
                {
                  fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
                  if (caseins) upper (one_aued_rec.au_nachname);
                  autoren_kennung = autoren_kennung +
                       verschluesseln(one_aued_rec.au_nachname);
                   if (caseins) upper (one_aued_rec.au_vornamen);
                   autoren_kennung = autoren_kennung +
                       verschluesseln(one_aued_rec.au_vornamen);
                    if (j >= 20) break;
                }

                byte_zeiger = ix01rec.autorbu_rptr * sizeof(one_aued_rec);
                fseek(fpautorbu,byte_zeiger,SEEK_SET);
                fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
                fseek(fpautorbu,byte_zeiger,SEEK_SET);
                for (j=1;j <= one_aued_rec.au_n;j++)
                {
                  fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
                  if (caseins) upper (one_aued_rec.au_nachname);
                  autoren_kennung = autoren_kennung +
                       verschluesseln(one_aued_rec.au_nachname);
                  if (caseins) upper (one_aued_rec.au_vornamen);
                   autoren_kennung = autoren_kennung +
                       verschluesseln(one_aued_rec.au_vornamen);
                    if (j >= 20) break;
                }


            }  /* Ende b2 */
            sprintf(kennstring,"%s-%03lX-%08lX-%08lX",
                    one_journal_rec.reftyp,
                    verschluesseln(one_journal_rec.jahrgang),
                    titel_kennung,
                    autoren_kennung
                   );
            strcpy(one_bbt_rec.sortierfeld,kennstring);
            strcpy(one_bbt_rec.kennziffer,ix01rec.kennziffer);
            fwrite(&one_bbt_rec,sizeof(one_bbt_rec),1,tmpbbt);
         }
     }
     fclose(fpbbt);
     fclose(tmpbbt);
     fclose(fpjournal);
     close_ix01();
     fclose(fpautorjl);
     fclose(fpautorbu);
     fclose(fpbuch);
     remove(bbt_name);
     rename(tmpbbt_name,bbt_name);
     wrtxt("\n[Please press any key]>");
     tastelesen();

    return 1;
}


static int remove_double_but_1st(void)
{
    long anzahl_records, i, j;
    bbatchtable_rec new_bbt_rec, old_bbt_rec;
    int schon_vorhanden;
    long byte_zeiger;

    if(!datei_suchen("*.BBT",bbt_name))
    {
        wrtxt("\n[Please press any key]>");
        tastelesen();
        return 0;
    }
    upper(bbt_name);
    if ((fpbbt=fopen(bbt_name,"rb"))==NULL)
    {
       sprintf(fehlermeldung,"ERROR: unable to read %s",bbt_name);
       beenden(fehlermeldung,2);
    }
    if ((tmpbbt=fopen(tmpbbt_name,"wb"))==NULL)
    {
       sprintf(fehlermeldung,"ERROR: unable to create %s",tmpbbt_name);
       beenden(fehlermeldung,2);
    }

    fseek(fpbbt,0L,SEEK_END);
    byte_zeiger = ftell(fpbbt);
    anzahl_records = byte_zeiger / sizeof(new_bbt_rec);
    anzahl_records--;
    rewind(fpbbt);
    wrtxt("\nExtracting duplicate records from BBT-file...\n");
    wrtxt("(This will take some time with large BBT-files)\n");
    if (anzahl_records<=0)
    {
       fclose(fpbbt);
       fclose(tmpbbt);
       wrtxt("Information: BBT file with less than 2 records will "
         "not be processed.");
       wrtxt("\n\n[Please press any key]>");
       tastelesen();
       return 0;
    }
    fread(&new_bbt_rec,sizeof(new_bbt_rec),1,fpbbt);
    fwrite(&new_bbt_rec,sizeof(new_bbt_rec),1,tmpbbt);
    old_bbt_rec = new_bbt_rec;
    for (i=1;i<=anzahl_records;i++)
    {
        byte_zeiger = i * sizeof(new_bbt_rec);
        fseek(fpbbt,byte_zeiger,SEEK_SET);
        fread(&new_bbt_rec,sizeof(new_bbt_rec),1,fpbbt);
        schon_vorhanden = 0;
        fseek(fpbbt,0L,SEEK_SET);
        for (j=0;j<i;j++)
        {
           fread(&old_bbt_rec,sizeof(old_bbt_rec),1,fpbbt);
           if (!strcmp(new_bbt_rec.kennziffer,old_bbt_rec.kennziffer))
           {
              schon_vorhanden=1;
              break;
           }
        }
        if (!schon_vorhanden)
        {
           fwrite(&new_bbt_rec,sizeof(new_bbt_rec),1,tmpbbt);
        }
    }

    fclose(fpbbt);
    fclose(tmpbbt);
    remove(bbt_name);
    rename(tmpbbt_name,bbt_name);

    wrtxt("\n[Completed, please press any key]>");
    tastelesen();
    return 1;
}



static int writebbt(void)
{
   int taste;
   static int dateipos;
   bbatchtable_rec one_bbt_rec;
   long  byte_zeiger, anzahl_records, zeiger, i;

   if (!datei_suchen_default("*.BBT",bbt_name,&dateipos))
   {
      wrtxt("\n[Please press any key]>");
      tastelesen();
      return 0;
   }
   wrtxt("\n\n");
   sc_gotoxy(1,one_config_set.sl-1);
   if ((fpbbt=fopen(bbt_name,"rb"))==NULL)
   {
       sprintf(wrtxtbu,"\n[Cannot read %s]>",bbt_name);
       wrtxt(wrtxtbu);
       tastelesen();
       return 0;
   }
   fseek(fpbbt,0L,SEEK_END);
   byte_zeiger = ftell(fpbbt);
   anzahl_records = byte_zeiger / sizeof(one_bbt_rec);
   anzahl_records--;

   if ((tmpbbt=fopen(tmpbbt_name,"wb"))==NULL)
   {
       sprintf(wrtxtbu,"\n[Cannot create %s]>",tmpbbt_name);
       wrtxt(wrtxtbu);
       tastelesen();
       return 0;
   }
   memset(&one_bbt_rec,0,sizeof(one_bbt_rec));
   rewind(fpbbt);
   for (i=0;i <= anzahl_records; i++)
   {
       fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
       fwrite(&one_bbt_rec,sizeof(one_bbt_rec),1,tmpbbt);
   }

   fclose(tmpbbt);
   fclose(fpbbt);
   if (anzahl_records< 0)
   {
       sprintf(wrtxtbu,"%s is empty, inserting one empty record...\n"
                           "\n[Please press any key]>",bbt_name);
       wrtxt(wrtxtbu);
       tastelesen();
       sc_gotoxy(1,one_config_set.sl);
       sc_clreol();
       if ((fpbbt=fopen(bbt_name,"wb"))==NULL)
       {

          sprintf(wrtxtbu,"[Cannot write into %s]>",bbt_name);
          wrtxt(wrtxtbu);
          tastelesen();
          return 0;

       }
       memset(&one_bbt_rec,0,sizeof(one_bbt_rec));
       fwrite(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
       fclose(fpbbt);
       anzahl_records=0;
   }
   wrtxt("\n");
   if ((fpbbt=fopen(bbt_name,"r+b"))==NULL)
   {
       sprintf(wrtxtbu,"[Cannot read %s]>",bbt_name);
       wrtxt(wrtxtbu);
       tastelesen();
       return 0;
   }

   zeiger = 0;

   for (;;)
   {
      size_t ok_gelesen;
      byte_zeiger = sizeof(one_bbt_rec)*zeiger;
      fseek(fpbbt,byte_zeiger,SEEK_SET);
      memset(&one_bbt_rec,0,sizeof(one_bbt_rec));
      ok_gelesen=fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
      taste=edit_bbt_rec(&one_bbt_rec,zeiger,anzahl_records);
      fseek(fpbbt,byte_zeiger,SEEK_SET);
      fwrite(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
      if (taste==ESC_KEY || taste==F10_KEY)
      {  
         int bbt_write_taste;
         fclose(fpbbt);
         
         bbt_write_taste=lotus_menu(
                "@Ok$Save the changes made in BBT-file"
                "@Cancel$Do not save the changes made in BBT-file");
         if (bbt_write_taste==1)
         {
            remove(tmpbbt_name);
         }
         else
         {
            remove(bbt_name);
            rename(tmpbbt_name,bbt_name);
         }
         return 1;
      }
      if (taste==UP_KEY)
      {
         zeiger--;
      }
      if (taste==DOWN_KEY)
      {
         zeiger++;
      }
      if (taste==CTRLEND_KEY)
      {
         zeiger=anzahl_records;
      }
      if (taste==CTRLHOME_KEY)
      {
         zeiger=0L;
      }
      if (taste==PGDN_KEY)
      {
        zeiger = zeiger + 25;
      }
      if (taste==PGUP_KEY)
      {
        zeiger = zeiger - 25;
      }
      if (taste==CTRLPGDN_KEY)
      {
        fseek(fpbbt,0L,SEEK_END);
        memset(&one_bbt_rec,0,sizeof(one_bbt_rec));
        fwrite(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
        byte_zeiger = ftell(fpbbt);
        anzahl_records = byte_zeiger / sizeof(one_bbt_rec);
        anzahl_records--;
        zeiger = anzahl_records;
      }

      if ( zeiger < 0)
      {
        beeps();
        zeiger = 0;
      }

      if ( zeiger > anzahl_records)
      {
        beeps();
        zeiger = anzahl_records;
      }
   }
   return 1;
}



static int edit_bbt_rec(bbatchtable_rec * one_bbt_rec, long zeiger, long max)
{
   int status, taste;
   char iz[INFO_Z_LEN];
   status = 2;
   sprintf(iz,"Record # %li/%li, [Ctrl-PgDn] append, [F10] or [ESC] Quit",zeiger,max);
   do
   {
       info_zeile(iz);
       do
       {
              sc_gotoxy(1,one_config_set.sl-1);
              strcpy(wrtxtbu,"Reference No...");
              wrtxt(wrtxtbu);
              taste = e_zle(
                       1+strlen(wrtxtbu),
                       one_config_set.sl-1,
                       one_bbt_rec->kennziffer,
                       KENNZIFFER_LEN,
                       KENNZIFFER_LEN,
                       status
                        );
              if (taste == UP_KEY ||
                  taste == DOWN_KEY ||
                  taste== ESC_KEY ||
                  taste== F10_KEY ||
                  taste == CTRLHOME_KEY ||
                  taste == CTRLEND_KEY ||
                  taste == PGDN_KEY ||
                  taste == PGUP_KEY ||
                  taste == CTRLPGDN_KEY
                  )
              {
                  return taste;
              }
       } while(taste != TAB_KEY && taste!=SHIFTTAB_KEY &&
               taste != ENTER_KEY && status == 0);

       do
       {
            sc_gotoxy(1+strlen("Reference No...")+KENNZIFFER_LEN+2,one_config_set.sl-1);
            strcpy(wrtxtbu," Text...");
            wrtxt(wrtxtbu);
            taste = e_zle(
                       1+strlen(wrtxtbu)+strlen("Reference No...")+KENNZIFFER_LEN+2,
                       one_config_set.sl-1,
                       one_bbt_rec->sortierfeld,
                       SORTIERFELD_LEN,
                       SORTIERFELD_LEN,
                       status
                        );
              if (taste == UP_KEY ||
                  taste == DOWN_KEY ||
                  taste== ESC_KEY ||
                  taste== F10_KEY ||
                  taste == CTRLHOME_KEY ||
                  taste == CTRLEND_KEY ||
                  taste == PGDN_KEY ||
                  taste == PGUP_KEY ||
                  taste == CTRLPGDN_KEY
                  )
              {
                  return taste;
              }
       } while(taste != TAB_KEY && taste!=SHIFTTAB_KEY &&
               taste != ENTER_KEY && status == 0);
       if (status == 2)
       {
          status=0;
       }
   } while(1);

   return 0;
}

static int remove_empty_records(void)
{
    long anzahl_records, i;
    bbatchtable_rec new_bbt_rec;
    long byte_zeiger;

    if(!datei_suchen("*.BBT",bbt_name))
    {
        wrtxt("\n[Please press any key]>");
        tastelesen();
        return 0;
    }
    upper(bbt_name);
    if (filesize(bbt_name) < sizeof(new_bbt_rec))
    {
        wrtxt("\n[BBT file is empty and will not be processed, "
                    "please press any key]>");
        tastelesen();
        return 0;
    }
    if ((fpbbt=fopen(bbt_name,"rb"))==NULL)
    {
       sprintf(fehlermeldung,"ERROR: unable to read %s",bbt_name);
       beenden(fehlermeldung,2);
    }
    if ((tmpbbt=fopen(tmpbbt_name,"wb"))==NULL)
    {
       sprintf(fehlermeldung,"ERROR: unable to create %s",tmpbbt_name);
       beenden(fehlermeldung,2);
    }

    fseek(fpbbt,0L,SEEK_END);
    byte_zeiger = ftell(fpbbt);
    anzahl_records = byte_zeiger / sizeof(new_bbt_rec);
    anzahl_records--;
    rewind(fpbbt);
    sprintf(wrtxtbu,"\nExtracting 'empty' records from BBT-file with %li records...\n",
               anzahl_records+1);
    wrtxt(wrtxtbu);

    for (i=0;i<=anzahl_records;i++)
    {
        fread(&new_bbt_rec,sizeof(new_bbt_rec),1,fpbbt);
        if (strlen(new_bbt_rec.kennziffer) > 0)
        {
           fwrite(&new_bbt_rec,sizeof(new_bbt_rec),1,tmpbbt);
        }
    }

    fclose(fpbbt);
    fclose(tmpbbt);
    remove(bbt_name);
    rename(tmpbbt_name,bbt_name);

    wrtxt("\n[Completed, please press any key]>");
    tastelesen();
    return 1;
}


static int invertbbt_order(void)
{
   static char eingabe[DOSDATEIVORNAME_LEN+1];
   bbatchtable_rec new_bbt_rec;
   char in_bbt_name[PFAD_LEN];
   FILE * fpinbbt;
   char out_bbt_name[PFAD_LEN];
   FILE * fpoutbbt;
   int taste, option;
   long i, anzahl_records;


   if (!datei_suchen("*.BBT",in_bbt_name))
   {
      wrtxt("\n[Please press any key]>");
      tastelesen();
      return 0;
   }
   upper(in_bbt_name);
   wrtxt("\n\n");
   sc_gotoxy(1,one_config_set.sl-1);

   do
   {
       info_zeile("Enter a filename for the output BBT file, [Esc] to leave");
       strcpy(wrtxtbu,"BBT file...........");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   eingabe,
                   DOSDATEIVORNAME_LEN,
                   DOSDATEIVORNAME_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
       if (taste==ESC_KEY) return 0;
       if (isdosfilename(eingabe)==0)
       {
           taste=200;
           continue;
       }
       upper(eingabe);
   }
   while (taste!=ENTER_KEY);
   sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
   sc_gotoxy(1,one_config_set.sl);sc_clreol();
   sc_gotoxy(1,one_config_set.sl-1);

   if (!strcmp(eingabe,"")) return 0;
   if (taste==ESC_KEY) return 0;
   strcpy(out_bbt_name,eingabe);
   strcat(out_bbt_name,".BBT");
   if (!strcmp(in_bbt_name,out_bbt_name))
   {
      wrtxt("\n[Problem: the same file selected for input and output]>");
      tastelesen();
      return 0;
   }
   if (isfile(out_bbt_name))
   {
      option = lotus_menu("Cancel$Quit the 'invert seqence of records' procedure@"
                          "Overwrite$Overwrite the existent BBT-file");
      if (option<=1) return 0;
   }

   if (filesize(in_bbt_name) < sizeof(new_bbt_rec)*2)
   {
       sprintf(wrtxtbu,"\n[File %s contains < 2 records, please press any key]>",
       in_bbt_name);
       wrtxt(wrtxtbu);
       tastelesen();
       return 0;
   }

   if ((fpinbbt=fopen(in_bbt_name,"rb"))==NULL)
   {
      sprintf(fehlermeldung,"ERROR: unable to read %s",in_bbt_name);
      beenden(fehlermeldung,2);
   }

   if ((fpoutbbt=fopen(out_bbt_name,"wb"))==NULL)
   {
      sprintf(fehlermeldung,"ERROR: unable to create/write "
        "into %s",out_bbt_name);
      beenden(fehlermeldung,2);
   }

   fseek(fpinbbt,0L,SEEK_END);
   anzahl_records = ftell(fpinbbt)/sizeof(new_bbt_rec);
   anzahl_records--;
   wrtxt("Please wait...");
   for (i=anzahl_records;i>=0;i--)
   {
      fseek(fpinbbt,i*sizeof(new_bbt_rec),SEEK_SET);
      fread(&new_bbt_rec,sizeof(new_bbt_rec),1,fpinbbt);
      fwrite(&new_bbt_rec,sizeof(new_bbt_rec),1,fpoutbbt);
   }
   fclose(fpinbbt);
   fclose(fpoutbbt);
   sprintf(wrtxtbu,"\n\n[Writing inverted records to %s completed]>",
     out_bbt_name);
   wrtxt(wrtxtbu);
   tastelesen();

   return 1;
}
