#include <fastgraf.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <alloc.h>

/*
ͻ
             ۲ WordUp Graphics Toolkit V4.0               
 Conversion Utility   Copyright 1994 WordUp Software Productions 
Ķ
 Program:      spr2fg.c                                          
 Description:  Utility for converting a WGT sprite file to       
               a Fastgraph format.                               
                                                                 
 Written by:   Chris Egerter                                     
ͼ
*/


/*
ͻ
  WGT Sprite File to Fastgraph conversion program                
                                                                 
  The file format is not one already used in Fastgraph, but      
  an altered version of the WGT sprite format.                   
                                                                 
  Note that this version works only in 256 color modes.          
ͼ
*/



unsigned char *sprites[2001];
void convertsprites (char *infile, char *outfile);
void loadsprites (char *infile, void far *loadspr[]);
void testsprites ();
void freesprites (void far *freespr[]);

int oldmode;
int width[2001], height[2001];


int main(void)
{
 oldmode = fg_getmode ();
 fg_setmode (19);  /* This mode can be any 256 color graphics mode */

 convertsprites ("sprtconv.spr", "out.spr");
 loadsprites ("out.spr", sprites);
 testsprites ();
 freesprites (sprites);


 /* clean up */
 fg_setmode (oldmode);
 return 0;
}

void convertsprites(char *infile, char *outfile)
{
FILE *in;   /* 256 color sprite file */
FILE *out;  /* converted sprite file */
unsigned char palette[768]; 		/* 256 * 3 (RGB values) */
int maxcolor;
int maxsprite;
unsigned size;

char far *temp;
int a, b, i, spritemade;
char buf[14];
unsigned char c;
int x, y;
int startingsprite;

 /* Open the files */
 if ((in = fopen (infile, "rb")) == NULL)
  {
   fg_setmode (oldmode);
   printf ("Could not open 256 color sprite file");
   exit (1);
  }
 if ((out = fopen (outfile, "wb")) == NULL)
  {
   fg_setmode (oldmode);
   printf ("Could not open converted sprite file");
   exit (1);
  }

 fread(&a, 1, 2, in);
     /* Get the version number, and change the startingsprite accordingly.
     If version <= 3, maxsprite contains the maximum number of sprites
     that can be stored in a file.  If version > 4, maxsprite contains
     the number of the highest sprite in the file. (empty sprites at
     the end are not kept in the file. */
 if (a <= 3)
   startingsprite = 1;
 else startingsprite = 0;    /* Version 4 starts at sprite 0 */



 fread (buf, 1, 13, in); /* sprite header */
 if (0 == strnicmp (" Sprite File ", buf, 13)) 
  /* see if it is a sprite file */
  {
   fread (palette, 1, 768, in); /* Read in 256 color palette */
   maxcolor = 256;
   fwrite(&maxcolor, 1, 2, out); 
   /* Write the number of colors stored in file */

   for (i = 0; i < maxcolor; i++) /* read in the palette */
    {
     fputc (palette[i*3],   out);    /* Write out Red */
     fputc (palette[i*3+1], out);    /* Green */
     fputc (palette[i*3+2], out);    /* And Blue color values */
    }
        
   fread(&maxsprite, 1, 2, in); /* maximum sprites in this file */
   fwrite(&maxsprite, 1, 2, out); 
   for (i = startingsprite; i <= maxsprite; i++) /* load them in */
     {
      fread(&spritemade, 1, 2, in);    /* flag to see if sprite exists */
      fwrite(&spritemade, 1, 2, out); 
      if (spritemade == 1)
        {
         fg_setcolor (0);
	 fg_rect (0, fg_getmaxx (), 0, fg_getmaxy ());
         /* maximum sprite size */

         fread(&a, 1, 2, in); /* get width and height */
         fread(&b, 1, 2, in);
         fwrite(&a, 1, 2, out); /* put width and height */
         fwrite(&b, 1, 2, out); 

	 /* Read in the image data. Each byte represents a color
	    from 0-255. Obviously converting sprites that use more colors
	    than the current mode allows will not work. Draw sprites using
	    only the first colors (eg 0-16), up to maxcolors of the mode 
            you're using.  */
         for (y = 0; y < b; y++)
	   for (x = 0; x < a; x++)
	    {
	     c = fgetc (in);
	     fg_setcolor (c);
	     fg_point (x, y);
	    }

	 size = fg_imagesiz(a - 1, b - 1); /* get byte size of image */
	 if ((temp = (char far *)farmalloc (size)) == NULL)
	   {
	    fg_setmode (oldmode);
	    printf ("Error: not enough heap space in convertsprites.\n");
	    exit (1);
	   }
	 fg_move (0, b);
	 fg_getimage(temp, a - 1, b - 1); /* Get the image in new mode */
         fwrite(temp, size, 1, out); /* Write the data in getimage format */
	 farfree (temp);
	}
     }
  }
 fclose (in);
 fclose (out);
}


void loadsprites (char *infile, void far *loadspr[])
{
FILE *in;   /* converted color sprite file */
int maxsprite;
unsigned size;

int a, b, i, spritemade;
int maxcolor;
struct {
        unsigned char red, green, blue;
       } pal[256];

    /* Open the files */
 if ((in = fopen (infile, "rb")) == NULL)
   {
    fg_setmode (oldmode);
    printf ("Could not load converted color sprite file");
    exit (1);
   }

 fread(&maxcolor, 1, 2, in);

 fg_getdacs (0, 255, (char far *)pal);
 for (i = 0; i < maxcolor; i++) /* read in the palette */
   {
    pal[i].red = fgetc (in);
    pal[i].green = fgetc (in);
    pal[i].blue = fgetc (in);
   }
 fg_setdacs (0, 255, (char far *)pal);

 fread(&maxsprite, 1, 2, in); /* maximum sprites in this file */

 for (i = 0; i < maxsprite; i++) /* load them in */
   {
    fread(&spritemade, 1, 2, in); /* flag to see if sprite exists */
    if (spritemade == 1)
      {
       fread(&a, 1, 2, in);  /* get width and height */
       fread(&b, 1, 2, in);
       width[i] = a - 1;
       height[i] = b - 1;

       size = fg_imagesiz(a - 1, b - 1); /* get byte size of image */
       if ((loadspr[i] = farmalloc (size)) == NULL)
         {
          fg_setmode (oldmode);
	  printf ("Error: not enough heap space in loadsprites().\n");
	  freesprites (loadspr);
	  exit (1);
	 }
       fread (loadspr[i], size, 1, in);
      } 
      else loadspr[i] = NULL;
     }
    fclose (in);
}




void testsprites(void)
/* Loops through 10 sprites, displaying them on the screen
   using the putimage method. Press a key to go to the next sprite */
{
int i, j;

 for (i = 0; i < 10; i++) 
  {
   fg_erase ();

   if (sprites[i] != NULL)
     {
      for (j = 1; j < 20; j++)
       {
        fg_move (rand () % fg_getmaxx (),rand () % fg_getmaxy ());
        fg_drwimage ((char far *)sprites[i], width[i], height[i]);
       }
       /* Put the converted image on the screen */
      getch ();
     }
  }
}


void freesprites(void far *freespr[])
{
int i;

 for (i = 0; i < 2001; i++)
   {
    if (freespr[i] != NULL)
      farfree (freespr[i]);
   }
}