#include "micro.h"
#include "global.h"
#include "icon.h"

extern loc icon_size(int icon_type);    // defined in icon.cpp

void draw(rect r, loc ic)
    {
    loc field = icon_size(1);        // microscope works with size of icon 1
    rect work(r.origin.X + field.X + 50,
	      r.origin.Y,
	      r.origin.X + field.X * 6 + 50,
	      r.origin.Y + field.Y * 5);
    loc pos = e.where();
    if(!work.contains(pos))
	return;

    int x_pos = (pos.X - work.origin.X) / 5;   // No of cell 5x5 pixels
    int y_pos = (pos.Y - work.origin.Y) / 5;

    int color;
    if(e.msstatus.buttonstate == MOUSELEFT)  // left - do it,
	{
	setfillstyle(SOLID_FILL, global_i[6]);
	color = global_i[6];
	}
    else
	{
	setfillstyle(SOLID_FILL, global_i[7]);
	color = global_i[7];
	}
    mouseHideCursor();
    putpixel(ic.X + x_pos, ic.Y + y_pos, color);
    bar(work.origin.X + x_pos * 5, work.origin.Y + y_pos * 5,
	work.origin.X + (x_pos + 1) * 5, work.origin.Y + (y_pos + 1) * 5);
    mouseShowCursor();
    }
//////////////////////////
void reflect(loc from, loc to)
    {
    int color;
    loc end = from + icon_size(1);
    for(int i = from.X; i < end.X; i++)
	for(int j = from.Y; j < end.Y; j++)
	    {
	    color = getpixel(i, j);
	    setfillstyle(SOLID_FILL, color);
	    bar(to.X + (i - from.X) * 5, to.Y + (j - from.Y) * 5,
		to.X + (i - from.X + 1) * 5, to.Y + (j - from.Y + 1) * 5);
	    }
    }
/////////////////////////
Micro::Micro(rect coord)
    :Window(coord)
    {
    }
/////////////////////////
void Micro::show()
    {
    Window::show();
    mouseHideCursor();
    loc field = icon_size(1);            // microscope works with size of icon 1
    rect r = user_screen();

    Carcase c;
    rect work(r.origin.X + field.X + 50,
	      r.origin.Y,
	      r.origin.X + field.X * 6 + 50,
	      r.origin.Y + field.Y * 5);

    setfillstyle(SOLID_FILL, pColorSet->colors.ATTR_COLOR);
    c.show(SHOW_BORDER, rect(work.origin - 6, work.corner + 6));

    void* image;
    if(image = get_image("copy.res", 1))
	putimage(r.origin + 6, image);
    delete image;

    c.show(BUTTON_BORDER, rect(r.origin.X + 2, r.origin.Y + 2,
		r.origin.X + field.X + 10,
		r.origin.Y + field.Y + 10));

    reflect(r.origin + 6, work.origin);
    mouseShowCursor();
    }
///////////////////////////////
void Micro::exe(int act)
    {
    e.what = act ? KEYEVENT : NOEVENT;
    switch(act)
	{
	case AC_CANCEL: e.key = (isRet(RET_REMOVE))
	    ? EVENT_ALT_F3 : EVENT_ESC;
	    break;
	case AC_OK:     e.key = EVENT_F2; break;
	}
    rect r = user_screen();
    mouseHideCursor();
    if(!act)
	hilite();
    mouseShowCursor();

    while(1)
	{
	if(!act)
	    get_event();
	if(e.what == KEYEVENT)
	    switch(e.key)
		{
		case EVENT_F1: return;

		case EVENT_ESC: global_num = 0;  // don't save
		    global_i[0] = AC_NULL;
		    e.what = KEYEVENT;
		    e.key = EVENT_ESC;
		    return;
		case EVENT_F2:
		case EVENT_RETURN:
		    unhilite(); global_num = 1;
                    mouseHideCursor();
		    global_i[0] = action_type;
		    e.what = KEYEVENT;
		    e.key = EVENT_RETURN;
		    unlink("copy.res");
		    save_image("copy.res", user_screen().origin + 6, 1);
                    mouseShowCursor();
		    return;
		}
	else
	    {
	    if(!mouse_in(loc(e.where())))
		{
		unhilite();
		global_num = 0; global_i[0] = AC_NULL;
		return;
		}   // outside of menu box
	    else
		draw(r, user_screen().origin + 6);
	    }
	}
    }
//////////////////////////
