//: PAGENUM.CPP -- put page numbers and date on code listings
#include <fstream.h>
#include <strstream.h>
#include <string.h>
#include <dir.h>
#include "allege.h"
const char* file = "..\\codexref.txt";
ofstream errors("c:\\tmp\\errors.txt", ios::app);

main(int argc, char ** argv) {
  allege(argc == 2, "usage: pagenum filename");
  ifstream database(file);
  allegefile(database);
  const sz = 100;
  char buf[sz];
  int flag = 0;
  while(database.getline(buf, sz)) {
	 if(strncmp(buf, argv[1], strlen(argv[1])) == 0) {
		flag++; // found match
		char* p = strchr(buf, ']');
		*p = 0;
		p = strchr(buf, '[') + 1;
		ostrstream s;
		{
			ifstream code(argv[1]);
			allegefile(code);
			s << code.rdbuf();
		}
		ofstream newcode(argv[1]);
		allegefile(newcode);
		newcode << "// "
		  << p << " in \"Thinking in C++\" by Bruce Eckel"
		  << endl << s.rdbuf();
	 }
  }
  if(!flag) {
	 const bsz = 100;
	 char buf[bsz];
	 errors << getcwd(buf, bsz)
		<< " couldn't find match for " << argv[1] << endl;
  }
}




