// File from page 667 in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT02.ZIP 4/11/95
// (Original ECKELT01.ZIP dated 2/21/95)
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: PERSIST2.CPP -- Improved MI persistence
#include <fstream.h>
#include <string.h>

class persistent {
public:
  virtual void write(ostream& out) const = 0;
  virtual void read(istream& in) = 0;
};

class data {
protected:
  float f[3];
public:
  data(float f0 = 0.0, float f1 = 0.0,
    float f2 = 0.0) {
    f[0] = f0;
    f[1] = f1;
    f[2] = f2;
  }
  void print(const char* msg = "") const {
    if(*msg) cout << msg << endl;
    for(int i = 0; i < 3; i++)
      cout << "f[" << i << "] = "
           << f[i] << endl;
  }
};

class wdata1 : public persistent, public data {
public:
  wdata1(float f0 = 0.0, float f1 = 0.0,
    float f2 = 0.0) : data(f0, f1, f2) {}
  void write(ostream& out) const {
    out << f[0] << " " << f[1] << " " << f[2];
  }
  void read(istream& in) {
    in >> f[0] >> f[1] >> f[2];
  }
};

class wdata2 : public data, public persistent {
public:
  wdata2(float f0 = 0.0, float f1 = 0.0,
    float f2 = 0.0) : data(f0, f1, f2) {}
  void write(ostream& out) const {
    out << f[0] << " " << f[1] << " " << f[2];
  }
  void read(istream& in) {
    in >> f[0] >> f[1] >> f[2];
  }
};

class conglomerate : public data,
public persistent {
  char* name; // Contains a pointer
  wdata1 d1;
  wdata2 d2;
public:
  conglomerate(const char* nm = "",
    float f0 = 0.0, float f1 = 0.0,
    float f2 = 0.0, float f3 = 0.0,
    float f4 = 0.0, float f5 = 0.0,
    float f6 = 0.0, float f7 = 0.0,
    float f8= 0.0) : data(f0, f1, f2),
    d1(f3, f4, f5), d2(f6, f7, f8) {
    name = new char[strlen(nm) + 1];
    strcpy(name, nm);
  }
  void write(ostream& out) const {
    int i = strlen(name) + 1;
    out << i << " "; // Store size of string
    out << name << endl;
    d1.write(out);
    d2.write(out);
    out << f[0] << " " << f[1] << " " << f[2];
  }
  // Must read in reverse order as write:
  void read(istream& in) {
    delete []name; // Remove old storage
    int i;
    in >> i >> ws; // Get int, strip whitespace
    name = new char[i];
    in.getline(name, i);
    d1.read(in);
    d2.read(in);
    in >> f[0] >> f[1] >> f[2];
  }
  void print() const {
    data::print(name);
    d1.print();
    d2.print();
  }
};

main() {
  {
    ofstream data("data.dat");
    conglomerate C("This is conglomerate C",
      1.1, 2.2, 3.3, 4.4, 5.5,
      6.6, 7.7, 8.8, 9.9);
    cout << "C before storage" << endl;
    C.print();
    C.write(data);
  } // Closes file
  ifstream data("data.dat");
  conglomerate C;
  C.read(data);
  cout << "after storage: " << endl;
  C.print();
}
