// File from page 596 in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT02.ZIP 4/11/95
// (Original ECKELT01.ZIP dated 2/21/95)
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: TSTEST.CPP -- Test TSTASH
#include <fstream.h>
#include "..\allege.h"
#include "..\14\tstash.h"
#include "..\11\strings.h"
const bufsize = 80;
ofstream out("tstest.out");

class Int {
  int i;
public:
  Int(int I = 0) : i(I) {
    out << ">" << i << endl;
  }
  ~Int() { out << "~" << i << endl; }
  operator int() const { return i; }
  friend ostream& 
    operator<<(ostream& os, const Int& x) {
      return os << x.i;
  }
};

main() {
  tstash<Int> intStash; // Instantiate for int
  for(int i = 0; i < 30; i++)
    intStash.add(new Int(i));
  tstashIter<Int> Intit(intStash);
  Intit.forward(5);
  for(int j = 0; j < 20; j++, Intit++)
    Intit.remove(); // Default removal
  for(int k = 0; k < intStash.count(); k++)
    if(intStash[k]) // Remove() causes "holes"
      out << *intStash[k] << endl;

  ifstream file("tstest.cpp");
  allegefile(file);
  char buf[bufsize];
  // Instantiate for String:
  tstash<String> stringStash;
  while(file.getline(buf, bufsize))
    stringStash.add(makeString(buf));
  for(int u = 0; u < stringStash.count(); u++)
    if(stringStash[u])
      out << *stringStash[u] << endl;
  tstashIter<String> it(stringStash);
  int j = 25;
  it.forward(j);
  while(it) {
    out << j++ << ": " << it->str() << endl;
    it++;
  }
}
