        /* getbyte */
        /* In wires.lib */
        
        #include <rs.h>
        #include <subwires.h>

                
/************************************************************************
*                                                                       *
*       Get a byte from the BBC.Receive in 3 slices,checking the parity *
*       bit for the last slice,hence 9 bits altogether.Each slice has   *
*       the same protocol:-                                             *
*                                                                       *
*               Tell the BBC we're ready(Clear Rx)                      *
*               Wait for the BBC to send something(Tx=1?)               *
*               Acknowledge the data(Set Rx)                            *
*               Wait for our Acknowledgement to be acknowledged(Tx=0?)  *
*                                                                       *
*       Then,after the last slice is sent,tell the BBC we're done(Rx=0) *
*                                                                       *
*       See 'subwires.h' for comments on Timeout.                       *
*                                                                       *
*                                                       27.02.1995.     *
************************************************************************/

        byte getbyte(y)
        byte *y; 
        {
        byte x,X; 
        unsigned long systime0,systime1;
        if (!RECEIVING) return(6);        /* Wrong mode */
/*
*       1st Slice:-
*/
/*      Tell BBC we're ready:-                            */
        if (!Clear_Rx()) return(6);         /* Wrong mode */
        getsyst(&systime0);
        while (Tx()!=1) {                     /* Loop till Ok or Timeout */
           getsyst(&systime1);
           if (systime1>systime0+Timeout) return(10);         /* Give up */
        }           
/*      Acknowledge the BBC straightaway:-                */
        if (!Set_Rx()) return(6);           /* Wrong mode */
        X=in8(PORT_IN);                    /* Get the port value */
        X=Rmask(X);                        /* Mask to get the data */
        x=X&7;                             /* Get lower 3 bits */
/*
*       Wait for BBC to acknowledge our acknowledgement :-
*/
        getsyst(&systime0);
        while (Tx()!=0) {                     /* Loop till Ok or Timeout */
           getsyst(&systime1);
           if (systime1>systime0+Timeout) return(10);         /* Give up */
        }           
/*
*       2nd Slice:-
*/
/*      Tell BBC we're ready:-                            */
        if (!Clear_Rx()) return(6);        /* Wrong mode */
        getsyst(&systime0);
        while (Tx()!=1) {                     /* Loop till Ok or Timeout */
           getsyst(&systime1);
           if (systime1>systime0+Timeout) return(10);         /* Give up */
        }           
/*      Acknowledge the BBC straightaway:-                */
        if (!Set_Rx()) return(6);          /* Wrong mode */
        X=in8(PORT_IN);                    /* Get the port value */
        X=Rmask(X);                        /* Mask to get the data */
        x=x|((X&7)<<3);                    /* Get middle 3 bits */
/*
*       Wait for BBC to acknowledge our acknowledgement :-
*/
        getsyst(&systime0);
        while (Tx()!=0) {                     /* Loop till Ok or Timeout */
           getsyst(&systime1);
           if (systime1>systime0+Timeout) return(10);         /* Give up */
        }           
/*
*       Last Slice:-
*/
/*      Tell BBC we're ready:-                            */
        if (!Clear_Rx()) return(6);        /* Wrong mode */
        getsyst(&systime0);
        while (Tx()!=1) {                     /* Loop till Ok or Timeout */
           getsyst(&systime1);
           if (systime1>systime0+Timeout) return(10);         /* Give up */
        }           
/*      Acknowledge the BBC straightaway:-                */
        if (!Set_Rx()) return(6);          /* Wrong mode */
        X=in8(PORT_IN);                    /* Get the port value */
        X=Rmask(X);                        /* Mask to get the data */
        x=x|((X&3)<<6);                    /* Get top 2 bits */
        if (evenprty(x)!=( (X&4)>>2 ) ) {  /* Parity check  */
           printf("\nx=%u,X=%u\n",x,X);
           return(20);
        }
/*
*       Wait for BBC to acknowledge our acknowledgement :-
*/
        getsyst(&systime0);
        while (Tx()!=0) {                     /* Loop till Ok or Timeout */
           getsyst(&systime1);
           if (systime1>systime0+Timeout) return(10);         /* Give up */
        }           
/*
*       Tell BBC we're done:-
*/
        if (!Clear_Rx()) return(6);        /* Wrong mode */
        *y=x;
        return(TRUE);
        }
