CHAT(8)                                                   CHAT(8)
DOS Chat Version 1.9        26 April 1997


NAME
       chat - Automated conversational script with a modem

SYNOPSIS
       chat [ options ] script

DESCRIPTION
       The chat program defines a conversational exchange between
       the computer and the modem.  Its  primary  purpose  is  to
       establish the connection between the Point-to-Point Proto-
       col packet driver (pppd.exe) and the remote's PPP process.

DOS NOTES
       The DOS version incorporates two flavours of the  program,
       one intended for use with the 'connect'  option  from pppd
       (chat.exe) and another for standalone use (chat0.exe). The
       chat.exe program  requires that pppd.exe is present in me-
       mory, as it access to COM  ports is done through a private
       interface via the packet driver interrupt.  The  chat0.exe
       program does  directly  access to COM ports and leaves the
       DTR line  high  after exiting, in much the same way kermit
       and other DOS terminal programs does when quitting without
       resetting the COM port.

       This means that chat0.exe accepts  options for selecting a
       port, while chat.exe gets wathever port pppd.exe is using.
       If you  don't specify  a COM port  with chat0.exe, COM1 is
       used by default. The OPTIONS sections will note these that
       are  aplicable to both  executables and to chat0.exe only.

       The command line parsing done by DOS C compilers  is quite
       different  from  *NIX  regarding quotes. It means that you
       must use "" for quoting  strings with  embedded blanks and
       '' for  inserting  empty  strings. It seems that the empty
       string "" doesn't store a null argument  under  DOS, which
       will make the CHAT script not to work as intended.

       Some examples are in oder:

           "CONNECT 14400"       generates the single string
                                 CONNECT 14400.

           ""                    no string is generated, the C
                                 startup code simply skips these.

           ''                    generates one single string
                                 which is empty.

           \"\"                  generates one single string
                                 which is empty.

           'CONNECT 14400'       tries to generate two strings,
                                 CONNECT and 14400', causing an
                                 unterminated quote error.

           '\"CONNECT 14400\"'   tries to generate two strings,
                                 "CONNECT and 14400", causing an
                                 unterminated quote error.

           "'CONNECT 14400'"     generates the single string
                                 CONNECT 14400.

           "\'CONNECT 14400\'"   generates the single string
                                 'CONNECT 14400'.

           "'\"CONNECT 14400\"'" generates the single string
                                 "CONNECT 14400".

       This  change  in  behavior doesn't applies when reading the
       CHAT script from a file, because  the  program code  is  in
       charge  of  interpreting  the  characters and DOS nor the C
       compiler interferes with it.

OPTIONS
       -p <COMn>                                 (CHAT0.EXE only)
              Specifies the COM port  to  use  for  communicating
              with the modem. Port COM1 through COM4 can be used,
              the  standar  base address/irq  is  asssumed unless
              you change the default with another  options. Basic
              testing (through BIOS) is done for ensure COM avai-
              lability.

       -b <port base>                            (CHAT0.EXE only)
              Specifies  the  base  address for  the COM port, in
              case it is  a  non-standar  one. The number  can be
              entered  in  hex, octal or decimal, following the C
              language rules  for  parsing  numbers (0xnnn is hex
              for example). No attempt is done for verifying that
              a valid COM port exists at the address, so use with
              care.

       -i <irq number>                           (CHAT0.EXE only)
              Specifies the irq number used by the  COM port. The
              same considerations as above applies.

       -s <baud rate>                            (CHAT0.EXE only)
              Specifies the speed for modem to computer comunica-
              tion. Up to  115200 baud  can be programmed, beware
              that serial ports that have the older 8250 UART can
              not  handle  speeds  higher than 9600 in a reliable
              way.  The number  can  be  entered in hex, octal or
              decimal, as in the above options.

       -f <chat file>
              Read the chat script from the chat file. The use of
              this  option  is  mutually  exclusive with the chat
              script parameters.  Multiple lines are permitted in
              the file. Space or horizontal tab characters should
              be used to separate the strings.

       -t <timeout>
              Set  the  timeout  for  the  expected  string to be
              received. If the string is not received within  the
              time  limit  then  the reply string is not sent. An
              alternate reply may be sent or the script will fail
              if  there  is  no  alternate reply string. A failed
              script will cause the  chat  program  to  terminate
              with a non-zero error code.

       -r <report file>
              Set  the  file for output of the report strings. If
              you use the keyword REPORT, the  resulting  strings
              are  written  to  this  file. If this option is not
              used and you still use REPORT keywords, the  stderr
              file is used for the report strings.

       -e     Start  with  the echo option turned on. Echoing may
              also be turned on or off at specific points in  the
              chat script by using the ECHO keyword. When echoing
              is enabled, all output from the modem is echoed  to
              DOS standar error device.

       -v     Request  that the chat script be executed in a ver-
              bose mode. The chat program will then log all  text
              received  from  the  modem  and  the output strings
              which it sends to the DOS standar output, which can
              be redirected.

       -V     Request that the  chat  script  be  executed  in  a
              stderr verbose mode. The chat program will then log
              all text received from the  modem  and  the  output
              strings  which  it  sends to the DOS  standar error
              device. This device is usually the local console at
              the  station running  the chat or pppd program.

       script If the script is not specified in a file  with  the
              -f option then the script is included as parameters
              to the chat program.

CHAT SCRIPT
       The chat script defines the communications.

       A script consists of one or more  "expect-send"  pairs  of
       strings, separated by spaces, with an optional "subexpect-
       subsend" string pair, separated by a dash as in  the  fol-
       lowing example:

              ogin:-BREAK-ogin: ppp ssword: hello2u2

       This  line  indicates  that the chat program should expect
       the string "ogin:". If it fails to receive a login  prompt
       within  the  time interval allotted, it is to send a break
       sequence to the remote and then expect the string "ogin:".
       If  the  first "ogin:" is received then the break sequence
       is not generated.

       Once it received the login prompt the  chat  program  will
       send  the string ppp and then expect the prompt "ssword:".
       When it receives the prompt for the password, it will send
       the password hello2u2.

       A  carriage  return  is  normally sent following the reply
       string. It is not expected in the "expect"  string  unless
       it  is  specifically  requested  by using the \r character
       sequence.

       The expect sequence should contain only what is needed  to
       identify the string. Since it is normally stored on a disk
       file, it should not contain variable  information.  It  is
       generally not acceptable to look for time strings, network
       identification strings, or other variable pieces  of  data
       as an expect string.

       To help correct for characters which may be corrupted dur-
       ing the initial sequence,  look  for  the  string  "ogin:"
       rather  than "login:". It is possible that the leading "l"
       character may be received in error and you may never  find
       the string even though it was sent by the system. For this
       reason, scripts look for "ogin:" rather than "login:"  and
       "ssword:" rather than "password:".

       A very simple script might look like this:

              ogin: ppp ssword: hello2u2

       In   other  words,  expect  ....ogin:,  send  ppp,  expect
       ...ssword:, send hello2u2.

       In actual practice, simple scripts are rare. At  the  vary
       least,  you should include sub-expect sequences should the
       original string not be received. For example, consider the
       following script:

              ogin:--ogin: ppp ssowrd: hello2u2

       This  would  be  a  better script than the simple one used
       earlier. This would look for the same login: prompt,  how-
       ever, if one was not received, a single return sequence is
       sent and then it will look for login: again.  Should  line
       noise  obscure  the  first  login  prompt then sending the
       empty line will usually generate a login prompt again.

ABORT STRINGS
       Many modems will report  the  status  of  the  call  as  a
       string.  These  strings  may be CONNECTED or NO CARRIER or
       BUSY. It is often desirable to terminate the script should
       the modem fail to connect to the remote. The difficulty is
       that a script would not know exactly which modem string it
       may receive. On one attempt, it may receive BUSY while the
       next time it may receive NO CARRIER.

       These "abort" strings may be specified in the script using
       the  ABORT sequence. It is written in the script as in the
       following example:

              ABORT BUSY ABORT 'NO CARRIER' '' ATZ OK ATDT5551212
              CONNECT

       This  sequence  will  expect  nothing;  and  then send the
       string ATZ. The expected response to this  is  the  string
       OK.  When  it  receives OK, the string ATDT5551212 to dial
       the telephone. The expected  string  is  CONNECT.  If  the
       string  CONNECT is received the remainder of the script is
       executed. However, should the modem find a busy telephone,
       it  will  send the string BUSY. This will cause the string
       to match the abort character  sequence.  The  script  will
       then fail because it found a match to the abort string. If
       it received the string NO CARRIER, it will abort  for  the
       same  reason. Either string may be received. Either string
       will terminate the chat script.


REPORT STRINGS
       A report string is similar to the ABORT string.  The  dif-
       ference  is  that  the  strings, and all characters to the
       next control character such  as  a  carriage  return,  are
       written to the report file.

       The report strings may be used to isolate the transmission
       rate of the modem's connect string and return the value to
       the  chat  user.  The  analysis of the report string logic
       occurs in conjunction with  the  other  string  processing
       such as looking for the expect string. The use of the same
       string for a report and abort  sequence  is  probably  not
       very useful, however, it is possible.

       The report strings to no change the completion code of the
       program.

       These "report" strings may  be  specified  in  the  script
       using  the REPORT sequence. It is written in the script as
       in the following example:

              REPORT CONNECT ABORT BUSY '' ATDT5551212 CONNECT ''
              ogin: account

       This  sequence  will  expect  nothing;  and  then send the
       string ATDT5551212 to dial  the  telephone.  The  expected
       string  is  CONNECT. If the string CONNECT is received the
       remainder of the script is executed. In addition the  pro-
       gram  will  write  to the expect-file the string "CONNECT"
       plus any characters which follow it such as the connection
       rate.

ECHO
       The  echo  options  controls  whether  the output from the
       modem is echoed to stderr. This option may be set with the
       -e  option, but it can also be controlled by the ECHO key-
       word. The "expect-send" pair ECHO ON enables echoing,  and
       ECHO  OFF  disables  it.  With this keyword you can select
       which parts of the conversation  should  be  visible.  For
       instance, with the following script:

              ABORT   'BUSY'
              ABORT   'NO CARIER'
              OK\r\n  ATD1234567
              \r\n    \c
              ECHO    ON
              CONNECT \c
              ogin:   account

       all  output resulting from modem configuration and dialing
       is not visible, but starting with the  CONNECT  (or  BUSY)
       message, everything will be echoed.

TIMEOUT
       The  initial  timeout  value  is  45  seconds. This may be
       changed using the -t parameter.

       To change the timeout value for the  next  expect  string,
       the following example may be used:

              ATZ  OK ATDT5551212 CONNECT TIMEOUT 10 ogin:--ogin:
              TIMEOUT 5 assowrd: hello2u2

       This will change the timeout to 10 seconds when it expects
       the  login:  prompt. The timeout is then changed to 5 sec-
       onds when it looks for the password prompt.

       The timeout, once changed, remains in effect until  it  is
       changed again.

SENDING EOT
       The  special  reply  string of EOT indicates that the chat
       program should send an EOT character to the  remote.  This
       is  normally  the End-of-file character sequence. A return
       character is not sent following the EOT.  The EOT sequence
       may  be  embedded  into the send string using the sequence
       ^D.

GENERATING BREAK
       The special reply string of BREAK will cause a break  con-
       dition  to  be  sent. The break is a special signal on the
       transmitter. The normal processing on the receiver  is  to
       change  the  transmission  rate.   It may be used to cycle
       through the available transmission  rates  on  the  remote
       until  you  are able to receive a valid login prompt.  The
       break sequence may be embedded into the send string  using
       the \K sequence.

ESCAPE SEQUENCES
       The expect and reply strings may contain escape sequences.
       All of the sequences are legal in the reply  string.  Many
       are legal in the expect.  Those which are not valid in the
       expect sequence are so indicated.

       ''     Expects or sends a null string. If you send a  null
              string  then  it will still send the return charac-
              ter. This sequence may either be a pair of apostro-
              phe or quote characters.

       \b     represents a backspace character.

       \c     Suppresses  the  newline  at  the  end of the reply
              string. This is the only method to  send  a  string
              without  a trailing return character. It must be at
              the end  of  the  send  string.  For  example,  the
              sequence hello\c will simply send the characters h,
              e, l, l, o.  (not valid in expect.)

       \d     Delay for one second.  The  program  uses  sleep(1)
              which  will delay to a maximum of one second.  (not
              valid in expect.)

       \K     Insert a BREAK (not valid in expect.)

       \n     Send a newline or linefeed character.

       \N     Send a null character. The  same  sequence  may  be
              represented by \0.  (not valid in expect.)

       \p     Pause  for  a  fraction  of  a second. The delay is
              1/10th of a second.  (not valid in expect.)

       \q     Suppress writing the string to the SYSLOG file. The
              string  ??????  is written to the log in its place.
              (not valid in expect.)

       \r     Send or expect a carriage return.

       \s     Represents a space character in  the  string.  This
              may  be  used when it is not desirable to quote the
              strings which contains  spaces.  The  sequence  'HI
              TIM' and HI\sTIM are the same.

       \t     Send or expect a tab character.

       \\     Send or expect a backslash character.

       \ddd   Collapse the octal digits (ddd) into a single ASCII
              character and send that character.   (some  charac-
              ters are not valid in expect.)

       ^C     Substitute  the sequence with the control character
              represented by C.  For example, the  character  DC1
              (17)  is  shown  as  ^Q.   (some characters are not
              valid in expect.)

TERMINATION CODES
       The chat program will terminate with the following comple-
       tion codes.

       0      The  normal  termination of the program. This indi-
              cates that the script was executed without error to
              the normal conclusion.

       1      One  or  more  of  the parameters are invalid or an
              expect  string  was  too  large  for  the  internal
              buffers.  This  indicates  that  the program as not
              properly executed.

       2      An error occurred during the execution of the  pro-
              gram.  This may be due to a read or write operation
              failing for some reason or chat receiving a  signal
              such as SIGINT.

       3      A  timeout  event occurred when there was an expect
              string without having a "-subsend" string. This may
              mean  that you did not program the script correctly
              for the condition or that some unexpected event has

              occurred  and  the  expected  string  could  not be
              found.

       4      The first  string  marked  as  an  ABORT  condition
              occurred.

       5      The  second  string  marked  as  an ABORT condition
              occurred.

       6      The third  string  marked  as  an  ABORT  condition
              occurred.

       7      The  fourth  string  marked  as  an ABORT condition
              occurred.

       ...    The other termination codes are also strings marked
              as an ABORT condition.

       Using  the  termination  code, it is possible to determine
       which event terminated  the  script.  It  is  possible  to
       decide if the string "BUSY" was received from the modem as
       opposed to "NO DIAL TONE". While the first  event  may  be
       retried,  the  second  will probably have little chance of
       succeeding during a retry.

SEE ALSO
       Additional information about chat  scripts  may  be  found
       with  UUCP  documentation.  The chat script was taken from
       the ideas proposed by the scripts used by the uucico  pro-
       gram.

       uucico(1), uucp(1)

COPYRIGHT
       The  chat program is in public domain. This is not the GNU
       public license. If it breaks then you  get  to  keep  both
       pieces.

