/*************************************************************************/
/*  MANYFAX.C     Send many faxes automatically by calling QFAX.EXE      */
/*          Copyright (C) 1996 Anthony Mai. All rights reserved          */
/*                                                                       */
/*  You may modify and use this program for any purpose as long as this  */
/*  copyright notice remains intact. But you may not re-distribute this  */
/*  file except when you distribute it in it's original form, as part of */
/*  the QFAXV107.ZIP shareware package.                                  */
/*************************************************************************/

#include <stdio.h>
#include <conio.h>
#include <process.h>

int i,j,k,Ans, returncode;
char qfaxcmd[128]; tmpstr[128];
char listname[64], logname[64];
char filename[20], phone[20];
char dirnam[128];
FILE * fbase, * ftemp;

usage()
{
 printf("Usage of this program is:\n"
        "  manyfax  -db fax_list_file -log log_file_name\n"
        "Example:\n"
        "  manyfax  -db manyfax.fdb  -log manyfax.log\n"
        "Contact 102773.370@CompuServe.com if there is a problem.\n");
}

main(argc, argv)
  int argc;
  char * argv[];
{
  _asm {
    mov  ax, 03h
    int  10h
   }

  printf("\nThis program demonstrate how to call QFAX from other programs\n"
         "and send out many faxes to different fax numbers\n\n");
  printf("You can use the spawl function in C to invoke QFAX from your program\n");
  printf("The file manyfax.fdb is a plain ASCII file that stores file names\n"
         "and fax numbers like this format:\n\n");
  printf("File#1      Fax_Number#1\n"
         "File#2      Fax_Number#2\n"
         "File#3      Fax_Number#3\n...\n\n");


 /* Find the the name of the directory where manyfax.exe and qfax.exe is */
 strcpy(dirnam, argv[0]);
 i = strlen(dirnam)-1;
 while (i>0 && (*(dirnam+i) != '\134')) i--;
 *(dirnam+i+1) = '\0';

 if (argc == 1) {usage(); exit(-1);}
  
  /*  Construct the QFAX command with the path name */
  strcpy(qfaxcmd, dirnam);
  strcat(qfaxcmd, "\\");
  strcat(qfaxcmd, "qfax.exe");

  /* Test whether the the QFAX path and file name is correct or not */
  if ((ftemp = fopen(qfaxcmd, "rb")) == NULL) {
      printf("%s can not be found!\n", qfaxcmd); exit(-1);
     }
  else fclose(ftemp);

  strcpy(listname, "manyfax.fdb");
  strcpy(logname,  "manyfax.log");

  i = 1;
  while (i<argc)
   {
    if (*(argv[i]) == '-') switch (*(argv[i]+1)) {
      case 'd': i++; strcpy(listname, argv[i]); break;
      case 'l': i++; strcpy(logname,  argv[i]); break;
     }
    i ++;
   }

  if ((fbase = fopen(listname, "rb")) == NULL) {
     printf("Database file %s not found\n", listname); exit(-1);
    }
  if ((ftemp = fopen(logname, "wb")) == NULL) {
     printf("Can not create file %s\n", logname); exit(-1);
    }

  while (!feof(fbase)) {
    filename[0] = 0x00; phone[0] = 0x00;
    fscanf(fbase, "%s", filename);
    if (strlen(filename)) {
       fscanf(fbase, "%s", phone);
       if (strlen(phone)) {
         printf("Trying to fax %s to %s using QFAX\n", filename, phone);
         
         /* Call QFAX as a command line faxer */

         returncode = spawnl(_P_WAIT, qfaxcmd, "qfax", "-nod",
           filename, phone, NULL);

         /* The above is similar to DOS command line:                   */
         /*    qfax -nod filename phone                                 */

         fprintf(ftemp, "%s -> %s  return code = %d : ",filename,phone,returncode);

         printf("QFAX called. ");
         switch(returncode) {
            case  0: printf (       "FAX Successful.\n");
                     fprintf(ftemp, "FAX Successful.\n");
                     break;
            case -1: printf (       "File, Memory or Modem errors.\n");
                     fprintf(ftemp, "File, Memory or Modem errors.\n");
                     break;
            case  1: printf (       "FAX partially completed.\n");
                     fprintf(ftemp, "FAX partially completed.\n");
                     break;
            case  2: printf (       "No FAX page transmitted.\n");
                     fprintf(ftemp, "No FAX page transmitted.\n");
                     break;
            case  3: printf (       "FAX handshake failed.\n");
                     fprintf(ftemp, "FAX handshake failed.\n");
                     break;
            case  4: printf (       "Unknown error after dialing.\n");
                     fprintf(ftemp, "Unknown error after dialing.\n");
                     break;
            case  5: printf (       "Unable to Start FAX.\n");
                     fprintf(ftemp, "Unable to Start FAX.\n");
                     break;
            case  6: printf (       "Unable to reset or initialize modem.\n");
                     fprintf(ftemp, "Unable to reset or initialize modem.\n");
                     break;
            case 10: printf (       "No Dial Tone on Phone Line.\n");
                     fprintf(ftemp, "No Dial Tone on Phone Line.\n");
                     break;
            case 11: printf (       "Phone Line Busy.\n");
                     fprintf(ftemp, "Phone Line Busy.\n");
                     break;
            case 12: printf (       "Fax Connection Time Out.\n");
                     fprintf(ftemp, "Fax Connection Time Out.\n");
                     break;
            default: printf (       "Unknown FAX error.\n");
                     fprintf(ftemp, "Unknown FAX error.\n");
                     break;
          }
         for (j=0; j<32767; j++) {/* This is just a time delay*/}
        }
      }
   }

  fclose(ftemp);
  fclose(fbase);
  printf("All done. Read the file %s for a log of fax results\n", logname);
}
