	       INCLUDE MODEL.INC
;
;---------------------------------------------------------------------------
;   Function:	void _bye_version(ver, rev)
;
;   Parms:	int *ver;   -> ptr to version buffer
;		int *rev;   -> ptr to revision buffer
;
;   Purpose:	Passes the version and revision number to the
;		calling function.
;
;   Return:	void
;---------------------------------------------------------------------------
;
	       PUBLIC __bye_version

__bye_version  PROC

	       push bp			;standard 'C' function entry
	       mov  bp,sp
	       push es

	       mov  ah,11		;AH=11 for get version
	       int  BYE_VECT		;AX = msb(ver#), lsb(rev#)
	       mov  cx,ax		;move ver/rev to CX

	     IF @datasize
	       les  bx,ARG1		;ES:BX = far ptr offset to ver#
	     ELSE
	       mov  bx,ARG1		;BX = ptr to ver num
	     ENDIF

	       xor  ah,ah		;clear the msb
	       mov  al,ch		;load ver into lsb

	     IF @datasize
	       mov  es:[bx],ax		;load into far ptr
	     ELSE
	       mov  [bx],ax		;load into near ptr
	     ENDIF

	     IF @datasize
	       les  bx,ARG2		;ES:BX = far ptr offset to rev#
	     ELSE
	       mov  bx,ARG2		;BX = ptr to rev num
	     ENDIF

	       xor  ah,ah		;clear the msb
	       mov  al,cl		;load rev into lsb

	     IF @datasize
	       mov  es:[bx],ax		;load into far ptr
	     ELSE
	       mov  [bx],ax		;load into near ptr
	     ENDIF

	       pop  es
	       mov  sp,bp		;standard 'C' exit
	       pop  bp
	       ret

__bye_version  ENDP
	       END

