* Function: NAMESPLIT
* Author..: Richard Low
* Syntax..: NAMESPLIT( <expC> )
* Returns.: 'Low, Richard C.' where p_name was 'Richard C. Low'
*            only if p_name contains at least one space, otherwise
*            p_name itself is returned.
* Usage...: Useful in converting names listed as Firstname first etc..
*           into Lastname first format.  Also useful for locating names
*           which were indexed on:
*
*               SUBSTR( TRIM(Lastname) + ', ' + TRIM(Firstname) ;
*               + ' ' + Middlename + SPACE(32) , 1, 32)
*
* Note....: The above index expression is built to, then limited to 32
*           characters in order to keep the index key a constant length

FUNCTION NAMESPLIT
PARAMETER p_name
PRIVATE f_first, f_middle, f_last, f_midstart, f_laststart

*-- first get rid of excess blanks
p_name = TRIM(p_name)

*-- set up some working space
STORE '' TO f_first, f_middle, f_last

*-- test if name is alpha and a space can be found in it
*-- if so, there must be more than one word entered (2 names)
*-- either first and last, or first, middle and last
IF ISALPHA(p_name) .AND. ' ' $ p_name

   *-- any middle name will start at the space, plus one
   f_midstart = AT(' ',p_name) + 1

   *-- and the last name should start at the space after the first
   f_laststart = AT(' ', SUBSTR(p_name, f_midstart) ) + 1

   *-- start of last name will be 1 if the AT() returned 0, not found
   IF f_laststart = 1
      *-- must be only 2 words in string, First and Last name
      f_first = TRIM(SUBSTR(p_name, 1, (f_midstart - 1)))
      f_last  = TRIM(SUBSTR(p_name, f_midstart))

   ELSE
      *-- otherwise, must be more than 2 names entered: First Middle Last
      f_first  = TRIM(SUBSTR(p_name, 1, (f_midstart - 1)))
      f_middle = TRIM(SUBSTR(p_name, f_midstart, (f_laststart - 1)))
      f_last   = TRIM(SUBSTR(p_name, f_laststart + f_midstart - 1))

      *-- if the last name is a Title
      IF UPPER(TRIM(f_last)) $ ',JR. ,SR. ,III ,II ,2ND ,3RD ,4TH  M.D. PHD'
         *-- its not really the last name, middle is, so tack it on to end
         f_last = TRIM(f_middle) + ' ' + TRIM(f_last)

         *-- scratch the middle name part
         f_middle = ''
      ENDIF
   ENDIF

   *-- now construct the end result in form LASTNAME, FIRSTNAME MIDDLE
   p_name = TRIM( f_last + ', ' + f_first + ' ' + f_middle )
ENDIF

*-- give it back
RETURN p_name
